/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.problems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.api.J2SECustomPropertySaver;
import org.netbeans.modules.java.j2seproject.api.J2SERuntimePlatformProvider;
import org.netbeans.modules.java.j2seproject.problems.ResolveBrokenRuntimePlatform;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Union2;
import org.openide.util.WeakListeners;

public class RuntimePlatformProblemsProvider
implements ProjectProblemsProvider,
PropertyChangeListener,
FileChangeListener {
    private static final Logger LOG = Logger.getLogger(RuntimePlatformProblemsProvider.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(RuntimePlatformProblemsProvider.class);
    private static final String CFG_PATH = "nbproject/configs";
    private final Project project;
    private final PropertyChangeSupport support;
    private final AtomicBoolean listens;
    private long eventId;
    private Collection<? extends ProjectProblemsProvider.ProjectProblem> problemCache;

    public RuntimePlatformProblemsProvider(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.project = project;
        this.support = new PropertyChangeSupport(this);
        this.listens = new AtomicBoolean();
    }

    public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.support.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        long currentId;
        Collection<? extends ProjectProblemsProvider.ProjectProblem> problems;
        RuntimePlatformProblemsProvider runtimePlatformProblemsProvider = this;
        synchronized (runtimePlatformProblemsProvider) {
            problems = this.problemCache;
            currentId = this.eventId;
        }
        if (problems == null) {
            this.initListeners();
            problems = this.findProblems();
            runtimePlatformProblemsProvider = this;
            synchronized (runtimePlatformProblemsProvider) {
                if (this.eventId == currentId) {
                    this.problemCache = problems;
                } else if (this.problemCache != null) {
                    problems = this.problemCache;
                }
            }
        }
        assert (problems != null);
        return problems;
    }

    @Override
    public void propertyChange(@NonNull PropertyChangeEvent evt) {
        Parameters.notNull((CharSequence)"evt", (Object)evt);
        String propName = evt.getPropertyName();
        if ("installedPlatforms".equals(propName) || "javac.target".equals(propName) || "javac.profile".equals(propName)) {
            this.resetAndFire();
        }
    }

    public void fileChanged(FileEvent fe) {
        this.resetAndFire();
    }

    public void fileDataCreated(FileEvent fe) {
        this.resetAndFire();
    }

    public void fileDeleted(FileEvent fe) {
        this.resetAndFire();
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.resetAndFire();
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    private void initListeners() {
        if (this.listens.compareAndSet(false, true)) {
            File projectDir;
            JavaPlatformManager jpm = JavaPlatformManager.getDefault();
            jpm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jpm));
            J2SEProject j2sePrj = (J2SEProject)this.project.getLookup().lookup(J2SEProject.class);
            if (j2sePrj != null) {
                j2sePrj.evaluator().addPropertyChangeListener((PropertyChangeListener)this);
            } else {
                LOG.log(Level.WARNING, "No property evaluator provider in project {0}({1})", new Object[]{ProjectUtils.getInformation((Project)this.project).getDisplayName(), FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory())});
            }
            FileObject projectFolder = this.project.getProjectDirectory();
            if (projectFolder != null && (projectDir = FileUtil.toFile((FileObject)projectFolder)) != null) {
                File cfgDir = new File(projectDir, CFG_PATH);
                FileUtil.addFileChangeListener((FileChangeListener)this, (File)cfgDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAndFire() {
        RuntimePlatformProblemsProvider runtimePlatformProblemsProvider = this;
        synchronized (runtimePlatformProblemsProvider) {
            this.problemCache = null;
            ++this.eventId;
        }
        this.support.firePropertyChange("problems", null, null);
    }

    @NonNull
    private Collection<? extends ProjectProblemsProvider.ProjectProblem> findProblems() {
        return (Collection)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Collection<? extends ProjectProblemsProvider.ProjectProblem>>(){

            public Collection<? extends ProjectProblemsProvider.ProjectProblem> run() {
                FileObject cfgFolder;
                HashSet<ProjectProblemsProvider.ProjectProblem> collector = new HashSet<ProjectProblemsProvider.ProjectProblem>();
                FileObject prjDir = RuntimePlatformProblemsProvider.this.project.getProjectDirectory();
                if (prjDir != null && (cfgFolder = prjDir.getFileObject(RuntimePlatformProblemsProvider.CFG_PATH)) != null) {
                    HashSet<? extends JavaPlatform> allowedPlatforms = new HashSet<JavaPlatform>();
                    SourceLevelQuery.Result slqr = SourceLevelQuery.getSourceLevel2((FileObject)prjDir);
                    String sourceLevel = slqr.getSourceLevel();
                    SourceLevelQuery.Profile profile = slqr.getProfile();
                    if (sourceLevel != null) {
                        for (J2SERuntimePlatformProvider rpp : RuntimePlatformProblemsProvider.this.project.getLookup().lookupAll(J2SERuntimePlatformProvider.class)) {
                            allowedPlatforms.addAll(rpp.getPlatformType(new SpecificationVersion(sourceLevel), profile));
                        }
                        for (FileObject cfgFile : cfgFolder.getChildren()) {
                            if (!cfgFile.hasExt("properties")) continue;
                            try {
                                RuntimePlatformResolver resolver;
                                EditableProperties ep = new EditableProperties(true);
                                try (InputStream in = cfgFile.getInputStream();){
                                    ep.load(in);
                                }
                                String runtimePlatform = ep.getProperty("platform.runtime");
                                if (runtimePlatform == null || runtimePlatform.isEmpty()) continue;
                                JavaPlatform platform = RuntimePlatformProblemsProvider.findPlatform(runtimePlatform);
                                if (platform == null) {
                                    resolver = new RuntimePlatformResolver(RuntimePlatformProblemsProvider.this.project, cfgFile.getName(), ep.getProperty("$label"), runtimePlatform);
                                    collector.add(ProjectProblemsProvider.ProjectProblem.createError((String)NbBundle.getMessage(RuntimePlatformProblemsProvider.class, (String)"LBL_MissingRuntimePlatform"), (String)NbBundle.getMessage(RuntimePlatformProblemsProvider.class, (String)"DESC_MissingRuntimePlatform", (Object)resolver.getDisplayName()), (ProjectProblemResolver)resolver));
                                    continue;
                                }
                                if (allowedPlatforms.contains(platform)) continue;
                                resolver = new RuntimePlatformResolver(RuntimePlatformProblemsProvider.this.project, cfgFile.getName(), ep.getProperty("$label"), platform, new SpecificationVersion(sourceLevel), profile);
                                collector.add(ProjectProblemsProvider.ProjectProblem.createError((String)NbBundle.getMessage(RuntimePlatformProblemsProvider.class, (String)"LBL_InvalidRuntimePlatform"), (String)NbBundle.getMessage(RuntimePlatformProblemsProvider.class, (String)"DESC_InvalidRuntimePlatform", (Object)resolver.getDisplayName()), (ProjectProblemResolver)resolver));
                            }
                            catch (IOException e) {
                                Exceptions.printStackTrace((Throwable)e);
                            }
                        }
                    }
                }
                return Collections.unmodifiableCollection(collector);
            }
        });
    }

    private static JavaPlatform findPlatform(@NonNull String platformId) {
        for (JavaPlatform jp : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            if (!platformId.equals(jp.getProperties().get("platform.ant.name"))) continue;
            return jp;
        }
        return null;
    }

    @NonNull
    static SourceLevelQuery.Profile getPlatformProfile(@NonNull JavaPlatform jp) {
        SourceLevelQuery.Profile profile = SourceLevelQuery.Profile.forName((String)((String)jp.getProperties().get("netbeans.java.profile")));
        if (profile == null) {
            profile = SourceLevelQuery.Profile.DEFAULT;
        }
        return profile;
    }

    private static class OK
    extends JButton
    implements ChangeListener {
        private ResolveBrokenRuntimePlatform panel;

        OK(@NonNull ResolveBrokenRuntimePlatform panel) {
            super(NbBundle.getMessage(RuntimePlatformProblemsProvider.class, (String)"LBL_OK"));
            Parameters.notNull((CharSequence)"panel", (Object)panel);
            this.panel = panel;
            panel.addChangeListener(this);
            this.stateChanged(null);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.setEnabled(this.panel.hasValidData());
        }
    }

    private static final class RuntimePlatformResolver
    implements ProjectProblemResolver {
        private final Project prj;
        private final String cfgId;
        private final String cfgDisplayName;
        private final Union2<String, InvalidPlatformData> data;

        private RuntimePlatformResolver(@NonNull Project project, @NonNull String cfgId, @NullAllowed String cfgDisplayName, @NonNull Union2<String, InvalidPlatformData> data) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"cfgId", (Object)cfgId);
            Parameters.notNull((CharSequence)"data", data);
            this.prj = project;
            this.cfgId = cfgId;
            this.cfgDisplayName = cfgDisplayName == null ? cfgId : cfgDisplayName;
            this.data = data;
        }

        RuntimePlatformResolver(@NonNull Project project, @NonNull String cfgId, @NullAllowed String cfgDisplayName, @NonNull String platformId) {
            this(project, cfgId, cfgDisplayName, (Union2<String, InvalidPlatformData>)Union2.createFirst((Object)platformId));
        }

        RuntimePlatformResolver(@NonNull Project project, @NonNull String cfgId, @NullAllowed String cfgDisplayName, @NonNull JavaPlatform jp, @NonNull SpecificationVersion targetLevel, @NonNull SourceLevelQuery.Profile profile) {
            this(project, cfgId, cfgDisplayName, (Union2<String, InvalidPlatformData>)Union2.createSecond((Object)new InvalidPlatformData(jp, targetLevel, profile)));
        }

        String getDisplayName() {
            return this.cfgDisplayName;
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            ResolveBrokenRuntimePlatform panel = this.data.hasFirst() ? ResolveBrokenRuntimePlatform.createMissingPlatform(this.prj, (String)this.data.first()) : ResolveBrokenRuntimePlatform.createInvalidPlatform(this.prj, (InvalidPlatformData)this.data.second());
            OK okButton = new OK(panel);
            DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(RuntimePlatformProblemsProvider.class, (String)"TITLE_MissingRuntimePlatform"), true, new Object[]{DialogDescriptor.CANCEL_OPTION, okButton}, (Object)okButton, 0, null, null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == okButton) {
                final boolean isSourceLevelChange = panel.isDowngradeSourceLevel();
                final String newPlatformId = panel.isSpecificPlatform() ? (String)panel.getRuntimePlatform().getProperties().get("platform.ant.name") : null;
                FutureTask<ProjectProblemsProvider.Result> res = new FutureTask<ProjectProblemsProvider.Result>(new Callable<ProjectProblemsProvider.Result>(){

                    @Override
                    public ProjectProblemsProvider.Result call() throws Exception {
                        if (isSourceLevelChange) {
                            return RuntimePlatformResolver.this.resolveSourceLevelImpl(((InvalidPlatformData)RuntimePlatformResolver.this.data.second()).jp);
                        }
                        return RuntimePlatformResolver.this.resolvePlatformImpl(newPlatformId);
                    }
                });
                RP.post(res);
                return res;
            }
            FutureTask<ProjectProblemsProvider.Result> res = new FutureTask<ProjectProblemsProvider.Result>(new Runnable(){

                @Override
                public void run() {
                }
            }, ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED));
            res.run();
            return res;
        }

        public boolean equals(@NullAllowed Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RuntimePlatformResolver)) {
                return false;
            }
            RuntimePlatformResolver other = (RuntimePlatformResolver)obj;
            FileObject thisPrjDir = this.prj.getProjectDirectory();
            FileObject otherPrjDir = other.prj.getProjectDirectory();
            return thisPrjDir == null ? otherPrjDir == null : thisPrjDir.equals(otherPrjDir) && this.data.equals(other.data);
        }

        public int hashCode() {
            int res = 17;
            res = res * 31 + Objects.hashCode(this.prj.getProjectDirectory());
            res = res * 31 + this.data.hashCode();
            return res;
        }

        @NonNull
        private ProjectProblemsProvider.Result resolvePlatformImpl(final @NullAllowed String newPlatformId) throws Exception {
            return (ProjectProblemsProvider.Result)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<ProjectProblemsProvider.Result>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public ProjectProblemsProvider.Result run() throws Exception {
                    FileObject cfg;
                    FileObject cfgDir;
                    FileObject prjDir = RuntimePlatformResolver.this.prj.getProjectDirectory();
                    if (prjDir != null && (cfgDir = prjDir.getFileObject(RuntimePlatformProblemsProvider.CFG_PATH)) != null && (cfg = cfgDir.getFileObject(RuntimePlatformResolver.this.cfgId, "properties")) != null) {
                        EditableProperties ep = new EditableProperties(true);
                        try (InputStream in = cfg.getInputStream();){
                            ep.load(in);
                        }
                        if (newPlatformId == null) {
                            ep.remove((Object)"platform.runtime");
                        } else {
                            ep.setProperty("platform.runtime", newPlatformId);
                        }
                        FileLock lock = cfg.lock();
                        try {
                            x2 = null;
                            try (OutputStream out = cfg.getOutputStream(lock);){
                                ep.store(out);
                            }
                            catch (Throwable throwable) {
                                x2 = throwable;
                                throw throwable;
                            }
                        }
                        finally {
                            lock.releaseLock();
                        }
                        for (J2SECustomPropertySaver saver : RuntimePlatformResolver.this.prj.getLookup().lookupAll(J2SECustomPropertySaver.class)) {
                            saver.save(RuntimePlatformResolver.this.prj);
                        }
                        return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED);
                    }
                    return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED);
                }
            });
        }

        @NonNull
        private ProjectProblemsProvider.Result resolveSourceLevelImpl(final @NonNull JavaPlatform jp) throws Exception {
            return (ProjectProblemsProvider.Result)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<ProjectProblemsProvider.Result>(){

                public ProjectProblemsProvider.Result run() throws Exception {
                    J2SEProject j2sePrj = (J2SEProject)RuntimePlatformResolver.this.prj.getLookup().lookup(J2SEProject.class);
                    if (j2sePrj != null) {
                        EditableProperties props = j2sePrj.getUpdateHelper().getProperties("nbproject/project.properties");
                        props.setProperty("javac.source", jp.getSpecification().getVersion().toString());
                        props.setProperty("javac.target", jp.getSpecification().getVersion().toString());
                        SourceLevelQuery.Profile profile = RuntimePlatformProblemsProvider.getPlatformProfile(jp);
                        if (profile == SourceLevelQuery.Profile.DEFAULT) {
                            props.remove((Object)"javac.profile");
                        } else {
                            props.setProperty("javac.profile", profile.getName());
                        }
                        j2sePrj.getUpdateHelper().putProperties("nbproject/project.properties", props);
                        ProjectManager.getDefault().saveProject(RuntimePlatformResolver.this.prj);
                    }
                    return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED);
                }
            });
        }
    }

    static final class InvalidPlatformData {
        private final JavaPlatform jp;
        private final SpecificationVersion targetLevel;
        private final SourceLevelQuery.Profile profile;

        InvalidPlatformData(@NonNull JavaPlatform jp, @NonNull SpecificationVersion targetLevel, @NonNull SourceLevelQuery.Profile profile) {
            Parameters.notNull((CharSequence)"jp", (Object)jp);
            Parameters.notNull((CharSequence)"targetLevel", (Object)targetLevel);
            Parameters.notNull((CharSequence)"profile", (Object)profile);
            this.jp = jp;
            this.targetLevel = targetLevel;
            this.profile = profile;
        }

        @NonNull
        JavaPlatform getJavaPlatform() {
            return this.jp;
        }

        @NonNull
        SpecificationVersion getTargetLevel() {
            return this.targetLevel;
        }

        @NonNull
        SourceLevelQuery.Profile getProfile() {
            return this.profile;
        }
    }
}

