/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.discovery.api.DriverFactory;
import org.netbeans.modules.cnd.discovery.wizard.api.support.ProjectBridge;
import org.netbeans.modules.cnd.dwarfdump.source.Artifacts;
import org.netbeans.modules.cnd.dwarfdump.source.CompileLineOrigin;
import org.netbeans.modules.cnd.dwarfdump.source.Driver;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.QmakeConfiguration;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.Pair;

public abstract class QtInfoProvider {
    private static final QtInfoProvider DEFAULT = new Default();
    private static final Logger LOGGER = Logger.getLogger(QtInfoProvider.class.getName());

    private QtInfoProvider() {
    }

    public static QtInfoProvider getDefault() {
        return DEFAULT;
    }

    public abstract List<String> getQtAdditionalMacros(MakeConfiguration var1);

    public abstract List<FSPath> getQtIncludeDirectories(MakeConfiguration var1);

    private static class Default
    extends QtInfoProvider {
        private final Map<String, Pair<String, String>> cache = new HashMap<String, Pair<String, String>>();

        private Default() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<String> getQtAdditionalMacros(MakeConfiguration conf) {
            String CXXFLAGS = "CXXFLAGS";
            TreeMap<String, String> vars = new TreeMap<String, String>();
            FileObject projectDir = conf.getBaseFSPath().getFileObject();
            if (projectDir == null) return Collections.emptyList();
            if (!projectDir.isValid()) return Collections.emptyList();
            try {
                FileObject qtMakeFile = RemoteFileUtil.getFileObject((FileObject)projectDir, (String)("nbproject/qt-" + conf.getName() + ".mk"));
                Project project = ProjectManager.getDefault().findProject(projectDir);
                if (project == null) return Collections.emptyList();
                if (qtMakeFile == null) return Collections.emptyList();
                if (!qtMakeFile.isValid()) return Collections.emptyList();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(qtMakeFile.getInputStream()));){
                    block22: {
                        String str;
                        while ((str = reader.readLine()) != null) {
                            String[] lines = str.split("=");
                            if (lines.length != 2) continue;
                            String key = lines[0].trim();
                            vars.put(lines[0].trim(), lines[1].trim());
                            if (!key.equals("CXXFLAGS")) {
                                continue;
                            }
                            break block22;
                        }
                        return Collections.emptyList();
                    }
                    ProjectBridge projectBridge = new ProjectBridge(project);
                    Driver driver = DriverFactory.getDriver(projectBridge.getCompilerSet());
                    Artifacts artifacts = driver.gatherCompilerLine(this.getActualVarValue(vars, "CXXFLAGS"), CompileLineOrigin.BuildLog, true);
                    ArrayList<String> result = new ArrayList<String>(artifacts.getUserMacros().size());
                    Iterator i$ = artifacts.getUserMacros().entrySet().iterator();
                    while (true) {
                        if (!i$.hasNext()) {
                            ArrayList<String> arrayList = result;
                            return arrayList;
                        }
                        Map.Entry pair = i$.next();
                        if (pair.getValue() == null) {
                            result.add((String)pair.getKey());
                            continue;
                        }
                        result.add((String)pair.getKey() + "=" + (String)pair.getValue());
                    }
                }
            }
            catch (IOException | IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return Collections.emptyList();
        }

        private String getActualVarValue(Map<String, String> vars, String var) {
            String result = vars.get(var);
            for (String v : vars.keySet()) {
                result = result.replace("$(" + v + ")", vars.get(v));
            }
            return result;
        }

        @Override
        public List<FSPath> getQtIncludeDirectories(MakeConfiguration conf) {
            List<FSPath> result;
            ExecutionEnvironment execEnv = conf.getDevelopmentHost().getExecutionEnvironment();
            FileSystem systemFS = FileSystemProvider.getFileSystem((ExecutionEnvironment)execEnv);
            FileSystem projectFS = conf.getBaseFSPath().getFileSystem();
            char separator = FileSystemProvider.getFileSeparatorChar((ExecutionEnvironment)execEnv);
            Pair<String, String> baseDir = this.getBaseQtIncludeDir(conf);
            if (baseDir != null && (baseDir.first() != null || baseDir.second() != null)) {
                String uiDir;
                QmakeConfiguration qmakeConfiguration;
                result = new ArrayList<FSPath>();
                if (baseDir.first() != null) {
                    result.add(new FSPath(systemFS, (String)baseDir.first()));
                }
                if ((qmakeConfiguration = conf.getQmakeConfiguration()).isCoreEnabled().getValue()) {
                    if (baseDir.second() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.second() + separator + "QtCore.framework/Headers"));
                    }
                    if (baseDir.first() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.first() + separator + "QtCore"));
                    }
                }
                if (qmakeConfiguration.isWidgetsEnabled().getValue()) {
                    if (baseDir.second() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.second() + separator + "QtWidgets.framework/Headers"));
                    }
                    if (baseDir.first() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.first() + separator + "QtWidgets"));
                    }
                }
                if (qmakeConfiguration.isGuiEnabled().getValue()) {
                    if (baseDir.second() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.second() + separator + "QtGui.framework/Headers"));
                    }
                    if (baseDir.first() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.first() + separator + "QtGui"));
                    }
                }
                if (qmakeConfiguration.isNetworkEnabled().getValue()) {
                    if (baseDir.second() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.second() + separator + "QtNetwork.framework/Headers"));
                    }
                    if (baseDir.first() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.first() + separator + "QtNetwork"));
                    }
                }
                if (qmakeConfiguration.isOpenglEnabled().getValue()) {
                    if (baseDir.second() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.second() + separator + "QtOpenGL.framework/Headers"));
                    }
                    if (baseDir.first() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.first() + separator + "QtOpenGL"));
                    }
                }
                if (qmakeConfiguration.isPhononEnabled().getValue()) {
                    if (baseDir.second() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.second() + separator + "phonon.framework/Headers"));
                    }
                    if (baseDir.first() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.first() + separator + "phonon"));
                    }
                }
                if (qmakeConfiguration.isQt3SupportEnabled().getValue()) {
                    if (baseDir.second() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.second() + separator + "Qt3Support.framework/Headers"));
                    }
                    if (baseDir.first() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.first() + separator + "Qt3Support"));
                    }
                }
                if (qmakeConfiguration.isPrintSupportEnabled().getValue()) {
                    if (baseDir.second() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.second() + separator + "QtPrintSupport.framework/Headers"));
                    }
                    if (baseDir.first() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.first() + separator + "QtPrintSupport"));
                    }
                }
                if (qmakeConfiguration.isSqlEnabled().getValue()) {
                    if (baseDir.second() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.second() + separator + "QtSql.framework/Headers"));
                    }
                    if (baseDir.first() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.first() + separator + "QtSql"));
                    }
                }
                if (qmakeConfiguration.isSvgEnabled().getValue()) {
                    if (baseDir.second() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.second() + separator + "QtSvg.framework/Headers"));
                    }
                    if (baseDir.first() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.first() + separator + "QtSvg"));
                    }
                }
                if (qmakeConfiguration.isXmlEnabled().getValue()) {
                    if (baseDir.second() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.second() + separator + "QtXml.framework/Headers"));
                    }
                    if (baseDir.first() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.first() + separator + "QtXml"));
                    }
                }
                if (qmakeConfiguration.isWebkitEnabled().getValue()) {
                    if (baseDir.second() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.second() + separator + "QtWebKit.framework/Headers"));
                    }
                    if (baseDir.first() != null) {
                        result.add(new FSPath(systemFS, (String)baseDir.first() + separator + "QtWebKit"));
                    }
                }
                if (CndPathUtilities.isPathAbsolute((CharSequence)(uiDir = qmakeConfiguration.getUiDir().getValue()))) {
                    result.add(new FSPath(systemFS, uiDir));
                } else {
                    result.add(new FSPath(projectFS, conf.getBaseDir() + separator + uiDir));
                }
            } else {
                result = Collections.emptyList();
            }
            return result;
        }

        private static String getQmakePath(MakeConfiguration conf) {
            Tool qmakeTool;
            CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
            if (compilerSet != null && (qmakeTool = compilerSet.getTool((ToolKind)PredefinedToolKind.QMakeTool)) != null && 0 < qmakeTool.getPath().length()) {
                return qmakeTool.getPath();
            }
            return "qmake";
        }

        private static String getCacheKey(MakeConfiguration conf) {
            return conf.getDevelopmentHost().getHostKey() + '/' + Default.getQmakePath(conf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Pair<String, String> getBaseQtIncludeDir(MakeConfiguration conf) {
            Pair baseDir;
            String cacheKey = Default.getCacheKey(conf);
            Map<String, Pair<String, String>> map = this.cache;
            synchronized (map) {
                if (this.cache.containsKey(cacheKey)) {
                    baseDir = this.cache.get(cacheKey);
                } else {
                    ExecutionEnvironment execEnv = conf.getDevelopmentHost().getExecutionEnvironment();
                    String qmakePath = Default.getQmakePath(conf);
                    if (ConnectionManager.getInstance().isConnectedTo(execEnv)) {
                        boolean isMac = false;
                        try {
                            isMac = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv).getOSFamily() == HostInfo.OSFamily.MACOSX;
                        }
                        catch (IOException | ConnectionManager.CancellationException ex) {
                            ex.printStackTrace(System.err);
                        }
                        String baseInc = Default.queryBaseQtIncludeDir(execEnv, qmakePath);
                        String baseLib = null;
                        if (isMac) {
                            baseLib = Default.queryBaseQtLibsDir(execEnv, qmakePath);
                        }
                        baseDir = Pair.of((Object)baseInc, baseLib);
                        this.cache.put(cacheKey, (Pair<String, String>)baseDir);
                    } else {
                        String baseInc = Default.guessBaseQtIncludeDir(qmakePath);
                        baseDir = Pair.of((Object)baseInc, null);
                    }
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Qt include dir for {0} = {1}", new Object[]{cacheKey, baseDir});
            }
            return baseDir;
        }

        private static String queryBaseQtIncludeDir(ExecutionEnvironment execEnv, String qmakePath) {
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv);
            npb.setExecutable(qmakePath);
            npb.setArguments(new String[]{"-query", "QT_INSTALL_HEADERS"});
            try {
                NativeProcess process = npb.call();
                String output = ProcessUtils.readProcessOutputLine((Process)process).trim();
                if (process.waitFor() == 0 && 0 < output.length()) {
                    return output;
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            return null;
        }

        private static String queryBaseQtLibsDir(ExecutionEnvironment execEnv, String qmakePath) {
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv);
            npb.setExecutable(qmakePath);
            npb.setArguments(new String[]{"-query", "QT_INSTALL_LIBS"});
            try {
                NativeProcess process = npb.call();
                String output = ProcessUtils.readProcessOutputLine((Process)process).trim();
                if (process.waitFor() == 0 && 0 < output.length()) {
                    return output;
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            return null;
        }

        private static String guessBaseQtIncludeDir(String qmakePath) {
            String baseDir;
            String binDir = CndPathUtilities.getDirName((String)qmakePath);
            if (binDir != null && (baseDir = CndPathUtilities.getDirName((String)binDir)) != null) {
                return baseDir + "/include/qt4";
            }
            return "/usr/include/qt4";
        }
    }
}

