/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.performance;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultCaret;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.modules.cnd.discovery.performance.AnalyzeStat;
import org.netbeans.modules.cnd.discovery.performance.Bundle;
import org.netbeans.modules.cnd.discovery.performance.PerformanceIssueDetector;
import org.netbeans.modules.dlight.libs.common.PerformanceLogger;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class StatisticPanel
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor("statistic", 1);
    private final PerformanceIssueDetector activeInstance;
    private final RequestProcessor.Task update;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private String lastUnusedFolders;
    private String lastSlowFolders;
    private String lastInfiniteParsing;
    private JTextPane infiniteParsing;
    private JScrollPane infiniteParsingScrollPane;
    private JTextField itemCpuTime;
    private JLabel itemCpuTimeLabel;
    private JLabel itemLabel;
    private JTextField itemNumber;
    private JLabel itemNumberLabel;
    private JTextField itemRatio;
    private JLabel itemRatioLabel;
    private JTextField itemSpeed;
    private JLabel itemSpeedLabel;
    private JPanel itemSpeedPanel;
    private JTextField itemWallTime;
    private JLabel itemWallTimeLabel;
    private JPanel itemsSlowPanel;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JTextField parsingCpuTime;
    private JLabel parsingCpuTimeLabel;
    private JLabel parsingLabel;
    private JTextField parsingLines;
    private JLabel parsingLinesLabel;
    private JTextField parsingNumber;
    private JLabel parsingNumberLabel;
    private JPanel parsingPanel;
    private JTextField parsingRatio;
    private JLabel parsingRatioLabel;
    private JPanel parsingRatioPanel;
    private JTextField parsingSpeed;
    private JLabel parsingSpeedLabel;
    private JPanel parsingSpeedPanel;
    private JTextField parsingWallTime;
    private JLabel parsingWallTimeLabel;
    private JTextField readCpuTime;
    private JLabel readCpuTimeLabel;
    private JLabel readLabel;
    private JTextField readNumber;
    private JLabel readNumberLabel;
    private JTextField readRatio;
    private JLabel readRatioLabel;
    private JPanel readSlowPanel;
    private JTextField readSpeed;
    private JLabel readSpeedLabel;
    private JPanel readSpeedPanel;
    private JTextField readWallTime;
    private JLabel readWallTimeLabel;
    private JTextPane slowFolders;
    private JScrollPane slowFoldersScrollPane;
    private JTextPane unusedFolders;
    private JScrollPane unusedFoldersScrollPane;

    public StatisticPanel() {
        this.initComponents();
        this.slowFolders.setBackground(this.getBackground());
        this.slowFolders.setEditorKit(new HTMLEditorKit());
        ((DefaultCaret)this.slowFolders.getCaret()).setUpdatePolicy(1);
        this.unusedFolders.setBackground(this.getBackground());
        this.unusedFolders.setEditorKit(new HTMLEditorKit());
        ((DefaultCaret)this.unusedFolders.getCaret()).setUpdatePolicy(1);
        this.infiniteParsing.setBackground(this.getBackground());
        this.infiniteParsing.setEditorKit(new HTMLEditorKit());
        ((DefaultCaret)this.infiniteParsing.getCaret()).setUpdatePolicy(1);
        this.activeInstance = PerformanceIssueDetector.getActiveInstance();
        this.update = RP.post(new Runnable(){

            @Override
            public void run() {
                if (SwingUtilities.isEventDispatchThread()) {
                    StatisticPanel.this.countStatistic();
                } else {
                    SwingUtilities.invokeLater(this);
                }
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (e.getChangeFlags() == 4L && !e.getChanged().isVisible()) {
                    StatisticPanel.this.closed.set(true);
                }
            }
        });
    }

    private void countStatistic() {
        if (this.closed.get()) {
            return;
        }
        if (this.activeInstance == null) {
            return;
        }
        TreeMap<String, AnalyzeStat.AgregatedStat> statistic = this.activeInstance.getStatistic();
        if (statistic != null) {
            long count = 0L;
            long time = 0L;
            long cpu = 0L;
            for (Map.Entry<String, AnalyzeStat.AgregatedStat> entry : statistic.entrySet()) {
                count += (long)entry.getValue().itemNumber;
                time += entry.getValue().itemTime;
                cpu += entry.getValue().itemCPU;
            }
            if (time > 0L) {
                long speed = count * 1000000000L / time;
                this.itemSpeed.setText(PerformanceIssueDetector.format(speed));
                this.getLimit(this.itemSpeedPanel, 100, 500, (int)speed);
                this.itemNumber.setText(PerformanceIssueDetector.format(count));
                this.itemWallTime.setText(PerformanceIssueDetector.format(time / 1000000L));
                this.itemCpuTime.setText(PerformanceIssueDetector.format(cpu / 1000000L));
                this.itemRatio.setText(PerformanceIssueDetector.format(cpu * 100L / time));
            }
            count = 0L;
            time = 0L;
            cpu = 0L;
            for (Map.Entry<String, AnalyzeStat.AgregatedStat> entry : statistic.entrySet()) {
                count += entry.getValue().readBytes;
                time += entry.getValue().readTime;
                cpu += entry.getValue().readCPU;
            }
            if (time > 0L) {
                long speed = count * 1000000000L / time / 1024L;
                this.readSpeed.setText(PerformanceIssueDetector.format(speed));
                this.getLimit(this.readSpeedPanel, 100, 1000, (int)speed);
                this.readNumber.setText(PerformanceIssueDetector.format(count / 1024L));
                this.readWallTime.setText(PerformanceIssueDetector.format(time / 1000000L));
                this.readCpuTime.setText(PerformanceIssueDetector.format(cpu / 1000000L));
                this.readRatio.setText(PerformanceIssueDetector.format(cpu * 100L / time));
            }
            count = 0L;
            long files = 0L;
            long time2 = 0L;
            long cpu2 = 0L;
            for (Map.Entry<String, AnalyzeStat.AgregatedStat> entry : statistic.entrySet()) {
                count += entry.getValue().parseLines;
                files += (long)entry.getValue().parseNumber;
                time2 += entry.getValue().parseTime;
                cpu2 += entry.getValue().parseCPU;
            }
            if (time2 > 0L) {
                long speed = count * 1000000000L / time2;
                this.parsingSpeed.setText(PerformanceIssueDetector.format(speed));
                this.getLimit(this.parsingSpeedPanel, 1000, 10000, (int)speed);
                this.parsingLines.setText(PerformanceIssueDetector.format(count));
                this.parsingNumber.setText(PerformanceIssueDetector.format(files));
                this.parsingWallTime.setText(PerformanceIssueDetector.format(time2 / 1000000L));
                this.parsingCpuTime.setText(PerformanceIssueDetector.format(cpu2 / 1000000L));
                this.parsingRatio.setText(PerformanceIssueDetector.format(cpu2 * 100L / time2));
                this.getLimit(this.parsingRatioPanel, 20, 50, (int)(cpu2 * 100L / time2));
            }
            AnalyzeStat.upEmptyFolder(statistic);
            StringBuilder buf = new StringBuilder();
            int i = 0;
            for (Map.Entry<String, AnalyzeStat.AgregatedStat> entry : AnalyzeStat.getBigUnused(statistic)) {
                if (buf.length() == 0) {
                    buf.append(Bundle.Details_slowest_unused_folders());
                }
                buf.append("<tr><td>");
                buf.append(entry.getKey());
                buf.append("</td><td>");
                buf.append(PerformanceIssueDetector.format(entry.getValue().itemNumber));
                buf.append("</td><td>");
                buf.append(PerformanceIssueDetector.format(entry.getValue().itemTime / 1000000000L));
                buf.append("</td></tr>");
                if (++i != 3) continue;
                break;
            }
            if (buf.length() > 0) {
                buf.append("</tbody></table>");
            }
            if (this.lastUnusedFolders == null || !this.lastUnusedFolders.equals(buf.toString())) {
                this.lastUnusedFolders = buf.toString();
                this.updatePane(this.lastUnusedFolders, this.unusedFolders, this.unusedFoldersScrollPane);
            }
            AnalyzeStat.groupByReadingSpeed(statistic);
            i = 0;
            buf.setLength(0);
            for (Map.Entry<String, AnalyzeStat.AgregatedStat> entry : AnalyzeStat.getSlowReading(statistic)) {
                if (buf.length() == 0) {
                    buf.append(Bundle.Details_slowest_reading_folders());
                }
                buf.append("<tr><td>");
                buf.append(entry.getKey());
                buf.append("</td><td>");
                buf.append(PerformanceIssueDetector.format(entry.getValue().readLines));
                buf.append("</td><td>");
                buf.append(PerformanceIssueDetector.format(entry.getValue().readTime / 1000000000L));
                buf.append("</td></tr>");
                if (++i != 3) continue;
                break;
            }
            if (buf.length() > 0) {
                buf.append("</tbody></table>");
            }
            if (this.lastSlowFolders == null || !this.lastSlowFolders.equals(buf.toString())) {
                this.lastSlowFolders = buf.toString();
                this.updatePane(this.lastSlowFolders, this.slowFolders, this.slowFoldersScrollPane);
            }
            buf.setLength(0);
            for (Map.Entry<String, AnalyzeStat.AgregatedStat> entry : this.activeInstance.getParseTimeout().entrySet()) {
                if (buf.length() == 0) {
                    buf.append(Bundle.Details_slowest_parsing_files());
                }
                buf.append("<tr><td>");
                buf.append(((FileObject)entry.getKey()).getPath());
                buf.append("</td><td>");
                buf.append(PerformanceIssueDetector.format((System.nanoTime() - ((PerformanceLogger.PerformanceEvent)entry.getValue()).getStartTime()) / 1000000000L));
                buf.append("</td><td>");
            }
            if (buf.length() > 0) {
                buf.append("</tbody></table>");
            }
            if (this.lastInfiniteParsing == null || !this.lastInfiniteParsing.equals(buf.toString())) {
                this.lastInfiniteParsing = buf.toString();
                this.updatePane(this.lastInfiniteParsing, this.infiniteParsing, this.infiniteParsingScrollPane);
            }
        }
        this.update.schedule(2000);
    }

    private void updatePane(String text, JTextPane pane, JScrollPane scroll) {
        text = "<head></head><body>" + text + "</body>";
        pane.setText(text);
    }

    private JPanel getLimit(JPanel parent, int low, int normal, int fact) {
        parent.removeAll();
        MyPanel panel = new MyPanel(low, normal, fact);
        parent.add((Component)panel, "Center");
        parent.validate();
        parent.repaint();
        return panel;
    }

    private void initComponents() {
        this.itemLabel = new JLabel();
        this.itemSpeedLabel = new JLabel();
        this.itemSpeed = new JTextField();
        this.itemNumberLabel = new JLabel();
        this.itemNumber = new JTextField();
        this.itemWallTimeLabel = new JLabel();
        this.itemWallTime = new JTextField();
        this.itemCpuTimeLabel = new JLabel();
        this.itemCpuTime = new JTextField();
        this.itemRatioLabel = new JLabel();
        this.itemRatio = new JTextField();
        this.readLabel = new JLabel();
        this.readSpeedLabel = new JLabel();
        this.readSpeed = new JTextField();
        this.readNumberLabel = new JLabel();
        this.readNumber = new JTextField();
        this.readWallTimeLabel = new JLabel();
        this.readWallTime = new JTextField();
        this.readCpuTimeLabel = new JLabel();
        this.readCpuTime = new JTextField();
        this.readRatioLabel = new JLabel();
        this.readRatio = new JTextField();
        this.parsingLabel = new JLabel();
        this.parsingSpeedLabel = new JLabel();
        this.parsingSpeed = new JTextField();
        this.parsingLinesLabel = new JLabel();
        this.parsingLines = new JTextField();
        this.parsingNumberLabel = new JLabel();
        this.parsingNumber = new JTextField();
        this.parsingWallTimeLabel = new JLabel();
        this.parsingWallTime = new JTextField();
        this.parsingCpuTimeLabel = new JLabel();
        this.parsingCpuTime = new JTextField();
        this.parsingRatioLabel = new JLabel();
        this.parsingRatio = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.itemSpeedPanel = new JPanel();
        this.readSpeedPanel = new JPanel();
        this.parsingSpeedPanel = new JPanel();
        this.parsingRatioPanel = new JPanel();
        this.itemsSlowPanel = new JPanel();
        this.unusedFoldersScrollPane = new JScrollPane();
        this.unusedFolders = new JTextPane();
        this.readSlowPanel = new JPanel();
        this.slowFoldersScrollPane = new JScrollPane();
        this.slowFolders = new JTextPane();
        this.parsingPanel = new JPanel();
        this.infiniteParsingScrollPane = new JScrollPane();
        this.infiniteParsing = new JTextPane();
        this.setMinimumSize(new Dimension(500, 350));
        this.setPreferredSize(new Dimension(700, 550));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.itemLabel, (String)NbBundle.getMessage(StatisticPanel.class, (String)"StatisticPanel.itemLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.itemLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.itemSpeedLabel, (String)NbBundle.getMessage(StatisticPanel.class, (String)"StatisticPanel.itemSpeedLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.itemSpeedLabel, gridBagConstraints);
        this.itemSpeed.setEditable(false);
        this.itemSpeed.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.itemSpeed, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.itemNumberLabel, (String)NbBundle.getMessage(StatisticPanel.class, (String)"StatisticPanel.itemNumberLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.itemNumberLabel, gridBagConstraints);
        this.itemNumber.setEditable(false);
        this.itemNumber.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.itemNumber, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.itemWallTimeLabel, (String)NbBundle.getMessage(StatisticPanel.class, (String)"StatisticPanel.itemWallTimeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.itemWallTimeLabel, gridBagConstraints);
        this.itemWallTime.setEditable(false);
        this.itemWallTime.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.itemWallTime, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.itemCpuTimeLabel, (String)NbBundle.getMessage(StatisticPanel.class, (String)"StatisticPanel.itemCpuTimeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.itemCpuTimeLabel, gridBagConstraints);
        this.itemCpuTime.setEditable(false);
        this.itemCpuTime.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.itemCpuTime, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.itemRatioLabel, (String)NbBundle.getMessage(StatisticPanel.class, (String)"StatisticPanel.itemRatioLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.itemRatioLabel, gridBagConstraints);
        this.itemRatio.setEditable(false);
        this.itemRatio.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.itemRatio, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.readLabel, (String)NbBundle.getMessage(StatisticPanel.class, (String)"StatisticPanel.readLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.readLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.readSpeedLabel, (String)NbBundle.getMessage(StatisticPanel.class, (String)"StatisticPanel.readSpeedLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.readSpeedLabel, gridBagConstraints);
        this.readSpeed.setEditable(false);
        this.readSpeed.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.readSpeed, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.readNumberLabel, (String)NbBundle.getMessage(StatisticPanel.class, (String)"StatisticPanel.readNumberLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.readNumberLabel, gridBagConstraints);
        this.readNumber.setEditable(false);
        this.readNumber.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.readNumber, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.readWallTimeLabel, (String)NbBundle.getMessage(StatisticPanel.class, (String)"StatisticPanel.readWallTimeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.readWallTimeLabel, gridBagConstraints);
        this.readWallTime.setEditable(false);
        this.readWallTime.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.readWallTime, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.readCpuTimeLabel, (String)NbBundle.getMessage(StatisticPanel.class, (String)"StatisticPanel.readCpuTimeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.readCpuTimeLabel, gridBagConstraints);
        this.readCpuTime.setEditable(false);
        this.readCpuTime.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.readCpuTime, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.readRatioLabel, (String)NbBundle.getMessage(StatisticPanel.class, (String)"StatisticPanel.readRatioLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.readRatioLabel, gridBagConstraints);
        this.readRatio.setEditable(false);
        this.readRatio.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.readRatio, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.parsingLabel, (String)NbBundle.getMessage(StatisticPanel.class, (String)"StatisticPanel.parsingLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.parsingLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.parsingSpeedLabel, (String)NbBundle.getMessage(StatisticPanel.class, (String)"StatisticPanel.parsingSpeedLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.parsingSpeedLabel, gridBagConstraints);
        this.parsingSpeed.setEditable(false);
        this.parsingSpeed.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.parsingSpeed, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.parsingLinesLabel, (String)NbBundle.getMessage(StatisticPanel.class, (String)"StatisticPanel.parsingLinesLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.parsingLinesLabel, gridBagConstraints);
        this.parsingLines.setEditable(false);
        this.parsingLines.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.parsingLines, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.parsingNumberLabel, (String)NbBundle.getMessage(StatisticPanel.class, (String)"StatisticPanel.parsingNumberLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.parsingNumberLabel, gridBagConstraints);
        this.parsingNumber.setEditable(false);
        this.parsingNumber.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.parsingNumber, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.parsingWallTimeLabel, (String)NbBundle.getMessage(StatisticPanel.class, (String)"StatisticPanel.parsingWallTimeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.parsingWallTimeLabel, gridBagConstraints);
        this.parsingWallTime.setEditable(false);
        this.parsingWallTime.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.parsingWallTime, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.parsingCpuTimeLabel, (String)NbBundle.getMessage(StatisticPanel.class, (String)"StatisticPanel.parsingCpuTimeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.parsingCpuTimeLabel, gridBagConstraints);
        this.parsingCpuTime.setEditable(false);
        this.parsingCpuTime.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.parsingCpuTime, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.parsingRatioLabel, (String)NbBundle.getMessage(StatisticPanel.class, (String)"StatisticPanel.parsingRatioLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.parsingRatioLabel, gridBagConstraints);
        this.parsingRatio.setEditable(false);
        this.parsingRatio.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.parsingRatio, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.jSeparator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.jSeparator3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.itemSpeedPanel.setMinimumSize(new Dimension(202, 22));
        this.itemSpeedPanel.setPreferredSize(new Dimension(202, 22));
        this.itemSpeedPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.itemSpeedPanel, gridBagConstraints);
        this.readSpeedPanel.setMinimumSize(new Dimension(202, 22));
        this.readSpeedPanel.setPreferredSize(new Dimension(202, 22));
        this.readSpeedPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.readSpeedPanel, gridBagConstraints);
        this.parsingSpeedPanel.setMinimumSize(new Dimension(202, 22));
        this.parsingSpeedPanel.setPreferredSize(new Dimension(202, 22));
        this.parsingSpeedPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.parsingSpeedPanel, gridBagConstraints);
        this.parsingRatioPanel.setInheritsPopupMenu(true);
        this.parsingRatioPanel.setMinimumSize(new Dimension(202, 22));
        this.parsingRatioPanel.setPreferredSize(new Dimension(202, 22));
        this.parsingRatioPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.parsingRatioPanel, gridBagConstraints);
        this.itemsSlowPanel.setLayout(new BorderLayout());
        this.unusedFolders.setEditable(false);
        this.unusedFoldersScrollPane.setViewportView(this.unusedFolders);
        this.itemsSlowPanel.add((Component)this.unusedFoldersScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.itemsSlowPanel, gridBagConstraints);
        this.readSlowPanel.setLayout(new BorderLayout());
        this.slowFolders.setEditable(false);
        this.slowFoldersScrollPane.setViewportView(this.slowFolders);
        this.readSlowPanel.add((Component)this.slowFoldersScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.readSlowPanel, gridBagConstraints);
        this.parsingPanel.setLayout(new BorderLayout());
        this.infiniteParsing.setEditable(false);
        this.infiniteParsingScrollPane.setViewportView(this.infiniteParsing);
        this.parsingPanel.add((Component)this.infiniteParsingScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.parsingPanel, gridBagConstraints);
    }

    private static final class MyPanel
    extends JPanel {
        private static final int NORMAL_COLOR = 192;
        private static final int BRIGHT_COLOR = 224;
        private final int low;
        private final int normal;
        private final int fact;

        private MyPanel(int low, int normal, int fact) {
            this.low = low;
            this.normal = normal;
            this.fact = fact;
        }

        @Override
        public Color getBackground() {
            return Color.WHITE;
        }

        @Override
        public void paint(Graphics g) {
            int MY_HEIGHT = this.getHeight();
            int MY_WIDTH = this.getWidth();
            Graphics2D graphics = (Graphics2D)g;
            graphics.drawRect(0, 0, MY_WIDTH, MY_HEIGHT);
            if (MY_WIDTH < 100 || MY_HEIGHT < 20) {
                return;
            }
            double m1 = Math.log(this.low);
            double m2 = Math.log(this.normal);
            double m3 = this.fact == 0 ? (double)(this.low - 2) : Math.log(this.fact);
            double min = Math.min(Math.min(m1, m2), m3);
            double max = Math.max(Math.max(m1, m2), m3);
            int borders = MY_WIDTH / 4;
            double point = (double)(MY_WIDTH - borders) / (max - min);
            int m1x = (int)((double)(borders / 2) + (m1 - min) * point);
            int m2x = (int)((double)(borders / 2) + (m2 - min) * point);
            int m3x = (int)((double)(borders / 2) + (m3 - min) * point);
            Color def = graphics.getColor();
            float[] fractions = new float[]{0.0f, 1.0f};
            Color[] colors = new Color[]{new Color(224, 0, 0), new Color(192, 0, 0)};
            LinearGradientPaint gradient = new LinearGradientPaint(1.0f, 1.0f, m1x - 1, 1.0f, fractions, colors);
            graphics.setPaint(gradient);
            graphics.fillRect(1, 1, m1x - 1, MY_HEIGHT - 2);
            fractions = new float[]{0.0f, 0.3f, 0.5f, 0.7f, 1.0f};
            colors = new Color[]{new Color(192, 0, 0), new Color(192, 192, 0), new Color(224, 224, 0), new Color(192, 192, 0), new Color(0, 192, 0)};
            gradient = new LinearGradientPaint(m1x + 1, 1.0f, m2x - 1, 1.0f, fractions, colors);
            graphics.setPaint(gradient);
            graphics.fillRect(m1x + 1, 1, m2x - m1x - 1, MY_HEIGHT - 2);
            fractions = new float[]{0.0f, 1.0f};
            colors = new Color[]{new Color(0, 192, 0), new Color(0, 224, 0)};
            gradient = new LinearGradientPaint(m2x + 1, 1.0f, MY_WIDTH - 1, 1.0f, fractions, colors);
            graphics.setPaint(gradient);
            graphics.fillRect(m2x + 1, 1, MY_WIDTH - m2x - 1, MY_HEIGHT - 2);
            graphics.setColor(Color.blue);
            graphics.fillOval(m3x - MY_HEIGHT / 4, MY_HEIGHT / 4, MY_HEIGHT / 2, MY_HEIGHT / 2);
            graphics.setColor(def);
            graphics.drawLine(m1x, MY_HEIGHT - 2, m1x, 1);
            String what = "" + this.low;
            int shift = graphics.getFontMetrics().getStringBounds((String)what, (Graphics)g).getBounds().width / 2;
            graphics.drawString(what, m1x - shift, MY_HEIGHT - 5);
            graphics.drawLine(m2x, MY_HEIGHT - 2, m2x, 1);
            what = "" + this.normal;
            shift = graphics.getFontMetrics().getStringBounds((String)what, (Graphics)g).getBounds().width / 2;
            graphics.drawString(what, m2x - shift, MY_HEIGHT - 5);
            graphics.draw3DRect(0, 0, MY_WIDTH - 1, MY_HEIGHT - 1, false);
        }
    }
}

