/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProviderFactory;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderPropertyType;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.discovery.projectimport.ImportExecutable;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.discovery.services.DiscoveryManagerImpl;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.SelectConfigurationPanel;
import org.netbeans.modules.cnd.discovery.wizard.api.ConfigurationFactory;
import org.netbeans.modules.cnd.discovery.wizard.api.ConsolidationStrategy;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.ProjectConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.support.impl.DiscoveryProjectGeneratorImpl;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public class DiscoveryExtension
implements IteratorExtension,
DiscoveryExtensionInterface {
    public static final String DWARF_PROVIDER = "dwarf-executable";
    public static final String FOLDER_PROVIDER = "dwarf-folder";
    public static final String MAKE_LOG_PROVIDER = "make-log";
    public static final String EXEC_LOG_PROVIDER = "exec-log";
    public static final String MODEL_FOLDER_PROVIDER = "model-folder";

    public void discoverArtifacts(Map<String, Object> map) {
        DiscoveryDescriptor descriptor = DiscoveryWizardDescriptor.adaptee(map);
        DiscoveryExtensionInterface.Applicable applicable = this.isApplicable(descriptor, null, false);
        if (applicable.isApplicable()) {
            descriptor.setCompilerName(applicable.getCompilerName());
            descriptor.setDependencies(applicable.getDependencies());
            descriptor.setSearchPaths(applicable.getSearchPaths());
            descriptor.setRootFolder(applicable.getSourceRoot());
            descriptor.setErrors(applicable.getErrors());
        } else {
            descriptor.setErrors(applicable.getErrors());
        }
    }

    public Set<FileObject> createProject(WizardDescriptor wizard) throws IOException {
        return new ImportProject(wizard).create();
    }

    @Override
    public void apply(Map<String, Object> map, Project project) throws IOException {
        this.apply(map, project, null);
    }

    @Override
    public void apply(Map<String, Object> map, Project project, Interrupter interrupter) throws IOException {
        DiscoveryDescriptor descriptor = DiscoveryWizardDescriptor.adaptee(map);
        descriptor.setProject(project);
        DiscoveryProjectGeneratorImpl generator = new DiscoveryProjectGeneratorImpl(descriptor);
        generator.makeProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoveryExtensionInterface.Applicable isApplicable(DiscoveryDescriptor descriptor, Interrupter interrupter, boolean findMain) {
        SelectConfigurationPanel.MyProgress progress = new SelectConfigurationPanel.MyProgress(NbBundle.getMessage(DiscoveryExtension.class, (String)"AnalyzingProjectProgress"));
        progress.start(0);
        try {
            ArrayList<String> errors = new ArrayList<String>();
            DiscoveryExtensionInterface.Applicable applicable = this.isApplicableExecLog(descriptor);
            if (applicable.isApplicable()) {
                DiscoveryExtensionInterface.Applicable applicable2 = applicable;
                return applicable2;
            }
            applicable = this.isApplicableDwarfExecutable(descriptor, findMain);
            if (applicable.isApplicable()) {
                DiscoveryExtensionInterface.Applicable applicable3 = applicable;
                return applicable3;
            }
            if (applicable.getErrors() != null) {
                errors.addAll(applicable.getErrors());
            }
            if ((applicable = this.isApplicableMakeLog(descriptor)).isApplicable()) {
                DiscoveryExtensionInterface.Applicable applicable4 = applicable;
                return applicable4;
            }
            if (applicable.getErrors() != null) {
                errors.addAll(applicable.getErrors());
            }
            if ((applicable = this.isApplicableDwarfFolder(descriptor, interrupter)).isApplicable()) {
                DiscoveryExtensionInterface.Applicable applicable5 = applicable;
                return applicable5;
            }
            if (applicable.getErrors() != null) {
                errors.addAll(applicable.getErrors());
            }
            if (!errors.isEmpty()) {
                DiscoveryExtensionInterface.Applicable applicable6 = ApplicableImpl.getNotApplicable(errors);
                return applicable6;
            }
            DiscoveryExtensionInterface.Applicable applicable7 = ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"NoExecutable_NoBaseFolder")));
            return applicable7;
        }
        finally {
            progress.done();
        }
    }

    private DiscoveryExtensionInterface.Applicable isApplicableDwarfExecutable(DiscoveryDescriptor descriptor, boolean findMain) {
        FileObject file;
        String selectedExecutable = descriptor.getBuildResult();
        if (selectedExecutable == null) {
            return ApplicableImpl.getNotApplicable(null);
        }
        FileSystem fileSystem = descriptor.getFileSystem();
        if (fileSystem == null) {
            fileSystem = FileSystemProvider.getFileSystem((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
        }
        if ((file = new FSPath(fileSystem, selectedExecutable).getFileObject()) == null || !file.isValid()) {
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"NotFoundExecutable", (Object)selectedExecutable)));
        }
        ProjectProxyImpl proxy = new ProjectProxyImpl(descriptor);
        DiscoveryProvider provider = DiscoveryProviderFactory.findProvider(DWARF_PROVIDER);
        if (provider != null && provider.isApplicable(proxy)) {
            ProviderPropertyType.ExecutablePropertyType.setProperty(provider, selectedExecutable);
            String aditionalLibraries = descriptor.getAditionalLibraries();
            if (aditionalLibraries == null || aditionalLibraries.isEmpty()) {
                ProviderPropertyType.LibrariesPropertyType.setProperty(provider, new String[0]);
            } else {
                ProviderPropertyType.LibrariesPropertyType.setProperty(provider, aditionalLibraries.split(";"));
            }
            ProviderPropertyType.BinaryFileSystemPropertyType.setProperty(provider, descriptor.getFileSystem());
            ProviderPropertyType.FindMainPropertyType.setProperty(provider, findMain);
            DiscoveryExtensionInterface.Applicable canAnalyze = provider.canAnalyze(proxy, null);
            if (canAnalyze.isApplicable()) {
                descriptor.setProvider(provider);
                return canAnalyze;
            }
            if (canAnalyze.getErrors().size() > 0) {
                return ApplicableImpl.getNotApplicable(canAnalyze.getErrors());
            }
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"CannotAnalyzeExecutable", (Object)selectedExecutable)));
        }
        return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"NotFoundDiscoveryProvider")));
    }

    private DiscoveryExtensionInterface.Applicable isApplicableDwarfFolder(DiscoveryDescriptor descriptor, Interrupter interrupter) {
        String buildFolder = descriptor.getBuildFolder();
        if (buildFolder == null) {
            buildFolder = descriptor.getRootFolder();
        }
        if (buildFolder == null) {
            return ApplicableImpl.getNotApplicable(null);
        }
        ProjectProxyImpl proxy = new ProjectProxyImpl(descriptor);
        DiscoveryProvider provider = DiscoveryProviderFactory.findProvider(FOLDER_PROVIDER);
        if (provider != null && provider.isApplicable(proxy)) {
            ProviderPropertyType.ExecutableFolderPropertyType.setProperty(provider, buildFolder);
            DiscoveryExtensionInterface.Applicable canAnalyze = provider.canAnalyze(proxy, interrupter);
            if (canAnalyze.isApplicable()) {
                descriptor.setProvider(provider);
                return canAnalyze;
            }
            if (canAnalyze.getErrors().size() > 0) {
                return ApplicableImpl.getNotApplicable(canAnalyze.getErrors());
            }
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"CannotAnalyzeFolder", (Object)buildFolder)));
        }
        return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"NotFoundDiscoveryProvider")));
    }

    private DiscoveryExtensionInterface.Applicable isApplicableMakeLog(DiscoveryDescriptor descriptor) {
        String rootFolder = descriptor.getRootFolder();
        if (rootFolder == null) {
            return ApplicableImpl.getNotApplicable(null);
        }
        String logFile = descriptor.getBuildLog();
        ProjectProxyImpl proxy = new ProjectProxyImpl(descriptor);
        DiscoveryProvider provider = DiscoveryProviderFactory.findProvider(MAKE_LOG_PROVIDER);
        if (provider != null && provider.isApplicable(proxy)) {
            ProviderPropertyType.MakeLogPropertyType.setProperty(provider, logFile);
            DiscoveryExtensionInterface.Applicable canAnalyze = provider.canAnalyze(proxy, null);
            if (canAnalyze.isApplicable()) {
                descriptor.setProvider(provider);
                return canAnalyze;
            }
            if (canAnalyze.getErrors().size() > 0) {
                return ApplicableImpl.getNotApplicable(canAnalyze.getErrors());
            }
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"CannotAnalyzeBuildLog", (Object)logFile)));
        }
        return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"NotFoundDiscoveryProvider")));
    }

    private DiscoveryExtensionInterface.Applicable isApplicableExecLog(DiscoveryDescriptor descriptor) {
        String rootFolder = descriptor.getRootFolder();
        if (rootFolder == null) {
            return ApplicableImpl.getNotApplicable(null);
        }
        String logFile = descriptor.getExecLog();
        if (logFile == null) {
            logFile = descriptor.getBuildLog();
        }
        ProjectProxyImpl proxy = new ProjectProxyImpl(descriptor);
        DiscoveryProvider provider = DiscoveryProviderFactory.findProvider(EXEC_LOG_PROVIDER);
        if (provider != null) {
            ProviderPropertyType.ExecLogPropertyType.setProperty(provider, logFile);
            if (provider.isApplicable(proxy)) {
                DiscoveryExtensionInterface.Applicable canAnalyze = provider.canAnalyze(proxy, null);
                if (canAnalyze.isApplicable()) {
                    descriptor.setProvider(provider);
                    return canAnalyze;
                }
                if (canAnalyze.getErrors().size() > 0) {
                    return ApplicableImpl.getNotApplicable(canAnalyze.getErrors());
                }
                return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"CannotAnalyzeBuildLog", (Object)logFile)));
            }
        }
        return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(DiscoveryExtension.class, (String)"NotFoundDiscoveryProvider")));
    }

    public DiscoveryExtensionInterface.Applicable isApplicable(Map<String, Object> map, Project project, boolean findMain) {
        DiscoveryDescriptor descriptor = DiscoveryWizardDescriptor.adaptee(map);
        return this.isApplicable(descriptor, null, findMain);
    }

    boolean canApply(DiscoveryDescriptor descriptor, Interrupter interrupter) {
        if (!this.isApplicable(descriptor, interrupter, false).isApplicable()) {
            return false;
        }
        DiscoveryProvider provider = descriptor.getProvider();
        if (provider == null) {
            return false;
        }
        if (DWARF_PROVIDER.equals(provider.getID())) {
            String selectedExecutable = descriptor.getBuildResult();
            String additional = descriptor.getAditionalLibraries();
            ProviderPropertyType.ExecutablePropertyType.setProperty(provider, selectedExecutable);
            ProviderPropertyType.FindMainPropertyType.setProperty(provider, Boolean.TRUE);
            if (additional != null && additional.length() > 0) {
                ArrayList<String> list = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(additional, ";");
                while (st.hasMoreTokens()) {
                    list.add(st.nextToken());
                }
                ProviderPropertyType.LibrariesPropertyType.setProperty(provider, list.toArray(new String[list.size()]));
            } else {
                ProviderPropertyType.LibrariesPropertyType.setProperty(provider, new String[0]);
            }
        } else if (FOLDER_PROVIDER.equals(provider.getID())) {
            String buildFolder = descriptor.getBuildFolder();
            if (buildFolder == null) {
                buildFolder = descriptor.getRootFolder();
            }
            ProviderPropertyType.ExecutableFolderPropertyType.setProperty(provider, buildFolder);
        } else if (!MAKE_LOG_PROVIDER.equals(provider.getID()) && !EXEC_LOG_PROVIDER.equals(provider.getID())) {
            return false;
        }
        DiscoveryExtension.buildModel(descriptor, interrupter);
        if (interrupter != null && interrupter.cancelled()) {
            return false;
        }
        return !descriptor.isInvokeProvider() && descriptor.getConfigurations() != null && descriptor.getConfigurations().size() > 0 && descriptor.getIncludedFiles() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildModel(final DiscoveryDescriptor wizardDescriptor, Interrupter interrupter) {
        String rootFolder = wizardDescriptor.getRootFolder();
        DiscoveryProvider provider = wizardDescriptor.getProvider();
        List<Configuration> configs = provider.analyze(new ProjectProxy(){

            @Override
            public boolean createSubProjects() {
                return false;
            }

            @Override
            public Project getProject() {
                return wizardDescriptor.getProject();
            }

            @Override
            public String getMakefile() {
                return null;
            }

            @Override
            public String getSourceRoot() {
                return wizardDescriptor.getRootFolder();
            }

            @Override
            public String getExecutable() {
                return wizardDescriptor.getBuildResult();
            }

            @Override
            public String getWorkingFolder() {
                return null;
            }

            @Override
            public boolean mergeProjectProperties() {
                return wizardDescriptor.isIncrementalMode();
            }

            @Override
            public boolean resolveSymbolicLinks() {
                return wizardDescriptor.isResolveSymbolicLinks();
            }
        }, new SelectConfigurationPanel.MyProgress(NbBundle.getMessage(DiscoveryExtension.class, (String)"AnalyzingProjectProgress")), interrupter);
        if (interrupter != null && interrupter.cancelled()) {
            return;
        }
        SelectConfigurationPanel.MyProgress myProgress = new SelectConfigurationPanel.MyProgress(NbBundle.getMessage(DiscoveryExtension.class, (String)"BuildCodeAssistanceProgress"));
        try {
            myProgress.start();
            ArrayList<ProjectConfiguration> projectConfigurations = new ArrayList<ProjectConfiguration>();
            ArrayList<String> includedFiles = new ArrayList<String>();
            wizardDescriptor.setIncludedFiles(includedFiles);
            HashMap<String, AtomicInteger> compilers = new HashMap<String, AtomicInteger>();
            HashSet<String> dep = new HashSet<String>();
            HashSet<String> buildArtifacts = new HashSet<String>();
            for (Configuration conf : configs) {
                includedFiles.addAll(conf.getIncludedFiles());
                List<ProjectProperties> langList = conf.getProjectConfiguration();
                Iterator<ProjectProperties> it2 = langList.iterator();
                while (it2.hasNext()) {
                    ProjectConfiguration project = ConfigurationFactory.makeRoot(it2.next(), rootFolder);
                    ConsolidationStrategy.consolidateModel(project);
                    projectConfigurations.add(project);
                }
                for (SourceFileProperties source : conf.getSourcesConfiguration()) {
                    String compiler = source.getCompilerName();
                    if (compiler == null) continue;
                    AtomicInteger count = (AtomicInteger)compilers.get(compiler);
                    if (count == null) {
                        count = new AtomicInteger();
                        compilers.put(compiler, count);
                    }
                    count.incrementAndGet();
                }
                if (conf.getDependencies() != null) {
                    dep.addAll(conf.getDependencies());
                }
                if (conf.getBuildArtifacts() == null) continue;
                buildArtifacts.addAll(conf.getBuildArtifacts());
            }
            wizardDescriptor.setInvokeProvider(false);
            wizardDescriptor.setDependencies(new ArrayList<String>(dep));
            wizardDescriptor.setBuildArtifacts(new ArrayList<String>(buildArtifacts));
            wizardDescriptor.setConfigurations(projectConfigurations);
            int max = 0;
            String top = "";
            for (Map.Entry entry : compilers.entrySet()) {
                if (((AtomicInteger)entry.getValue()).get() <= max) continue;
                max = ((AtomicInteger)entry.getValue()).get();
                top = (String)entry.getKey();
            }
            wizardDescriptor.setCompilerName(top);
        }
        finally {
            myProgress.done();
        }
    }

    @Override
    public boolean canApply(Map<String, Object> map, Project project) {
        return this.canApply(map, project, null);
    }

    @Override
    public boolean canApply(Map<String, Object> map, Project project, Interrupter interrupter) {
        DiscoveryDescriptor descriptor = DiscoveryWizardDescriptor.adaptee(map);
        descriptor.setProject(project);
        return this.canApply(descriptor, interrupter);
    }

    public void discoverProject(Map<String, Object> map, Project lastSelectedProject, IteratorExtension.ProjectKind projectKind) {
        ImportExecutable importer = new ImportExecutable(map, lastSelectedProject, projectKind);
        if (lastSelectedProject != null) {
            importer.process(this);
        }
    }

    public void discoverHeadersByModel(Project project) {
        DiscoveryManagerImpl.discoverHeadersByModel(project);
    }

    public void disableModel(Project makeProject) {
        CsmModel model = CsmModelAccessor.getModel();
        if (model != null && makeProject != null) {
            NativeProject np = (NativeProject)makeProject.getLookup().lookup(NativeProject.class);
            model.disableProject((Object)np);
        }
    }

    private static class ProjectProxyImpl
    implements ProjectProxy {
        private final DiscoveryDescriptor descriptor;

        private ProjectProxyImpl(DiscoveryDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public boolean createSubProjects() {
            return false;
        }

        @Override
        public Project getProject() {
            return null;
        }

        @Override
        public String getMakefile() {
            return null;
        }

        @Override
        public String getSourceRoot() {
            return this.descriptor.getRootFolder();
        }

        @Override
        public String getExecutable() {
            return this.descriptor.getBuildResult();
        }

        @Override
        public String getWorkingFolder() {
            return null;
        }

        @Override
        public boolean mergeProjectProperties() {
            return false;
        }

        @Override
        public boolean resolveSymbolicLinks() {
            return this.descriptor.isResolveSymbolicLinks();
        }
    }
}

