/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardIterator;
import org.netbeans.modules.cnd.discovery.wizard.SelectConfigurationWizard;
import org.netbeans.modules.cnd.discovery.wizard.SelectObjectFilesWizard;
import org.netbeans.modules.cnd.discovery.wizard.SelectProviderWizard;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.wizards.CommonUtilities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;

public final class DiscoveryWizardAction
extends NodeAction {
    public static final String HELP_CONTEXT_SELECT_MODE = "CodeAssistanceWizardP1";
    public static final String HELP_CONTEXT_SIMPLE_CONFIGURATION = "CodeAssistanceWizardP6";
    public static final String HELP_CONTEXT_SELECT_PROVIDER = "CodeAssistanceWizardP2";
    public static final String HELP_CONTEXT_SELECT_OBJECT_FILES = "CodeAssistanceWizardP3";
    public static final String HELP_CONTEXT_CONSOLIDATION_STRATEGY = "CodeAssistanceWizardP4";
    public static final String HELP_CONTEXT_SELECT_CONFIGURATION = "CodeAssistanceWizardP5";

    public DiscoveryWizardAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected void performAction(Node[] activatedNodes) {
        Collection<Project> projects = this.getMakeProjects(activatedNodes);
        if (projects == null || projects.size() != 1) {
            return;
        }
        this.invokeWizard(projects.iterator().next());
    }

    protected boolean enable(Node[] activatedNodes) {
        Collection<Project> projects = this.getMakeProjects(activatedNodes);
        return projects != null && projects.size() == 1;
    }

    private void invokeWizard(Project project) {
        boolean cancelled;
        MakeConfiguration activeConfiguration;
        MakeConfigurationDescriptor cd;
        DiscoveryWizardDescriptor wizardDescriptor = new DiscoveryWizardDescriptor((WizardDescriptor.Iterator)this.getPanels());
        wizardDescriptor.setProject(project);
        wizardDescriptor.setRootFolder(DiscoveryWizardAction.findSourceRoot(project));
        wizardDescriptor.setBuildResult(DiscoveryWizardAction.findBuildResult(project));
        wizardDescriptor.setFileSystem(DiscoveryWizardAction.findBuildResultFileSystem(project));
        boolean resolveSymbolic = CommonUtilities.resolveSymbolicLinks();
        ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (cdp != null && cdp.gotDescriptor() && (cd = cdp.getConfigurationDescriptor()) != null && (activeConfiguration = cd.getActiveConfiguration()) != null) {
            resolveSymbolic = activeConfiguration.getCodeAssistanceConfiguration().getResolveSymbolicLinks().getValue();
        }
        wizardDescriptor.setResolveSymbolicLinks(resolveSymbolic);
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle(this.getString("WIZARD_TITLE_TXT"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            // empty if block
        }
        dialog.dispose();
    }

    private static String findBuildResult(Project project) {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp == null || !pdp.gotDescriptor()) {
            return null;
        }
        MakeConfigurationDescriptor make = pdp.getConfigurationDescriptor();
        MakeConfiguration conf = make.getActiveConfiguration();
        if (conf != null) {
            String output = conf.getMakefileConfiguration().getAbsOutput();
            if (output == null || output.length() == 0) {
                return null;
            }
            return output;
        }
        return null;
    }

    private static FileSystem findBuildResultFileSystem(Project project) {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp == null || !pdp.gotDescriptor()) {
            return null;
        }
        MakeConfigurationDescriptor make = pdp.getConfigurationDescriptor();
        MakeConfiguration conf = make.getActiveConfiguration();
        if (conf != null) {
            ExecutionEnvironment env = conf.getDevelopmentHost().getExecutionEnvironment();
            return FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
        }
        return null;
    }

    private static String getProjectDirectoryPath(Project project) {
        FileObject projectDirectory = project.getProjectDirectory();
        if (CndFileUtils.isLocalFileSystem((FileObject)projectDirectory) && Utilities.isWindows()) {
            return projectDirectory.getPath().replace('\\', '/');
        }
        return projectDirectory.getPath();
    }

    public static String findSourceRoot(Project project) {
        String base = DiscoveryWizardAction.getProjectDirectoryPath(project);
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp != null && pdp.gotDescriptor()) {
            MakeConfigurationDescriptor make = pdp.getConfigurationDescriptor();
            Folder folder = make.getLogicalFolders();
            List sources = folder.getFolders();
            List roots = make.getAbsoluteSourceRoots();
            if (roots.size() > 0) {
                return (String)roots.get(0);
            }
            for (Object o : sources) {
                Folder sub = (Folder)o;
                if (!sub.isProjectFiles()) continue;
                if ("SourceFiles".equals(sub.getName())) {
                    List v = sub.getFolders();
                    for (Object e : v) {
                        Folder s = (Folder)e;
                        if (!s.isProjectFiles()) continue;
                        roots.add(s.getName());
                    }
                    continue;
                }
                if ("HeaderFiles".equals(sub.getName()) || "ResourceFiles".equals(sub.getName())) continue;
                roots.add(sub.getName());
            }
            if (roots.size() > 0) {
                String rootName = (String)roots.get(0);
                Item[] items = make.getProjectItems();
                if (items.length > 0) {
                    String path = items[0].getAbsPath();
                    StringBuilder newBase = null;
                    newBase = path.startsWith("..") ? new StringBuilder(base) : new StringBuilder();
                    StringTokenizer st = new StringTokenizer(path, "/\\");
                    while (st.hasMoreTokens()) {
                        String segment = st.nextToken();
                        newBase.append(CndFileUtils.getFileSeparatorChar((FileSystem)make.getBaseDirFileSystem()));
                        newBase.append(segment);
                        if (!rootName.equals(segment) || !st.hasMoreTokens()) continue;
                        return CndFileUtils.normalizeAbsolutePath((FileSystem)make.getBaseDirFileSystem(), (String)newBase.toString());
                    }
                }
            }
        }
        return base;
    }

    private Collection<Project> getMakeProjects(Node[] nodes) {
        ArrayList<Project> projects = new ArrayList<Project>();
        for (int i = 0; i < nodes.length; ++i) {
            Project project = (Project)nodes[i].getLookup().lookup(Project.class);
            if (project == null) {
                return null;
            }
            ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            if (pdp == null || !pdp.gotDescriptor()) {
                return null;
            }
            MakeConfigurationDescriptor make = pdp.getConfigurationDescriptor();
            if (make == null) {
                return null;
            }
            MakeConfiguration conf = make.getActiveConfiguration();
            if (conf == null || !conf.isMakefileConfiguration()) {
                return null;
            }
            projects.add(project);
        }
        return projects;
    }

    private WizardDescriptor.InstantiatingIterator getPanels() {
        WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{new SelectProviderWizard(), new SelectObjectFilesWizard(), new SelectConfigurationWizard()};
        String[] steps = new String[panels.length];
        for (int i = 0; i < panels.length; ++i) {
            Component c = panels[i].getComponent();
            steps[i] = c.getName();
            this.setupComponent(steps, i, c);
        }
        return new DiscoveryWizardIterator(panels);
    }

    private void setupComponent(String[] steps, int i, Component c) {
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
    }

    public String getName() {
        return this.getString("ACTION_TITLE_TXT");
    }

    public String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private String getString(String key) {
        return NbBundle.getMessage(DiscoveryWizardAction.class, (String)key);
    }
}

