/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.TreeElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;

final class TypeTreeElementImpl
implements TreeElement<TypeElement> {
    private final TypeElement delegate;
    private final Set<TypeElement> preferredTypes;
    private final boolean superTypesAsChildren;
    private volatile Set<TreeElement<TypeElement>> children;

    TypeTreeElementImpl(TypeElement delegate, boolean superTypesAsChildren) {
        this(delegate, new HashSet<TypeElement>(), superTypesAsChildren);
    }

    TypeTreeElementImpl(TypeElement delegate, Set<TypeElement> preferredTypes, boolean superTypesAsChildren) {
        this.delegate = delegate;
        this.preferredTypes = preferredTypes;
        this.superTypesAsChildren = superTypesAsChildren;
    }

    @Override
    public Set<TreeElement<TypeElement>> children() {
        if (this.children == null) {
            this.children = this.superTypesAsChildren ? this.childrenForSuperTypes() : this.childrenForSubTypes();
        }
        return this.children;
    }

    private Set<TreeElement<TypeElement>> childrenForSuperTypes() {
        QualifiedName superClassName;
        HashSet<TreeElement<TypeElement>> directTypes = new HashSet<TreeElement<TypeElement>>();
        if (this.delegate instanceof ClassElement && (superClassName = ((ClassElement)this.delegate).getSuperClassName()) != null) {
            ElementFilter forName = ElementFilter.forName(NameKind.exact(superClassName));
            Set<TypeElement> types = forName.filter(this.preferredTypes);
            if (types.isEmpty()) {
                ElementQuery.Index index = this.getIndex();
                types = index.getTypes(NameKind.exact(superClassName));
            }
            for (TypeElement typeElementImpl : types) {
                directTypes.add(new TypeTreeElementImpl(typeElementImpl, this.preferredTypes, this.superTypesAsChildren));
            }
        }
        for (QualifiedName iface : this.delegate.getSuperInterfaces()) {
            ElementFilter forName = ElementFilter.forName(NameKind.exact(iface));
            Set<TypeElement> types = forName.filter(this.preferredTypes);
            if (types.isEmpty()) {
                ElementQuery.Index index = this.getIndex();
                types = index.getTypes(NameKind.exact(iface));
            }
            for (TypeElement typeElementImpl : types) {
                directTypes.add(new TypeTreeElementImpl(typeElementImpl, this.preferredTypes, this.superTypesAsChildren));
            }
        }
        return directTypes;
    }

    private Set<TreeElement<TypeElement>> childrenForSubTypes() {
        HashSet<TreeElement<TypeElement>> directTypes = new HashSet<TreeElement<TypeElement>>();
        ElementQuery.Index index = this.getIndex();
        Set<TypeElement> directInheritedByTypes = index.getDirectInheritedByTypes(this.delegate);
        for (TypeElement typeElement : directInheritedByTypes) {
            directTypes.add(new TypeTreeElementImpl(typeElement, this.preferredTypes, this.superTypesAsChildren));
        }
        return directTypes;
    }

    @Override
    public TypeElement getElement() {
        return this.delegate;
    }

    private ElementQuery.Index getIndex() {
        ElementQuery elementQuery = this.delegate.getElementQuery();
        boolean indexScope = elementQuery.getQueryScope().isIndexScope();
        if (indexScope && elementQuery instanceof ElementQuery.Index) {
            return (ElementQuery.Index)elementQuery;
        }
        return null;
    }
}

