/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.api.elements.TypedInstanceElement;
import org.netbeans.modules.php.editor.api.elements.VariableElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.AssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.FieldAssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.FieldElementImpl;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VarAssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.openide.filesystems.FileObject;
import org.openide.util.Union2;

class VariableNameImpl
extends ScopeImpl
implements VariableName {
    private TypeResolutionKind typeResolutionKind = TypeResolutionKind.LAST_ASSIGNMENT;
    final List<LazyFieldAssignment> assignmentDatas = new ArrayList<LazyFieldAssignment>();
    private boolean globallyVisible;

    VariableNameImpl(Scope inScope, VariableElement indexedVariable) {
        this(inScope, indexedVariable.getName(), (Union2<String, FileObject>)Union2.createFirst((Object)indexedVariable.getFilenameUrl()), new OffsetRange(indexedVariable.getOffset(), indexedVariable.getOffset() + indexedVariable.getName().length()), true);
        this.indexedElement = indexedVariable;
    }

    VarAssignmentImpl createAssignment(Scope scope, boolean conditionalBlock, OffsetRange blockRange, OffsetRange nameRange, Assignment assignment, Map<String, AssignmentImpl> allAssignments) {
        VarAssignmentImpl retval = new VarAssignmentImpl(this, scope, conditionalBlock, blockRange, nameRange, assignment, allAssignments);
        return retval;
    }

    VarAssignmentImpl createAssignment(Scope scope, boolean conditionalBlock, OffsetRange blockRange, OffsetRange nameRange, String typeName) {
        VarAssignmentImpl retval = new VarAssignmentImpl(this, scope, conditionalBlock, blockRange, nameRange, typeName);
        return retval;
    }

    @Override
    public FileObject getRealFileObject() {
        return this.indexedElement != null ? this.indexedElement.getFileObject() : null;
    }

    VariableNameImpl(Scope inScope, Variable variable, boolean globallyVisible) {
        this(inScope, VariableNameImpl.toName(variable), inScope.getFile(), VariableNameImpl.toOffsetRange(variable), globallyVisible);
    }

    VariableNameImpl(Scope inScope, String name, Union2<String, FileObject> file, OffsetRange offsetRange, boolean globallyVisible) {
        super(inScope, name, file, offsetRange, PhpElementKind.VARIABLE, false);
        this.globallyVisible = globallyVisible;
    }

    void setTypeResolutionKind(TypeResolutionKind typeResolutionKind) {
        this.typeResolutionKind = typeResolutionKind;
    }

    static String toName(Variable node) {
        return CodeUtils.extractVariableName(node);
    }

    static OffsetRange toOffsetRange(Variable node) {
        Expression name = node.getName();
        while (name instanceof Variable) {
            while (name instanceof ArrayAccess) {
                ArrayAccess access = (ArrayAccess)name;
                name = access.getName();
            }
            if (!(name instanceof Variable)) continue;
            Variable var = (Variable)name;
            name = var.getName();
        }
        return new OffsetRange(name.getStartOffset(), name.getEndOffset());
    }

    public List<? extends VarAssignmentImpl> getVarAssignments() {
        Collection values = VariableNameImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            @Override
            public boolean isAccepted(ModelElement element) {
                return element instanceof VarAssignmentImpl;
            }
        });
        return new ArrayList(values);
    }

    private List<? extends FieldAssignmentImpl> getFieldAssignments() {
        Collection values = VariableNameImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            @Override
            public boolean isAccepted(ModelElement element) {
                return element instanceof FieldAssignmentImpl;
            }
        });
        return new ArrayList(values);
    }

    AssignmentImpl findVarAssignment(int offset) {
        return this.findAssignment(offset, true, null);
    }

    AssignmentImpl findFieldAssignment(int offset, FieldElement expectedField) {
        return this.findAssignment(offset, false, expectedField);
    }

    String findFieldType(int offset, String fldName) {
        String retval = null;
        int retvalOffset = -1;
        if (this.assignmentDatas.isEmpty() && (this.isGloballyVisible() || this.representsThis())) {
            VariableName varName;
            VariableScope varScope;
            List<? extends VariableName> variables;
            Scope inScope = this.getInScope();
            if (inScope != null) {
                inScope = inScope.getInScope();
            }
            if (inScope instanceof VariableScope && !(variables = ModelUtils.filter((varScope = (VariableScope)inScope).getDeclaredVariables(), this.getName())).isEmpty() && (varName = ModelUtils.getFirst(variables)) instanceof VariableNameImpl) {
                return ((VariableNameImpl)varName).findFieldType(offset, fldName);
            }
        }
        for (LazyFieldAssignment assign : this.assignmentDatas) {
            if (!assign.scope.getBlockRange().containsInclusive(offset) || retval != null && retvalOffset > assign.startOffset || assign.startOffset >= offset) continue;
            if (fldName.equals(assign.fldName)) {
                retval = assign.typeName;
                continue;
            }
            if (assign.fldName.length() <= 0 || !fldName.equals(assign.fldName.substring(1))) continue;
            retval = assign.typeName;
        }
        return retval;
    }

    AssignmentImpl findAssignment(int offset, boolean varAssignment, FieldElement expectedField) {
        List<AssignmentImpl> assignments;
        AssignmentImpl retval = null;
        List<AssignmentImpl> list = assignments = varAssignment ? this.getVarAssignments() : this.getFieldAssignments();
        if (assignments.size() == 1) {
            AssignmentImpl assign = (AssignmentImpl)assignments.iterator().next();
            if (expectedField == null || expectedField.equals(assign.getContainer())) {
                retval = assign;
            }
        }
        if (retval == null) {
            if (assignments.isEmpty() && (this.isGloballyVisible() || this.representsThis())) {
                VariableName varName;
                VariableScope varScope;
                List<? extends VariableName> variables;
                Scope inScope = this.getInScope();
                if (inScope != null) {
                    inScope = inScope.getInScope();
                    if (this.isGloballyVisible() && inScope instanceof ClassScope) {
                        inScope = inScope.getInScope();
                    }
                }
                if (inScope instanceof VariableScope && !(variables = ModelUtils.filter((varScope = (VariableScope)inScope).getDeclaredVariables(), this.getName())).isEmpty() && (varName = ModelUtils.getFirst(variables)) instanceof VariableNameImpl) {
                    return ((VariableNameImpl)varName).findAssignment(offset, true, null);
                }
            }
            if (!assignments.isEmpty()) {
                for (AssignmentImpl assign : assignments) {
                    if (retval != null && retval.getOffset() > assign.getOffset() || assign.getOffset() >= offset && (retval != null || !VariableNameImpl.isInitAssignment(assign)) || expectedField != null && !expectedField.equals(assign.getContainer())) continue;
                    retval = assign;
                }
            }
        }
        return retval;
    }

    private static boolean isInitAssignment(AssignmentImpl assignment) {
        boolean result = false;
        Scope assignmentScope = assignment.getInScope();
        if (assignmentScope instanceof MethodScope) {
            MethodScope assignmentInMethodScope = (MethodScope)assignmentScope;
            result = assignmentInMethodScope.isInitiator();
        }
        return result;
    }

    @Override
    public String getNormalizedName() {
        Scope inScope = this.getInScope();
        if (inScope instanceof MethodScope) {
            String methodName = this.representsThis() ? "" : inScope.getName();
            inScope = inScope.getInScope();
            return inScope != null && !this.isGloballyVisible() ? inScope.getName() + methodName + this.getName() : this.getName();
        }
        return inScope != null && !this.isGloballyVisible() ? inScope.getName() + this.getName() : this.getName();
    }

    @Override
    public Collection<? extends String> getTypeNames(int offset) {
        return this.getTypeNamesImpl(offset, false);
    }

    public Collection<? extends String> getArrayAccessTypeNames(int offset) {
        return this.getTypeNamesImpl(offset, true);
    }

    @Override
    public Collection<? extends TypeScope> getArrayAccessTypes(int offset) {
        return this.getTypesImpl(offset, true);
    }

    @Override
    public Collection<? extends TypeScope> getTypes(int offset) {
        return this.getTypesImpl(offset, false);
    }

    private Collection<? extends String> getTypeNamesImpl(int offset, boolean arrayAccess) {
        TypeResolutionKind useTypeResolutionKind;
        Collection<String> retval = new ArrayList<String>();
        if (!arrayAccess && this.getIndexedElement() instanceof TypedInstanceElement) {
            TypedInstanceElement typedInstanceElement = (TypedInstanceElement)this.getIndexedElement();
            Set<TypeResolver> instanceTypes = typedInstanceElement.getInstanceTypes();
            for (TypeResolver typeResolver : instanceTypes) {
                QualifiedName typeName;
                if (!typeResolver.isResolved() || (typeName = typeResolver.getTypeName(false)) == null) continue;
                retval.add(typeName.toString());
            }
            return retval;
        }
        if (this.representsThis()) {
            ClassScope classScope = (ClassScope)this.getInScope();
            return Collections.singletonList(classScope.getName());
        }
        TypeResolutionKind typeResolutionKind = useTypeResolutionKind = arrayAccess ? TypeResolutionKind.MERGE_ASSIGNMENTS : this.typeResolutionKind;
        if (useTypeResolutionKind.equals((Object)TypeResolutionKind.LAST_ASSIGNMENT)) {
            AssignmentImpl assignment = this.findVarAssignment(offset);
            while (assignment != null) {
                if (assignment.isConditionalBlock() && !assignment.getBlockRange().containsInclusive(offset)) {
                    return this.getMergedTypeNames();
                }
                Collection<String> typeNames = assignment.getTypeNames();
                if (typeNames.isEmpty() || assignment.isArrayAccess()) {
                    AssignmentImpl nextAssignment;
                    if (assignment.isArrayAccess()) {
                        retval = Collections.singleton("array");
                    }
                    if ((nextAssignment = this.findVarAssignment(assignment.getOffset() - 1)) == null || nextAssignment.equals(assignment)) break;
                    assignment = nextAssignment;
                    continue;
                }
                return typeNames;
            }
            return retval;
        }
        return this.getMergedTypeNames();
    }

    private Collection<? extends String> getMergedTypeNames() {
        HashSet<String> types = new HashSet<String>();
        List<? extends VarAssignmentImpl> varAssignments = this.getVarAssignments();
        for (VarAssignmentImpl varAssignmentImpl : varAssignments) {
            types.addAll(varAssignmentImpl.getTypeNames());
        }
        return types;
    }

    private Collection<? extends TypeScope> getTypesImpl(int offset, boolean arrayAccess) {
        TypeResolutionKind useTypeResolutionKind;
        if (this.representsThis()) {
            ClassScope classScope = (ClassScope)this.getInScope();
            return Collections.singletonList(classScope);
        }
        TypeResolutionKind typeResolutionKind = useTypeResolutionKind = arrayAccess ? TypeResolutionKind.MERGE_ASSIGNMENTS : this.typeResolutionKind;
        if (useTypeResolutionKind.equals((Object)TypeResolutionKind.LAST_ASSIGNMENT)) {
            AssignmentImpl assignment = this.findVarAssignment(offset);
            while (assignment != null) {
                if (assignment.isConditionalBlock() && !assignment.getBlockRange().containsInclusive(offset)) {
                    return this.getMergedTypes();
                }
                Collection<TypeScope> types = assignment.getTypes();
                if (types.isEmpty() || assignment.isArrayAccess()) {
                    AssignmentImpl nextAssignment = this.findVarAssignment(assignment.getOffset() - 1);
                    if (nextAssignment != null && !nextAssignment.equals(assignment)) {
                        assignment = nextAssignment;
                        continue;
                    }
                    break;
                }
                return types;
            }
        } else {
            return this.getMergedTypes();
        }
        if (this.getIndexedElement() instanceof TypedInstanceElement) {
            HashSet<? extends TypeScope> retval = new HashSet<TypeScope>();
            Collection<? extends String> typeNamesImpl = this.getTypeNamesImpl(offset, arrayAccess);
            for (String string : typeNamesImpl) {
                retval.addAll(IndexScopeImpl.getTypes(QualifiedName.create(string), this.getInScope()));
            }
            return retval;
        }
        return Collections.emptyList();
    }

    private Collection<TypeScope> getMergedTypes() {
        HashSet<TypeScope> types = new HashSet<TypeScope>();
        List<? extends VarAssignmentImpl> varAssignments = this.getVarAssignments();
        for (VarAssignmentImpl varAssignmentImpl : varAssignments) {
            types.addAll(varAssignmentImpl.getTypes());
        }
        return types;
    }

    @Override
    public boolean isGloballyVisible() {
        String name = this.getName();
        if (name.startsWith("$")) {
            name = name.substring(1);
        }
        return this.globallyVisible || PredefinedSymbols.SUPERGLOBALS.contains(name);
    }

    void setGloballyVisible(boolean globallyVisible) {
        this.globallyVisible = globallyVisible;
    }

    @Override
    public boolean representsThis() {
        Scope inScope = this.getInScope();
        return inScope instanceof ClassScope && this.getName().equals("$this");
    }

    @Override
    public void addSelfToIndex(IndexDocument indexDocument) {
        String varNameNoDollar;
        String varName = this.getName();
        String string = varNameNoDollar = varName.startsWith("$") ? varName.substring(1) : varName;
        if (!PredefinedSymbols.isSuperGlobalName(varNameNoDollar)) {
            indexDocument.addPair("var", this.getIndexSignature(), true, true);
            indexDocument.addPair("top", this.getName().toLowerCase(), true, true);
        }
    }

    private String getIndexSignature() {
        StringBuilder sb = new StringBuilder();
        String varName = this.getName();
        sb.append(varName.toLowerCase()).append(';');
        sb.append(varName).append(';');
        sb.append(';');
        sb.append(this.getOffset()).append(';');
        sb.append(this.isDeprecated() ? 1 : 0).append(';');
        sb.append(this.getFilenameUrl()).append(';');
        return sb.toString();
    }

    void createLazyFieldAssignment(FieldAccess fieldAccess, Assignment node, Scope scope) {
        String fldName = CodeUtils.extractVariableName(fieldAccess.getField());
        if (fldName != null && !fldName.startsWith("$")) {
            fldName = "$" + fldName;
        }
        String typeName = VariousUtils.extractVariableTypeFromAssignment(node, Collections.emptyMap());
        ASTNodeInfo<FieldAccess> fieldInfo = ASTNodeInfo.create(fieldAccess);
        OffsetRange range = fieldInfo.getRange();
        int startOffset = fieldAccess.getStartOffset();
        this.assignmentDatas.add(new LazyFieldAssignment(typeName, fldName, range, startOffset, scope));
    }

    void createLazyStaticFieldAssignment(StaticFieldAccess staticFieldAccess, Assignment node, Scope scope) {
        String fldName = CodeUtils.extractVariableName(staticFieldAccess.getField());
        if (fldName != null && !fldName.startsWith("$")) {
            fldName = "$" + fldName;
        }
        String typeName = VariousUtils.extractVariableTypeFromAssignment(node, Collections.emptyMap());
        ASTNodeInfo<StaticFieldAccess> fieldInfo = ASTNodeInfo.create(staticFieldAccess);
        OffsetRange range = fieldInfo.getRange();
        int startOffset = staticFieldAccess.getStartOffset();
        this.assignmentDatas.add(new LazyFieldAssignment(typeName, fldName, range, startOffset, scope));
    }

    @Override
    public Collection<? extends TypeScope> getFieldTypes(FieldElement element, int offset) {
        this.processFieldAssignments();
        AssignmentImpl assignment = this.findFieldAssignment(offset, element);
        return assignment != null ? assignment.getTypes() : element.getTypes(offset);
    }

    void processFieldAssignments() {
        if (!this.assignmentDatas.isEmpty()) {
            for (LazyFieldAssignment fieldAssignmentData : this.assignmentDatas) {
                fieldAssignmentData.process();
            }
            this.assignmentDatas.clear();
        }
    }

    private final class LazyFieldAssignment {
        private final String typeName;
        private final String fldName;
        private final OffsetRange range;
        private final int startOffset;
        private final Scope scope;

        private LazyFieldAssignment(String typeName, String fldName, OffsetRange range, int startOffset, Scope scope) {
            this.typeName = typeName;
            this.fldName = fldName;
            this.range = range;
            this.startOffset = startOffset;
            this.scope = scope;
        }

        void process() {
            Collection<? extends TypeScope> types = VariableNameImpl.this.getTypes(this.startOffset);
            TypeScope type = ModelUtils.getFirst(types);
            if (type instanceof ClassScope) {
                ClassScope cls = (ClassScope)type;
                FieldElementImpl field = (FieldElementImpl)ModelUtils.getFirst(cls.getDeclaredFields(), this.fldName);
                if (field != null) {
                    FieldAssignmentImpl fa = new FieldAssignmentImpl(VariableNameImpl.this, field, this.scope, this.scope.getBlockRange(), this.range, this.typeName);
                    VariableNameImpl.this.addElement(fa);
                }
            }
        }
    }

    static enum TypeResolutionKind {
        LAST_ASSIGNMENT,
        MERGE_ASSIGNMENTS;

    }
}

