/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeNameResolver;
import org.netbeans.modules.php.editor.elements.TypeNameResolverImpl;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class ImplementAbstractMethodsHintError
extends HintErrorRule {
    private static final String ABSTRACT_PREFIX = "abstract ";
    private static final Logger LOGGER = Logger.getLogger(ImplementAbstractMethodsHintError.class.getName());

    public String getDisplayName() {
        return Bundle.ImplementAbstractMethodsDispName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        FileScope fileScope = context.fileScope;
        FileObject fileObject = context.parserResult.getSnapshot().getSource().getFileObject();
        if (fileScope != null && fileObject != null) {
            Collection<? extends ClassScope> allClasses = ModelUtils.getDeclaredClasses(fileScope);
            for (FixInfo fixInfo : this.checkHints(allClasses, context)) {
                hints.add(new Hint((Rule)this, Bundle.ImplementAbstractMethodsHintDesc(fixInfo.className, fixInfo.lastMethodDeclaration, fixInfo.lastMethodOwnerName), fileObject, fixInfo.classNameRange, this.createHintFixes(context.doc, fixInfo), 500));
            }
        }
    }

    private List<HintFix> createHintFixes(BaseDocument doc, FixInfo fixInfo) {
        ArrayList<Object> hintFixes = new ArrayList<Object>();
        hintFixes.add(new ImplementAllFix(doc, fixInfo));
        hintFixes.add(new AbstractClassFix(doc, fixInfo));
        return Collections.unmodifiableList(hintFixes);
    }

    private Collection<FixInfo> checkHints(Collection<? extends ClassScope> allClasses, PHPRuleContext context) {
        ArrayList<FixInfo> retval = new ArrayList<FixInfo>();
        for (ClassScope classScope : allClasses) {
            int classDeclarationOffset;
            int newMethodsOffset;
            if (classScope.isAbstract()) continue;
            ElementQuery.Index index = context.getIndex();
            HashSet<String> allValidMethods = new HashSet<String>();
            allValidMethods.addAll(ImplementAbstractMethodsHintError.toNames(this.getValidInheritedMethods(this.getInheritedMethods(classScope, index))));
            allValidMethods.addAll(ImplementAbstractMethodsHintError.toNames(index.getDeclaredMethods(classScope)));
            ElementFilter declaredMethods = ElementFilter.forExcludedNames(allValidMethods, PhpElementKind.METHOD);
            Set<MethodElement> accessibleMethods = declaredMethods.filter(index.getAccessibleMethods(classScope, classScope));
            LinkedHashSet<String> methodSkeletons = new LinkedHashSet<String>();
            MethodElement lastMethodElement = null;
            FileObject lastFileObject = null;
            FileScope fileScope = null;
            for (MethodElement methodElement : accessibleMethods) {
                TypeElement type = methodElement.getType();
                if (!type.isInterface() && !methodElement.isAbstract() || methodElement.isFinal()) continue;
                FileObject fileObject = methodElement.getFileObject();
                if (lastFileObject != fileObject) {
                    lastFileObject = fileObject;
                    fileScope = this.getFileScope(fileObject);
                }
                if (fileScope == null) continue;
                NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(fileScope, methodElement.getOffset());
                ArrayList<TypeNameResolver> typeNameResolvers = new ArrayList<TypeNameResolver>();
                if (fileObject != null && CodeUtils.isPhp52(fileObject)) {
                    typeNameResolvers.add(TypeNameResolverImpl.forUnqualifiedName());
                } else {
                    typeNameResolvers.add(TypeNameResolverImpl.forFullyQualifiedName(namespaceScope, methodElement.getOffset()));
                    typeNameResolvers.add(TypeNameResolverImpl.forSmartName(classScope, classScope.getOffset()));
                }
                TypeNameResolver typeNameResolver = TypeNameResolverImpl.forChainOf(typeNameResolvers);
                String skeleton = methodElement.asString(BaseFunctionElement.PrintAs.DeclarationWithEmptyBody, typeNameResolver);
                skeleton = skeleton.replace(ABSTRACT_PREFIX, "");
                methodSkeletons.add(skeleton);
                lastMethodElement = methodElement;
            }
            if (methodSkeletons.isEmpty() || lastMethodElement == null || (newMethodsOffset = ImplementAbstractMethodsHintError.getNewMethodsOffset(classScope, context.doc, classDeclarationOffset = ImplementAbstractMethodsHintError.getClassDeclarationOffset(context.parserResult.getSnapshot().getTokenHierarchy(), classScope.getOffset()))) == -1 || classDeclarationOffset == -1) continue;
            retval.add(new FixInfo(classScope, methodSkeletons, lastMethodElement, newMethodsOffset, classDeclarationOffset));
        }
        return retval;
    }

    private FileScope getFileScope(FileObject fileObject) {
        final FileScope[] fileScope = new FileScope[1];
        try {
            ParserManager.parse(Collections.singletonList(Source.create((FileObject)fileObject)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result parserResult = resultIterator.getParserResult();
                    PHPParseResult phpResult = (PHPParseResult)parserResult;
                    fileScope[0] = phpResult.getModel().getFileScope();
                }
            });
        }
        catch (ParseException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        return fileScope[0];
    }

    private Set<MethodElement> getInheritedMethods(ClassScope classScope, ElementQuery.Index index) {
        HashSet<MethodElement> inheritedMethods = new HashSet<MethodElement>();
        HashSet<MethodElement> declaredSuperMethods = new HashSet<MethodElement>();
        HashSet<MethodElement> accessibleSuperMethods = new HashSet<MethodElement>();
        Collection<? extends ClassScope> superClasses = classScope.getSuperClasses();
        for (ClassScope classScope2 : superClasses) {
            declaredSuperMethods.addAll(index.getDeclaredMethods(classScope2));
            accessibleSuperMethods.addAll(index.getAccessibleMethods(classScope2, classScope));
        }
        Collection<? extends InterfaceScope> superInterface = classScope.getSuperInterfaceScopes();
        for (InterfaceScope interfaceScope : superInterface) {
            declaredSuperMethods.addAll(index.getDeclaredMethods(interfaceScope));
            accessibleSuperMethods.addAll(index.getAccessibleMethods(interfaceScope, classScope));
        }
        Collection collection = classScope.getTraits();
        for (TraitScope traitScope : collection) {
            declaredSuperMethods.addAll(index.getDeclaredMethods(traitScope));
            accessibleSuperMethods.addAll(index.getAccessibleMethods(traitScope, classScope));
        }
        inheritedMethods.addAll(declaredSuperMethods);
        inheritedMethods.addAll(accessibleSuperMethods);
        return inheritedMethods;
    }

    private Set<MethodElement> getValidInheritedMethods(Set<MethodElement> inheritedMethods) {
        HashSet<MethodElement> retval = new HashSet<MethodElement>();
        for (MethodElement methodElement : inheritedMethods) {
            if (methodElement.isAbstract()) continue;
            retval.add(methodElement);
        }
        return retval;
    }

    private static Set<String> toNames(Set<? extends PhpElement> elements) {
        HashSet<String> names = new HashSet<String>();
        for (PhpElement phpElement : elements) {
            names.add(phpElement.getName());
        }
        return names;
    }

    private static int getClassDeclarationOffset(TokenHierarchy<?> th, int classNameOffset) {
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence(th, classNameOffset);
        ts.move(classNameOffset);
        ts.movePrevious();
        Token<? extends PHPTokenId> previousToken = LexUtilities.findPreviousToken(ts, Collections.singletonList(PHPTokenId.PHP_CLASS));
        return previousToken.offset(th);
    }

    private static int getNewMethodsOffset(ClassScope classScope, BaseDocument doc, int classDeclarationOffset) {
        int offset = -1;
        Collection<? extends MethodScope> declaredMethods = classScope.getDeclaredMethods();
        for (MethodScope methodScope : declaredMethods) {
            OffsetRange blockRange = methodScope.getBlockRange();
            if (blockRange == null || blockRange.getEnd() <= offset) continue;
            offset = blockRange.getEnd();
        }
        if (offset == -1 && classScope.getBlockRange() != null) {
            try {
                int rowStartOfClassEnd = Utilities.getRowStart((BaseDocument)doc, (int)classScope.getBlockRange().getEnd());
                int n = rowStartOfClassEnd - 1;
                int newMethodPossibleOffset = Utilities.getRowStart((BaseDocument)doc, (int)n);
                int newMethodLineOffset = Utilities.getLineOffset((BaseDocument)doc, (int)newMethodPossibleOffset);
                int classDeclarationLineOffset = Utilities.getLineOffset((BaseDocument)doc, (int)classDeclarationOffset);
                offset = newMethodLineOffset == classDeclarationLineOffset ? n : newMethodPossibleOffset;
            }
            catch (BadLocationException ex) {
                offset = -1;
            }
        }
        return offset;
    }

    private static class FixInfo {
        private List<String> methodSkeletons;
        private String className;
        private int newMethodsOffset;
        private OffsetRange classNameRange;
        private final String lastMethodDeclaration;
        private final String lastMethodOwnerName;
        private final int classDeclarationOffset;

        FixInfo(ClassScope classScope, Set<String> methodSkeletons, MethodElement lastMethodElement, int newMethodsOffset, int classDeclarationOffset) {
            this.methodSkeletons = new ArrayList<String>(methodSkeletons);
            this.className = classScope.getFullyQualifiedName().toString();
            Collections.sort(this.methodSkeletons);
            this.classNameRange = classScope.getNameRange();
            this.classDeclarationOffset = classDeclarationOffset;
            this.newMethodsOffset = newMethodsOffset;
            this.lastMethodDeclaration = lastMethodElement.asString(BaseFunctionElement.PrintAs.NameAndParamsDeclaration);
            this.lastMethodOwnerName = lastMethodElement.getType().getFullyQualifiedName().toString();
        }
    }

    private static class AbstractClassFix
    implements HintFix {
        private final BaseDocument doc;
        private final FixInfo fixInfo;

        public AbstractClassFix(BaseDocument doc, FixInfo fixInfo) {
            this.doc = doc;
            this.fixInfo = fixInfo;
        }

        public String getDescription() {
            return Bundle.AbstractClassFixDesc();
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            edits.replace(this.fixInfo.classDeclarationOffset, 0, ImplementAbstractMethodsHintError.ABSTRACT_PREFIX, true, 0);
            edits.apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static class ImplementAllFix
    implements HintFix {
        private final BaseDocument doc;
        private final FixInfo fixInfo;

        ImplementAllFix(BaseDocument doc, FixInfo fixInfo) {
            this.doc = doc;
            this.fixInfo = fixInfo;
        }

        public String getDescription() {
            return Bundle.ImplementAbstractMethodsDesc();
        }

        public void implement() throws Exception {
            this.getEditList().apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        EditList getEditList() throws Exception {
            EditList edits = new EditList(this.doc);
            edits.setFormatAll(true);
            for (String methodScope : this.fixInfo.methodSkeletons) {
                edits.replace(this.fixInfo.newMethodsOffset, 0, methodScope, true, 0);
            }
            return edits;
        }
    }
}

