/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.verification.CaretSensitiveRule;
import org.netbeans.modules.php.editor.verification.CustomisableRule;
import org.netbeans.modules.php.editor.verification.InvokableRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;

public class PHPHintsProvider
implements HintsProvider {
    public static final String DEFAULT_HINTS = "default.hints";
    public static final String DEFAULT_SUGGESTIONS = "default.suggestions";
    private volatile boolean cancel = false;

    public void computeHints(HintsProvider.HintsManager mgr, RuleContext context, List<Hint> hints) {
        this.resume();
        Map allHints = mgr.getHints(false, context);
        List modelHints = (List)allHints.get(DEFAULT_HINTS);
        RulesRunnerImpl<Hint> rulesRunner = new RulesRunnerImpl<Hint>(mgr, this.initializeContext(context), hints);
        ForAllAdjusters forAllAdjusters = new ForAllAdjusters(Arrays.asList(new PreferencesAdjuster(mgr), new ResetCaretOffsetAdjuster()));
        rulesRunner.run(modelHints, forAllAdjusters);
    }

    public void computeSuggestions(HintsProvider.HintsManager mgr, RuleContext context, List<Hint> suggestions, int caretOffset) {
        Map allHints;
        List modelHints;
        this.resume();
        RulesRunnerImpl<Hint> rulesRunner = new RulesRunnerImpl<Hint>(mgr, this.initializeContext(context), suggestions);
        ForAllAdjusters forAllAdjusters = new ForAllAdjusters(Arrays.asList(new PreferencesAdjuster(mgr), new CaretOffsetAdjuster(caretOffset)));
        Map hintsOnLine = mgr.getHints(true, context);
        List defaultHintsOnLine = (List)hintsOnLine.get(DEFAULT_HINTS);
        if (defaultHintsOnLine != null) {
            rulesRunner.run(defaultHintsOnLine, forAllAdjusters);
        }
        if ((modelHints = (List)(allHints = mgr.getSuggestions()).get(DEFAULT_SUGGESTIONS)) != null) {
            rulesRunner.run(modelHints, forAllAdjusters);
        }
    }

    public void computeSelectionHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> selections, int start, int end) {
    }

    public void computeErrors(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, List<Error> unhandled) {
        List hintErrors;
        this.resume();
        List errors = context.parserResult.getDiagnostics();
        unhandled.addAll(errors);
        Map allErrors = manager.getErrors();
        List unhandledErrors = (List)allErrors.get((Object)ErrorType.UNHANDLED_ERRORS);
        if (unhandledErrors != null) {
            RulesRunnerImpl<Error> rulesRunner = new RulesRunnerImpl<Error>(manager, this.initializeContext(context), unhandled);
            rulesRunner.run(unhandledErrors, RuleAdjuster.NONE);
        }
        if ((hintErrors = (List)allErrors.get((Object)ErrorType.HINT_ERRORS)) != null) {
            RulesRunnerImpl<Hint> rulesRunner = new RulesRunnerImpl<Hint>(manager, this.initializeContext(context), hints);
            rulesRunner.run(hintErrors, RuleAdjuster.NONE);
        }
    }

    private PHPRuleContext initializeContext(RuleContext context) {
        FileScope modelScope;
        PHPRuleContext phpRuleContext = (PHPRuleContext)context;
        ParserResult info = context.parserResult;
        PHPParseResult result = (PHPParseResult)info;
        Model model = result.getModel();
        phpRuleContext.fileScope = modelScope = model.getFileScope();
        return phpRuleContext;
    }

    public void cancel() {
        this.cancel = true;
    }

    private void resume() {
        this.cancel = false;
    }

    public List<Rule> getBuiltinRules() {
        return Collections.emptyList();
    }

    public RuleContext createRuleContext() {
        return new PHPRuleContext();
    }

    private static final class PreferencesAdjuster
    implements RuleAdjuster {
        private final HintsProvider.HintsManager hintManager;

        public PreferencesAdjuster(HintsProvider.HintsManager hintManager) {
            this.hintManager = hintManager;
        }

        @Override
        public void adjust(Rule rule) {
            if (rule instanceof CustomisableRule) {
                CustomisableRule icm = (CustomisableRule)rule;
                Preferences preferences = this.hintManager.getPreferences((Rule.UserConfigurableRule)icm);
                assert (preferences != null) : rule;
                icm.setPreferences(preferences);
            }
        }
    }

    private static final class CaretOffsetAdjuster
    implements RuleAdjuster {
        private final int caretOffset;

        public CaretOffsetAdjuster(int caretOffset) {
            this.caretOffset = caretOffset;
        }

        @Override
        public void adjust(Rule rule) {
            if (rule instanceof CaretSensitiveRule) {
                CaretSensitiveRule icm = (CaretSensitiveRule)rule;
                icm.setCaretOffset(this.caretOffset);
            }
        }
    }

    private static final class ResetCaretOffsetAdjuster
    implements RuleAdjuster {
        private final RuleAdjuster caretOffsetAdjuster = new CaretOffsetAdjuster(-1);

        @Override
        public void adjust(Rule rule) {
            this.caretOffsetAdjuster.adjust(rule);
        }
    }

    private static final class ForAllAdjusters
    implements RuleAdjuster {
        private final Collection<RuleAdjuster> adjusters;

        public ForAllAdjusters(Collection<RuleAdjuster> adjusters) {
            this.adjusters = adjusters;
        }

        @Override
        public void adjust(Rule rule) {
            for (RuleAdjuster hintAdjuster : this.adjusters) {
                hintAdjuster.adjust(rule);
            }
        }
    }

    private static interface RuleAdjuster {
        public static final RuleAdjuster NONE = new RuleAdjuster(){

            @Override
            public void adjust(Rule rule) {
            }
        };

        public void adjust(Rule var1);
    }

    private final class RulesRunnerImpl<T>
    implements RulesRunner<T> {
        private final HintsProvider.HintsManager hintManager;
        private final PHPRuleContext ruleContext;
        private final List<T> result;

        public RulesRunnerImpl(HintsProvider.HintsManager hintManager, PHPRuleContext ruleContext, List<T> result) {
            this.hintManager = hintManager;
            this.ruleContext = ruleContext;
            this.result = result;
        }

        @Override
        public void run(List<? extends Rule> rules, RuleAdjuster adjuster) {
            for (Rule rule : rules) {
                if (PHPHintsProvider.this.cancel) break;
                if (rule instanceof Rule.AstRule) {
                    Rule.AstRule astRule = (Rule.AstRule)rule;
                    if (!this.hintManager.isEnabled((Rule.UserConfigurableRule)astRule)) continue;
                    this.adjustAndInvoke(rule, adjuster);
                    continue;
                }
                if (!(rule instanceof Rule.ErrorRule)) continue;
                this.adjustAndInvoke(rule, adjuster);
            }
        }

        private void adjustAndInvoke(Rule rule, RuleAdjuster adjuster) {
            if (PHPHintsProvider.this.cancel) {
                return;
            }
            if (rule instanceof InvokableRule) {
                adjuster.adjust(rule);
                InvokableRule invokableRule = (InvokableRule)rule;
                if (PHPHintsProvider.this.cancel) {
                    return;
                }
                ArrayList tempResult = new ArrayList();
                invokableRule.invoke(this.ruleContext, tempResult);
                boolean checkResult = false;
                if (!$assertionsDisabled) {
                    checkResult = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (checkResult) {
                    for (Object item : tempResult) {
                        assert (item != null) : rule;
                    }
                }
                this.result.addAll(tempResult);
            }
        }
    }

    private static interface RulesRunner<T> {
        public void run(List<? extends Rule> var1, RuleAdjuster var2);
    }

    static enum ErrorType {
        UNHANDLED_ERRORS,
        HINT_ERRORS;

    }
}

