/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.ConditionalExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public abstract class SuperglobalsHint
extends HintRule {
    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            CheckVisitor checkVisitor = new CheckVisitor(this, fileObject, context.doc);
            phpParseResult.getProgram().accept(checkVisitor);
            hints.addAll(checkVisitor.getHints());
        }
    }

    public String getDescription() {
        return Bundle.SuperglobalsHintDesc();
    }

    public String getDisplayName() {
        return Bundle.SuperglobalsHintDisp(this.getSuperglobalName());
    }

    abstract String getSuperglobalName();

    private static final class ConditionVisitor
    extends DefaultTreePathVisitor {
        private final String superglobalName;
        private boolean isSuperglobalValidated;

        private ConditionVisitor(String superglobalName) {
            assert (superglobalName != null);
            this.superglobalName = superglobalName;
            this.isSuperglobalValidated = false;
        }

        public boolean isSuperglobalValidated() {
            return this.isSuperglobalValidated;
        }

        @Override
        public void visit(Variable node) {
            super.visit(node);
            String variableName = CodeUtils.extractVariableName(node);
            if (this.superglobalName.equals(variableName) && new AccessValidator(this.getPath(), this.superglobalName).isInValidatorFunction()) {
                this.isSuperglobalValidated = true;
            }
        }
    }

    private static final class AccessValidator {
        private static final Collection<String> VALIDATOR_FUNCTIONS = new ArrayList<String>();
        private static final Collection<String> FILTER_FUNCTIONS;
        private final List<ASTNode> path;
        private final String superglobalName;

        private AccessValidator(List<ASTNode> path, String superglobalName) {
            assert (path != null);
            assert (superglobalName != null);
            this.path = path;
            this.superglobalName = superglobalName;
        }

        public boolean isValidAccess() {
            return this.isInFilterFunction() || this.isInValidatorFunction() || this.isValidatedByCondition() || this.isOnLeftSideOfAssignment();
        }

        private boolean isOnLeftSideOfAssignment() {
            boolean result = false;
            ASTNode firstInPath = this.path.get(0);
            for (ASTNode aSTNode : this.path) {
                if (!(aSTNode instanceof Assignment)) continue;
                Assignment assignment = (Assignment)aSTNode;
                if (!assignment.getLeftHandSide().equals(firstInPath)) break;
                result = true;
                break;
            }
            return result;
        }

        private boolean isValidatedByCondition() {
            boolean result = false;
            for (ASTNode aSTNode : this.path) {
                Expression condition = null;
                if (aSTNode instanceof IfStatement) {
                    IfStatement ifStatement = (IfStatement)aSTNode;
                    condition = ifStatement.getCondition();
                } else if (aSTNode instanceof WhileStatement) {
                    WhileStatement whileStatement = (WhileStatement)aSTNode;
                    condition = whileStatement.getCondition();
                } else if (aSTNode instanceof ConditionalExpression) {
                    ConditionalExpression conditionalExpression = (ConditionalExpression)aSTNode;
                    condition = conditionalExpression.getCondition();
                }
                if (condition == null) continue;
                ConditionVisitor conditionVisitor = new ConditionVisitor(this.superglobalName);
                condition.accept(conditionVisitor);
                if (!conditionVisitor.isSuperglobalValidated()) continue;
                result = true;
                break;
            }
            return result;
        }

        public boolean isInValidatorFunction() {
            boolean result = false;
            for (ASTNode aSTNode : this.path) {
                String functionName;
                if (!(aSTNode instanceof FunctionInvocation) || !AccessValidator.isValidatorFunction(functionName = CodeUtils.extractFunctionName((FunctionInvocation)aSTNode))) continue;
                result = true;
                break;
            }
            return result;
        }

        private static boolean isValidatorFunction(String functionName) {
            return VALIDATOR_FUNCTIONS.contains(functionName);
        }

        private boolean isInFilterFunction() {
            boolean result = false;
            for (ASTNode aSTNode : this.path) {
                String functionName;
                if (!(aSTNode instanceof FunctionInvocation) || !AccessValidator.isFilterFunction(functionName = CodeUtils.extractFunctionName((FunctionInvocation)aSTNode))) continue;
                result = true;
                break;
            }
            return result;
        }

        private static boolean isFilterFunction(String functionName) {
            return FILTER_FUNCTIONS.contains(functionName);
        }

        static {
            VALIDATOR_FUNCTIONS.add("is_integer");
            VALIDATOR_FUNCTIONS.add("is_long");
            VALIDATOR_FUNCTIONS.add("is_float");
            VALIDATOR_FUNCTIONS.add("is_file");
            VALIDATOR_FUNCTIONS.add("is_object");
            VALIDATOR_FUNCTIONS.add("is_string");
            VALIDATOR_FUNCTIONS.add("is_int");
            VALIDATOR_FUNCTIONS.add("is_double");
            VALIDATOR_FUNCTIONS.add("is_numeric");
            VALIDATOR_FUNCTIONS.add("is_finite");
            VALIDATOR_FUNCTIONS.add("is_infinite");
            VALIDATOR_FUNCTIONS.add("is_null");
            VALIDATOR_FUNCTIONS.add("is_nan");
            VALIDATOR_FUNCTIONS.add("is_scalar");
            VALIDATOR_FUNCTIONS.add("is_real");
            FILTER_FUNCTIONS = new ArrayList<String>();
            FILTER_FUNCTIONS.add("htmlspecialchars");
        }
    }

    private static final class CheckVisitor
    extends DefaultTreePathVisitor {
        private final SuperglobalsHint superglobalsHint;
        private final FileObject fileObject;
        private final BaseDocument baseDocument;
        private final List<Hint> hints;

        private CheckVisitor(SuperglobalsHint superglobalsHint, FileObject fileObject, BaseDocument baseDocument) {
            assert (superglobalsHint != null);
            assert (fileObject != null);
            this.superglobalsHint = superglobalsHint;
            this.fileObject = fileObject;
            this.baseDocument = baseDocument;
            this.hints = new ArrayList<Hint>();
        }

        public List<Hint> getHints() {
            return this.hints;
        }

        @Override
        public void visit(Variable node) {
            super.visit(node);
            String variableName = CodeUtils.extractVariableName(node);
            if (this.superglobalsHint.getSuperglobalName().equals(variableName) && !this.isValidAccess()) {
                this.addHint(node);
            }
        }

        protected void addHint(ASTNode node) {
            assert (node != null);
            OffsetRange offsetRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
            if (this.superglobalsHint.showHint(offsetRange, this.baseDocument)) {
                this.hints.add(new Hint((Rule)this.superglobalsHint, Bundle.SuperglobalHintText(this.superglobalsHint.getSuperglobalName()), this.fileObject, offsetRange, null, 500));
            }
        }

        protected boolean isValidAccess() {
            return new AccessValidator(this.getPath(), this.superglobalsHint.getSuperglobalName()).isValidAccess();
        }
    }

    public static final class RequestSuperglobalHint
    extends SuperglobalsHint {
        private static final String HINT_ID = "Request.Superglobal.Hint";
        private static final String ARRAY_NAME = "$_REQUEST";

        public String getId() {
            return HINT_ID;
        }

        @Override
        protected String getSuperglobalName() {
            return ARRAY_NAME;
        }
    }

    public static final class EnvSuperglobalHint
    extends SuperglobalsHint {
        private static final String HINT_ID = "Env.Superglobal.Hint";
        private static final String ARRAY_NAME = "$_ENV";

        public String getId() {
            return HINT_ID;
        }

        @Override
        protected String getSuperglobalName() {
            return ARRAY_NAME;
        }
    }

    public static final class ServerSuperglobalHint
    extends SuperglobalsHint {
        private static final String HINT_ID = "Server.Superglobal.Hint";
        private static final String ARRAY_NAME = "$_SERVER";

        public String getId() {
            return HINT_ID;
        }

        @Override
        protected String getSuperglobalName() {
            return ARRAY_NAME;
        }
    }

    public static final class CookieSuperglobalHint
    extends SuperglobalsHint {
        private static final String HINT_ID = "Cookie.Superglobal.Hint";
        private static final String ARRAY_NAME = "$_COOKIE";

        public String getId() {
            return HINT_ID;
        }

        @Override
        protected String getSuperglobalName() {
            return ARRAY_NAME;
        }
    }

    public static final class PostSuperglobalHint
    extends SuperglobalsHint {
        private static final String HINT_ID = "Post.Superglobal.Hint";
        private static final String ARRAY_NAME = "$_POST";

        public String getId() {
            return HINT_ID;
        }

        @Override
        protected String getSuperglobalName() {
            return ARRAY_NAME;
        }
    }

    public static final class GetSuperglobalHint
    extends SuperglobalsHint {
        private static final String HINT_ID = "Get.Superglobal.Hint";
        private static final String ARRAY_NAME = "$_GET";

        public String getId() {
            return HINT_ID;
        }

        @Override
        protected String getSuperglobalName() {
            return ARRAY_NAME;
        }
    }
}

