/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.UnusedUsesCollector;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class UnusedUsesHint
extends HintRule {
    private static final String HINT_ID = "Unused.Uses.Hint";
    private List<Hint> hints;
    private BaseDocument baseDocument;
    private FileObject fileObject;

    @Override
    public void invoke(PHPRuleContext context, List<Hint> allHints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        this.fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (this.fileObject == null || CodeUtils.isPhp52(this.fileObject)) {
            return;
        }
        this.hints = allHints;
        this.baseDocument = context.doc;
        for (UnusedUsesCollector.UnusedOffsetRanges unusedOffsetRanges : new UnusedUsesCollector(phpParseResult).collect()) {
            this.createHint(unusedOffsetRanges);
        }
    }

    private void createHint(UnusedUsesCollector.UnusedOffsetRanges unusedOffsetRanges) {
        OffsetRange offsetRange = unusedOffsetRanges.getRangeToVisualise();
        if (this.showHint(offsetRange, this.baseDocument)) {
            this.hints.add(new Hint((Rule)this, Bundle.UnsedUsesHintDisp(), this.fileObject, offsetRange, this.createHintFixes(this.baseDocument, unusedOffsetRanges), 500));
        }
    }

    private List<HintFix> createHintFixes(BaseDocument baseDocument, UnusedUsesCollector.UnusedOffsetRanges unusedOffsetRanges) {
        return Collections.singletonList(new RemoveUnusedUseFix(baseDocument, unusedOffsetRanges));
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.UnusedUsesHintDesc();
    }

    public String getDisplayName() {
        return Bundle.UnsedUsesHintDisp();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    private static class RemoveUnusedUseFix
    implements HintFix {
        private final BaseDocument baseDocument;
        private final UnusedUsesCollector.UnusedOffsetRanges unusedOffsetRanges;

        public RemoveUnusedUseFix(BaseDocument baseDocument, UnusedUsesCollector.UnusedOffsetRanges unusedOffsetRanges) {
            this.baseDocument = baseDocument;
            this.unusedOffsetRanges = unusedOffsetRanges;
        }

        public String getDescription() {
            return Bundle.RemoveUnusedUseFixDesc();
        }

        public void implement() throws Exception {
            EditList editList = new EditList(this.baseDocument);
            OffsetRange offsetRange = this.unusedOffsetRanges.getRangeToReplace();
            int startOffset = this.getOffsetWithoutLeadingWhitespaces(offsetRange.getStart());
            editList.replace(startOffset, offsetRange.getEnd() - startOffset, "", true, 0);
            editList.apply();
        }

        private int getOffsetWithoutLeadingWhitespaces(int startOffset) {
            int result = startOffset;
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)this.baseDocument, startOffset);
            if (ts != null) {
                ts.move(startOffset);
                while (ts.movePrevious() && ((PHPTokenId)ts.token().id()).equals((Object)PHPTokenId.WHITESPACE)) {
                    result = ts.offset();
                }
                if (((PHPTokenId)ts.token().id()).equals((Object)PHPTokenId.PHP_USE)) {
                    result = startOffset;
                }
            }
            return result;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

