/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.api.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.JMenu;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.api.build.ui.CustomizerPanel;
import org.netbeans.modules.web.clientproject.api.build.ui.TasksMenu;
import org.netbeans.modules.web.clientproject.spi.build.BuildToolImplementation;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Parameters;

public final class BuildTools {
    private static final BuildTools INSTANCE = new BuildTools();

    private BuildTools() {
    }

    public static BuildTools getDefault() {
        return INSTANCE;
    }

    public boolean run(@NonNull Project project, @NonNull String commandId, boolean waitFinished, boolean warnUser) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"commandId", (Object)commandId);
        boolean run = false;
        for (BuildToolImplementation buildTool : this.getEnabledBuildTools(project)) {
            if (!buildTool.run(commandId, waitFinished, warnUser)) continue;
            run = true;
        }
        return run;
    }

    public boolean hasBuildTools(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        return !this.getEnabledBuildTools(project).isEmpty();
    }

    public JComponent createCustomizerComponent(@NonNull CustomizerSupport customizerSupport) {
        Parameters.notNull((CharSequence)"customizerSupport", (Object)customizerSupport);
        return new CustomizerPanel(customizerSupport);
    }

    public JMenu createTasksMenu(@NonNull TasksMenuSupport tasksMenuSupport) {
        Parameters.notNull((CharSequence)"tasksMenuSupport", (Object)tasksMenuSupport);
        return new TasksMenu(tasksMenuSupport);
    }

    private Collection<BuildToolImplementation> getEnabledBuildTools(Project project) {
        assert (project != null);
        Collection allBuildTools = project.getLookup().lookupAll(BuildToolImplementation.class);
        ArrayList<BuildToolImplementation> enabledBuildTools = new ArrayList<BuildToolImplementation>(allBuildTools.size());
        for (BuildToolImplementation buildTool : allBuildTools) {
            if (!buildTool.isEnabled()) continue;
            enabledBuildTools.add(buildTool);
        }
        return enabledBuildTools;
    }

    public static interface TasksMenuSupport {
        @NonNull
        public Project getProject();

        @NonNull
        public String getIdentifier();

        @NonNull
        public String getTitle(@NonNull Title var1);

        @CheckForNull
        public String getDefaultTaskName();

        @NonNull
        public Future<List<String>> getTasks();

        public void runTask(String ... var1);

        public void reloadTasks();

        public void configure();

        public static enum Title {
            MENU,
            LOADING_TASKS,
            RELOAD_TASKS,
            CONFIGURE_TOOL,
            RUN_ADVANCED,
            TASKS_LABEL,
            BUILD_TOOL_EXEC;

        }
    }

    public static interface CustomizerSupport {
        @NonNull
        public ProjectCustomizer.Category getCategory();

        @NonNull
        public String getHeader();

        @CheckForNull
        public String getTask(@NonNull String var1);

        public void setTask(@NonNull String var1, @NullAllowed String var2);
    }
}

