/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.option;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.OptSpecifier;
import org.llvm.option.OptTable;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class Option
implements Destructors.ClassWithDestructor {
    protected type.ptr<OptTable.Info> Info;
    protected OptTable Owner;

    public Option(type.ptr<OptTable.Info> info, OptTable owner) {
        this.Info = (type.ptr)Native.$tryClone(info);
        this.Owner = owner;
        assert (this.Info == null || !this.getAlias().isValid() || !this.getAlias().getAlias().isValid()) : "Multi-level aliases are not supported.";
        if (this.Info != null && this.getAliasArgs() != null) {
            assert (this.getAlias().isValid()) : "Only alias options can have alias args.";
            assert (this.getKind() == OptionClass.FlagClass) : "Only Flag aliases can have alias args.";
            assert (this.getAlias().getKind() != OptionClass.FlagClass) : "Cannot provide alias args to a flag option.";
        }
    }

    public void $destroy() {
    }

    public boolean isValid() {
        return this.Info != null;
    }

    public long getID() {
        assert (this.Info != null) : "Must have a valid info!";
        return ((OptTable.Info)this.Info.$star()).ID;
    }

    public OptionClass getKind() {
        assert (this.Info != null) : "Must have a valid info!";
        return OptionClass.valueOf(((OptTable.Info)this.Info.$star()).Kind);
    }

    public StringRef getName() {
        assert (this.Info != null) : "Must have a valid info!";
        return new StringRef(((OptTable.Info)this.Info.$star()).Name);
    }

    public Option getGroup() {
        assert (this.Info != null) : "Must have a valid info!";
        assert (this.Owner != null) : "Must have a valid owner!";
        return this.Owner.getOption(new OptSpecifier(((OptTable.Info)this.Info.$star()).GroupID));
    }

    public Option getAlias() {
        assert (this.Info != null) : "Must have a valid info!";
        assert (this.Owner != null) : "Must have a valid owner!";
        return this.Owner.getOption(new OptSpecifier(((OptTable.Info)this.Info.$star()).AliasID));
    }

    public char.ptr getAliasArgs() {
        assert (this.Info != null) : "Must have a valid info!";
        assert (((OptTable.Info)this.Info.$star()).AliasArgs == null || ((OptTable.Info)this.Info.$star()).AliasArgs.$at(0) != 0) : "AliasArgs should be either 0 or non-empty.";
        return ((OptTable.Info)this.Info.$star()).AliasArgs;
    }

    public StringRef getPrefix() {
        char.ptr Prefix = Native.$tryClone((char.ptr)((char.ptr)((OptTable.Info)this.Info.$star()).Prefixes.$star()));
        return Prefix != null ? new StringRef(Prefix) : new StringRef();
    }

    public std.string getPrefixedName() {
        std.string Ret = this.getPrefix().$basic_string();
        llvm.$addassign_str_StringRef((std.string)Ret, (StringRef)this.getName());
        return Ret;
    }

    public long getNumArgs() {
        return ((OptTable.Info)this.Info.$star()).Param;
    }

    public boolean hasNoOptAsInput() {
        return (((OptTable.Info)this.Info.$star()).Flags & 2) != 0;
    }

    public RenderStyleKind getRenderStyle() {
        if ((((OptTable.Info)this.Info.$star()).Flags & 4) != 0) {
            return RenderStyleKind.RenderJoinedStyle;
        }
        if ((((OptTable.Info)this.Info.$star()).Flags & 8) != 0) {
            return RenderStyleKind.RenderSeparateStyle;
        }
        switch (this.getKind()) {
            case GroupClass: 
            case InputClass: 
            case UnknownClass: {
                return RenderStyleKind.RenderValuesStyle;
            }
            case JoinedClass: 
            case JoinedAndSeparateClass: {
                return RenderStyleKind.RenderJoinedStyle;
            }
            case CommaJoinedClass: {
                return RenderStyleKind.RenderCommaJoinedStyle;
            }
            case FlagClass: 
            case SeparateClass: 
            case MultiArgClass: 
            case JoinedOrSeparateClass: 
            case RemainingArgsClass: {
                return RenderStyleKind.RenderSeparateStyle;
            }
        }
        throw new llvm_unreachable((CharSequence)"Unexpected kind!");
    }

    public boolean hasFlag(long Val) {
        return ((long)((OptTable.Info)this.Info.$star()).Flags & Val) != 0L;
    }

    public Option getUnaliasedOption() {
        Option Alias = this.getAlias();
        if (Alias.isValid()) {
            return Alias.getUnaliasedOption();
        }
        return this;
    }

    public StringRef getRenderName() {
        return this.getUnaliasedOption().getName();
    }

    public boolean matches(OptSpecifier Opt) {
        Option Alias = this.getAlias();
        if (Alias.isValid()) {
            return Alias.matches(Opt);
        }
        if (this.getID() == Opt.getID()) {
            return true;
        }
        Option Group = this.getGroup();
        if (Group.isValid()) {
            return Group.matches(Opt);
        }
        return false;
    }

    public Arg accept(ArgList Args, uint.ref Index, long ArgSize) {
        Option UnaliasedOption = null;
        try {
            UnaliasedOption = this.getUnaliasedOption();
            StringRef Spelling = new StringRef();
            if (this.getID() == UnaliasedOption.getID()) {
                Spelling.$assign(new StringRef(Args.getArgString(Index.$deref()), ArgSize));
            } else {
                Spelling.$assign(new StringRef(Args.MakeArgString(llvm.$plus_Twine((Twine)new Twine(UnaliasedOption.getPrefix()), (Twine)new Twine(UnaliasedOption.getName())))));
            }
            switch (this.getKind()) {
                case FlagClass: {
                    Arg Val;
                    if (ArgSize != (long)std.strlen((char.ptr)Args.getArgString(Index.$deref()))) {
                        Arg arg = null;
                        return arg;
                    }
                    long PrevIndex = Index.$deref();
                    Index.$set(PrevIndex + 1L);
                    Arg A = new Arg(UnaliasedOption, Spelling, PrevIndex);
                    if (this.getAliasArgs() != null) {
                        Val = Native.$tryClone((char.ptr)this.getAliasArgs());
                        while (Val.$star() != 0) {
                            A.getValues().push_back((Object)Val);
                            Val.$inc(std.strlen((char.ptr)Val) + 1);
                        }
                    }
                    Val = A;
                    return Val;
                }
                case JoinedClass: {
                    char.ptr Value = (char.ptr)Args.getArgString(Index.$deref()).$add(ArgSize);
                    long PrevIndex = Index.$deref();
                    Index.$set(PrevIndex + 1L);
                    Arg Val = new Arg(UnaliasedOption, Spelling, PrevIndex, Value);
                    return Val;
                }
                case CommaJoinedClass: {
                    char.ptr Str = (char.ptr)Args.getArgString(Index.$deref()).$add(ArgSize);
                    long PrevIndex = Index.$deref();
                    Index.$set(PrevIndex + 1L);
                    Arg A = new Arg(UnaliasedOption, Spelling, PrevIndex);
                    char.ptr Prev = Native.$tryClone((char.ptr)Str);
                    while (true) {
                        byte c;
                        if ((c = Str.$star()) == 0 || c == NativePointer.$((char)',')) {
                            if (Prev.$noteq((Object)Str)) {
                                char.ptr Value = NativePointer.create_char$ptr((byte[])new byte[Str.$sub((abstract_iterator)Prev) + 1]);
                                std.memcpy((char.ptr)Value, (char.ptr)Prev, (int)Str.$sub((abstract_iterator)Prev));
                                Value.$set(Str.$sub((abstract_iterator)Prev), (byte)0);
                                A.getValues().push_back((Object)Value);
                            }
                            if (c == 0) break;
                            Prev = (char.ptr)Str.$add(1);
                        }
                        Str.$preInc();
                    }
                    A.setOwnsValues(true);
                    Arg arg = A;
                    return arg;
                }
                case SeparateClass: {
                    if (ArgSize != (long)std.strlen((char.ptr)Args.getArgString(Index.$deref()))) {
                        Arg Str = null;
                        return Str;
                    }
                    Index.$set(Index.$deref() + 2L);
                    if (Index.$deref() > Args.getNumInputArgStrings() || Args.getArgString(Index.$deref() - 1L) == null) {
                        Arg Str = null;
                        return Str;
                    }
                    Arg Str = new Arg(UnaliasedOption, Spelling, Index.$deref() - 2L, Args.getArgString(Index.$deref() - 1L));
                    return Str;
                }
                case MultiArgClass: {
                    if (ArgSize != (long)std.strlen((char.ptr)Args.getArgString(Index.$deref()))) {
                        Arg Str = null;
                        return Str;
                    }
                    Index.$set(Index.$deref() + 1L + this.getNumArgs());
                    if (Index.$deref() > Args.getNumInputArgStrings()) {
                        Arg Str = null;
                        return Str;
                    }
                    Arg A = new Arg(UnaliasedOption, Spelling, Index.$deref() - 1L - this.getNumArgs(), Args.getArgString(Index.$deref() - this.getNumArgs()));
                    for (long i = 1L; i != this.getNumArgs(); ++i) {
                        A.getValues().push_back((Object)Args.getArgString(Index.$deref() - this.getNumArgs() + i));
                    }
                    Arg i = A;
                    return i;
                }
                case JoinedOrSeparateClass: {
                    if (ArgSize != (long)std.strlen((char.ptr)Args.getArgString(Index.$deref()))) {
                        char.ptr Value = (char.ptr)Args.getArgString(Index.$deref()).$add(ArgSize);
                        long PrevIndex = Index.$deref();
                        Index.$set(PrevIndex + 1L);
                        Arg arg = new Arg(this, Spelling, PrevIndex, Value);
                        return arg;
                    }
                    Index.$set(Index.$deref() + 2L);
                    if (Index.$deref() > Args.getNumInputArgStrings() || Args.getArgString(Index.$deref() - 1L) == null) {
                        Arg Value = null;
                        return Value;
                    }
                    Arg Value = new Arg(UnaliasedOption, Spelling, Index.$deref() - 2L, Args.getArgString(Index.$deref() - 1L));
                    return Value;
                }
                case JoinedAndSeparateClass: {
                    Index.$set(Index.$deref() + 2L);
                    if (Index.$deref() > Args.getNumInputArgStrings() || Args.getArgString(Index.$deref() - 1L) == null) {
                        Arg Value = null;
                        return Value;
                    }
                    Arg Value = new Arg(UnaliasedOption, Spelling, Index.$deref() - 2L, (char.ptr)Args.getArgString(Index.$deref() - 2L).$add(ArgSize), Args.getArgString(Index.$deref() - 1L));
                    return Value;
                }
                case RemainingArgsClass: {
                    if (ArgSize != (long)std.strlen((char.ptr)Args.getArgString(Index.$deref()))) {
                        Arg Value = null;
                        return Value;
                    }
                    long PrevIndex = Index.$deref();
                    Index.$set(PrevIndex + 1L);
                    Arg A = new Arg(UnaliasedOption, Spelling, PrevIndex);
                    while (Index.$deref() < Args.getNumInputArgStrings() && Args.getArgString(Index.$deref()) != null) {
                        PrevIndex = Index.$deref();
                        Index.$set(PrevIndex + 1L);
                        A.getValues().push_back((Object)Args.getArgString(PrevIndex));
                    }
                    Arg arg = A;
                    return arg;
                }
            }
            throw new llvm_unreachable((CharSequence)"Invalid option kind!");
        }
        finally {
            if (UnaliasedOption != null) {
                UnaliasedOption.$destroy();
            }
        }
    }

    public void dump() {
        Option Alias;
        llvm.errs().$out((CharSequence)"<");
        switch (this.getKind()) {
            case GroupClass: {
                llvm.errs().$out((CharSequence)"GroupClass");
                break;
            }
            case InputClass: {
                llvm.errs().$out((CharSequence)"InputClass");
                break;
            }
            case UnknownClass: {
                llvm.errs().$out((CharSequence)"UnknownClass");
                break;
            }
            case FlagClass: {
                llvm.errs().$out((CharSequence)"FlagClass");
                break;
            }
            case JoinedClass: {
                llvm.errs().$out((CharSequence)"JoinedClass");
                break;
            }
            case SeparateClass: {
                llvm.errs().$out((CharSequence)"SeparateClass");
                break;
            }
            case CommaJoinedClass: {
                llvm.errs().$out((CharSequence)"CommaJoinedClass");
                break;
            }
            case MultiArgClass: {
                llvm.errs().$out((CharSequence)"MultiArgClass");
                break;
            }
            case JoinedOrSeparateClass: {
                llvm.errs().$out((CharSequence)"JoinedOrSeparateClass");
                break;
            }
            case JoinedAndSeparateClass: {
                llvm.errs().$out((CharSequence)"JoinedAndSeparateClass");
                break;
            }
            case RemainingArgsClass: {
                llvm.errs().$out((CharSequence)"RemainingArgsClass");
            }
        }
        if (((OptTable.Info)this.Info.$star()).Prefixes != null) {
            llvm.errs().$out((CharSequence)" Prefixes:[");
            type.ptr Pre = (type.ptr)Native.$tryClone(((OptTable.Info)this.Info.$star()).Prefixes);
            while (Pre.$star() != null) {
                llvm.errs().$out('\"').$out((char.ptr)Pre.$star()).$out((CharSequence)(((type.ptr)Pre.$add(1)).$star() == null ? "\"" : "\", "));
                Pre.$preInc();
            }
            llvm.errs().$out(']');
        }
        llvm.errs().$out((CharSequence)" Name:\"").$out(this.getName()).$out('\"');
        Option Group = this.getGroup();
        if (Group.isValid()) {
            llvm.errs().$out((CharSequence)" Group:");
            Group.dump();
        }
        if ((Alias = this.getAlias()).isValid()) {
            llvm.errs().$out((CharSequence)" Alias:");
            Alias.dump();
        }
        if (this.getKind() == OptionClass.MultiArgClass) {
            llvm.errs().$out((CharSequence)" NumArgs:").$out(this.getNumArgs());
        }
        llvm.errs().$out((CharSequence)">\n");
    }

    public Option(Option $Prm0) {
        this.Info = (type.ptr)Native.$tryClone($Prm0.Info);
        this.Owner = $Prm0.Owner;
    }

    public static final class RenderStyleKind
    extends Enum<RenderStyleKind> {
        public static final /* enum */ RenderStyleKind RenderCommaJoinedStyle = new RenderStyleKind(0L);
        public static final /* enum */ RenderStyleKind RenderJoinedStyle = new RenderStyleKind(1L);
        public static final /* enum */ RenderStyleKind RenderSeparateStyle = new RenderStyleKind(2L);
        public static final /* enum */ RenderStyleKind RenderValuesStyle = new RenderStyleKind(3L);
        private final int value;
        private static final /* synthetic */ RenderStyleKind[] $VALUES;

        public static RenderStyleKind[] values() {
            return (RenderStyleKind[])$VALUES.clone();
        }

        public static RenderStyleKind valueOf(String name) {
            return Enum.valueOf(RenderStyleKind.class, name);
        }

        public static RenderStyleKind valueOf(int val) {
            RenderStyleKind out;
            RenderStyleKind renderStyleKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private RenderStyleKind(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new RenderStyleKind[]{RenderCommaJoinedStyle, RenderJoinedStyle, RenderSeparateStyle, RenderValuesStyle};
        }

        private static final class Values {
            private static final RenderStyleKind[] VALUES;
            private static final RenderStyleKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (RenderStyleKind kind : RenderStyleKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new RenderStyleKind[min < 0 ? 1 - min : 0];
                VALUES = new RenderStyleKind[max >= 0 ? 1 + max : 0];
                for (RenderStyleKind kind : RenderStyleKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((RenderStyleKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((RenderStyleKind)kind).value] = kind;
                }
            }
        }
    }

    public static final class OptionClass
    extends Enum<OptionClass> {
        public static final /* enum */ OptionClass GroupClass = new OptionClass(0L);
        public static final /* enum */ OptionClass InputClass = new OptionClass(1L);
        public static final /* enum */ OptionClass UnknownClass = new OptionClass(2L);
        public static final /* enum */ OptionClass FlagClass = new OptionClass(3L);
        public static final /* enum */ OptionClass JoinedClass = new OptionClass(4L);
        public static final /* enum */ OptionClass SeparateClass = new OptionClass(5L);
        public static final /* enum */ OptionClass RemainingArgsClass = new OptionClass(6L);
        public static final /* enum */ OptionClass CommaJoinedClass = new OptionClass(7L);
        public static final /* enum */ OptionClass MultiArgClass = new OptionClass(8L);
        public static final /* enum */ OptionClass JoinedOrSeparateClass = new OptionClass(9L);
        public static final /* enum */ OptionClass JoinedAndSeparateClass = new OptionClass(10L);
        private final int value;
        private static final /* synthetic */ OptionClass[] $VALUES;

        public static OptionClass[] values() {
            return (OptionClass[])$VALUES.clone();
        }

        public static OptionClass valueOf(String name) {
            return Enum.valueOf(OptionClass.class, name);
        }

        public static OptionClass valueOf(int val) {
            OptionClass out;
            OptionClass optionClass = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private OptionClass(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new OptionClass[]{GroupClass, InputClass, UnknownClass, FlagClass, JoinedClass, SeparateClass, RemainingArgsClass, CommaJoinedClass, MultiArgClass, JoinedOrSeparateClass, JoinedAndSeparateClass};
        }

        private static final class Values {
            private static final OptionClass[] VALUES;
            private static final OptionClass[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (OptionClass kind : OptionClass.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new OptionClass[min < 0 ? 1 - min : 0];
                VALUES = new OptionClass[max >= 0 ? 1 + max : 0];
                for (OptionClass kind : OptionClass.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((OptionClass)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((OptionClass)kind).value] = kind;
                }
            }
        }
    }
}

