/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.api;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Main;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.processing.Processor;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class JavacTaskImpl
extends BasicJavacTask {
    private Main compilerMain;
    private JavaCompiler compiler;
    private Locale locale;
    private String[] args;
    private String[] classNames;
    private List<JavaFileObject> fileObjects;
    private Map<JavaFileObject, JCTree.JCCompilationUnit> notYetEntered;
    private ListBuffer<Env<AttrContext>> genList;
    private final AtomicBoolean used = new AtomicBoolean();
    private Iterable<? extends Processor> processors;
    private Main.Result result = null;
    private boolean parsed = false;

    JavacTaskImpl(Main compilerMain, String[] args, String[] classNames, Context context, List<JavaFileObject> fileObjects) {
        super(null, false);
        this.compilerMain = compilerMain;
        this.args = args;
        this.classNames = classNames;
        this.context = context;
        this.fileObjects = fileObjects;
        this.setLocale(Locale.getDefault());
        compilerMain.getClass();
        args.getClass();
        fileObjects.getClass();
    }

    JavacTaskImpl(Main compilerMain, Iterable<String> args, Context context, Iterable<String> classes, Iterable<? extends JavaFileObject> fileObjects) {
        this(compilerMain, JavacTaskImpl.toArray(args), JavacTaskImpl.toArray(classes), context, JavacTaskImpl.toList(fileObjects));
    }

    JavacTaskImpl(Context context) {
        super(null, false);
        this.context = context;
        this.setLocale(Locale.getDefault());
    }

    private static String[] toArray(Iterable<String> iter) {
        ListBuffer<String> result = new ListBuffer<String>();
        if (iter != null) {
            for (String s : iter) {
                result.append(s);
            }
        }
        return result.toArray(new String[result.length()]);
    }

    private static List<JavaFileObject> toList(Iterable<? extends JavaFileObject> fileObjects) {
        if (fileObjects == null) {
            return List.nil();
        }
        ListBuffer<JavaFileObject> result = new ListBuffer<JavaFileObject>();
        for (JavaFileObject javaFileObject : fileObjects) {
            result.append(javaFileObject);
        }
        return result.toList();
    }

    public Main.Result doCall() {
        if (!this.used.getAndSet(true)) {
            this.initContext();
            this.notYetEntered = new HashMap<JavaFileObject, JCTree.JCCompilationUnit>();
            this.compilerMain.setAPIMode(true);
            this.result = this.compilerMain.compile(this.args, this.classNames, this.context, this.fileObjects, this.processors);
            this.cleanup();
            return this.result;
        }
        throw new IllegalStateException("multiple calls to method 'call'");
    }

    @Override
    public Boolean call() {
        return this.doCall().isOK();
    }

    @Override
    public void setProcessors(Iterable<? extends Processor> processors) {
        processors.getClass();
        if (this.used.get()) {
            throw new IllegalStateException();
        }
        this.processors = processors;
    }

    public Iterable<? extends Processor> getProcessors() {
        return this.processors;
    }

    @Override
    public void setLocale(Locale locale) {
        if (this.used.get()) {
            throw new IllegalStateException();
        }
        this.locale = locale;
    }

    private void prepareCompiler() throws IOException {
        if (this.used.getAndSet(true)) {
            if (this.compiler == null) {
                throw new IllegalStateException();
            }
        } else {
            this.initContext();
            this.compilerMain.log = Log.instance(this.context);
            this.compilerMain.setOptions(Options.instance(this.context));
            this.compilerMain.filenames = new LinkedHashSet<File>();
            Collection<File> filenames = this.compilerMain.processArgs(CommandLine.parse(this.args), this.classNames);
            if (filenames != null && !filenames.isEmpty()) {
                throw new IllegalArgumentException("Malformed arguments " + this.toString(filenames, " "));
            }
            this.compiler = JavaCompiler.instance(this.context);
            this.compiler.initProcessAnnotations(this.processors);
            this.notYetEntered = new HashMap<JavaFileObject, JCTree.JCCompilationUnit>();
            this.compiler.initNotYetEntered(this.notYetEntered);
            for (JavaFileObject file : this.fileObjects) {
                this.notYetEntered.put(file, null);
            }
            this.genList = new ListBuffer();
            this.args = null;
            this.classNames = null;
        }
    }

    <T> String toString(Iterable<T> items, String sep) {
        String currSep = "";
        StringBuilder sb = new StringBuilder();
        for (T item : items) {
            sb.append(currSep);
            sb.append(item.toString());
            currSep = sep;
        }
        return sb.toString();
    }

    private void initContext() {
        this.context.put(JavacTask.class, this);
        this.context.put(Locale.class, this.locale);
    }

    void cleanup() {
        if (this.compiler != null) {
            this.compiler.close();
        }
        this.compiler = null;
        this.compilerMain = null;
        this.args = null;
        this.classNames = null;
        this.context = null;
        this.fileObjects = null;
        this.notYetEntered = null;
    }

    public JavaFileObject asJavaFileObject(File file) {
        JavacFileManager fm = (JavacFileManager)this.context.get(JavaFileManager.class);
        return fm.getRegularFile(file);
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<? extends CompilationUnitTree> parse(JavaFileObject ... files) throws IOException {
        void var5_7;
        this.prepareCompiler();
        LinkedList<CompilationUnitTree> trees = new LinkedList<CompilationUnitTree>();
        this.fileObjects = List.nil();
        JavaFileObject[] arr$ = files;
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_7 < len$) {
            JavaFileObject file = arr$[var5_7];
            CompilationUnitTree tree = this.getTreeForFile(file);
            if (tree != null) {
                trees.add(tree);
            } else {
                this.fileObjects = this.fileObjects.append(file);
                if (this.notYetEntered != null) {
                    assert (!this.notYetEntered.containsKey(file) || this.notYetEntered.get(file) == null);
                    this.notYetEntered.put(file, null);
                }
            }
            ++var5_7;
        }
        if (!this.fileObjects.isEmpty()) {
            Iterable<? extends CompilationUnitTree> newTrees = this.parse();
            for (CompilationUnitTree compilationUnitTree : newTrees) {
                trees.add(compilationUnitTree);
            }
        }
        return trees;
    }

    private CompilationUnitTree getTreeForFile(JavaFileObject file) {
        assert (file != null);
        Enter enter = Enter.instance(this.context);
        CompilationUnitTree tree = enter.getCompilationUnit(file);
        if (tree == null && this.notYetEntered != null) {
            tree = this.notYetEntered.get(file);
        }
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<? extends CompilationUnitTree> parse() throws IOException {
        try {
            this.prepareCompiler();
            List<JCTree.JCCompilationUnit> units = this.compiler.parseFiles(this.fileObjects);
            for (JCTree.JCCompilationUnit unit : units) {
                JavaFileObject file = unit.getSourceFile();
                if (!this.notYetEntered.containsKey(file)) continue;
                this.notYetEntered.put(file, unit);
            }
            List<JCTree.JCCompilationUnit> list = units;
            return list;
        }
        finally {
            this.parsed = true;
            if (this.compiler != null && this.compiler.log != null) {
                this.compiler.log.flush();
            }
            for (JavaFileObject file : this.fileObjects) {
                if (this.notYetEntered.get(file) != null) continue;
                this.notYetEntered.remove(file);
            }
        }
    }

    public Iterable<? extends TypeElement> enter() throws IOException {
        return this.enter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends TypeElement> enter(Iterable<? extends CompilationUnitTree> trees) throws IOException {
        if (trees == null && this.notYetEntered != null && this.notYetEntered.isEmpty()) {
            return List.nil();
        }
        this.prepareCompiler();
        ListBuffer<JCTree.JCCompilationUnit> roots = null;
        if (trees == null) {
            if (this.notYetEntered.size() > 0) {
                if (!this.parsed) {
                    this.parse();
                }
                for (JavaFileObject javaFileObject : this.fileObjects) {
                    JCTree.JCCompilationUnit unit = this.notYetEntered.remove(javaFileObject);
                    if (unit == null) continue;
                    if (roots == null) {
                        roots = new ListBuffer();
                    }
                    roots.append(unit);
                }
                this.notYetEntered.clear();
            }
        } else {
            for (CompilationUnitTree compilationUnitTree : trees) {
                if (compilationUnitTree instanceof JCTree.JCCompilationUnit) {
                    if (roots == null) {
                        roots = new ListBuffer<JCTree.JCCompilationUnit>();
                    }
                    roots.append((JCTree.JCCompilationUnit)compilationUnitTree);
                    this.notYetEntered.remove(compilationUnitTree.getSourceFile());
                    continue;
                }
                throw new IllegalArgumentException(compilationUnitTree.toString());
            }
        }
        if (roots == null) {
            return List.nil();
        }
        if (!this.compiler.skipAnnotationProcessing && this.compiler.processAnnotations && this.compiler.deferredDiagnosticHandler == null) {
            this.compiler.deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(this.compiler.log);
        }
        try {
            List<JCTree.JCCompilationUnit> units = this.compiler.enterTrees(roots.toList());
            if (!this.compiler.skipAnnotationProcessing) {
                this.compiler.skipAnnotationProcessing = true;
                try {
                    this.compiler.processAnnotations(units);
                }
                finally {
                    this.compiler.skipAnnotationProcessing = false;
                }
            }
            ListBuffer<Symbol.ClassSymbol> listBuffer = new ListBuffer<Symbol.ClassSymbol>();
            for (JCTree.JCCompilationUnit unit : units) {
                boolean isPkgInfo = unit.sourcefile.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE);
                if (isPkgInfo) {
                    if (unit.packge.package_info == null) continue;
                    listBuffer.append(unit.packge.package_info);
                    continue;
                }
                for (JCTree node : unit.defs) {
                    if (!node.hasTag(JCTree.Tag.CLASSDEF)) continue;
                    JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)node;
                    if (cdef.sym == null) continue;
                    listBuffer.append(cdef.sym);
                }
            }
            List list = listBuffer.toList();
            return list;
        }
        finally {
            this.compiler.log.flush();
        }
    }

    public Iterable<? extends TypeElement> enterTrees(Iterable<? extends CompilationUnitTree> trees) throws IOException {
        ArrayList<CompilationUnitTree> toEnter = new ArrayList<CompilationUnitTree>();
        ArrayList<TypeElement> res = new ArrayList<TypeElement>();
        for (CompilationUnitTree compilationUnitTree : trees) {
            Collection<TypeElement> collection = this.getEnteredElements(compilationUnitTree);
            if (collection.isEmpty()) {
                toEnter.add(compilationUnitTree);
                continue;
            }
            res.addAll(collection);
        }
        if (!toEnter.isEmpty()) {
            Iterable<? extends TypeElement> classes = this.enter(toEnter);
            for (TypeElement typeElement : classes) {
                res.add(typeElement);
            }
        }
        return res;
    }

    private Collection<TypeElement> getEnteredElements(CompilationUnitTree tree) {
        assert (tree instanceof JCTree.JCCompilationUnit);
        ArrayList<TypeElement> res = new ArrayList<TypeElement>();
        if (((JCTree.JCCompilationUnit)tree).packge != null) {
            for (JCTree t : ((JCTree.JCCompilationUnit)tree).defs) {
                Symbol.ClassSymbol sym;
                if (!t.hasTag(JCTree.Tag.CLASSDEF) || (sym = ((JCTree.JCClassDecl)t).sym) == null) continue;
                res.add(sym);
            }
        }
        return res;
    }

    @Override
    public Iterable<? extends Element> analyze() throws IOException {
        return this.analyze(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends Element> analyze(Iterable<? extends TypeElement> classes) throws IOException {
        if (classes == null) {
            this.enter(null);
        }
        final ListBuffer<Element> results = new ListBuffer<Element>();
        try {
            if (classes == null) {
                this.handleFlowResults(this.compiler.flow(this.compiler.attribute(this.compiler.todo)), results);
            } else {
                Filter f = new Filter(){

                    @Override
                    public void process(Env<AttrContext> env) {
                        JavacTaskImpl.this.handleFlowResults(JavacTaskImpl.this.compiler.flow(JavacTaskImpl.this.compiler.attribute(env)), results);
                    }
                };
                f.run(this.compiler.todo, classes);
            }
            if (!this.compiler.skipAnnotationProcessing && this.compiler.deferredDiagnosticHandler != null && this.compiler.toProcessAnnotations.nonEmpty()) {
                this.compiler = this.compiler.processAnnotations(List.nil());
            }
        }
        finally {
            this.compiler.log.flush();
        }
        return results;
    }

    private void handleFlowResults(Queue<Env<AttrContext>> queue, ListBuffer<Element> elems) {
        for (Env env : queue) {
            switch (env.tree.getTag()) {
                case CLASSDEF: {
                    JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)env.tree;
                    if (cdef.sym == null) break;
                    elems.append(cdef.sym);
                    break;
                }
                case TOPLEVEL: {
                    JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)env.tree;
                    if (unit.packge == null) break;
                    elems.append(unit.packge);
                }
            }
        }
        this.genList.addAll((Collection<Env<AttrContext>>)queue);
    }

    @Override
    public Iterable<? extends JavaFileObject> generate() throws IOException {
        return this.generate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends JavaFileObject> generate(Iterable<? extends TypeElement> classes) throws IOException {
        final ListBuffer<JavaFileObject> results = new ListBuffer<JavaFileObject>();
        try {
            this.analyze(classes);
            if (classes == null) {
                this.compiler.generate(this.compiler.desugar(this.genList), results);
                this.genList.clear();
            } else {
                Filter f = new Filter(){

                    @Override
                    public void process(Env<AttrContext> env) {
                        JavacTaskImpl.this.compiler.generate(JavacTaskImpl.this.compiler.desugar(ListBuffer.of(env)), results);
                    }
                };
                f.run(this.genList, classes);
            }
            if (this.genList.isEmpty()) {
                this.compiler.reportDeferredDiagnostics();
                this.compiler.log.flush();
                this.compiler.repair.flush();
            }
        }
        finally {
            if (this.compiler != null) {
                this.compiler.log.flush();
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateTypeElements(Iterable<? extends TypeElement> classes) throws IOException {
        assert (classes != null);
        try {
            this.analyze(classes);
            Filter f = new Filter(){

                @Override
                public void process(Env<AttrContext> env) {
                    JavacTaskImpl.this.compiler.generate(JavacTaskImpl.this.compiler.desugar(ListBuffer.of(env)));
                }
            };
            f.run(this.genList, classes);
        }
        finally {
            this.compiler.log.flush();
        }
    }

    public void finish() {
        if (this.notYetEntered != null && !this.notYetEntered.isEmpty()) {
            this.notYetEntered.clear();
        }
        if (this.compiler != null && this.compiler.todo != null && !this.compiler.todo.isEmpty()) {
            this.compiler.todo.clear();
        }
        if (this.genList != null && !this.genList.isEmpty()) {
            this.genList.clear();
        }
        this.cleanup();
    }

    @Override
    public TypeMirror getTypeMirror(Iterable<? extends Tree> path) {
        Tree last = null;
        Iterator<? extends Tree> i$ = path.iterator();
        while (i$.hasNext()) {
            Tree node;
            last = node = i$.next();
        }
        return ((JCTree)last).type;
    }

    @Override
    public JavacElements getElements() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return JavacElements.instance(this.context);
    }

    @Override
    public JavacTypes getTypes() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return JavacTypes.instance(this.context);
    }

    public Iterable<? extends Tree> pathFor(CompilationUnitTree unit, Tree node) {
        return TreeInfo.pathFor((JCTree)node, (JCTree.JCCompilationUnit)unit).reverse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type parseType(String expr, TypeElement scope) {
        if (expr == null || expr.equals("")) {
            throw new IllegalArgumentException();
        }
        this.compiler = JavaCompiler.instance(this.context);
        JavaFileObject prev = this.compiler.log.useSource(null);
        ParserFactory parserFactory = ParserFactory.instance(this.context);
        Attr attr = Attr.instance(this.context);
        Log.DiscardDiagnosticHandler discardHandler = new Log.DiscardDiagnosticHandler(this.compiler.log);
        try {
            CharSequence buf = '\u0000' == expr.charAt(expr.length() - 1) ? expr : CharBuffer.wrap((expr + "\u0000").toCharArray(), 0, expr.length());
            JavacParser parser = parserFactory.newParser(buf, false, false, false);
            JCTree.JCExpression tree = parser.parseType();
            Type type = attr.attribType((JCTree)tree, (Symbol.TypeSymbol)((Object)scope));
            return type;
        }
        finally {
            this.compiler.log.popDiagnosticHandler(discardHandler);
            this.compiler.log.useSource(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tree parseType(String expr) {
        if (expr == null || expr.equals("")) {
            throw new IllegalArgumentException();
        }
        this.compiler = JavaCompiler.instance(this.context);
        JavaFileObject prev = this.compiler.log.useSource(null);
        ParserFactory parserFactory = ParserFactory.instance(this.context);
        Log.DiscardDiagnosticHandler discardHandler = new Log.DiscardDiagnosticHandler(this.compiler.log);
        try {
            CharSequence buf = '\u0000' == expr.charAt(expr.length() - 1) ? expr : CharBuffer.wrap((expr + "\u0000").toCharArray(), 0, expr.length());
            JavacParser parser = parserFactory.newParser(buf, false, false, false);
            JCTree.JCExpression jCExpression = parser.parseType();
            return jCExpression;
        }
        finally {
            this.compiler.log.popDiagnosticHandler(discardHandler);
            this.compiler.log.useSource(prev);
        }
    }

    public JCTree.JCStatement parseStatement(CharSequence stmt, SourcePositions[] pos, DiagnosticListener<? super JavaFileObject> errors) {
        return (JCTree.JCStatement)this.doParse(ParseKind.STATEMENT, stmt, pos, errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCTree doParse(ParseKind kind, CharSequence source, SourcePositions[] pos, final DiagnosticListener<? super JavaFileObject> errors) {
        if (source == null || source.length() == 0 || pos != null && pos.length != 1) {
            throw new IllegalArgumentException();
        }
        this.compiler = JavaCompiler.instance(this.context);
        JavaFileObject prev = this.compiler.log.useSource(null);
        Log.DiscardDiagnosticHandler discardHandler = new Log.DiscardDiagnosticHandler(this.compiler.log){

            @Override
            public void report(JCDiagnostic diag) {
                errors.report(diag);
            }
        };
        ParserFactory parserFactory = ParserFactory.instance(this.context);
        try {
            CharSequence buf = '\u0000' == source.charAt(source.length() - 1) ? source : CharBuffer.wrap((source + "\u0000").toCharArray(), 0, source.length());
            JavacParser parser = parserFactory.newParser(buf, false, true, false);
            if (parser instanceof JavacParser) {
                if (pos != null) {
                    pos[0] = new ParserSourcePositions(parser);
                }
                switch (kind) {
                    case STATEMENT: {
                        JCTree.JCStatement jCStatement = parser.parseStatement();
                        return jCStatement;
                    }
                    case EXPRESSION: {
                        JCTree.JCExpression jCExpression = parser.parseExpression();
                        return jCExpression;
                    }
                    case VARIABLE_INIT: {
                        JCTree.JCExpression jCExpression = parser.variableInitializer();
                        return jCExpression;
                    }
                    case STATIC_BLOCK: {
                        List<JCTree> trees = parser.classOrInterfaceBodyDeclaration(null, false);
                        JCTree.JCBlock jCBlock = trees.head != null && ((JCTree)trees.head).hasTag(JCTree.Tag.BLOCK) ? (JCTree.JCBlock)trees.head : null;
                        return jCBlock;
                    }
                }
                throw new UnsupportedOperationException(kind.name());
            }
            JCTree jCTree = null;
            return jCTree;
        }
        finally {
            this.compiler.log.popDiagnosticHandler(discardHandler);
            this.compiler.log.useSource(prev);
        }
    }

    public JCTree.JCExpression parseExpression(CharSequence expr, SourcePositions[] pos, DiagnosticListener<? super JavaFileObject> errors) {
        return (JCTree.JCExpression)this.doParse(ParseKind.EXPRESSION, expr, pos, errors);
    }

    public JCTree.JCExpression parseVariableInitializer(CharSequence init, SourcePositions[] pos, DiagnosticListener<? super JavaFileObject> errors) {
        return (JCTree.JCExpression)this.doParse(ParseKind.VARIABLE_INIT, init, pos, errors);
    }

    public JCTree.JCBlock parseStaticBlock(CharSequence block, SourcePositions[] pos, DiagnosticListener<? super JavaFileObject> errors) {
        return (JCTree.JCBlock)this.doParse(ParseKind.STATIC_BLOCK, block, pos, errors);
    }

    @Deprecated
    public JCTree.JCStatement parseStatement(CharSequence stmt, SourcePositions[] pos) {
        return this.parseStatement(stmt, pos, new DiscardDiagnosticListener());
    }

    @Deprecated
    public JCTree.JCExpression parseExpression(CharSequence expr, SourcePositions[] pos) {
        return this.parseExpression(expr, pos, new DiscardDiagnosticListener());
    }

    @Deprecated
    public JCTree.JCExpression parseVariableInitializer(CharSequence init, SourcePositions[] pos) {
        return this.parseVariableInitializer(init, pos, new DiscardDiagnosticListener());
    }

    @Deprecated
    public JCTree.JCBlock parseStaticBlock(CharSequence block, SourcePositions[] pos) {
        return this.parseStaticBlock(block, pos, new DiscardDiagnosticListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type attributeTree(JCTree tree, Env<AttrContext> env) {
        Log log = Log.instance(this.context);
        Attr attr = Attr.instance(this.context);
        JavaFileObject prev = log.useSource(null);
        Log.DiscardDiagnosticHandler discardHandler = new Log.DiscardDiagnosticHandler(log);
        Log.DeferredDiagnosticHandler deferredHandler = this.compiler.deferredDiagnosticHandler;
        this.compiler.deferredDiagnosticHandler = null;
        Enter enter = Enter.instance(this.context);
        enter.shadowTypeEnvs(true);
        try {
            Type type;
            Type type2 = type = tree instanceof JCTree.JCExpression ? attr.attribExpr(tree, env, Type.noType) : attr.attribStat(tree, env);
            if (!this.compiler.skipAnnotationProcessing && this.compiler.deferredDiagnosticHandler != null && this.compiler.toProcessAnnotations.nonEmpty()) {
                this.compiler = this.compiler.processAnnotations(List.nil());
            }
            Type type3 = type;
            return type3;
        }
        finally {
            enter.shadowTypeEnvs(false);
            this.compiler.deferredDiagnosticHandler = deferredHandler;
            log.popDiagnosticHandler(discardHandler);
            log.useSource(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavacScope attributeTreeTo(JCTree tree, Env<AttrContext> env, JCTree to) {
        Log log = Log.instance(this.context);
        Attr attr = Attr.instance(this.context);
        JavaFileObject prev = log.useSource(null);
        Log.DiscardDiagnosticHandler discardHandler = new Log.DiscardDiagnosticHandler(log);
        Log.DeferredDiagnosticHandler deferredHandler = this.compiler.deferredDiagnosticHandler;
        this.compiler.deferredDiagnosticHandler = null;
        Enter enter = Enter.instance(this.context);
        enter.shadowTypeEnvs(true);
        try {
            Env<AttrContext> ret;
            Env<AttrContext> env2 = ret = tree instanceof JCTree.JCExpression ? attr.attribExprToTree(tree, env, to) : attr.attribStatToTree(tree, env, to);
            if (!this.compiler.skipAnnotationProcessing && this.compiler.deferredDiagnosticHandler != null && this.compiler.toProcessAnnotations.nonEmpty()) {
                this.compiler = this.compiler.processAnnotations(List.nil());
            }
            JavacScope javacScope = new JavacScope(ret);
            return javacScope;
        }
        finally {
            enter.shadowTypeEnvs(false);
            this.compiler.deferredDiagnosticHandler = deferredHandler;
            log.popDiagnosticHandler(discardHandler);
            log.useSource(prev);
        }
    }

    public String dumpTodo() {
        StringBuilder res = new StringBuilder();
        if (this.compiler != null && this.compiler.todo != null) {
            for (Env<AttrContext> env : this.compiler.todo) {
                res.append(((JCTree.JCClassDecl)env.tree).sym.toString()).append(" from: ").append(env.toplevel.sourcefile.toUri());
            }
        }
        return res.toString();
    }

    public java.util.List<Env<AttrContext>> getTodo() {
        if (this.compiler != null && this.compiler.todo != null) {
            return new ArrayList<Env<AttrContext>>(this.compiler.todo);
        }
        return Collections.emptyList();
    }

    private class ParserSourcePositions
    implements SourcePositions {
        private JavacParser parser;

        private ParserSourcePositions(JavacParser parser) {
            this.parser = parser;
        }

        @Override
        public long getStartPosition(CompilationUnitTree file, Tree tree) {
            return this.parser.getStartPos((JCTree)tree);
        }

        @Override
        public long getEndPosition(CompilationUnitTree file, Tree tree) {
            return this.parser.getEndPos((JCTree)tree);
        }
    }

    private static final class DiscardDiagnosticListener
    implements DiagnosticListener<JavaFileObject> {
        private DiscardDiagnosticListener() {
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
        }
    }

    private static enum ParseKind {
        STATEMENT,
        EXPRESSION,
        VARIABLE_INIT,
        STATIC_BLOCK;

    }

    abstract class Filter {
        Filter() {
        }

        void run(Queue<Env<AttrContext>> list, Iterable<? extends TypeElement> classes) {
            HashSet<TypeElement> set = new HashSet<TypeElement>();
            for (TypeElement typeElement : classes) {
                set.add(typeElement);
            }
            ListBuffer<Env<AttrContext>> defer = new ListBuffer<Env<AttrContext>>();
            while (list.peek() != null) {
                Env<AttrContext> env = list.remove();
                boolean isPkgInfo = env.toplevel.sourcefile.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE);
                Symbol.ClassSymbol csym = isPkgInfo ? env.toplevel.packge.package_info : env.enclClass.sym;
                if (csym != null && set.contains(csym.outermostClass())) {
                    this.process(env);
                    continue;
                }
                defer = defer.append(env);
            }
            list.addAll(defer);
        }

        abstract void process(Env<AttrContext> var1);
    }
}

