/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;
import javax.tools.JavaFileObject;

public class TypeAnnotations {
    protected static final Context.Key<TypeAnnotations> typeAnnosKey = new Context.Key();
    final Log log;
    final Names names;
    final Symtab syms;
    final Annotate annotate;
    final Attr attr;

    public static TypeAnnotations instance(Context context) {
        TypeAnnotations instance = context.get(typeAnnosKey);
        if (instance == null) {
            instance = new TypeAnnotations(context);
        }
        return instance;
    }

    protected TypeAnnotations(Context context) {
        context.put(typeAnnosKey, this);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.annotate = Annotate.instance(context);
        this.attr = Attr.instance(context);
        Options options = Options.instance(context);
    }

    public void organizeTypeAnnotationsSignatures(final Env<AttrContext> env, final JCTree.JCClassDecl tree) {
        this.annotate.afterRepeated(new Annotate.Worker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JavaFileObject oldSource = TypeAnnotations.this.log.useSource(env.toplevel.sourcefile);
                try {
                    new TypeAnnotationPositions(true).scan(tree);
                }
                finally {
                    TypeAnnotations.this.log.useSource(oldSource);
                }
            }
        });
    }

    public void validateTypeAnnotationsSignatures(final Env<AttrContext> env, final JCTree.JCClassDecl tree) {
        this.annotate.validate(new Annotate.Worker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JavaFileObject oldSource = TypeAnnotations.this.log.useSource(env.toplevel.sourcefile);
                try {
                    TypeAnnotations.this.attr.validateTypeAnnotations(tree, true);
                }
                finally {
                    TypeAnnotations.this.log.useSource(oldSource);
                }
            }
        });
    }

    public void organizeTypeAnnotationsBodies(JCTree.JCClassDecl tree) {
        new TypeAnnotationPositions(false).scan(tree);
    }

    public AnnotationType annotationType(Attribute.Compound a, Symbol s) {
        if (a == null) {
            return AnnotationType.BOTH;
        }
        Attribute.Compound atTarget = a.type.tsym.attribute(this.syms.annotationTargetType.tsym);
        if (atTarget == null) {
            return TypeAnnotations.inferTargetMetaInfo(a, s);
        }
        Attribute atValue = atTarget.member(this.names.value);
        if (atValue == null) {
            return TypeAnnotations.inferTargetMetaInfo(a, s);
        }
        if (!(atValue instanceof Attribute.Array)) {
            Assert.error("annotationType(): bad @Target argument " + atValue + " (" + atValue.getClass() + ")");
            return AnnotationType.DECLARATION;
        }
        Attribute.Array arr = (Attribute.Array)atValue;
        boolean isDecl = false;
        boolean isType = false;
        for (Attribute app : arr.values) {
            if (!(app instanceof Attribute.Enum)) {
                Assert.error("annotationType(): unrecognized Attribute kind " + app + " (" + app.getClass() + ")");
                isDecl = true;
                continue;
            }
            Attribute.Enum e = (Attribute.Enum)app;
            if (e.value.name == this.names.TYPE) {
                if (s.kind != 2) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.FIELD) {
                if (s.kind != 4 || s.owner.kind == 16) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.METHOD) {
                if (s.kind != 16 || s.isConstructor()) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.PARAMETER) {
                if (s.kind != 4 || s.owner.kind != 16 || (s.flags() & 0x200000000L) == 0L) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.CONSTRUCTOR) {
                if (s.kind != 16 || !s.isConstructor()) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.LOCAL_VARIABLE) {
                if (s.kind != 4 || s.owner.kind != 16 || (s.flags() & 0x200000000L) != 0L) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.ANNOTATION_TYPE) {
                if (s.kind != 2 || (s.flags() & 0x2000L) == 0L) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.PACKAGE) {
                if (s.kind != 1) continue;
                isDecl = true;
                continue;
            }
            if (e.value.name == this.names.TYPE_USE) {
                if (s.kind != 2 && s.kind != 4 && (s.kind != 16 || s.isConstructor() || s.type.getReturnType().hasTag(TypeTag.VOID)) && (s.kind != 16 || !s.isConstructor())) continue;
                isType = true;
                continue;
            }
            if (e.value.name == this.names.TYPE_PARAMETER) continue;
            Assert.error("annotationType(): unrecognized Attribute name " + e.value.name + " (" + e.value.name.getClass() + ")");
            isDecl = true;
        }
        if (isDecl && isType) {
            return AnnotationType.BOTH;
        }
        if (isType) {
            return AnnotationType.TYPE;
        }
        return AnnotationType.DECLARATION;
    }

    private static AnnotationType inferTargetMetaInfo(Attribute.Compound a, Symbol s) {
        return AnnotationType.DECLARATION;
    }

    private class TypeAnnotationPositions
    extends TreeScanner {
        private final boolean sigOnly;
        private ListBuffer<JCTree> frames = new ListBuffer();
        private boolean isInClass = false;
        private JCTree.JCLambda currentLambda = null;

        TypeAnnotationPositions(boolean sigOnly) {
            this.sigOnly = sigOnly;
        }

        protected void push(JCTree t) {
            this.frames = this.frames.prepend(t);
        }

        protected JCTree pop() {
            return this.frames.next();
        }

        private JCTree peek2() {
            return (JCTree)this.frames.toList().tail.head;
        }

        @Override
        public void scan(JCTree tree) {
            this.push(tree);
            super.scan(tree);
            this.pop();
        }

        private void separateAnnotationsKinds(JCTree typetree, Type type, Symbol sym, TypeAnnotationPosition pos) {
            List<Attribute.Compound> annotations = sym.getRawAttributes();
            ListBuffer<Attribute.Compound> declAnnos = new ListBuffer<Attribute.Compound>();
            ListBuffer<Attribute.TypeCompound> typeAnnos = new ListBuffer<Attribute.TypeCompound>();
            ListBuffer<Attribute.TypeCompound> onlyTypeAnnos = new ListBuffer<Attribute.TypeCompound>();
            for (Attribute.Compound a : annotations) {
                switch (TypeAnnotations.this.annotationType(a, sym)) {
                    case DECLARATION: {
                        declAnnos.append(a);
                        break;
                    }
                    case BOTH: {
                        declAnnos.append(a);
                        Attribute.TypeCompound ta = this.toTypeCompound(a, pos);
                        typeAnnos.append(ta);
                        break;
                    }
                    case TYPE: {
                        Attribute.TypeCompound ta = this.toTypeCompound(a, pos);
                        typeAnnos.append(ta);
                        onlyTypeAnnos.append(ta);
                        break;
                    }
                }
            }
            sym.resetAnnotations();
            sym.setDeclarationAttributes(declAnnos.toList());
            if (typeAnnos.isEmpty()) {
                return;
            }
            List<Attribute.TypeCompound> typeAnnotations = typeAnnos.toList();
            if (type == null) {
                type = sym.getEnclosingElement().asType();
                type = this.typeWithAnnotations(typetree, type, typeAnnotations, typeAnnotations);
                sym.appendUniqueTypeAttributes(typeAnnotations);
                return;
            }
            type = this.typeWithAnnotations(typetree, type, typeAnnotations, onlyTypeAnnos.toList());
            if (sym.getKind() == ElementKind.METHOD) {
                sym.type.asMethodType().restype = type;
            } else if (sym.getKind() == ElementKind.PARAMETER) {
                sym.type = type;
                if (sym.getQualifiedName().equals(TypeAnnotations.this.names._this)) {
                    sym.owner.type.asMethodType().recvtype = type;
                } else {
                    Type.MethodType methType = sym.owner.type.asMethodType();
                    List<Symbol.VarSymbol> params = ((Symbol.MethodSymbol)sym.owner).params;
                    List<Type> oldArgs = methType.argtypes;
                    ListBuffer<Type> newArgs = new ListBuffer<Type>();
                    while (params.nonEmpty()) {
                        if (params.head == sym) {
                            newArgs.add(type);
                        } else {
                            newArgs.add((Type)oldArgs.head);
                        }
                        oldArgs = oldArgs.tail;
                        params = params.tail;
                    }
                    methType.argtypes = newArgs.toList();
                }
            } else {
                sym.type = type;
            }
            sym.appendUniqueTypeAttributes(typeAnnotations);
            if (sym.getKind() == ElementKind.PARAMETER || sym.getKind() == ElementKind.LOCAL_VARIABLE || sym.getKind() == ElementKind.RESOURCE_VARIABLE || sym.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                sym.owner.appendUniqueTypeAttributes(sym.getRawTypeAttributes());
            }
        }

        private Type typeWithAnnotations(JCTree typetree, Type type, List<Attribute.TypeCompound> annotations, List<Attribute.TypeCompound> onlyTypeAnnotations) {
            Type ret;
            if (annotations.isEmpty()) {
                return type;
            }
            if (type.hasTag(TypeTag.ARRAY)) {
                Type arelemType;
                Type.ArrayType arType = (Type.ArrayType)type.unannotatedType();
                Type.ArrayType tomodify = new Type.ArrayType(null, arType.tsym);
                Type toreturn = type.isAnnotated() ? tomodify.annotatedType((List<Attribute.TypeCompound>)type.getAnnotationMirrors()) : tomodify;
                JCTree.JCArrayTypeTree arTree = this.arrayTypeTree(typetree);
                ListBuffer<Object> depth = new ListBuffer<TypeAnnotationPosition.TypePathEntry>();
                depth = depth.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
                while (arType.elemtype.hasTag(TypeTag.ARRAY)) {
                    if (arType.elemtype.isAnnotated()) {
                        Type aelemtype = arType.elemtype;
                        arType = (Type.ArrayType)aelemtype.unannotatedType();
                        Type.ArrayType prevToMod = tomodify;
                        tomodify = new Type.ArrayType(null, arType.tsym);
                        prevToMod.elemtype = tomodify.annotatedType((List<Attribute.TypeCompound>)arType.elemtype.getAnnotationMirrors());
                    } else {
                        arType = (Type.ArrayType)arType.elemtype;
                        tomodify.elemtype = new Type.ArrayType(null, arType.tsym);
                        tomodify = (Type.ArrayType)tomodify.elemtype;
                    }
                    arTree = this.arrayTypeTree(arTree.elemtype);
                    depth = depth.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
                }
                tomodify.elemtype = arelemType = this.typeWithAnnotations(arTree.elemtype, arType.elemtype, annotations, onlyTypeAnnotations);
                Attribute.TypeCompound a = annotations.get(0);
                TypeAnnotationPosition p = a.position;
                p.location = p.location.prependList(depth.toList());
                typetree.type = toreturn;
                return toreturn;
            }
            if (type.hasTag(TypeTag.TYPEVAR)) {
                return type;
            }
            if (type.getKind() == TypeKind.UNION) {
                Type res;
                JCTree.JCTypeUnion tutree = (JCTree.JCTypeUnion)typetree;
                JCTree.JCExpression fst = tutree.alternatives.get(0);
                fst.type = res = this.typeWithAnnotations(fst, fst.type, annotations, onlyTypeAnnotations);
                return type;
            }
            Type enclTy = type;
            Element enclEl = type.asElement();
            JCTree enclTr = typetree;
            while (enclEl != null && enclEl.getKind() != ElementKind.PACKAGE && enclTy != null && enclTy.getKind() != TypeKind.NONE && enclTy.getKind() != TypeKind.ERROR && (enclTr.getKind() == Tree.Kind.MEMBER_SELECT || enclTr.getKind() == Tree.Kind.PARAMETERIZED_TYPE || enclTr.getKind() == Tree.Kind.ANNOTATED_TYPE)) {
                if (enclTr.getKind() == Tree.Kind.MEMBER_SELECT) {
                    enclTy = enclTy.getEnclosingType();
                    enclEl = enclEl.getEnclosingElement();
                    enclTr = ((JCTree.JCFieldAccess)enclTr).getExpression();
                    continue;
                }
                if (enclTr.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                    enclTr = ((JCTree.JCTypeApply)enclTr).getType();
                    continue;
                }
                enclTr = ((JCTree.JCAnnotatedType)enclTr).getUnderlyingType();
            }
            if (enclTy != null && enclTy.hasTag(TypeTag.NONE)) {
                switch (onlyTypeAnnotations.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        TypeAnnotations.this.log.error(typetree.pos(), "cant.type.annotate.scoping.1", onlyTypeAnnotations);
                        break;
                    }
                    default: {
                        TypeAnnotations.this.log.error(typetree.pos(), "cant.type.annotate.scoping", onlyTypeAnnotations);
                    }
                }
                return type;
            }
            ListBuffer<TypeAnnotationPosition.TypePathEntry> depth = new ListBuffer<TypeAnnotationPosition.TypePathEntry>();
            for (Type topTy = enclTy; enclEl != null && enclEl.getKind() != ElementKind.PACKAGE && topTy != null && topTy.getKind() != TypeKind.NONE && topTy.getKind() != TypeKind.ERROR; topTy = topTy.getEnclosingType(), enclEl = enclEl.getEnclosingElement()) {
                if (topTy == null || topTy.getKind() == TypeKind.NONE) continue;
                depth = depth.append(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
            }
            if (depth.nonEmpty()) {
                Attribute.TypeCompound a = annotations.get(0);
                TypeAnnotationPosition p = a.position;
                p.location = p.location.appendList(depth.toList());
            }
            typetree.type = ret = this.typeWithAnnotations(type, enclTy, annotations);
            return ret;
        }

        private JCTree.JCArrayTypeTree arrayTypeTree(JCTree typetree) {
            if (typetree.getKind() == Tree.Kind.ARRAY_TYPE) {
                return (JCTree.JCArrayTypeTree)typetree;
            }
            if (typetree.getKind() == Tree.Kind.ANNOTATED_TYPE) {
                return (JCTree.JCArrayTypeTree)((JCTree.JCAnnotatedType)typetree).underlyingType;
            }
            Assert.error("Could not determine array type from type tree: " + typetree);
            return null;
        }

        private Type typeWithAnnotations(Type type, final Type stopAt, List<Attribute.TypeCompound> annotations) {
            Type.Visitor<Type, List<Attribute.TypeCompound>> visitor = new Type.Visitor<Type, List<Attribute.TypeCompound>>(){

                @Override
                public Type visitClassType(Type.ClassType t, List<Attribute.TypeCompound> s) {
                    if (t == stopAt || t.getEnclosingType() == Type.noType) {
                        return t.annotatedType(s);
                    }
                    Type.ClassType ret = new Type.ClassType(t.getEnclosingType().accept(this, s), t.typarams_field, t.tsym);
                    ret.all_interfaces_field = t.all_interfaces_field;
                    ret.allparams_field = t.allparams_field;
                    ret.interfaces_field = t.interfaces_field;
                    ret.rank_field = t.rank_field;
                    ret.supertype_field = t.supertype_field;
                    return ret;
                }

                @Override
                public Type visitAnnotatedType(Type.AnnotatedType t, List<Attribute.TypeCompound> s) {
                    return t.unannotatedType().accept(this, s).annotatedType((List<Attribute.TypeCompound>)t.getAnnotationMirrors());
                }

                @Override
                public Type visitWildcardType(Type.WildcardType t, List<Attribute.TypeCompound> s) {
                    return t.annotatedType(s);
                }

                @Override
                public Type visitArrayType(Type.ArrayType t, List<Attribute.TypeCompound> s) {
                    Type.ArrayType ret = new Type.ArrayType(t.elemtype.accept(this, s), t.tsym);
                    return ret;
                }

                @Override
                public Type visitMethodType(Type.MethodType t, List<Attribute.TypeCompound> s) {
                    return t;
                }

                @Override
                public Type visitPackageType(Type.PackageType t, List<Attribute.TypeCompound> s) {
                    return t;
                }

                @Override
                public Type visitTypeVar(Type.TypeVar t, List<Attribute.TypeCompound> s) {
                    return t.annotatedType(s);
                }

                @Override
                public Type visitCapturedType(Type.CapturedType t, List<Attribute.TypeCompound> s) {
                    return t.annotatedType(s);
                }

                @Override
                public Type visitForAll(Type.ForAll t, List<Attribute.TypeCompound> s) {
                    return t;
                }

                @Override
                public Type visitUndetVar(Type.UndetVar t, List<Attribute.TypeCompound> s) {
                    return t;
                }

                @Override
                public Type visitErrorType(Type.ErrorType t, List<Attribute.TypeCompound> s) {
                    return t.annotatedType(s);
                }

                @Override
                public Type visitType(Type t, List<Attribute.TypeCompound> s) {
                    return t.annotatedType(s);
                }
            };
            return type.accept(visitor, annotations);
        }

        private Attribute.TypeCompound toTypeCompound(Attribute.Compound a, TypeAnnotationPosition p) {
            return new Attribute.TypeCompound(a, p);
        }

        /*
         * Unable to fully structure code
         */
        private void resolveFrame(JCTree tree, JCTree frame, List<JCTree> path, TypeAnnotationPosition p) {
            switch (3.$SwitchMap$com$sun$source$tree$Tree$Kind[frame.getKind().ordinal()]) {
                case 1: {
                    frameTC = (JCTree.JCTypeCast)frame;
                    p.type = TargetType.CAST;
                    if (!frameTC.clazz.hasTag(JCTree.Tag.TYPEINTERSECTION)) {
                        p.type_index = 0;
                    }
                    p.pos = frame.pos;
                    return;
                }
                case 2: {
                    p.type = TargetType.INSTANCEOF;
                    p.pos = frame.pos;
                    return;
                }
                case 3: {
                    frameNewClass = (JCTree.JCNewClass)frame;
                    if (frameNewClass.def == null) ** GOTO lbl33
                    frameClassDecl = frameNewClass.def;
                    if (frameClassDecl.extending == null || TreeInfo.symbolFor(frameClassDecl.extending) != TreeInfo.symbolFor(tree)) ** GOTO lbl21
                    p.type = TargetType.CLASS_EXTENDS;
                    p.type_index = -1;
                    ** GOTO lbl38
lbl21:
                    // 1 sources

                    found = false;
                    for (i = 0; i < frameClassDecl.implementing.size(); ++i) {
                        impl = frameClassDecl.implementing.get(i);
                        if (TreeInfo.symbolFor(impl) != TreeInfo.symbolFor(tree)) ** GOTO lbl29
                        p.type = TargetType.CLASS_EXTENDS;
                        p.type_index = i;
                        found = true;
                        ** GOTO lbl38
lbl29:
                        // 1 sources

                        if (found) continue;
                        Assert.error("Could not determine position of tree " + tree + " within frame " + frame);
                    }
                    ** GOTO lbl38
lbl33:
                    // 1 sources

                    if (frameNewClass.typeargs.contains(tree)) {
                        p.type = TargetType.CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT;
                        p.type_index = frameNewClass.typeargs.indexOf(tree);
                    } else {
                        p.type = TargetType.NEW;
                    }
lbl38:
                    // 5 sources

                    p.pos = frame.pos;
                    return;
                }
                case 4: {
                    p.type = TargetType.NEW;
                    p.pos = frame.pos;
                    return;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    p.pos = frame.pos;
                    if (((JCTree.JCClassDecl)frame).extending == tree) {
                        p.type = TargetType.CLASS_EXTENDS;
                        p.type_index = -1;
                    } else if (((JCTree.JCClassDecl)frame).implementing.contains(tree)) {
                        p.type = TargetType.CLASS_EXTENDS;
                        p.type_index = ((JCTree.JCClassDecl)frame).implementing.indexOf(tree);
                    } else if (((JCTree.JCClassDecl)frame).typarams.contains(tree)) {
                        p.type = TargetType.CLASS_TYPE_PARAMETER;
                        p.parameter_index = ((JCTree.JCClassDecl)frame).typarams.indexOf(tree);
                    } else {
                        Assert.error("Could not determine position of tree " + tree + " within frame " + frame);
                    }
                    return;
                }
                case 9: {
                    frameMethod = (JCTree.JCMethodDecl)frame;
                    p.pos = frame.pos;
                    if (frameMethod.thrown.contains(tree)) {
                        p.type = TargetType.THROWS;
                        p.type_index = frameMethod.thrown.indexOf(tree);
                    } else if (frameMethod.restype == tree) {
                        p.type = TargetType.METHOD_RETURN;
                    } else if (frameMethod.typarams.contains(tree)) {
                        p.type = TargetType.METHOD_TYPE_PARAMETER;
                        p.parameter_index = frameMethod.typarams.indexOf(tree);
                    } else {
                        Assert.error("Could not determine position of tree " + tree + " within frame " + frame);
                    }
                    return;
                }
                case 10: {
                    newPath = path.tail;
                    if (((JCTree.JCTypeApply)frame).clazz != tree) {
                        if (((JCTree.JCTypeApply)frame).arguments.contains(tree)) {
                            taframe = (JCTree.JCTypeApply)frame;
                            arg = taframe.arguments.indexOf(tree);
                            p.location = p.location.prepend(new TypeAnnotationPosition.TypePathEntry(TypeAnnotationPosition.TypePathEntryKind.TYPE_ARGUMENT, arg));
                            typeToUse = newPath.tail != null && ((JCTree)newPath.tail.head).hasTag(JCTree.Tag.NEWCLASS) != false ? ((JCTree)newPath.tail.head).type : taframe.type;
                            this.locateNestedTypes(typeToUse, p);
                        } else {
                            Assert.error("Could not determine type argument position of tree " + tree + " within frame " + frame);
                        }
                    }
                    this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, p);
                    return;
                }
                case 11: {
                    mrframe = (JCTree.JCMemberReference)frame;
                    if (mrframe.expr == tree) {
                        switch (3.$SwitchMap$com$sun$source$tree$MemberReferenceTree$ReferenceMode[mrframe.mode.ordinal()]) {
                            case 1: {
                                p.type = TargetType.METHOD_REFERENCE;
                                break;
                            }
                            case 2: {
                                p.type = TargetType.CONSTRUCTOR_REFERENCE;
                                break;
                            }
                            default: {
                                Assert.error("Unknown method reference mode " + (Object)mrframe.mode + " for tree " + tree + " within frame " + frame);
                            }
                        }
                        p.pos = frame.pos;
                    } else if (mrframe.typeargs != null && mrframe.typeargs.contains(tree)) {
                        p.type_index = arg = mrframe.typeargs.indexOf(tree);
                        switch (3.$SwitchMap$com$sun$source$tree$MemberReferenceTree$ReferenceMode[mrframe.mode.ordinal()]) {
                            case 1: {
                                p.type = TargetType.METHOD_REFERENCE_TYPE_ARGUMENT;
                                break;
                            }
                            case 2: {
                                p.type = TargetType.CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT;
                                break;
                            }
                            default: {
                                Assert.error("Unknown method reference mode " + (Object)mrframe.mode + " for tree " + tree + " within frame " + frame);
                            }
                        }
                        p.pos = frame.pos;
                    } else {
                        Assert.error("Could not determine type argument position of tree " + tree + " within frame " + frame);
                    }
                    return;
                }
                case 12: {
                    index = new ListBuffer<TypeAnnotationPosition.TypePathEntry>();
                    index = index.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
                    newPath = path.tail;
                    while (true) {
                        if ((npHead = (JCTree)newPath.tail.head).hasTag(JCTree.Tag.TYPEARRAY)) {
                            newPath = newPath.tail;
                            index = index.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
                            continue;
                        }
                        if (!npHead.hasTag(JCTree.Tag.ANNOTATED_TYPE)) break;
                        newPath = newPath.tail;
                    }
                    p.location = p.location.prependList(index.toList());
                    this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, p);
                    return;
                }
                case 13: {
                    if (((JCTree)path.tail.tail.head).hasTag(JCTree.Tag.CLASSDEF)) {
                        clazz = (JCTree.JCClassDecl)path.tail.tail.head;
                        p.type = TargetType.CLASS_TYPE_PARAMETER_BOUND;
                        p.parameter_index = clazz.typarams.indexOf(path.tail.head);
                        p.bound_index = ((JCTree.JCTypeParameter)frame).bounds.indexOf(tree);
                        if (((JCTree.JCTypeParameter)frame).bounds.get((int)0).type.isInterface()) {
                            ++p.bound_index;
                        }
                    } else if (((JCTree)path.tail.tail.head).hasTag(JCTree.Tag.METHODDEF)) {
                        method = (JCTree.JCMethodDecl)path.tail.tail.head;
                        p.type = TargetType.METHOD_TYPE_PARAMETER_BOUND;
                        p.parameter_index = method.typarams.indexOf(path.tail.head);
                        p.bound_index = ((JCTree.JCTypeParameter)frame).bounds.indexOf(tree);
                        if (((JCTree.JCTypeParameter)frame).bounds.get((int)0).type.isInterface()) {
                            ++p.bound_index;
                        }
                    } else {
                        Assert.error("Could not determine position of tree " + tree + " within frame " + frame);
                    }
                    p.pos = frame.pos;
                    return;
                }
                case 14: {
                    v = ((JCTree.JCVariableDecl)frame).sym;
                    p.pos = frame.pos;
                    switch (3.$SwitchMap$javax$lang$model$element$ElementKind[v.getKind().ordinal()]) {
                        case 1: {
                            p.type = TargetType.LOCAL_VARIABLE;
                            break;
                        }
                        case 2: {
                            p.type = TargetType.FIELD;
                            break;
                        }
                        case 3: {
                            if (v.getQualifiedName().equals(TypeAnnotations.this.names._this)) {
                                p.type = TargetType.METHOD_RECEIVER;
                                break;
                            }
                            p.type = TargetType.METHOD_FORMAL_PARAMETER;
                            p.parameter_index = this.methodParamIndex(path, frame);
                            break;
                        }
                        case 4: {
                            p.type = TargetType.EXCEPTION_PARAMETER;
                            break;
                        }
                        case 5: {
                            p.type = TargetType.RESOURCE_VARIABLE;
                            break;
                        }
                        default: {
                            Assert.error("Found unexpected type annotation for variable: " + v + " with kind: " + (Object)v.getKind());
                        }
                    }
                    if (v.getKind() != ElementKind.FIELD) {
                        v.owner.appendUniqueTypeAttributes(v.getRawTypeAttributes());
                    }
                    return;
                }
                case 15: {
                    if (frame == tree) {
                        atypetree = (JCTree.JCAnnotatedType)frame;
                        utype = atypetree.underlyingType.type;
                        if (utype == null) {
                            return;
                        }
                        tsym = utype.tsym;
                        if (!(tsym.getKind().equals((Object)ElementKind.TYPE_PARAMETER) || utype.getKind().equals((Object)TypeKind.WILDCARD) || utype.getKind().equals((Object)TypeKind.ARRAY))) {
                            this.locateNestedTypes(utype, p);
                        }
                    }
                    newPath = path.tail;
                    this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, p);
                    return;
                }
                case 16: {
                    newPath = path.tail;
                    this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, p);
                    return;
                }
                case 17: {
                    isect = (JCTree.JCTypeIntersection)frame;
                    p.type_index = isect.bounds.indexOf(tree);
                    newPath = path.tail;
                    this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, p);
                    return;
                }
                case 18: {
                    invocation = (JCTree.JCMethodInvocation)frame;
                    if (!invocation.typeargs.contains(tree)) {
                        Assert.error("{" + tree + "} is not an argument in the invocation: " + invocation);
                    }
                    if ((exsym = (Symbol.MethodSymbol)TreeInfo.symbol(invocation.getMethodSelect())) == null) {
                        Assert.error("could not determine symbol for {" + invocation + "}");
                    } else {
                        p.type = exsym.isConstructor() != false ? TargetType.CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT : TargetType.METHOD_INVOCATION_TYPE_ARGUMENT;
                    }
                    p.pos = invocation.pos;
                    p.type_index = invocation.typeargs.indexOf(tree);
                    return;
                }
                case 19: 
                case 20: {
                    p.location = p.location.prepend(TypeAnnotationPosition.TypePathEntry.WILDCARD);
                    newPath = path.tail;
                    this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, p);
                    return;
                }
                case 21: {
                    newPath = path.tail;
                    this.resolveFrame((JCTree)newPath.head, (JCTree)newPath.tail.head, newPath, p);
                    return;
                }
            }
            Assert.error("Unresolved frame: " + frame + " of kind: " + (Object)frame.getKind() + "\n    Looking for tree: " + tree);
        }

        private void locateNestedTypes(Type type, TypeAnnotationPosition p) {
            ListBuffer<TypeAnnotationPosition.TypePathEntry> depth = new ListBuffer<TypeAnnotationPosition.TypePathEntry>();
            for (Type encl = type.getEnclosingType(); encl != null && encl.getKind() != TypeKind.NONE && encl.getKind() != TypeKind.ERROR; encl = encl.getEnclosingType()) {
                depth = depth.append(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
            }
            if (depth.nonEmpty()) {
                p.location = p.location.prependList(depth.toList());
            }
        }

        private int methodParamIndex(List<JCTree> path, JCTree param) {
            List<JCTree> curr = path;
            while (((JCTree)curr.head).getTag() != JCTree.Tag.METHODDEF && ((JCTree)curr.head).getTag() != JCTree.Tag.LAMBDA) {
                curr = curr.tail;
            }
            if (((JCTree)curr.head).getTag() == JCTree.Tag.METHODDEF) {
                JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)curr.head;
                return method.params.indexOf(param);
            }
            if (((JCTree)curr.head).getTag() == JCTree.Tag.LAMBDA) {
                JCTree.JCLambda lambda = (JCTree.JCLambda)curr.head;
                return lambda.params.indexOf(param);
            }
            Assert.error("methodParamIndex expected to find method or lambda for param: " + param);
            return -1;
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (this.isInClass) {
                return;
            }
            this.isInClass = true;
            if (this.sigOnly) {
                this.scan(tree.mods);
                this.scan(tree.typarams);
                this.scan(tree.extending);
                this.scan(tree.implementing);
            }
            this.scan(tree.defs);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            if (tree.sym == null || tree.sym.type == null) {
                return;
            }
            if (this.sigOnly) {
                TypeAnnotationPosition pos;
                if (!tree.mods.annotations.isEmpty()) {
                    pos = new TypeAnnotationPosition();
                    pos.type = TargetType.METHOD_RETURN;
                    if (tree.sym.isConstructor()) {
                        pos.pos = tree.pos;
                        this.separateAnnotationsKinds(tree, null, tree.sym, pos);
                    } else {
                        pos.pos = tree.restype != null ? tree.restype.pos : tree.pos;
                        this.separateAnnotationsKinds(tree.restype, tree.sym.type.getReturnType(), tree.sym, pos);
                    }
                }
                if (tree.recvparam != null && tree.recvparam.sym != null && !tree.recvparam.mods.annotations.isEmpty()) {
                    pos = new TypeAnnotationPosition();
                    pos.type = TargetType.METHOD_RECEIVER;
                    pos.pos = tree.recvparam.vartype.pos;
                    this.separateAnnotationsKinds(tree.recvparam.vartype, tree.recvparam.sym.type, tree.recvparam.sym, pos);
                }
                int i = 0;
                for (JCTree.JCVariableDecl param : tree.params) {
                    if (!param.mods.annotations.isEmpty()) {
                        TypeAnnotationPosition pos2 = new TypeAnnotationPosition();
                        pos2.type = TargetType.METHOD_FORMAL_PARAMETER;
                        pos2.parameter_index = i;
                        pos2.pos = param.vartype.pos;
                        this.separateAnnotationsKinds(param.vartype, param.sym.type, param.sym, pos2);
                    }
                    ++i;
                }
            }
            this.push(tree);
            if (this.sigOnly) {
                this.scan(tree.mods);
                this.scan(tree.restype);
                this.scan(tree.typarams);
                this.scan(tree.recvparam);
                this.scan(tree.params);
                this.scan(tree.thrown);
            } else {
                this.scan(tree.defaultValue);
                this.scan(tree.body);
            }
            this.pop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            JCTree.JCLambda prevLambda = this.currentLambda;
            try {
                this.currentLambda = tree;
                int i = 0;
                for (JCTree.JCVariableDecl param : tree.params) {
                    if (!param.mods.annotations.isEmpty()) {
                        TypeAnnotationPosition pos = new TypeAnnotationPosition();
                        pos.type = TargetType.METHOD_FORMAL_PARAMETER;
                        pos.parameter_index = i;
                        pos.pos = param.vartype.pos;
                        pos.onLambda = tree;
                        this.separateAnnotationsKinds(param.vartype, param.sym.type, param.sym, pos);
                    }
                    ++i;
                }
                this.push(tree);
                this.scan(tree.body);
                this.scan(tree.params);
                this.pop();
            }
            finally {
                this.currentLambda = prevLambda;
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            if (!tree.mods.annotations.isEmpty()) {
                if (tree.sym == null) {
                    Assert.error("Visiting tree node before memberEnter");
                } else if (tree.sym.getKind() != ElementKind.PARAMETER) {
                    if (tree.sym.getKind() == ElementKind.FIELD) {
                        if (this.sigOnly) {
                            TypeAnnotationPosition pos = new TypeAnnotationPosition();
                            pos.type = TargetType.FIELD;
                            pos.pos = tree.pos;
                            this.separateAnnotationsKinds(tree.vartype, tree.sym.type, tree.sym, pos);
                        }
                    } else if (tree.sym.getKind() == ElementKind.LOCAL_VARIABLE) {
                        TypeAnnotationPosition pos = new TypeAnnotationPosition();
                        pos.type = TargetType.LOCAL_VARIABLE;
                        pos.pos = tree.pos;
                        pos.onLambda = this.currentLambda;
                        this.separateAnnotationsKinds(tree.vartype, tree.sym.type, tree.sym, pos);
                    } else if (tree.sym.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                        TypeAnnotationPosition pos = new TypeAnnotationPosition();
                        pos.type = TargetType.EXCEPTION_PARAMETER;
                        pos.pos = tree.pos;
                        pos.onLambda = this.currentLambda;
                        this.separateAnnotationsKinds(tree.vartype, tree.sym.type, tree.sym, pos);
                    } else if (tree.sym.getKind() == ElementKind.RESOURCE_VARIABLE) {
                        TypeAnnotationPosition pos = new TypeAnnotationPosition();
                        pos.type = TargetType.RESOURCE_VARIABLE;
                        pos.pos = tree.pos;
                        pos.onLambda = this.currentLambda;
                        this.separateAnnotationsKinds(tree.vartype, tree.sym.type, tree.sym, pos);
                    } else if (tree.sym.getKind() != ElementKind.ENUM_CONSTANT) {
                        Assert.error("Unhandled variable kind: " + tree + " of kind: " + (Object)((Object)tree.sym.getKind()));
                    }
                }
            }
            this.push(tree);
            this.scan(tree.mods);
            this.scan(tree.vartype);
            if (!this.sigOnly) {
                this.scan(tree.init);
            }
            this.pop();
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            if (!this.sigOnly) {
                this.scan(tree.stats);
            }
        }

        @Override
        public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
            this.push(tree);
            this.findPosition(tree, tree, tree.annotations);
            this.pop();
            super.visitAnnotatedType(tree);
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter tree) {
            this.findPosition(tree, this.peek2(), tree.annotations);
            super.visitTypeParameter(tree);
        }

        private void copyNewClassAnnotationsToOwner(JCTree.JCNewClass tree) {
            Symbol.ClassSymbol sym = tree.def.sym;
            TypeAnnotationPosition pos = new TypeAnnotationPosition();
            ListBuffer<Attribute.TypeCompound> newattrs = new ListBuffer<Attribute.TypeCompound>();
            for (Attribute.TypeCompound old : ((Symbol)sym).getRawTypeAttributes()) {
                newattrs.append(new Attribute.TypeCompound(old.type, old.values, pos));
            }
            pos.type = TargetType.NEW;
            pos.pos = tree.pos;
            sym.owner.appendUniqueTypeAttributes(newattrs.toList());
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass tree) {
            if (tree.def != null && !tree.def.mods.annotations.isEmpty()) {
                JCTree.JCClassDecl classdecl = tree.def;
                TypeAnnotationPosition pos = new TypeAnnotationPosition();
                pos.type = TargetType.CLASS_EXTENDS;
                pos.pos = tree.pos;
                if (classdecl.extending != null && TreeInfo.symbolFor(classdecl.extending) == TreeInfo.symbolFor(tree.clazz)) {
                    pos.type_index = -1;
                } else {
                    boolean found = false;
                    for (int i = 0; i < classdecl.implementing.size(); ++i) {
                        JCTree.JCExpression impl = classdecl.implementing.get(i);
                        if (TreeInfo.symbolFor(impl) == TreeInfo.symbolFor(tree.clazz)) {
                            pos.type_index = i;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        Assert.error("Could not determine position of tree " + tree);
                    }
                }
                Type before = classdecl.sym.type;
                this.separateAnnotationsKinds(classdecl, tree.clazz.type, classdecl.sym, pos);
                this.copyNewClassAnnotationsToOwner(tree);
                classdecl.sym.type = before;
            }
            this.scan(tree.encl);
            this.scan(tree.typeargs);
            this.scan(tree.clazz);
            this.scan(tree.args);
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray tree) {
            this.findPosition(tree, tree, tree.annotations);
            int dimAnnosCount = tree.dimAnnotations.size();
            ListBuffer<Object> depth = new ListBuffer<TypeAnnotationPosition.TypePathEntry>();
            for (int i = 0; i < dimAnnosCount; ++i) {
                TypeAnnotationPosition p = new TypeAnnotationPosition();
                p.pos = tree.pos;
                p.onLambda = this.currentLambda;
                p.type = TargetType.NEW;
                if (i != 0) {
                    depth = depth.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
                    p.location = p.location.appendList(depth.toList());
                }
                this.setTypeAnnotationPos(tree.dimAnnotations.get(i), p);
            }
            JCTree.JCExpression elemType = tree.elemtype;
            depth = depth.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
            while (elemType != null) {
                if (elemType.hasTag(JCTree.Tag.ANNOTATED_TYPE)) {
                    JCTree.JCAnnotatedType at = (JCTree.JCAnnotatedType)elemType;
                    TypeAnnotationPosition p = new TypeAnnotationPosition();
                    p.type = TargetType.NEW;
                    p.pos = tree.pos;
                    p.onLambda = this.currentLambda;
                    this.locateNestedTypes(elemType.type, p);
                    p.location = p.location.prependList(depth.toList());
                    this.setTypeAnnotationPos(at.annotations, p);
                    elemType = at.underlyingType;
                    continue;
                }
                if (elemType.hasTag(JCTree.Tag.TYPEARRAY)) {
                    depth = depth.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
                    elemType = ((JCTree.JCArrayTypeTree)elemType).elemtype;
                    continue;
                }
                if (!elemType.hasTag(JCTree.Tag.SELECT)) break;
                elemType = ((JCTree.JCFieldAccess)elemType).selected;
            }
            this.scan(tree.elems);
        }

        private void findPosition(JCTree tree, JCTree frame, List<JCTree.JCAnnotation> annotations) {
            if (!annotations.isEmpty()) {
                TypeAnnotationPosition p = new TypeAnnotationPosition();
                p.onLambda = this.currentLambda;
                this.resolveFrame(tree, frame, this.frames.toList(), p);
                this.setTypeAnnotationPos(annotations, p);
            }
        }

        private void setTypeAnnotationPos(List<JCTree.JCAnnotation> annotations, TypeAnnotationPosition position) {
            for (JCTree.JCAnnotation anno : annotations) {
                if (anno.attribute == null) continue;
                ((Attribute.TypeCompound)anno.attribute).position = position;
            }
        }

        public String toString() {
            return super.toString() + ": sigOnly: " + this.sigOnly;
        }
    }

    public static enum AnnotationType {
        DECLARATION,
        TYPE,
        BOTH;

    }
}

