/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.util.List;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class ZipFileIndex {
    private static final String MIN_CHAR = String.valueOf('\u0000');
    private static final String MAX_CHAR = String.valueOf('\uffff');
    public static final long NOT_MODIFIED = Long.MIN_VALUE;
    private static final boolean NON_BATCH_MODE = System.getProperty("nonBatchMode") != null;
    private Map<RelativePath.RelativeDirectory, DirectoryEntry> directories = Collections.emptyMap();
    private Set<RelativePath.RelativeDirectory> allDirs = Collections.emptySet();
    final File zipFile;
    private Reference<File> absFileRef;
    long zipFileLastModified = Long.MIN_VALUE;
    private RandomAccessFile zipRandomFile;
    private Entry[] entries;
    private boolean readFromIndex = false;
    private File zipIndexFile = null;
    private boolean triedToReadIndex = false;
    final RelativePath.RelativeDirectory symbolFilePrefix;
    private final int symbolFilePrefixLength;
    private boolean hasPopulatedData = false;
    long lastReferenceTimeStamp = Long.MIN_VALUE;
    private final boolean usePreindexedCache;
    private final String preindexedCacheLocation;
    private boolean writeIndex = false;
    private Map<String, SoftReference<RelativePath.RelativeDirectory>> relativeDirectoryCache = new HashMap<String, SoftReference<RelativePath.RelativeDirectory>>();
    private SoftReference<Inflater> inflaterRef;

    public synchronized boolean isOpen() {
        return this.zipRandomFile != null;
    }

    ZipFileIndex(File zipFile, RelativePath.RelativeDirectory symbolFilePrefix, boolean writeIndex, boolean useCache, String cacheLocation) throws IOException {
        this.zipFile = zipFile;
        this.symbolFilePrefix = symbolFilePrefix;
        this.symbolFilePrefixLength = symbolFilePrefix == null ? 0 : symbolFilePrefix.getPath().getBytes("UTF-8").length;
        this.writeIndex = writeIndex;
        this.usePreindexedCache = useCache;
        this.preindexedCacheLocation = cacheLocation;
        if (zipFile != null) {
            this.zipFileLastModified = zipFile.lastModified();
        }
        this.checkIndex();
    }

    public String toString() {
        return "ZipFileIndex[" + this.zipFile + "]";
    }

    protected void finalize() throws Throwable {
        this.closeFile();
        super.finalize();
    }

    private boolean isUpToDate() {
        return this.zipFile != null && (!NON_BATCH_MODE || this.zipFileLastModified == this.zipFile.lastModified()) && this.hasPopulatedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIndex() throws IOException {
        boolean isUpToDate = true;
        if (!this.isUpToDate()) {
            this.closeFile();
            isUpToDate = false;
        }
        if (this.zipRandomFile != null || isUpToDate) {
            this.lastReferenceTimeStamp = System.currentTimeMillis();
            return;
        }
        this.hasPopulatedData = true;
        if (this.readIndex()) {
            this.lastReferenceTimeStamp = System.currentTimeMillis();
            return;
        }
        this.directories = Collections.emptyMap();
        this.allDirs = Collections.emptySet();
        try {
            this.openFile();
            long totalLength = this.zipRandomFile.length();
            ZipDirectory directory = new ZipDirectory(this.zipRandomFile, 0L, totalLength, this);
            directory.buildIndex();
        }
        finally {
            if (this.zipRandomFile != null) {
                this.closeFile();
            }
        }
        this.lastReferenceTimeStamp = System.currentTimeMillis();
    }

    private void openFile() throws FileNotFoundException {
        if (this.zipRandomFile == null && this.zipFile != null) {
            this.zipRandomFile = new RandomAccessFile(this.zipFile, "r");
        }
    }

    private void cleanupState() {
        this.entries = Entry.EMPTY_ARRAY;
        this.directories = Collections.emptyMap();
        this.zipFileLastModified = Long.MIN_VALUE;
        this.allDirs = Collections.emptySet();
    }

    public synchronized void close() {
        this.writeIndex();
        this.closeFile();
    }

    private void closeFile() {
        if (this.zipRandomFile != null) {
            try {
                this.zipRandomFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.zipRandomFile = null;
        }
    }

    synchronized Entry getZipIndexEntry(RelativePath path) {
        try {
            this.checkIndex();
            DirectoryEntry de = this.directories.get(path.dirname());
            String lookFor = path.basename();
            return de == null ? null : de.getEntry(lookFor);
        }
        catch (IOException e) {
            return null;
        }
    }

    public synchronized List<String> getFiles(RelativePath.RelativeDirectory path) {
        try {
            List ret;
            this.checkIndex();
            DirectoryEntry de = this.directories.get(path);
            List list = ret = de == null ? null : de.getFiles();
            if (ret == null) {
                return List.nil();
            }
            return ret;
        }
        catch (IOException e) {
            return List.nil();
        }
    }

    public synchronized java.util.List<String> getDirectories(RelativePath.RelativeDirectory path) {
        try {
            List ret;
            this.checkIndex();
            DirectoryEntry de = this.directories.get(path);
            List list = ret = de == null ? null : de.getDirectories();
            if (ret == null) {
                return List.nil();
            }
            return ret;
        }
        catch (IOException e) {
            return List.nil();
        }
    }

    public synchronized Set<RelativePath.RelativeDirectory> getAllDirectories() {
        try {
            this.checkIndex();
            if (this.allDirs == Collections.EMPTY_SET) {
                this.allDirs = new LinkedHashSet<RelativePath.RelativeDirectory>(this.directories.keySet());
            }
            return this.allDirs;
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
    }

    public synchronized boolean contains(RelativePath path) {
        try {
            this.checkIndex();
            return this.getZipIndexEntry(path) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean isDirectory(RelativePath path) throws IOException {
        if (path.getPath().length() == 0) {
            this.lastReferenceTimeStamp = System.currentTimeMillis();
            return true;
        }
        this.checkIndex();
        return this.directories.get(path) != null;
    }

    public synchronized long getLastModified(RelativePath.RelativeFile path) throws IOException {
        Entry entry = this.getZipIndexEntry(path);
        if (entry == null) {
            throw new FileNotFoundException();
        }
        return entry.getLastModified();
    }

    public synchronized int length(RelativePath.RelativeFile path) throws IOException {
        Entry entry = this.getZipIndexEntry(path);
        if (entry == null) {
            throw new FileNotFoundException();
        }
        if (entry.isDir) {
            return 0;
        }
        byte[] header = this.getHeader(entry);
        if (ZipFileIndex.get2ByteLittleEndian(header, 8) == 0) {
            return entry.compressedSize;
        }
        return entry.size;
    }

    public synchronized byte[] read(RelativePath.RelativeFile path) throws IOException {
        Entry entry = this.getZipIndexEntry(path);
        if (entry == null) {
            throw new FileNotFoundException("Path not found in ZIP: " + path.path);
        }
        return this.read(entry);
    }

    synchronized byte[] read(Entry entry) throws IOException {
        this.openFile();
        byte[] result = this.readBytes(entry);
        this.closeFile();
        return result;
    }

    public synchronized int read(RelativePath.RelativeFile path, byte[] buffer) throws IOException {
        Entry entry = this.getZipIndexEntry(path);
        if (entry == null) {
            throw new FileNotFoundException();
        }
        return this.read(entry, buffer);
    }

    synchronized int read(Entry entry, byte[] buffer) throws IOException {
        int result = this.readBytes(entry, buffer);
        return result;
    }

    private byte[] readBytes(Entry entry) throws IOException {
        byte[] header = this.getHeader(entry);
        int csize = entry.compressedSize;
        byte[] cbuf = new byte[csize];
        this.zipRandomFile.skipBytes(ZipFileIndex.get2ByteLittleEndian(header, 26) + ZipFileIndex.get2ByteLittleEndian(header, 28));
        this.zipRandomFile.readFully(cbuf, 0, csize);
        if (ZipFileIndex.get2ByteLittleEndian(header, 8) == 0) {
            return cbuf;
        }
        int size = entry.size;
        byte[] buf = new byte[size];
        if (this.inflate(cbuf, buf) != size) {
            throw new ZipException("corrupted zip file");
        }
        return buf;
    }

    private int readBytes(Entry entry, byte[] buffer) throws IOException {
        byte[] header = this.getHeader(entry);
        if (ZipFileIndex.get2ByteLittleEndian(header, 8) == 0) {
            int count;
            this.zipRandomFile.skipBytes(ZipFileIndex.get2ByteLittleEndian(header, 26) + ZipFileIndex.get2ByteLittleEndian(header, 28));
            int size = buffer.length;
            for (int offset = 0; offset < size && (count = this.zipRandomFile.read(buffer, offset, size - offset)) != -1; offset += count) {
            }
            return entry.size;
        }
        int csize = entry.compressedSize;
        byte[] cbuf = new byte[csize];
        this.zipRandomFile.skipBytes(ZipFileIndex.get2ByteLittleEndian(header, 26) + ZipFileIndex.get2ByteLittleEndian(header, 28));
        this.zipRandomFile.readFully(cbuf, 0, csize);
        int count = this.inflate(cbuf, buffer);
        if (count == -1) {
            throw new ZipException("corrupted zip file");
        }
        return entry.size;
    }

    private byte[] getHeader(Entry entry) throws IOException {
        this.zipRandomFile.seek(entry.offset);
        byte[] header = new byte[30];
        this.zipRandomFile.readFully(header);
        if (ZipFileIndex.get4ByteLittleEndian(header, 0) != 67324752) {
            throw new ZipException("corrupted zip file");
        }
        if ((ZipFileIndex.get2ByteLittleEndian(header, 6) & 1) != 0) {
            throw new ZipException("encrypted zip file");
        }
        return header;
    }

    private int inflate(byte[] src, byte[] dest) {
        Inflater inflater;
        Inflater inflater2 = inflater = this.inflaterRef == null ? null : this.inflaterRef.get();
        if (inflater == null) {
            inflater = new Inflater(true);
            this.inflaterRef = new SoftReference<Inflater>(inflater);
        }
        inflater.reset();
        inflater.setInput(src);
        try {
            return inflater.inflate(dest);
        }
        catch (DataFormatException ex) {
            return -1;
        }
    }

    private static int get2ByteLittleEndian(byte[] buf, int pos) {
        return (buf[pos] & 0xFF) + ((buf[pos + 1] & 0xFF) << 8);
    }

    private static int get4ByteLittleEndian(byte[] buf, int pos) {
        return (buf[pos] & 0xFF) + ((buf[pos + 1] & 0xFF) << 8) + ((buf[pos + 2] & 0xFF) << 16) + ((buf[pos + 3] & 0xFF) << 24);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getZipFileLastModified() throws IOException {
        ZipFileIndex zipFileIndex = this;
        synchronized (zipFileIndex) {
            this.checkIndex();
            return this.zipFileLastModified;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readIndex() {
        if (this.triedToReadIndex || !this.usePreindexedCache) {
            return false;
        }
        boolean ret = false;
        ZipFileIndex zipFileIndex = this;
        synchronized (zipFileIndex) {
            this.triedToReadIndex = true;
            RandomAccessFile raf = null;
            try {
                File indexFileName = this.getIndexFile();
                raf = new RandomAccessFile(indexFileName, "r");
                long fileStamp = raf.readLong();
                if (this.zipFile.lastModified() != fileStamp) {
                    ret = false;
                } else {
                    this.directories = new LinkedHashMap<RelativePath.RelativeDirectory, DirectoryEntry>();
                    int numDirs = raf.readInt();
                    for (int nDirs = 0; nDirs < numDirs; ++nDirs) {
                        int dirNameBytesLen = raf.readInt();
                        byte[] dirNameBytes = new byte[dirNameBytesLen];
                        raf.read(dirNameBytes);
                        RelativePath.RelativeDirectory dirNameStr = this.getRelativeDirectory(new String(dirNameBytes, "UTF-8"));
                        DirectoryEntry de = new DirectoryEntry(dirNameStr, this);
                        de.numEntries = raf.readInt();
                        de.writtenOffsetOffset = raf.readLong();
                        this.directories.put(dirNameStr, de);
                    }
                    ret = true;
                    this.zipFileLastModified = fileStamp;
                }
            }
            catch (Throwable t) {
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (Throwable tt) {}
                }
            }
            if (ret) {
                this.readFromIndex = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeIndex() {
        boolean ret = false;
        if (this.readFromIndex || !this.usePreindexedCache) {
            return true;
        }
        if (!this.writeIndex) {
            return true;
        }
        File indexFile = this.getIndexFile();
        if (indexFile == null) {
            return false;
        }
        RandomAccessFile raf = null;
        long writtenSoFar = 0L;
        try {
            raf = new RandomAccessFile(indexFile, "rw");
            raf.writeLong(this.zipFileLastModified);
            writtenSoFar += 8L;
            ArrayList<DirectoryEntry> directoriesToWrite = new ArrayList<DirectoryEntry>();
            HashMap<RelativePath.RelativeDirectory, Long> offsets = new HashMap<RelativePath.RelativeDirectory, Long>();
            raf.writeInt(this.directories.keySet().size());
            writtenSoFar += 4L;
            for (RelativePath.RelativeDirectory dirName : this.directories.keySet()) {
                DirectoryEntry dirEntry = this.directories.get(dirName);
                directoriesToWrite.add(dirEntry);
                byte[] dirNameBytes = dirName.getPath().getBytes("UTF-8");
                int dirNameBytesLen = dirNameBytes.length;
                raf.writeInt(dirNameBytesLen);
                writtenSoFar += 4L;
                raf.write(dirNameBytes);
                writtenSoFar += (long)dirNameBytesLen;
                java.util.List<Entry> dirEntries = dirEntry.getEntriesAsCollection();
                raf.writeInt(dirEntries.size());
                offsets.put(dirName, new Long(writtenSoFar += 4L));
                dirEntry.writtenOffsetOffset = 0L;
                raf.writeLong(0L);
                writtenSoFar += 8L;
            }
            for (DirectoryEntry de : directoriesToWrite) {
                long currFP = raf.getFilePointer();
                long offsetOffset = (Long)offsets.get(de.dirName);
                raf.seek(offsetOffset);
                raf.writeLong(writtenSoFar);
                raf.seek(currFP);
                java.util.List<Entry> list = de.getEntriesAsCollection();
                for (Entry zfie : list) {
                    byte[] zfieNameBytes = zfie.name.getBytes("UTF-8");
                    int zfieNameBytesLen = zfieNameBytes.length;
                    raf.writeInt(zfieNameBytesLen);
                    writtenSoFar += 4L;
                    raf.write(zfieNameBytes);
                    writtenSoFar += (long)zfieNameBytesLen;
                    raf.writeByte(zfie.isDir ? 1 : 0);
                    ++writtenSoFar;
                    raf.writeInt(zfie.offset);
                    writtenSoFar += 4L;
                    raf.writeInt(zfie.size);
                    writtenSoFar += 4L;
                    raf.writeInt(zfie.compressedSize);
                    writtenSoFar += 4L;
                    raf.writeLong(zfie.getLastModified());
                    writtenSoFar += 8L;
                }
            }
        }
        catch (Throwable t) {
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException ioe) {}
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeZipIndex() {
        ZipFileIndex zipFileIndex = this;
        synchronized (zipFileIndex) {
            return this.writeIndex();
        }
    }

    private File getIndexFile() {
        if (this.zipIndexFile == null) {
            if (this.zipFile == null) {
                return null;
            }
            this.zipIndexFile = new File((this.preindexedCacheLocation == null ? "" : this.preindexedCacheLocation) + this.zipFile.getName() + ".index");
        }
        return this.zipIndexFile;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    File getAbsoluteFile() {
        File absFile;
        File file = absFile = this.absFileRef == null ? null : this.absFileRef.get();
        if (absFile == null) {
            absFile = this.zipFile.getAbsoluteFile();
            this.absFileRef = new SoftReference<File>(absFile);
        }
        return absFile;
    }

    private RelativePath.RelativeDirectory getRelativeDirectory(String path) {
        RelativePath.RelativeDirectory rd;
        SoftReference<RelativePath.RelativeDirectory> ref = this.relativeDirectoryCache.get(path);
        if (ref != null && (rd = ref.get()) != null) {
            return rd;
        }
        rd = new RelativePath.RelativeDirectory(path);
        this.relativeDirectoryCache.put(path, new SoftReference<RelativePath.RelativeDirectory>(rd));
        return rd;
    }

    static /* synthetic */ Entry[] access$802(ZipFileIndex x0, Entry[] x1) {
        x0.entries = x1;
        return x1;
    }

    static final class ZipFormatException
    extends IOException {
        private static final long serialVersionUID = 8000196834066748623L;

        protected ZipFormatException(String message) {
            super(message);
        }

        protected ZipFormatException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    static class Entry
    implements Comparable<Entry> {
        public static final Entry[] EMPTY_ARRAY = new Entry[0];
        RelativePath.RelativeDirectory dir;
        boolean isDir;
        String name;
        int offset;
        int size;
        int compressedSize;
        long javatime;
        private int nativetime;

        public Entry(RelativePath path) {
            this(path.dirname(), path.basename());
        }

        public Entry(RelativePath.RelativeDirectory directory, String name) {
            this.dir = directory;
            this.name = name;
        }

        public String getName() {
            return new RelativePath.RelativeFile(this.dir, this.name).getPath();
        }

        public String getFileName() {
            return this.name;
        }

        public long getLastModified() {
            if (this.javatime == 0L) {
                this.javatime = Entry.dosToJavaTime(this.nativetime);
            }
            return this.javatime;
        }

        private static long dosToJavaTime(int dtime) {
            Calendar c = Calendar.getInstance();
            c.set(1, (dtime >> 25 & 0x7F) + 1980);
            c.set(2, (dtime >> 21 & 0xF) - 1);
            c.set(5, dtime >> 16 & 0x1F);
            c.set(11, dtime >> 11 & 0x1F);
            c.set(12, dtime >> 5 & 0x3F);
            c.set(13, dtime << 1 & 0x3E);
            c.set(14, 0);
            return c.getTimeInMillis();
        }

        void setNativeTime(int natTime) {
            this.nativetime = natTime;
        }

        public boolean isDirectory() {
            return this.isDir;
        }

        @Override
        public int compareTo(Entry other) {
            int c;
            RelativePath.RelativeDirectory otherD = other.dir;
            if (this.dir != otherD && (c = this.dir.compareTo(otherD)) != 0) {
                return c;
            }
            return this.name.compareTo(other.name);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            return this.dir.equals(other.dir) && this.name.equals(other.name);
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + (this.dir != null ? this.dir.hashCode() : 0);
            hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return this.isDir ? "Dir:" + this.dir + " : " + this.name : this.dir + ":" + this.name;
        }
    }

    static class DirectoryEntry {
        private boolean filesInited = false;
        private boolean directoriesInited = false;
        private boolean zipFileEntriesInited;
        private boolean entriesInited = false;
        private long writtenOffsetOffset = 0L;
        private RelativePath.RelativeDirectory dirName;
        private List<String> zipFileEntriesFiles = List.nil();
        private List<String> zipFileEntriesDirectories = List.nil();
        private List<Entry> zipFileEntries = List.nil();
        private java.util.List<Entry> entries = new ArrayList<Entry>();
        private ZipFileIndex zipFileIndex;
        private int numEntries;

        DirectoryEntry(RelativePath.RelativeDirectory dirName, ZipFileIndex index) {
            this.dirName = dirName;
            this.zipFileIndex = index;
        }

        private List<String> getFiles() {
            if (!this.filesInited) {
                this.initEntries();
                for (Entry e : this.entries) {
                    if (e.isDir) continue;
                    this.zipFileEntriesFiles = this.zipFileEntriesFiles.append(e.name);
                }
                this.filesInited = true;
            }
            return this.zipFileEntriesFiles;
        }

        private List<String> getDirectories() {
            if (!this.directoriesInited) {
                this.initEntries();
                for (Entry e : this.entries) {
                    if (!e.isDir) continue;
                    this.zipFileEntriesDirectories = this.zipFileEntriesDirectories.append(e.name);
                }
                this.directoriesInited = true;
            }
            return this.zipFileEntriesDirectories;
        }

        private List<Entry> getEntries() {
            if (!this.zipFileEntriesInited) {
                this.initEntries();
                this.zipFileEntries = List.nil();
                for (Entry zfie : this.entries) {
                    this.zipFileEntries = this.zipFileEntries.append(zfie);
                }
                this.zipFileEntriesInited = true;
            }
            return this.zipFileEntries;
        }

        private Entry getEntry(String rootName) {
            this.initEntries();
            int index = Collections.binarySearch(this.entries, new Entry(this.dirName, rootName));
            if (index < 0) {
                return null;
            }
            return this.entries.get(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initEntries() {
            if (this.entriesInited) {
                return;
            }
            if (!this.zipFileIndex.readFromIndex) {
                int from = -Arrays.binarySearch(this.zipFileIndex.entries, new Entry(this.dirName, MIN_CHAR)) - 1;
                int to = -Arrays.binarySearch(this.zipFileIndex.entries, new Entry(this.dirName, MAX_CHAR)) - 1;
                for (int i = from; i < to; ++i) {
                    this.entries.add(this.zipFileIndex.entries[i]);
                }
            } else {
                File indexFile = this.zipFileIndex.getIndexFile();
                if (indexFile != null) {
                    RandomAccessFile raf = null;
                    try {
                        raf = new RandomAccessFile(indexFile, "r");
                        raf.seek(this.writtenOffsetOffset);
                        for (int nFiles = 0; nFiles < this.numEntries; ++nFiles) {
                            int zfieNameBytesLen = raf.readInt();
                            byte[] zfieNameBytes = new byte[zfieNameBytesLen];
                            raf.read(zfieNameBytes);
                            String eName = new String(zfieNameBytes, "UTF-8");
                            boolean eIsDir = raf.readByte() != 0;
                            int eOffset = raf.readInt();
                            int eSize = raf.readInt();
                            int eCsize = raf.readInt();
                            long eJavaTimestamp = raf.readLong();
                            Entry rfie = new Entry(this.dirName, eName);
                            rfie.isDir = eIsDir;
                            rfie.offset = eOffset;
                            rfie.size = eSize;
                            rfie.compressedSize = eCsize;
                            rfie.javatime = eJavaTimestamp;
                            this.entries.add(rfie);
                        }
                    }
                    catch (Throwable t) {
                    }
                    finally {
                        try {
                            if (raf != null) {
                                raf.close();
                            }
                        }
                        catch (Throwable t) {}
                    }
                }
            }
            this.entriesInited = true;
        }

        java.util.List<Entry> getEntriesAsCollection() {
            this.initEntries();
            return this.entries;
        }
    }

    private class ZipDirectory {
        private RelativePath.RelativeDirectory lastDir;
        private int lastStart;
        private int lastLen;
        byte[] zipDir;
        RandomAccessFile zipRandomFile = null;
        ZipFileIndex zipFileIndex = null;

        public ZipDirectory(RandomAccessFile zipRandomFile, long start, long end, ZipFileIndex index) throws IOException {
            this.zipRandomFile = zipRandomFile;
            this.zipFileIndex = index;
            this.hasValidHeader();
            this.findCENRecord(start, end);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean hasValidHeader() throws IOException {
            long pos = this.zipRandomFile.getFilePointer();
            try {
                if (this.zipRandomFile.read() == 80 && this.zipRandomFile.read() == 75 && this.zipRandomFile.read() == 3 && this.zipRandomFile.read() == 4) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.zipRandomFile.seek(pos);
            }
            throw new ZipFormatException("invalid zip magic");
        }

        private void findCENRecord(long start, long end) throws IOException {
            long totalLength = end - start;
            int endbuflen = 1024;
            byte[] endbuf = new byte[endbuflen];
            long endbufend = end - start;
            while (endbufend >= 22L) {
                int i;
                if (endbufend < (long)endbuflen) {
                    endbuflen = (int)endbufend;
                }
                long endbufpos = endbufend - (long)endbuflen;
                this.zipRandomFile.seek(start + endbufpos);
                this.zipRandomFile.readFully(endbuf, 0, endbuflen);
                for (i = endbuflen - 22; i >= 0 && (endbuf[i] != 80 || endbuf[i + 1] != 75 || endbuf[i + 2] != 5 || endbuf[i + 3] != 6 || endbufpos + (long)i + 22L + (long)ZipFileIndex.get2ByteLittleEndian(endbuf, i + 20) != totalLength); --i) {
                }
                if (i >= 0) {
                    this.zipDir = new byte[ZipFileIndex.get4ByteLittleEndian(endbuf, i + 12)];
                    int sz = ZipFileIndex.get4ByteLittleEndian(endbuf, i + 16);
                    if (sz < 0 || ZipFileIndex.get2ByteLittleEndian(endbuf, i + 10) == 65535) {
                        throw new ZipFormatException("detected a zip64 archive");
                    }
                    this.zipRandomFile.seek(start + (long)sz);
                    this.zipRandomFile.readFully(this.zipDir, 0, this.zipDir.length);
                    return;
                }
                endbufend = endbufpos + 21L;
            }
            throw new ZipException("cannot read zip file");
        }

        private void buildIndex() throws IOException {
            int len = this.zipDir.length;
            if (len > 0) {
                ZipFileIndex.this.directories = new LinkedHashMap();
                ArrayList<Entry> entryList = new ArrayList<Entry>();
                int pos = 0;
                while (pos < len) {
                    pos = this.readEntry(pos, entryList, ZipFileIndex.this.directories);
                }
                for (RelativePath.RelativeDirectory d : ZipFileIndex.this.directories.keySet()) {
                    RelativePath.RelativeDirectory parent = ZipFileIndex.this.getRelativeDirectory(d.dirname().getPath());
                    String file = d.basename();
                    Entry zipFileIndexEntry = new Entry(parent, file);
                    zipFileIndexEntry.isDir = true;
                    entryList.add(zipFileIndexEntry);
                }
                ZipFileIndex.access$802(ZipFileIndex.this, entryList.toArray(new Entry[entryList.size()]));
                Arrays.sort(ZipFileIndex.this.entries);
            } else {
                ZipFileIndex.this.cleanupState();
            }
        }

        private int readEntry(int pos, java.util.List<Entry> entryList, Map<RelativePath.RelativeDirectory, DirectoryEntry> directories) throws IOException {
            int dirStart;
            if (ZipFileIndex.get4ByteLittleEndian(this.zipDir, pos) != 33639248) {
                throw new ZipException("cannot read zip file entry");
            }
            int fileStart = dirStart = pos + 46;
            int fileEnd = fileStart + ZipFileIndex.get2ByteLittleEndian(this.zipDir, pos + 28);
            if (this.zipFileIndex.symbolFilePrefixLength != 0 && fileEnd - fileStart >= ZipFileIndex.this.symbolFilePrefixLength) {
                dirStart += this.zipFileIndex.symbolFilePrefixLength;
                fileStart += this.zipFileIndex.symbolFilePrefixLength;
            }
            for (int index = fileStart; index < fileEnd; ++index) {
                byte nextByte = this.zipDir[index];
                if (nextByte == 92) {
                    this.zipDir[index] = 47;
                    fileStart = index + 1;
                    continue;
                }
                if (nextByte != 47) continue;
                fileStart = index + 1;
            }
            RelativePath.RelativeDirectory directory = null;
            if (fileStart == dirStart) {
                directory = ZipFileIndex.this.getRelativeDirectory("");
            } else if (this.lastDir != null && this.lastLen == fileStart - dirStart - 1) {
                int index = this.lastLen - 1;
                while (this.zipDir[this.lastStart + index] == this.zipDir[dirStart + index]) {
                    if (index == 0) {
                        directory = this.lastDir;
                        break;
                    }
                    --index;
                }
            }
            if (directory == null) {
                this.lastStart = dirStart;
                this.lastLen = fileStart - dirStart - 1;
                this.lastDir = directory = ZipFileIndex.this.getRelativeDirectory(new String(this.zipDir, dirStart, this.lastLen, "UTF-8"));
                RelativePath.RelativeDirectory tempDirectory = directory;
                while (directories.get(tempDirectory) == null) {
                    directories.put(tempDirectory, new DirectoryEntry(tempDirectory, this.zipFileIndex));
                    if (tempDirectory.path.indexOf("/") != tempDirectory.path.length() - 1) {
                        tempDirectory = ZipFileIndex.this.getRelativeDirectory(tempDirectory.dirname().getPath());
                        continue;
                    }
                    break;
                }
            } else if (directories.get(directory) == null) {
                directories.put(directory, new DirectoryEntry(directory, this.zipFileIndex));
            }
            if (fileStart != fileEnd) {
                Entry entry = new Entry(directory, new String(this.zipDir, fileStart, fileEnd - fileStart, "UTF-8"));
                entry.setNativeTime(ZipFileIndex.get4ByteLittleEndian(this.zipDir, pos + 12));
                entry.compressedSize = ZipFileIndex.get4ByteLittleEndian(this.zipDir, pos + 20);
                entry.size = ZipFileIndex.get4ByteLittleEndian(this.zipDir, pos + 24);
                entry.offset = ZipFileIndex.get4ByteLittleEndian(this.zipDir, pos + 42);
                entryList.add(entry);
            }
            return pos + 46 + ZipFileIndex.get2ByteLittleEndian(this.zipDir, pos + 28) + ZipFileIndex.get2ByteLittleEndian(this.zipDir, pos + 30) + ZipFileIndex.get2ByteLittleEndian(this.zipDir, pos + 32);
        }
    }
}

