/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.DocTree;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.DocTreeMaker;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.StringUtils;
import java.text.BreakIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DocCommentParser {
    final ParserFactory fac;
    private final EndPosTable ept;
    final DiagnosticSource diagSource;
    final Tokens.Comment comment;
    final DocTreeMaker m;
    final Names names;
    BreakIterator sentenceBreaker;
    protected char[] buf;
    protected int bp;
    protected int buflen;
    protected char ch;
    int textStart = -1;
    int lastNonWhite = -1;
    boolean newline = true;
    Map<Name, TagParser> tagParsers;
    private final boolean breakOnError;
    private ListBuffer<JCDiagnostic> errors = new ListBuffer();
    Set<String> htmlBlockTags = new HashSet<String>(Arrays.asList("h1", "h2", "h3", "h4", "h5", "h6", "p", "pre"));

    DocCommentParser(ParserFactory fac, boolean breakOnError, EndPosTable ept, DiagnosticSource diagSource, Tokens.Comment comment) {
        this.fac = fac;
        this.ept = ept;
        this.breakOnError = breakOnError;
        this.diagSource = diagSource;
        this.comment = comment;
        this.names = fac.names;
        this.m = fac.docTreeMaker;
        Locale locale = fac.locale == null ? Locale.getDefault() : fac.locale;
        Options options = fac.options;
        boolean useBreakIterator = options.isSet("breakIterator");
        if (useBreakIterator || !locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            this.sentenceBreaker = BreakIterator.getSentenceInstance(locale);
        }
        this.initTagParsers();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    DCTree.DCDocComment parse() {
        void var2_8;
        DCTree first;
        void var2_3;
        this.errors.clear();
        String c = this.comment.getText();
        this.buf = new char[c.length() + 1];
        c.getChars(0, c.length(), this.buf, 0);
        this.buf[this.buf.length - 1] = 26;
        this.buflen = this.buf.length - 1;
        this.bp = -1;
        this.nextChar();
        List<DCTree> list = this.blockContent();
        List<DCTree> tags = this.blockTags();
        ListBuffer<DCTree> fs = new ListBuffer<DCTree>();
        block4: while (var2_3.nonEmpty()) {
            DCTree t = (DCTree)var2_3.head;
            switch (t.getKind()) {
                case TEXT: {
                    int i0;
                    String s = ((DCTree.DCText)t).getBody();
                    int i = this.getSentenceBreak(s);
                    if (i > 0) {
                        int i1;
                        int i02;
                        for (i02 = i; i02 > 0 && this.isWhitespace(s.charAt(i02 - 1)); --i02) {
                        }
                        fs.add(this.m.at(t.pos).Text(s.substring(0, i02)));
                        for (i1 = i; i1 < s.length() && this.isWhitespace(s.charAt(i1)); ++i1) {
                        }
                        List<DCTree.DCText> list2 = var2_3.tail;
                        if (i1 >= s.length()) break block4;
                        List<DCTree.DCText> list3 = list2.prepend(this.m.at(t.pos + i1).Text(s.substring(i1)));
                        break block4;
                    }
                    if (!var2_3.tail.nonEmpty() || !this.isSentenceBreak((DCTree)var2_3.tail.head)) break;
                    for (i0 = s.length() - 1; i0 > 0 && this.isWhitespace(s.charAt(i0)); --i0) {
                    }
                    fs.add(this.m.at(t.pos).Text(s.substring(0, i0 + 1)));
                    List list4 = var2_3.tail;
                    break block4;
                }
                case START_ELEMENT: 
                case END_ELEMENT: {
                    if (this.isSentenceBreak(t)) break block4;
                }
            }
            fs.add(t);
            List list5 = var2_3.tail;
        }
        int pos = (first = (DCTree)this.getFirst(new List[]{fs.toList(), var2_8, tags})) == null ? -1 : first.pos;
        DCTree.DCDocComment dc = this.m.at(pos).DocComment(this.comment, fs.toList(), (List<DCTree>)var2_8, tags);
        dc.errors = this.errors.toList();
        return dc;
    }

    void nextChar() {
        this.ch = this.buf[this.bp < this.buflen ? (this.bp = this.bp + 1) : this.buflen];
        switch (this.ch) {
            case '\n': 
            case '\f': 
            case '\r': {
                this.newline = true;
            }
        }
    }

    char peekNextChar() {
        return this.buf[this.bp < this.buflen ? this.bp + 1 : this.buflen];
    }

    protected List<DCTree> blockContent() {
        ListBuffer<DCTree> trees = new ListBuffer<DCTree>();
        this.textStart = -1;
        block9: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    this.nextChar();
                    continue block9;
                }
                case '&': {
                    this.entity(trees);
                    continue block9;
                }
                case '<': {
                    this.newline = false;
                    this.addPendingText(trees, this.bp - 1);
                    trees.add(this.html());
                    if (this.textStart != -1) continue block9;
                    this.textStart = this.bp;
                    this.lastNonWhite = -1;
                    continue block9;
                }
                case '>': {
                    this.newline = false;
                    this.addPendingText(trees, this.bp - 1);
                    trees.add(this.m.at(this.bp).Erroneous(this.newString(this.bp, this.bp + 1), this.diagSource, "dc.bad.gt", new Object[0]));
                    this.nextChar();
                    if (this.textStart != -1) continue block9;
                    this.textStart = this.bp;
                    this.lastNonWhite = -1;
                    continue block9;
                }
                case '{': {
                    this.inlineTag(trees);
                    continue block9;
                }
                case '@': {
                    if (this.newline) {
                        this.addPendingText(trees, this.lastNonWhite);
                        break block9;
                    }
                }
                default: {
                    this.newline = false;
                    if (this.textStart == -1) {
                        this.textStart = this.bp;
                    }
                    this.lastNonWhite = this.bp;
                    this.nextChar();
                    continue block9;
                }
            }
        }
        if (this.lastNonWhite != -1) {
            this.addPendingText(trees, this.lastNonWhite);
        }
        return trees.toList();
    }

    protected List<DCTree> blockTags() {
        ListBuffer<DCTree> tags = new ListBuffer<DCTree>();
        while (this.ch == '@') {
            tags.add(this.blockTag());
        }
        return tags.toList();
    }

    protected DCTree blockTag() {
        int p = this.bp;
        try {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readTagName();
                TagParser tp = this.tagParsers.get(name);
                if (tp == null) {
                    List<DCTree> content = this.blockContent();
                    return this.m.at(p).UnknownBlockTag(name, content);
                }
                switch (tp.getKind()) {
                    case BLOCK: {
                        return tp.parse(p);
                    }
                    case INLINE: {
                        this.handleError("dc.bad.inline.tag", p);
                        return tp.parse(p);
                    }
                }
            }
            DCTree.DCErroneous err = this.erroneous("dc.no.tag.name", p);
            if (this.breakOnError) {
                return err;
            }
            List<DCTree> content = this.blockContent();
            return this.m.at(p).UnknownBlockTag(this.names.empty, content);
        }
        catch (ParseException e) {
            if (!this.breakOnError) {
                throw new IllegalStateException(e);
            }
            this.blockContent();
            return this.erroneous(e.getMessage(), p);
        }
    }

    protected void inlineTag(ListBuffer<DCTree> list) {
        this.newline = false;
        this.nextChar();
        if (this.ch == '@') {
            this.addPendingText(list, this.bp - 2);
            list.add(this.inlineTag());
            this.textStart = this.bp;
            this.lastNonWhite = -1;
        } else {
            if (this.textStart == -1) {
                this.textStart = this.bp - 1;
            }
            this.lastNonWhite = this.bp;
        }
    }

    protected DCTree inlineTag() {
        int p = this.bp - 1;
        try {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readTagName();
                this.skipWhitespace();
                TagParser tp = this.tagParsers.get(name);
                if (tp == null) {
                    DCTree text = this.inlineText();
                    if (text != null) {
                        return this.m.at(p).UnknownInlineTag(name, List.of(text)).setEndPos(this.bp);
                    }
                } else if (tp.getKind() == TagParser.Kind.INLINE) {
                    DCTree.DCEndPosTree tree = (DCTree.DCEndPosTree)tp.parse(p);
                    if (tree != null) {
                        return tree.setEndPos(this.bp);
                    }
                } else {
                    this.inlineText();
                }
            }
            DCTree.DCErroneous err = this.erroneous("dc.no.tag.name", p);
            if (this.breakOnError) {
                return err;
            }
            List<DCTree> content = this.inlineContent();
            return this.m.at(p).UnknownInlineTag(this.names.empty, content);
        }
        catch (ParseException e) {
            if (!this.breakOnError) {
                throw new IllegalStateException(e);
            }
            return this.erroneous(e.getMessage(), p);
        }
    }

    protected DCTree inlineText() throws ParseException {
        this.skipWhitespace();
        int pos = this.bp;
        int depth = 1;
        block7: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                case '{': {
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    ++depth;
                    break;
                }
                case '}': {
                    if (--depth == 0) {
                        DCTree.DCText result = this.m.at(pos).Text(this.newString(pos, this.bp));
                        this.nextChar();
                        return result;
                    }
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    break;
                }
                case '@': {
                    if (this.newline) break block7;
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    break;
                }
                default: {
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                }
            }
            this.nextChar();
        }
        this.handleError("dc.unterminated.inline.tag", pos);
        return this.m.at(pos).Text(this.newString(pos, this.bp));
    }

    protected void handleError(String errorKey, int pos) throws ParseException {
        if (this.breakOnError) {
            throw new ParseException(errorKey);
        }
        DCTree.DCErroneous err = this.erroneous(errorKey, pos);
        this.errors.add(err.diag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DCTree.DCReference reference(boolean allowMember) throws ParseException {
        List<JCTree> paramTypes;
        Name member;
        JCTree.JCExpression qualExpr;
        int pos = this.bp;
        int depth = 0;
        block12: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    if (depth != 0) break;
                    break block12;
                }
                case '(': 
                case '<': {
                    this.newline = false;
                    ++depth;
                    break;
                }
                case ')': 
                case '>': {
                    this.newline = false;
                    --depth;
                    break;
                }
                case '}': {
                    if (this.bp == pos) {
                        return null;
                    }
                    this.newline = false;
                    break block12;
                }
                case '@': {
                    if (this.newline) break block12;
                }
                case '{': {
                    break block12;
                }
                default: {
                    this.newline = false;
                }
            }
            this.nextChar();
        }
        if (depth != 0) {
            this.handleError("dc.unterminated.signature", pos);
        }
        String sig = this.newString(pos, this.bp);
        Log.DeferredDiagnosticHandler deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(this.fac.log);
        try {
            int hash = sig.indexOf("#");
            int lparen = sig.indexOf("(", hash + 1);
            if (hash == -1) {
                if (lparen == -1) {
                    qualExpr = this.parseType(sig, this.comment.getSourcePos(pos));
                    member = null;
                } else {
                    qualExpr = null;
                    member = this.parseMember(sig.substring(0, lparen));
                }
            } else {
                qualExpr = hash == 0 ? null : this.parseType(sig.substring(0, hash), this.comment.getSourcePos(pos));
                member = lparen == -1 ? this.parseMember(sig.substring(hash + 1)) : this.parseMember(sig.substring(hash + 1, lparen));
            }
            if (lparen < 0) {
                paramTypes = null;
            } else {
                int rparen = sig.indexOf(")", lparen);
                if (rparen != sig.length() - 1) {
                    this.handleError("dc.ref.bad.parens", pos);
                    if (rparen == -1) {
                        rparen = sig.length();
                    }
                }
                paramTypes = this.parseParams(sig.substring(lparen + 1, rparen), this.comment.getSourcePos(pos + lparen + 1));
            }
            if (!deferredDiagnosticHandler.getDiagnostics().isEmpty()) {
                this.handleError("dc.ref.syntax.error", pos);
            }
        }
        finally {
            this.fac.log.popDiagnosticHandler(deferredDiagnosticHandler);
        }
        return (DCTree.DCReference)this.m.at(pos).Reference(sig, qualExpr, member, paramTypes).setEndPos(this.bp);
    }

    JCTree.JCExpression parseType(String s, int startPos) throws ParseException {
        JavacParser p = this.fac.newParser(s, false, true, false);
        JCTree.JCExpression tree = p.parseType();
        this.moveTree(startPos, tree, p, this.ept);
        if (p.token().kind != Tokens.TokenKind.EOF) {
            this.handleError("dc.ref.unexpected.input", p.token().pos);
        }
        return tree;
    }

    private <T extends JCTree> T moveTree(final int offset, T toMove, final JavacParser parser, final EndPosTable targetEndPos) {
        new TreeScanner(){

            @Override
            public void scan(JCTree tree) {
                if (tree != null) {
                    int endPos = parser.getEndPos(tree) + offset;
                    tree.pos += offset;
                    ((JavacParser.AbstractEndPosTable)targetEndPos).storeEnd(tree, endPos);
                }
                super.scan(tree);
            }
        }.scan(toMove);
        return toMove;
    }

    Name parseMember(String s) throws ParseException {
        JavacParser p = this.fac.newParser(s, false, false, false);
        Name name = p.ident();
        if (p.token().kind != Tokens.TokenKind.EOF) {
            this.handleError("dc.ref.unexpected.input", this.bp);
            return this.names.error;
        }
        return name;
    }

    List<JCTree> parseParams(String s, int startPos) throws ParseException {
        if (s.trim().isEmpty()) {
            return List.nil();
        }
        JavacParser p = this.fac.newParser(s.replace("...", "[ ]"), false, true, false);
        ListBuffer<JCTree.JCExpression> paramTypes = new ListBuffer<JCTree.JCExpression>();
        paramTypes.add(this.moveTree(startPos, p.parseType(), p, this.ept));
        if (p.token().kind == Tokens.TokenKind.IDENTIFIER) {
            p.nextToken();
        }
        while (p.token().kind == Tokens.TokenKind.COMMA) {
            p.nextToken();
            paramTypes.add(this.moveTree(startPos, p.parseType(), p, this.ept));
            if (p.token().kind != Tokens.TokenKind.IDENTIFIER) continue;
            p.nextToken();
        }
        if (p.token().kind != Tokens.TokenKind.EOF) {
            this.handleError("dc.ref.unexpected.input", this.bp);
        }
        return paramTypes.toList();
    }

    protected DCTree.DCIdentifier identifier() throws ParseException {
        this.skipWhitespace();
        int pos = this.bp;
        if (this.isJavaIdentifierStart(this.ch)) {
            Name name = this.readJavaIdentifier();
            return this.m.at(pos).Identifier(name);
        }
        this.handleError("dc.identifier.expected", pos);
        return this.m.at(pos).Identifier(this.names.error);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected DCTree.DCText quotedString() {
        int pos = this.bp;
        this.nextChar();
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                case '\"': {
                    this.nextChar();
                    return this.m.at(pos).Text(this.newString(pos, this.bp));
                }
                case '@': {
                    if (!this.newline) break;
                    return null;
                }
            }
            this.nextChar();
        }
        return null;
    }

    protected List<DCTree> inlineContent() {
        ListBuffer<DCTree> trees = new ListBuffer<DCTree>();
        this.skipWhitespace();
        int pos = this.bp;
        int depth = 1;
        this.textStart = -1;
        block9: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    this.nextChar();
                    continue block9;
                }
                case '&': {
                    this.entity(trees);
                    continue block9;
                }
                case '<': {
                    this.newline = false;
                    this.addPendingText(trees, this.bp - 1);
                    trees.add(this.html());
                    continue block9;
                }
                case '{': {
                    this.newline = false;
                    if (this.peekNextChar() == '@') {
                        this.addPendingText(trees, this.bp - 1);
                        pos = this.bp;
                        break block9;
                    }
                    this.nextChar();
                    ++depth;
                    continue block9;
                }
                case '}': {
                    this.newline = false;
                    if (--depth == 0) {
                        this.addPendingText(trees, this.bp - 1);
                        this.nextChar();
                        return trees.toList();
                    }
                    this.nextChar();
                    continue block9;
                }
                case '@': {
                    if (this.newline) break block9;
                }
                default: {
                    if (this.textStart == -1) {
                        this.textStart = this.bp;
                    }
                    this.nextChar();
                    continue block9;
                }
            }
        }
        DCTree.DCErroneous err = this.erroneous("dc.unterminated.inline.tag", pos);
        if (!this.breakOnError) {
            return trees.toList();
        }
        return List.of(err);
    }

    protected void entity(ListBuffer<DCTree> list) {
        this.newline = false;
        this.addPendingText(list, this.bp - 1);
        list.add(this.entity());
        if (this.textStart == -1) {
            this.textStart = this.bp;
            this.lastNonWhite = -1;
        }
    }

    protected DCTree entity() {
        int p = this.bp;
        this.nextChar();
        Name name = null;
        boolean checkSemi = false;
        if (this.ch == '#') {
            int namep = this.bp;
            this.nextChar();
            if (this.isDecimalDigit(this.ch)) {
                this.nextChar();
                while (this.isDecimalDigit(this.ch)) {
                    this.nextChar();
                }
                name = this.names.fromChars(this.buf, namep, this.bp - namep);
            } else if (this.ch == 'x' || this.ch == 'X') {
                this.nextChar();
                if (this.isHexDigit(this.ch)) {
                    this.nextChar();
                    while (this.isHexDigit(this.ch)) {
                        this.nextChar();
                    }
                    name = this.names.fromChars(this.buf, namep, this.bp - namep);
                }
            }
        } else if (this.isIdentifierStart(this.ch)) {
            name = this.readIdentifier();
        }
        if (name == null) {
            DCTree.DCErroneous err = this.erroneous("dc.bad.entity", p);
            if (this.breakOnError) {
                return err;
            }
            name = this.names.empty;
        } else if (this.ch != ';') {
            DCTree.DCErroneous err = this.erroneous("dc.missing.semicolon", p);
            if (this.breakOnError) {
                return err;
            }
        } else {
            this.nextChar();
        }
        return this.m.at(p).Entity(name);
    }

    protected DCTree html() {
        int p = this.bp;
        this.nextChar();
        if (this.isIdentifierStart(this.ch)) {
            Name name = this.readIdentifier();
            List<DCTree> attrs = this.htmlAttrs();
            if (attrs != null) {
                boolean selfClosing = false;
                if (this.ch == '/') {
                    this.nextChar();
                    selfClosing = true;
                }
                if (this.ch == '>') {
                    this.nextChar();
                    return this.m.at(p).StartElement(name, attrs, selfClosing).setEndPos(this.bp);
                }
            }
        } else if (this.ch == '/') {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readIdentifier();
                this.skipWhitespace();
                if (this.ch == '>') {
                    this.nextChar();
                    return this.m.at(p).EndElement(name);
                }
            }
        } else if (this.ch == '!') {
            this.nextChar();
            if (this.ch == '-') {
                this.nextChar();
                if (this.ch == '-') {
                    this.nextChar();
                    while (this.bp < this.buflen) {
                        int dash = 0;
                        while (this.ch == '-') {
                            ++dash;
                            this.nextChar();
                        }
                        if (dash >= 2 && this.ch == '>') {
                            this.nextChar();
                            return this.m.at(p).Comment(this.newString(p, this.bp));
                        }
                        this.nextChar();
                    }
                }
            }
        }
        this.bp = p + 1;
        this.ch = this.buf[this.bp];
        return this.erroneous("dc.malformed.html", p);
    }

    protected List<DCTree> htmlAttrs() {
        ListBuffer<DCTree> attrs = new ListBuffer<DCTree>();
        this.skipWhitespace();
        block0: while (this.isIdentifierStart(this.ch)) {
            int namePos = this.bp;
            Name name = this.readIdentifier();
            this.skipWhitespace();
            List<DCTree> value = null;
            AttributeTree.ValueKind vkind = AttributeTree.ValueKind.EMPTY;
            if (this.ch == '=') {
                ListBuffer<DCTree> v = new ListBuffer<DCTree>();
                this.nextChar();
                this.skipWhitespace();
                if (this.ch == '\'' || this.ch == '\"') {
                    vkind = this.ch == '\'' ? AttributeTree.ValueKind.SINGLE : AttributeTree.ValueKind.DOUBLE;
                    char quote = this.ch;
                    this.nextChar();
                    this.textStart = this.bp;
                    while (this.bp < this.buflen && this.ch != quote) {
                        if (this.newline && this.ch == '@') {
                            DCTree.DCErroneous err = this.erroneous("dc.unterminated.string", namePos);
                            if (this.breakOnError) {
                                attrs.add(err);
                                break block0;
                            }
                            this.attrValueChar(v);
                            attrs.add(this.m.at(namePos).Attribute(name, vkind, v.toList()));
                            break block0;
                        }
                        this.attrValueChar(v);
                    }
                    this.addPendingText(v, this.bp - 1);
                    this.nextChar();
                } else {
                    vkind = AttributeTree.ValueKind.UNQUOTED;
                    this.textStart = this.bp;
                    while (this.bp < this.buflen && !this.isUnquotedAttrValueTerminator(this.ch)) {
                        this.attrValueChar(v);
                    }
                    this.addPendingText(v, this.bp - 1);
                }
                this.skipWhitespace();
                value = v.toList();
            }
            DCTree.DCAttribute attr = this.m.at(namePos).Attribute(name, vkind, value);
            attrs.add(attr);
        }
        return attrs.toList();
    }

    protected void attrValueChar(ListBuffer<DCTree> list) {
        switch (this.ch) {
            case '&': {
                this.entity(list);
                break;
            }
            case '{': {
                this.inlineTag(list);
                break;
            }
            default: {
                this.nextChar();
            }
        }
    }

    protected void addPendingText(ListBuffer<DCTree> list, int textEnd) {
        if (this.textStart != -1) {
            if (this.textStart <= textEnd) {
                list.add(this.m.at(this.textStart).Text(this.newString(this.textStart, textEnd + 1)));
            }
            this.textStart = -1;
        }
    }

    protected DCTree.DCErroneous erroneous(String code, int pos) {
        int i;
        block4: for (i = this.bp - 1; i > pos; --i) {
            switch (this.buf[i]) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    continue block4;
                }
            }
        }
        this.textStart = -1;
        DCTree.DCErroneous result = this.m.at(pos).Erroneous(this.newString(pos, i + 1), this.diagSource, code, new Object[0]);
        if (!this.breakOnError) {
            this.errors.add(result.diag);
        }
        return result;
    }

    <T> T getFirst(List<T> ... lists) {
        for (List<T> list : lists) {
            if (!list.nonEmpty()) continue;
            return (T)list.head;
        }
        return null;
    }

    protected boolean isIdentifierStart(char ch) {
        return Character.isUnicodeIdentifierStart(ch);
    }

    protected Name readIdentifier() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isUnicodeIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, start, this.bp - start);
    }

    protected Name readTagName() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && (Character.isUnicodeIdentifierPart(this.ch) || this.ch == '.')) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, start, this.bp - start);
    }

    protected boolean isJavaIdentifierStart(char ch) {
        return Character.isJavaIdentifierStart(ch);
    }

    protected Name readJavaIdentifier() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isJavaIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, start, this.bp - start);
    }

    protected boolean isDecimalDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    protected boolean isHexDigit(char ch) {
        return '0' <= ch && ch <= '9' || 'a' <= ch && ch <= 'f' || 'A' <= ch && ch <= 'F';
    }

    protected boolean isUnquotedAttrValueTerminator(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\"': 
            case '\'': 
            case '<': 
            case '=': 
            case '>': 
            case '`': {
                return true;
            }
        }
        return false;
    }

    protected boolean isWhitespace(char ch) {
        return Character.isWhitespace(ch);
    }

    protected void skipWhitespace() {
        while (this.isWhitespace(this.ch)) {
            this.nextChar();
        }
    }

    protected int getSentenceBreak(String s) {
        if (this.sentenceBreaker != null) {
            this.sentenceBreaker.setText(s);
            int i = this.sentenceBreaker.next();
            return i == s.length() ? -1 : i;
        }
        boolean period = false;
        block4: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '.': {
                    period = true;
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!period) continue block4;
                    return i;
                }
                default: {
                    period = false;
                }
            }
        }
        return -1;
    }

    protected boolean isSentenceBreak(Name n) {
        return this.htmlBlockTags.contains(StringUtils.toLowerCase(n.toString()));
    }

    protected boolean isSentenceBreak(DCTree t) {
        switch (t.getKind()) {
            case START_ELEMENT: {
                return this.isSentenceBreak(((DCTree.DCStartElement)t).getName());
            }
            case END_ELEMENT: {
                return this.isSentenceBreak(((DCTree.DCEndElement)t).getName());
            }
        }
        return false;
    }

    String newString(int start, int end) {
        return new String(this.buf, start, end - start);
    }

    private void initTagParsers() {
        TagParser[] parsers = new TagParser[]{new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.AUTHOR){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> name = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).Author(name);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.CODE){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree text = DocCommentParser.this.inlineText();
                return DocCommentParser.this.m.at(pos).Code((DCTree.DCText)text);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.DEPRECATED){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> reason = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).Deprecated(reason);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.DOC_ROOT){

            @Override
            public DCTree parse(int pos) throws ParseException {
                if (DocCommentParser.this.ch == '}' || !DocCommentParser.this.breakOnError) {
                    if (DocCommentParser.this.ch == '}') {
                        DocCommentParser.this.nextChar();
                    } else {
                        DocCommentParser.this.erroneous("dc.unexpected.content", DocCommentParser.this.bp);
                    }
                    return DocCommentParser.this.m.at(pos).DocRoot();
                }
                DocCommentParser.this.inlineText();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.EXCEPTION){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference ref = DocCommentParser.this.reference(false);
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).Exception(ref, description);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.INHERIT_DOC){

            @Override
            public DCTree parse(int pos) throws ParseException {
                if (DocCommentParser.this.ch == '}' || !DocCommentParser.this.breakOnError) {
                    if (DocCommentParser.this.ch == '}') {
                        DocCommentParser.this.nextChar();
                    } else {
                        DocCommentParser.this.erroneous("dc.unexpected.content", DocCommentParser.this.bp);
                    }
                    return DocCommentParser.this.m.at(pos).InheritDoc();
                }
                DocCommentParser.this.inlineText();
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LINK){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCReference ref = DocCommentParser.this.reference(true);
                List<DCTree> label = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(pos).Link(ref, label);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LINK_PLAIN){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCReference ref = DocCommentParser.this.reference(true);
                List<DCTree> label = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(pos).LinkPlain(ref, label);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LITERAL){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree text = DocCommentParser.this.inlineText();
                return DocCommentParser.this.m.at(pos).Literal((DCTree.DCText)text);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.PARAM){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                boolean typaram = false;
                if (DocCommentParser.this.ch == '<') {
                    typaram = true;
                    DocCommentParser.this.nextChar();
                }
                DCTree.DCIdentifier id = DocCommentParser.this.identifier();
                if (typaram) {
                    if (DocCommentParser.this.ch != '>') {
                        DocCommentParser.this.handleError("dc.gt.expected", DocCommentParser.this.bp);
                    }
                    DocCommentParser.this.nextChar();
                }
                DocCommentParser.this.skipWhitespace();
                List<DCTree> desc = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).Param(typaram, id, desc);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.RETURN){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).Return(description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SEE){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                String errorKey = "dc.unexpected.content";
                switch (DocCommentParser.this.ch) {
                    case '\"': {
                        DCTree.DCText string = DocCommentParser.this.quotedString();
                        if (string == null) break;
                        DocCommentParser.this.skipWhitespace();
                        if (DocCommentParser.this.ch != '@' && (DocCommentParser.this.ch != '\u001a' || DocCommentParser.this.bp != DocCommentParser.this.buf.length - 1)) break;
                        return DocCommentParser.this.m.at(pos).See(List.of(string));
                    }
                    case '<': {
                        List<DCTree> html = DocCommentParser.this.blockContent();
                        if (html == null) break;
                        return DocCommentParser.this.m.at(pos).See(html);
                    }
                    case '@': {
                        if (!DocCommentParser.this.newline) break;
                        DocCommentParser.this.handleError("dc.no.content", DocCommentParser.this.bp);
                        break;
                    }
                    case '\u001a': {
                        if (DocCommentParser.this.bp != DocCommentParser.this.buf.length - 1) break;
                        errorKey = "dc.no.content";
                        break;
                    }
                    default: {
                        if (!DocCommentParser.this.isJavaIdentifierStart(DocCommentParser.this.ch) && DocCommentParser.this.ch != '#') break;
                        DCTree.DCReference ref = DocCommentParser.this.reference(true);
                        List<DCTree> description = DocCommentParser.this.blockContent();
                        return DocCommentParser.this.m.at(pos).See(description.prepend(ref));
                    }
                }
                DocCommentParser.this.handleError(errorKey, DocCommentParser.this.bp);
                return DocCommentParser.this.m.at(pos).See(List.nil());
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL_DATA){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).SerialData(description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL_FIELD){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCIdentifier name = DocCommentParser.this.identifier();
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference type = DocCommentParser.this.reference(false);
                List<DCTree> description = null;
                if (DocCommentParser.this.isWhitespace(DocCommentParser.this.ch)) {
                    DocCommentParser.this.skipWhitespace();
                    description = DocCommentParser.this.blockContent();
                }
                return DocCommentParser.this.m.at(pos).SerialField(name, type, description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).Serial(description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SINCE){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).Since(description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.THROWS){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference ref = DocCommentParser.this.reference(false);
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).Throws(ref, description);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.VALUE){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCReference ref = DocCommentParser.this.reference(true);
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                } else {
                    DocCommentParser.this.handleError("dc.unexpected.content", pos);
                }
                return DocCommentParser.this.m.at(pos).Value(ref);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.VERSION){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).Version(description);
            }
        }};
        this.tagParsers = new HashMap<Name, TagParser>();
        for (TagParser p : parsers) {
            this.tagParsers.put(this.names.fromString(p.getTreeKind().tagName), p);
        }
    }

    static abstract class TagParser {
        Kind kind;
        DocTree.Kind treeKind;

        TagParser(Kind k, DocTree.Kind tk) {
            this.kind = k;
            this.treeKind = tk;
        }

        Kind getKind() {
            return this.kind;
        }

        DocTree.Kind getTreeKind() {
            return this.treeKind;
        }

        abstract DCTree parse(int var1) throws ParseException;

        static enum Kind {
            INLINE,
            BLOCK;

        }
    }

    static class ParseException
    extends Exception {
        private static final long serialVersionUID = 0L;

        ParseException(String key) {
            super(key);
        }
    }
}

