/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.util.ArrayUtils;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.nio.CharBuffer;
import java.util.Arrays;

public class UnicodeReader {
    protected char[] buf;
    protected int bp;
    protected final int buflen;
    protected char ch;
    protected int unicodeConversionBp = -1;
    protected Log log;
    protected Names names;
    protected char[] sbuf = new char[128];
    private char replacedCharacter;
    protected int realLength;
    protected int sp;
    int seek;
    static final boolean surrogatesSupported = UnicodeReader.surrogatesSupported();

    protected UnicodeReader(ScannerFactory sf, CharBuffer buffer) {
        this(sf, JavacFileManager.toArray(buffer), buffer.limit());
    }

    protected UnicodeReader(ScannerFactory sf, char[] input, int inputLength) {
        this.log = sf.log;
        this.names = sf.names;
        this.realLength = inputLength;
        if (inputLength == input.length) {
            if (input.length > 0 && Character.isWhitespace(input[input.length - 1])) {
                this.replacedCharacter = input[--inputLength];
            } else {
                input = Arrays.copyOf(input, inputLength + 1);
            }
        }
        this.buf = input;
        this.buflen = inputLength;
        this.buf[this.buflen] = 26;
        this.bp = -1;
        this.scanChar();
    }

    protected void scanChar() {
        if (this.bp < this.buflen) {
            this.ch = this.buf[++this.bp];
            if (this.ch == '\\') {
                this.convertUnicode();
            }
        }
    }

    protected void scanCommentChar() {
        this.scanChar();
        if (this.ch == '\\') {
            if (this.peekChar() == '\\' && !this.isUnicode()) {
                this.skipChar();
            } else {
                this.convertUnicode();
            }
        }
    }

    protected void putChar(char ch, boolean scan) {
        this.sbuf = ArrayUtils.ensureCapacity(this.sbuf, this.sp);
        this.sbuf[this.sp++] = ch;
        if (scan) {
            this.scanChar();
        }
    }

    protected void putChar(char ch) {
        this.putChar(ch, false);
    }

    protected void putChar(boolean scan) {
        this.putChar(this.ch, scan);
    }

    Name name() {
        return this.names.fromChars(this.sbuf, 0, this.sp);
    }

    String chars() {
        return new String(this.sbuf, 0, this.sp);
    }

    protected void convertUnicode() {
        int startPos = this.bp;
        if (this.ch == '\\' && this.unicodeConversionBp != this.bp) {
            ++this.bp;
            this.ch = this.buf[this.bp];
            if (this.ch == 'u') {
                do {
                    ++this.bp;
                    this.ch = this.buf[this.bp];
                } while (this.ch == 'u');
                int limit = this.bp + 3;
                if (limit < this.buflen) {
                    int d;
                    int code = d = this.digit(this.bp, 16);
                    while (this.bp < limit && d >= 0) {
                        ++this.bp;
                        this.ch = this.buf[this.bp];
                        d = this.digit(this.bp, 16);
                        code = (code << 4) + d;
                    }
                    if (d >= 0) {
                        this.ch = (char)code;
                        this.unicodeConversionBp = this.bp;
                        return;
                    }
                }
                this.log.error(new JCDiagnostic.SimpleDiagnosticPosition(startPos + this.seek, this.bp + this.seek), "illegal.unicode.esc", new Object[0]);
            } else {
                --this.bp;
                this.ch = (char)92;
            }
        }
    }

    private static boolean surrogatesSupported() {
        try {
            Character.isHighSurrogate('a');
            return true;
        }
        catch (NoSuchMethodError ex) {
            return false;
        }
    }

    protected char scanSurrogates() {
        if (surrogatesSupported && Character.isHighSurrogate(this.ch)) {
            char high = this.ch;
            this.scanChar();
            if (Character.isLowSurrogate(this.ch)) {
                return high;
            }
            this.ch = high;
        }
        return '\u0000';
    }

    protected int digit(int pos, int base) {
        char c = this.ch;
        int result = Character.digit(c, base);
        if (result >= 0 && c > '\u007f') {
            this.log.error(pos + 1, "illegal.nonascii.digit", new Object[0]);
            this.ch = "0123456789abcdef".charAt(result);
        }
        return result;
    }

    protected boolean isUnicode() {
        return this.unicodeConversionBp == this.bp;
    }

    protected void skipChar() {
        ++this.bp;
    }

    protected char peekChar() {
        return this.buf[this.bp + 1];
    }

    public char[] getRawCharacters() {
        char[] chars = new char[this.realLength];
        System.arraycopy(this.buf, 0, chars, 0, this.buflen);
        if (this.buflen < chars.length) {
            chars[this.buflen] = this.replacedCharacter;
        }
        return chars;
    }

    public char[] getRawCharacters(int beginIndex, int endIndex) {
        int length = endIndex - beginIndex;
        char[] chars = new char[length];
        System.arraycopy(this.buf, beginIndex, chars, 0, length);
        return chars;
    }
}

