/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.util.Iterator;

public class GraphUtils {
    public static <D, N extends TarjanNode<D>> List<? extends List<? extends N>> tarjan(Iterable<? extends N> nodes) {
        ListBuffer<List<N>> cycles = new ListBuffer<List<N>>();
        ListBuffer stack = new ListBuffer();
        int index = 0;
        for (TarjanNode node : nodes) {
            if (node.index != -1) continue;
            index += GraphUtils.tarjan(node, index, stack, cycles);
        }
        return cycles.toList();
    }

    private static <D, N extends TarjanNode<D>> int tarjan(N v, int index, ListBuffer<N> stack, ListBuffer<List<N>> cycles) {
        v.index = index;
        v.lowlink = index++;
        stack.prepend(v);
        v.active = true;
        Iterator<TarjanNode<D>> i$ = v.getAllDependencies().iterator();
        while (i$.hasNext()) {
            TarjanNode<D> nd;
            TarjanNode<D> n = nd = i$.next();
            if (n.index == -1) {
                GraphUtils.tarjan(n, index, stack, cycles);
                v.lowlink = Math.min(v.lowlink, n.lowlink);
                continue;
            }
            if (!stack.contains(n)) continue;
            v.lowlink = Math.min(v.lowlink, n.index);
        }
        if (v.lowlink == v.index) {
            TarjanNode n;
            ListBuffer<TarjanNode> cycle = new ListBuffer<TarjanNode>();
            do {
                n = (TarjanNode)stack.remove();
                n.active = false;
                cycle.add(n);
            } while (n != v);
            cycles.add(cycle.toList());
        }
        return index;
    }

    public static <D> String toDot(Iterable<? extends TarjanNode<D>> nodes, String name, String header) {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("digraph %s {\n", name));
        buf.append(String.format("label = \"%s\";\n", header));
        for (TarjanNode<D> n : nodes) {
            buf.append(String.format("%s [label = \"%s\"];\n", n.hashCode(), n.toString()));
        }
        for (TarjanNode<D> from : nodes) {
            for (DependencyKind dk : from.getSupportedDependencyKinds()) {
                for (TarjanNode<D> to : from.getDependenciesByKind(dk)) {
                    buf.append(String.format("%s -> %s [label = \" %s \" style = %s ];\n", from.hashCode(), to.hashCode(), from.getDependencyName(to, dk), dk.getDotStyle()));
                }
            }
        }
        buf.append("}\n");
        return buf.toString();
    }

    public static abstract class TarjanNode<D>
    extends Node<D>
    implements Comparable<TarjanNode<D>> {
        int index = -1;
        int lowlink;
        boolean active;

        public TarjanNode(D data) {
            super(data);
        }

        @Override
        public abstract Iterable<? extends TarjanNode<D>> getAllDependencies();

        public abstract Iterable<? extends TarjanNode<D>> getDependenciesByKind(DependencyKind var1);

        @Override
        public int compareTo(TarjanNode<D> o) {
            return this.index < o.index ? -1 : (this.index == o.index ? 0 : 1);
        }
    }

    public static abstract class Node<D> {
        public final D data;

        public Node(D data) {
            this.data = data;
        }

        public abstract DependencyKind[] getSupportedDependencyKinds();

        public abstract Iterable<? extends Node<D>> getAllDependencies();

        public abstract String getDependencyName(Node<D> var1, DependencyKind var2);

        public String toString() {
            return this.data.toString();
        }
    }

    public static interface DependencyKind {
        public String getDotStyle();
    }
}

