/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.Doc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javadoc.Comment;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.SourcePositionImpl;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.CollationKey;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.FileObject;

public abstract class DocImpl
implements Doc,
Comparable<Object> {
    protected final DocEnv env;
    protected TreePath treePath;
    private Comment comment;
    private CollationKey collationkey = null;
    protected String documentation;
    private Tag[] firstSentence;
    private Tag[] inlineTags;

    DocImpl(DocEnv env, TreePath treePath) {
        this.treePath = treePath;
        this.documentation = DocImpl.getCommentText(treePath);
        this.env = env;
    }

    private static String getCommentText(TreePath p) {
        if (p == null) {
            return null;
        }
        JCTree.JCCompilationUnit topLevel = (JCTree.JCCompilationUnit)p.getCompilationUnit();
        JCTree tree = (JCTree)p.getLeaf();
        return topLevel.docComments.getCommentText(tree);
    }

    protected String documentation() {
        if (this.documentation == null) {
            this.documentation = "";
        }
        return this.documentation;
    }

    Comment comment() {
        if (this.comment == null) {
            String d = this.documentation();
            if (this.env.doclint != null && this.treePath != null && d.equals(DocImpl.getCommentText(this.treePath))) {
                this.env.doclint.scan(this.treePath);
            }
            this.comment = new Comment(this, d);
        }
        return this.comment;
    }

    public String commentText() {
        return this.comment().commentText();
    }

    public Tag[] tags() {
        return this.comment().tags();
    }

    public Tag[] tags(String tagname) {
        return this.comment().tags(tagname);
    }

    public SeeTag[] seeTags() {
        return this.comment().seeTags();
    }

    public Tag[] inlineTags() {
        if (this.inlineTags == null) {
            this.inlineTags = Comment.getInlineTags(this, this.commentText());
        }
        return this.inlineTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag[] firstSentenceTags() {
        if (this.firstSentence == null) {
            this.inlineTags();
            try {
                this.env.setSilent(true);
                this.firstSentence = Comment.firstSentenceTags(this, this.commentText());
            }
            finally {
                this.env.setSilent(false);
            }
        }
        return this.firstSentence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readHTMLDocumentation(InputStream input, FileObject filename) throws IOException {
        byte[] filecontents = new byte[input.available()];
        try {
            DataInputStream dataIn = new DataInputStream(input);
            dataIn.readFully(filecontents);
        }
        finally {
            input.close();
        }
        String encoding = this.env.getEncoding();
        String rawDoc = encoding != null ? new String(filecontents, encoding) : new String(filecontents);
        Pattern bodyPat = Pattern.compile("(?is).*<body\\b[^>]*>(.*)</body\\b.*");
        Matcher m = bodyPat.matcher(rawDoc);
        if (m.matches()) {
            return m.group(1);
        }
        String key = rawDoc.matches("(?is).*<body\\b.*") ? "javadoc.End_body_missing_from_html_file" : "javadoc.Body_missing_from_html_file";
        this.env.error(SourcePositionImpl.make(filename, -1, null), key);
        return "";
    }

    public String getRawCommentText() {
        return this.documentation();
    }

    public void setRawCommentText(String rawDocumentation) {
        this.treePath = null;
        this.documentation = rawDocumentation;
        this.comment = null;
    }

    void setTreePath(TreePath treePath) {
        this.treePath = treePath;
        this.documentation = DocImpl.getCommentText(treePath);
        this.comment = null;
    }

    CollationKey key() {
        if (this.collationkey == null) {
            this.collationkey = this.generateKey();
        }
        return this.collationkey;
    }

    CollationKey generateKey() {
        String k = this.name();
        return this.env.doclocale.collator.getCollationKey(k);
    }

    public String toString() {
        return this.qualifiedName();
    }

    public abstract String name();

    public abstract String qualifiedName();

    @Override
    public int compareTo(Object obj) {
        return this.key().compareTo(((DocImpl)obj).key());
    }

    public boolean isField() {
        return false;
    }

    public boolean isEnumConstant() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isAnnotationTypeElement() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isException() {
        return false;
    }

    public boolean isError() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isAnnotationType() {
        return false;
    }

    public boolean isOrdinaryClass() {
        return false;
    }

    public boolean isClass() {
        return false;
    }

    public abstract boolean isIncluded();

    public SourcePosition position() {
        return null;
    }
}

