/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FilterMappingPanel
extends JPanel {
    private FilterMapping fm;
    private boolean hasFilterNames;
    private boolean hasServletNames;
    private static final String[] dispatcherTypes = new String[]{"REQUEST", "FORWARD", "INCLUDE", "ERROR"};
    private boolean isMultipleUrlServlet;
    private ButtonGroup buttonGroup1;
    private JComboBox filterNameCB;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JLabel myComment;
    private JScrollPane myScrollPane;
    private JList myServletNameList;
    private JTextField urlTF;

    public FilterMappingPanel(FilterMapping fm, String[] filterNames, String[] servletNames, boolean supportsMultiple) {
        String[] urlPatterns;
        String[] selectedServletNames;
        block23: {
            block22: {
                this.hasFilterNames = true;
                this.hasServletNames = true;
                this.fm = fm;
                this.isMultipleUrlServlet = supportsMultiple;
                this.initComponents();
                this.jCheckBox1.setText(dispatcherTypes[0]);
                this.jCheckBox2.setText(dispatcherTypes[1]);
                this.jCheckBox3.setText(dispatcherTypes[2]);
                this.jCheckBox4.setText(dispatcherTypes[3]);
                this.jCheckBox1.setMnemonic(dispatcherTypes[0].charAt(0));
                this.jCheckBox2.setMnemonic(dispatcherTypes[1].charAt(0));
                this.jCheckBox3.setMnemonic(dispatcherTypes[2].charAt(0));
                this.jCheckBox4.setMnemonic(dispatcherTypes[3].charAt(0));
                if (filterNames == null || filterNames.length == 0) {
                    filterNames = new String[]{NbBundle.getMessage(FilterMappingPanel.class, (String)"LBL_no_filters")};
                    this.hasFilterNames = false;
                }
                for (int i = 0; i < filterNames.length; ++i) {
                    this.filterNameCB.addItem(filterNames[i]);
                }
                String filterName = fm.getFilterName();
                if (filterName != null) {
                    this.filterNameCB.setSelectedItem(filterName);
                }
                if (servletNames == null || servletNames.length == 0) {
                    servletNames = new String[]{NbBundle.getMessage(FilterMappingPanel.class, (String)"LBL_no_servlets")};
                    this.hasServletNames = false;
                }
                this.myServletNameList.setModel(new DefaultComboBoxModel<String>(servletNames));
                if (!this.hasServletNames) {
                    this.jRadioButton2.setEnabled(false);
                }
                if (!this.isMultipleUrlServlet) {
                    this.myServletNameList.setSelectionMode(0);
                    this.jPanel2.remove(this.myComment);
                }
                selectedServletNames = null;
                urlPatterns = null;
                try {
                    selectedServletNames = fm.getServletNames();
                }
                catch (VersionNotSupportedException ex) {
                    if (fm.getServletName() == null) break block22;
                    selectedServletNames = new String[]{fm.getServletName()};
                }
            }
            try {
                urlPatterns = fm.getUrlPatterns();
            }
            catch (VersionNotSupportedException ex) {
                if (fm.getUrlPattern() == null) break block23;
                urlPatterns = new String[]{fm.getUrlPattern()};
            }
        }
        if (selectedServletNames != null && selectedServletNames.length > 0) {
            this.jRadioButton2.setSelected(true);
            this.urlTF.setEnabled(false);
            LinkedList indeces = new LinkedList();
            HashSet<String> servletSet = new HashSet<String>(Arrays.asList(selectedServletNames));
            for (int i = 0; i < servletNames.length; ++i) {
                if (!servletSet.contains(servletNames[i])) continue;
                this.myServletNameList.addSelectionInterval(i, i);
            }
        } else {
            if (urlPatterns != null) {
                StringBuilder builder = new StringBuilder();
                for (String url : urlPatterns) {
                    builder.append(url);
                    builder.append(", ");
                }
                if (builder.length() > 0) {
                    this.urlTF.setText(builder.substring(0, builder.length() - 2));
                }
            }
            this.jRadioButton1.setSelected(true);
            this.myServletNameList.setEnabled(false);
        }
        try {
            String[] dispTypes = fm.getDispatcher();
            for (int i = 0; i < dispTypes.length; ++i) {
                if (dispatcherTypes[0].equals(dispTypes[i])) {
                    this.jCheckBox1.setSelected(true);
                    continue;
                }
                if (dispatcherTypes[1].equals(dispTypes[i])) {
                    this.jCheckBox2.setSelected(true);
                    continue;
                }
                if (dispatcherTypes[2].equals(dispTypes[i])) {
                    this.jCheckBox3.setSelected(true);
                    continue;
                }
                if (!dispatcherTypes[3].equals(dispTypes[i])) continue;
                this.jCheckBox4.setSelected(true);
            }
        }
        catch (VersionNotSupportedException ex) {
            // empty catch block
        }
    }

    JTextField getUrlTF() {
        return this.urlTF;
    }

    JList getServletNamesList() {
        return this.myServletNameList;
    }

    JRadioButton getUrlRB() {
        return this.jRadioButton1;
    }

    JRadioButton getServletNameRB() {
        return this.jRadioButton2;
    }

    String getUrlPattern() {
        return this.jRadioButton1.isSelected() ? this.urlTF.getText().trim() : null;
    }

    String[] getServletNames() {
        if (this.jRadioButton2.isSelected()) {
            Object[] selected = this.myServletNameList.getSelectedValues();
            return Arrays.asList(selected).toArray(new String[selected.length]);
        }
        return null;
    }

    String getFilterName() {
        return this.hasFilterNames ? (String)this.filterNameCB.getSelectedItem() : null;
    }

    String[] getDispatcherTypes() {
        ArrayList<String> list = new ArrayList<String>(4);
        if (this.jCheckBox1.isSelected()) {
            list.add(dispatcherTypes[0]);
        }
        if (this.jCheckBox2.isSelected()) {
            list.add(dispatcherTypes[1]);
        }
        if (this.jCheckBox3.isSelected()) {
            list.add(dispatcherTypes[2]);
        }
        if (this.jCheckBox4.isSelected()) {
            list.add(dispatcherTypes[3]);
        }
        String[] ret = new String[list.size()];
        list.toArray(ret);
        return ret;
    }

    boolean hasFilterNames() {
        return this.hasFilterNames;
    }

    boolean hasServletNames() {
        return this.hasServletNames;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.filterNameCB = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.urlTF = new JTextField();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.myComment = new JLabel();
        this.myScrollPane = new JScrollPane();
        this.myServletNameList = new JList();
        this.jLabel2 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.filterNameCB);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(FilterMappingPanel.class, (String)"LBL_filterName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        this.add((Component)this.filterNameCB, gridBagConstraints);
        this.filterNameCB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FilterMappingPanel.class, (String)"ACSD_filter_name"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(FilterMappingPanel.class, (String)"LBL_dispatcherTypes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.add(this.jCheckBox1);
        this.jCheckBox1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FilterMappingPanel.class, (String)"ACSD_req_box"));
        this.jPanel1.add(this.jCheckBox2);
        this.jCheckBox2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FilterMappingPanel.class, (String)"ACSD_fw_box"));
        this.jPanel1.add(this.jCheckBox3);
        this.jCheckBox3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FilterMappingPanel.class, (String)"ACSD_inc_box"));
        this.jPanel1.add(this.jCheckBox4);
        this.jCheckBox4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FilterMappingPanel.class, (String)"ACSD_err_box"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel2.setLayout(new GridBagLayout());
        this.urlTF.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel2.add((Component)this.urlTF, gridBagConstraints);
        this.urlTF.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FilterMappingPanel.class, (String)"ACSD_filter_mapping_url_text_field"));
        this.urlTF.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FilterMappingPanel.class, (String)"ACSD_filter_mapping_url_text_field"));
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton1, (String)NbBundle.getMessage(FilterMappingPanel.class, (String)"LBL_urlPattern"));
        this.jRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterMappingPanel.this.jRadioButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 7, 0, 0);
        this.jPanel2.add((Component)this.jRadioButton1, gridBagConstraints);
        this.jRadioButton1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FilterMappingPanel.class, (String)"ACSD_url_pattern"));
        this.buttonGroup1.add(this.jRadioButton2);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton2, (String)NbBundle.getMessage(FilterMappingPanel.class, (String)"LBL_servletName"));
        this.jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterMappingPanel.this.jRadioButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 7, 5, 0);
        this.jPanel2.add((Component)this.jRadioButton2, gridBagConstraints);
        this.jRadioButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FilterMappingPanel.class, (String)"ACSD_servlet_name"));
        Mnemonics.setLocalizedText((JLabel)this.myComment, (String)NbBundle.getMessage(FilterMappingPanel.class, (String)"HINT_urlPatterns"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel2.add((Component)this.myComment, gridBagConstraints);
        this.myServletNameList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.myServletNameList.setVisibleRowCount(2);
        this.myScrollPane.setViewportView(this.myServletNameList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.myScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.jPanel2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(FilterMappingPanel.class, (String)"LBL_applyTo"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.urlTF.setEnabled(false);
        this.myServletNameList.setEnabled(true);
        this.jRadioButton2.requestFocus();
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.urlTF.setEnabled(true);
        this.myServletNameList.setEnabled(false);
        this.urlTF.requestFocus();
    }
}

