/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.math.BigInteger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.common.RunAs;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.BrowseFolders;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.DDUtils;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.InitParamTableModel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.InitParamsPanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.RunAsPanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityRoleRefTableModel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityRoleRefTablePanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.cookies.LinkCookie;
import org.netbeans.modules.xml.multiview.ui.LinkButton;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ServletPanel
extends SectionInnerPanel
implements ActionListener {
    private DDDataObject dObj;
    private Servlet servlet;
    private JButton linkServletClass;
    private JButton linkJspFile;
    private InitParamsPanel initParamsPanel;
    private JComboBox runAsCB;
    private JButton browseButton;
    private JButton browseButton1;
    private ButtonGroup buttonGroup1;
    private JLabel descriptionLabel;
    private JTextArea descriptionTA;
    private JPanel filler;
    private JLabel initParamsLabel;
    private JLabel jLabel1;
    private JRadioButton jspFileRB;
    private JTextField jspFileTF;
    private JLabel orderLabel;
    private JTextField orderTF;
    private JRadioButton servletClassRB;
    private JTextField servletClassTF;
    private JLabel servletMappingLabel;
    private JTextField servletMappingsTF;
    private JLabel servletNameLabel;
    private JTextField servletNameTF;

    public ServletPanel(SectionView sectionView, DDDataObject dObj, Servlet servlet) {
        super(sectionView);
        this.dObj = dObj;
        this.servlet = servlet;
        this.initComponents();
        this.servletNameTF.setText(servlet.getServletName());
        this.addValidatee(this.servletNameTF);
        Utils.makeTextAreaLikeTextField((JTextArea)this.descriptionTA, (JTextField)this.servletNameTF);
        this.descriptionTA.setText(servlet.getDefaultDescription());
        this.addModifier(this.descriptionTA);
        BigInteger los = servlet.getLoadOnStartup();
        this.orderTF.setText(los == null ? "" : los.toString());
        this.addValidatee(this.orderTF);
        String jspFile = servlet.getJspFile();
        if (jspFile != null) {
            this.jspFileRB.setSelected(true);
            this.servletClassTF.setEnabled(false);
            this.browseButton.setEnabled(false);
            this.jspFileTF.setText(jspFile);
        } else {
            this.servletClassRB.setSelected(true);
            this.jspFileTF.setEnabled(false);
            this.browseButton1.setEnabled(false);
            this.servletClassTF.setText(servlet.getServletClass());
        }
        this.servletClassRB.addActionListener(this);
        this.jspFileRB.addActionListener(this);
        this.addValidatee(this.servletClassTF);
        this.addValidatee(this.jspFileTF);
        String[] urlPatterns = DDUtils.getUrlPatterns(dObj.getWebApp(), servlet);
        this.servletMappingsTF.setText(DDUtils.urlPatternList(urlPatterns));
        this.addValidatee(this.servletMappingsTF);
        InitParamTableModel model = new InitParamTableModel();
        this.initParamsPanel = new InitParamsPanel(dObj, model);
        this.initParamsPanel.setModel(servlet, servlet.getInitParam());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 10, 0, 0);
        this.add((Component)((Object)this.initParamsPanel), gridBagConstraints);
        JLabel securityRoleRefsLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)securityRoleRefsLabel, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_SecurityRoleRefs"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 0, 0);
        this.add(securityRoleRefsLabel, gridBagConstraints);
        SecurityRoleRefTableModel roleRefModel = new SecurityRoleRefTableModel();
        SecurityRoleRefTablePanel roleRefPanel = new SecurityRoleRefTablePanel(dObj, roleRefModel);
        roleRefPanel.setModel(dObj.getWebApp(), servlet, servlet.getSecurityRoleRef());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 10, 0, 0);
        this.add((Component)((Object)roleRefPanel), gridBagConstraints);
        RunAsPanel runAsPanel = new RunAsPanel(dObj.getWebApp());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 10, 0, 0);
        this.add(runAsPanel, gridBagConstraints);
        this.runAsCB = runAsPanel.getRunAsCB();
        RunAs runAs = servlet.getRunAs();
        if (runAs == null) {
            this.runAsCB.setSelectedItem("");
        } else {
            this.runAsCB.setSelectedItem(runAs.getRoleName());
        }
        this.addModifier(this.runAsCB);
        this.linkServletClass = new LinkButton((LinkCookie)this, (Object)servlet, "ClassName");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        Mnemonics.setLocalizedText((AbstractButton)this.linkServletClass, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_goToSource"));
        this.add(this.linkServletClass, gridBagConstraints);
        this.linkJspFile = new LinkButton((LinkCookie)this, (Object)servlet, "JspFile");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        Mnemonics.setLocalizedText((AbstractButton)this.linkJspFile, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_goToSource_2"));
        this.add(this.linkJspFile, gridBagConstraints);
        this.setAccessibility();
    }

    private void setAccessibility() {
        this.initParamsLabel.setLabelFor(this.initParamsPanel.getTable());
    }

    public void linkButtonPressed(Object ddBean, String property) {
        if ("ClassName".equals(property)) {
            DDUtils.openEditorFor(this.dObj, ((Servlet)ddBean).getServletClass());
        } else if ("JspFile".equals(property)) {
            DDUtils.openEditorForSingleFile(this.dObj, ((Servlet)ddBean).getJspFile());
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.servletNameLabel = new JLabel();
        this.servletNameTF = new JTextField();
        this.orderLabel = new JLabel();
        this.orderTF = new JTextField();
        this.descriptionLabel = new JLabel();
        this.descriptionTA = new JTextArea();
        this.servletClassRB = new JRadioButton();
        this.servletClassTF = new JTextField();
        this.browseButton = new JButton();
        this.jspFileRB = new JRadioButton();
        this.jspFileTF = new JTextField();
        this.browseButton1 = new JButton();
        this.servletMappingLabel = new JLabel();
        this.servletMappingsTF = new JTextField();
        this.jLabel1 = new JLabel();
        this.initParamsLabel = new JLabel();
        this.filler = new JPanel();
        this.setLayout(new GridBagLayout());
        this.servletNameLabel.setLabelFor(this.servletNameTF);
        Mnemonics.setLocalizedText((JLabel)this.servletNameLabel, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_servletName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.servletNameLabel, gridBagConstraints);
        this.servletNameTF.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.servletNameTF, gridBagConstraints);
        this.orderLabel.setLabelFor(this.orderTF);
        Mnemonics.setLocalizedText((JLabel)this.orderLabel, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_order"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        this.add(this.orderLabel, gridBagConstraints);
        this.orderTF.setColumns(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.orderTF, gridBagConstraints);
        this.descriptionLabel.setLabelFor(this.descriptionTA);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.descriptionLabel, gridBagConstraints);
        this.descriptionTA.setRows(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.descriptionTA, gridBagConstraints);
        this.buttonGroup1.add(this.servletClassRB);
        Mnemonics.setLocalizedText((AbstractButton)this.servletClassRB, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_servletClass"));
        this.servletClassRB.setHorizontalTextPosition(4);
        this.servletClassRB.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.add(this.servletClassRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.servletClassTF, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_browse"));
        this.browseButton.setMargin(new Insets(0, 14, 0, 14));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServletPanel.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 10, 0, 0);
        this.add(this.browseButton, gridBagConstraints);
        this.buttonGroup1.add(this.jspFileRB);
        Mnemonics.setLocalizedText((AbstractButton)this.jspFileRB, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_jspFile"));
        this.jspFileRB.setHorizontalTextPosition(4);
        this.jspFileRB.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.add(this.jspFileRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.jspFileTF, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton1, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_browse_2"));
        this.browseButton1.setMargin(new Insets(0, 14, 0, 14));
        this.browseButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServletPanel.this.browseButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 10, 0, 0);
        this.add(this.browseButton1, gridBagConstraints);
        this.servletMappingLabel.setLabelFor(this.servletMappingsTF);
        Mnemonics.setLocalizedText((JLabel)this.servletMappingLabel, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_urlPatterns"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add(this.servletMappingLabel, gridBagConstraints);
        this.servletMappingsTF.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.servletMappingsTF, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ServletPanel.class, (String)"HINT_urlPatterns"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.add(this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.initParamsLabel, (String)NbBundle.getMessage(ServletPanel.class, (String)"LBL_initParams"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 0, 0);
        this.add(this.initParamsLabel, gridBagConstraints);
        this.filler.setBackground(new Color(255, 255, 255));
        this.filler.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.filler, gridBagConstraints);
    }

    private void browseButton1ActionPerformed(ActionEvent evt) {
        try {
            String res;
            SourceGroup[] groups = DDUtils.getDocBaseGroups(this.dObj);
            FileObject fo = BrowseFolders.showDialog(groups);
            if (fo != null && !(res = "/" + DDUtils.getResourcePath(groups, fo, '/', true)).equals(this.jspFileTF.getText())) {
                this.dObj.modelUpdatedFromUI();
                this.jspFileTF.setText(res);
                this.dObj.setChangedFromUI(true);
                this.servlet.setJspFile(res);
                this.dObj.setChangedFromUI(false);
                this.getSectionView().checkValidity();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        try {
            String className;
            SourceGroup[] groups = DDUtils.getJavaSourceGroups(this.dObj);
            FileObject fo = BrowseFolders.showDialog(groups);
            if (fo != null && (className = DDUtils.getResourcePath(groups, fo)).length() > 0 && !className.equals(this.servletClassTF.getText())) {
                this.dObj.modelUpdatedFromUI();
                this.servletClassTF.setText(className);
                this.dObj.setChangedFromUI(true);
                this.servlet.setServletClass(className);
                this.dObj.setChangedFromUI(false);
                this.getSectionView().checkValidity();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.servletClassRB.isSelected()) {
            this.servletClassTF.setEnabled(true);
            this.jspFileTF.setEnabled(false);
            this.browseButton.setEnabled(true);
            this.browseButton1.setEnabled(false);
            String servletClass = this.servletClassTF.getText().trim();
            if (servletClass.length() > 0 && !servletClass.equals(this.servlet.getServletClass())) {
                this.dObj.modelUpdatedFromUI();
                this.dObj.setChangedFromUI(true);
                this.servlet.setServletClass(servletClass);
                this.dObj.setChangedFromUI(false);
                this.getSectionView().checkValidity();
            }
        } else {
            this.servletClassTF.setEnabled(false);
            this.jspFileTF.setEnabled(true);
            this.browseButton.setEnabled(false);
            this.browseButton1.setEnabled(true);
            String jspFile = this.jspFileTF.getText().trim();
            if (jspFile.length() > 0 && !jspFile.equals(this.servlet.getJspFile())) {
                this.dObj.modelUpdatedFromUI();
                this.dObj.setChangedFromUI(true);
                this.servlet.setJspFile(jspFile);
                this.dObj.setChangedFromUI(false);
                this.getSectionView().checkValidity();
            }
        }
    }

    public JComponent getErrorComponent(String name) {
        if ("ServletName".equals(name)) {
            return this.servletNameTF;
        }
        if ("ServletClass".equals(name)) {
            return this.servletClassTF;
        }
        if ("JspFile".equals(name)) {
            return this.jspFileTF;
        }
        if ("ServletMapping".equals(name)) {
            return this.servletMappingsTF;
        }
        return null;
    }

    public void documentChanged(JTextComponent comp, String value) {
        if (comp == this.servletNameTF) {
            String val = value;
            if (val.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, "Servlet Name", (JComponent)this.servletNameTF));
                return;
            }
            Servlet[] servlets = this.dObj.getWebApp().getServlet();
            for (int i = 0; i < servlets.length; ++i) {
                if (this.servlet == servlets[i] || !val.equals(servlets[i].getServletName())) continue;
                this.getSectionView().getErrorPanel().setError(new Error(0, 3, val, (JComponent)this.servletNameTF));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        } else if (comp == this.servletClassTF) {
            String text = value;
            if (text.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, "Servlet Class", (JComponent)this.servletClassTF));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        } else if (comp == this.jspFileTF) {
            String text = value;
            if (text.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, "Jsp File", (JComponent)this.jspFileTF));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        } else if (comp == this.servletMappingsTF) {
            String text = value;
            String[] patterns = DDUtils.getStringArray(text);
            for (int i = 0; i < patterns.length; ++i) {
                String errorMessage = DDUtils.checkServletMappig(patterns[i]);
                if (errorMessage != null) {
                    this.getSectionView().getErrorPanel().setError(new Error(0, errorMessage, (JComponent)this.servletMappingsTF));
                    return;
                }
                if (!DDUtils.isServletMapping(this.dObj.getWebApp(), this.servlet, patterns[i])) continue;
                this.getSectionView().getErrorPanel().setError(new Error(3, patterns[i], (JComponent)this.servletMappingsTF));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        } else if (comp == this.orderTF) {
            String text = value;
            BigInteger los = null;
            try {
                los = new BigInteger(text);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (los == null) {
                this.getSectionView().getErrorPanel().setError(new Error(0, 0, "Invalid Value : " + text, (JComponent)this.orderTF));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        }
    }

    public void setValue(JComponent source, Object value) {
        if (source == this.servletNameTF) {
            String text = (String)value;
            ServletMapping[] maps = DDUtils.getServletMappings(this.dObj.getWebApp(), this.servlet);
            for (int i = 0; i < maps.length; ++i) {
                maps[i].setServletName(text);
            }
            FilterMapping[] filterMappings = DDUtils.getFilterMappings(this.dObj.getWebApp(), this.servlet);
            for (int i = 0; i < filterMappings.length; ++i) {
                filterMappings[i].setServletName(text);
            }
            this.servlet.setServletName(text);
            SectionPanel enclosingPanel = this.getSectionView().findSectionPanel((Object)this.servlet);
            enclosingPanel.setTitle(((ServletsMultiViewElement.ServletsView)this.getSectionView()).getServletTitle(this.servlet));
            enclosingPanel.getNode().setDisplayName(text);
        } else if (source == this.servletClassTF) {
            String text = (String)value;
            this.servlet.setServletClass(text.length() == 0 ? null : text);
        } else if (source == this.jspFileTF) {
            String text = (String)value;
            this.servlet.setJspFile(text.length() == 0 ? null : text);
        } else if (source == this.descriptionTA) {
            String text = (String)value;
            this.servlet.setDescription(text.length() == 0 ? null : text);
        } else if (source == this.servletMappingsTF) {
            DDUtils.setServletMappings(this.dObj.getWebApp(), this.servlet, DDUtils.getStringArray((String)value));
            SectionPanel enclosingPanel = this.getSectionView().findSectionPanel((Object)this.servlet);
            enclosingPanel.setTitle(((ServletsMultiViewElement.ServletsView)this.getSectionView()).getServletTitle(this.servlet));
        } else if (source == this.orderTF) {
            String text = (String)value;
            this.servlet.setLoadOnStartup(text.length() == 0 ? null : new BigInteger(text));
        } else if (source == this.runAsCB) {
            String text = (String)this.runAsCB.getSelectedItem();
            if (text.length() == 0) {
                this.servlet.setRunAs(null);
            } else {
                try {
                    RunAs runAs = (RunAs)this.dObj.getWebApp().createBean("RunAs");
                    runAs.setRoleName(text);
                    this.servlet.setRunAs(runAs);
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void rollbackValue(JTextComponent source) {
        if (source == this.servletNameTF) {
            this.servletNameTF.setText(this.servlet.getServletName());
        } else if (source == this.servletClassTF) {
            this.servletClassTF.setText(this.servlet.getServletClass());
        } else if (source == this.jspFileTF) {
            this.jspFileTF.setText(this.servlet.getJspFile());
        } else if (source == this.servletMappingsTF) {
            String[] urlPatterns = DDUtils.getUrlPatterns(this.dObj.getWebApp(), this.servlet);
            this.servletMappingsTF.setText(DDUtils.urlPatternList(urlPatterns));
        } else if (source == this.orderTF) {
            BigInteger los = this.servlet.getLoadOnStartup();
            this.orderTF.setText(los == null ? "" : los.toString());
        }
    }

    protected void startUIChange() {
        this.dObj.setChangedFromUI(true);
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
        this.dObj.setChangedFromUI(false);
    }
}

