/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2se;

import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.modules.profiler.j2se.J2SEProjectProfilingSupportProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;

public class JFXProjectProfilingSupportProvider
extends J2SEProjectProfilingSupportProvider {
    static final String JAVAFX_ENABLED = "javafx.enabled";

    public JFXProjectProfilingSupportProvider(Project p) {
        super(p);
    }

    @Override
    public boolean checkProjectCanBeProfiled(FileObject profiledClassFile) {
        if (profiledClassFile == null && this.isFXProject()) {
            Project p = this.getProject();
            PropertyEvaluator pp = this.getProjectProperties(p);
            String profiledClass = pp.getProperty("main.class");
            return profiledClass != null && !"".equals(profiledClass);
        }
        return super.checkProjectCanBeProfiled(profiledClassFile);
    }

    @Override
    protected void setMainClass(PropertyEvaluator pp, SessionSettings ss) {
        String jdkVersion = this.getProjectJavaPlatform().getPlatformJDKVersion();
        String fxMainClassProp = pp.getProperty("javafx.main.class");
        if (this.mainClassSetManually == null) {
            String mainClass = jdkVersion != null && (jdkVersion.equals("jdk18") || jdkVersion.equals("jdk19")) && fxMainClassProp != null ? fxMainClassProp : pp.getProperty("main.class");
            ss.setMainClass(mainClass != null ? mainClass : "");
        } else {
            ss.setMainClass(this.mainClassSetManually);
        }
    }

    private boolean isFXProject() {
        PropertyEvaluator ep = this.getProjectProperties(this.getProject());
        if (ep == null) {
            return false;
        }
        return JFXProjectProfilingSupportProvider.isTrue(ep.getProperty(JAVAFX_ENABLED));
    }

    private static boolean isTrue(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on"));
    }
}

