/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.javac;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.profiler.nbimpl.javac.ScanSensitiveTask;
import org.openide.filesystems.FileObject;

public class ParsingUtils {
    private static final Logger LOG = Logger.getLogger(ParsingUtils.class.getName());

    public static void invokeScanSensitiveTask(ClasspathInfo cpInfo, ScanSensitiveTask<CompilationController> t) {
        ParsingUtils.invokeScanSensitiveTask(JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]), t);
    }

    public static void invokeScanSensitiveTask(JavaSource js, ScanSensitiveTask<CompilationController> t) {
        try {
            boolean wasScanning = SourceUtils.isScanInProgress();
            if (!t.requiresUpToDate()) {
                js.runUserActionTask(t, true);
            }
            if (t.requiresUpToDate() || wasScanning && t.shouldRetry()) {
                js.runWhenScanFinished(t, true).get();
            }
        }
        catch (IllegalArgumentException e) {
            LOG.log(Level.SEVERE, null, e);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, null, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOG.log(Level.SEVERE, null, e);
        }
    }
}

