/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupportFactory;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.Parameters;
import org.openide.util.Union2;

public final class ClassPathProviderImpl
implements ClassPathProvider {
    private static final String buildGeneratedDir = "build.generated.sources.dir";
    private static final String[] processorTestClasspath = new String[]{"javac.test.processorpath"};
    private final AntProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testSourceRoots;
    private final String buildClassesDir;
    private final String distJar;
    private final String buildTestClassesDir;
    private final String[] javacClasspath;
    private final String[] processorClasspath;
    private final String[] javacTestClasspath;
    private final String[] runClasspath;
    private final String[] runTestClasspath;
    private final String[] endorsedClasspath;
    private final Union2<String, String[]> platform;
    private final ClassPath[] cache = new ClassPath[11];
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();
    private PropertyChangeListener listener;

    public ClassPathProviderImpl(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testSourceRoots) {
        this(helper, evaluator, sourceRoots, testSourceRoots, "build.classes.dir", "dist.jar", "build.test.classes.dir", Builder.DEFAULT_JAVAC_CLASS_PATH, Builder.DEFAULT_JAVAC_TEST_CLASS_PATH, Builder.DEFAULT_RUN_CLASS_PATH, Builder.DEFAULT_RUN_TEST_CLASS_PATH);
    }

    public ClassPathProviderImpl(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testSourceRoots, String buildClassesDir, String distJar, String buildTestClassesDir, String[] javacClasspath, String[] javacTestClasspath, String[] runClasspath, String[] runTestClasspath) {
        this(helper, evaluator, sourceRoots, testSourceRoots, buildClassesDir, distJar, buildTestClassesDir, javacClasspath, javacTestClasspath, runClasspath, runTestClasspath, Builder.DEFAULT_ENDORSED_CLASSPATH);
    }

    public ClassPathProviderImpl(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testSourceRoots, String buildClassesDir, String distJar, String buildTestClassesDir, String[] javacClasspath, String[] javacTestClasspath, String[] runClasspath, String[] runTestClasspath, String[] endorsedClasspath) {
        this(helper, evaluator, sourceRoots, testSourceRoots, buildClassesDir, distJar, buildTestClassesDir, javacClasspath, Builder.DEFAULT_PROCESSOR_PATH, javacTestClasspath, runClasspath, runTestClasspath, endorsedClasspath);
    }

    public ClassPathProviderImpl(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testSourceRoots, String buildClassesDir, String distJar, String buildTestClassesDir, String[] javacClasspath, String[] processorPath, String[] javacTestClasspath, String[] runClasspath, String[] runTestClasspath, String[] endorsedClasspath) {
        this(helper, evaluator, sourceRoots, testSourceRoots, buildClassesDir, distJar, buildTestClassesDir, javacClasspath, processorPath, javacTestClasspath, runClasspath, runTestClasspath, endorsedClasspath, (Union2<String, String[]>)Union2.createFirst((Object)"j2se"));
    }

    private ClassPathProviderImpl(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator evaluator, @NonNull SourceRoots sourceRoots, @NonNull SourceRoots testSourceRoots, @NonNull String buildClassesDir, @NonNull String distJar, @NonNull String buildTestClassesDir, @NonNull String[] javacClasspath, @NonNull String[] processorPath, @NonNull String[] javacTestClasspath, @NonNull String[] runClasspath, @NonNull String[] runTestClasspath, @NonNull String[] endorsedClasspath, @NonNull Union2<String, String[]> platform) {
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        Parameters.notNull((CharSequence)"evaluator", (Object)evaluator);
        Parameters.notNull((CharSequence)"sourceRoots", (Object)sourceRoots);
        Parameters.notNull((CharSequence)"testSourceRoots", (Object)testSourceRoots);
        Parameters.notNull((CharSequence)"buildClassesDir", (Object)buildClassesDir);
        Parameters.notNull((CharSequence)"distJar", (Object)distJar);
        Parameters.notNull((CharSequence)"buildTestClassesDir", (Object)buildTestClassesDir);
        Parameters.notNull((CharSequence)"javacClasspath", (Object)javacClasspath);
        Parameters.notNull((CharSequence)"processorPath", (Object)processorPath);
        Parameters.notNull((CharSequence)"javacTestClasspath", (Object)javacTestClasspath);
        Parameters.notNull((CharSequence)"runClasspath", (Object)runClasspath);
        Parameters.notNull((CharSequence)"runTestClasspath", (Object)runTestClasspath);
        Parameters.notNull((CharSequence)"endorsedClasspath", (Object)endorsedClasspath);
        Parameters.notNull((CharSequence)"platform", platform);
        this.helper = helper;
        this.projectDirectory = FileUtil.toFile((FileObject)helper.getProjectDirectory());
        assert (this.projectDirectory != null);
        this.evaluator = evaluator;
        this.sourceRoots = sourceRoots;
        this.testSourceRoots = testSourceRoots;
        this.buildClassesDir = buildClassesDir;
        this.distJar = distJar;
        this.buildTestClassesDir = buildTestClassesDir;
        this.javacClasspath = javacClasspath;
        this.processorClasspath = processorPath;
        this.javacTestClasspath = javacTestClasspath;
        this.runClasspath = runClasspath;
        this.runTestClasspath = runTestClasspath;
        this.endorsedClasspath = endorsedClasspath;
        this.platform = platform;
    }

    private FileObject getDir(final String propname) {
        return (FileObject)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject run() {
                ClassPathProviderImpl classPathProviderImpl = ClassPathProviderImpl.this;
                synchronized (classPathProviderImpl) {
                    String prop;
                    FileObject fo = (FileObject)ClassPathProviderImpl.this.dirCache.get(propname);
                    if (!(fo != null && fo.isValid() || (prop = ClassPathProviderImpl.this.evaluator.getProperty(propname)) == null)) {
                        fo = ClassPathProviderImpl.this.helper.resolveFileObject(prop);
                        ClassPathProviderImpl.this.dirCache.put(propname, fo);
                    }
                    return fo;
                }
            }
        });
    }

    private FileObject[] getPrimarySrcPath() {
        return this.sourceRoots.getRoots();
    }

    private FileObject[] getTestSrcDir() {
        return this.testSourceRoots.getRoots();
    }

    private FileObject getBuildClassesDir() {
        return this.getDir(this.buildClassesDir);
    }

    private FileObject getBuildGeneratedDir() {
        return this.getDir(buildGeneratedDir);
    }

    private FileObject getDistJar() {
        return this.getDir(this.distJar);
    }

    private FileObject getBuildTestClassesDir() {
        return this.getDir(this.buildTestClassesDir);
    }

    private FileObject getAnnotationProcessingSourceOutputDir() {
        return this.getDir("annotation.processing.source.output");
    }

    private int getType(FileObject file) {
        FileObject root;
        int i;
        FileObject[] srcPath = this.getPrimarySrcPath();
        for (i = 0; i < srcPath.length; ++i) {
            root = srcPath[i];
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return 0;
        }
        srcPath = this.getTestSrcDir();
        for (i = 0; i < srcPath.length; ++i) {
            root = srcPath[i];
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return 1;
        }
        FileObject dir = this.getBuildClassesDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 2;
        }
        dir = this.getDistJar();
        if (dir != null && dir.equals(FileUtil.getArchiveFile((FileObject)file))) {
            return 4;
        }
        dir = this.getBuildTestClassesDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 3;
        }
        dir = this.getBuildGeneratedDir();
        if (dir != null && FileUtil.isParentOf((FileObject)dir, (FileObject)file)) {
            dir = this.getAnnotationProcessingSourceOutputDir();
            if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    private ClassPath getCompileTimeClasspath(FileObject file) {
        int type = this.getType(file);
        return this.getCompileTimeClasspath(type);
    }

    private synchronized ClassPath getCompileTimeClasspath(int type) {
        if (type < 0 || type > 1) {
            return null;
        }
        ClassPath cp = this.cache[2 + type];
        if (cp == null) {
            cp = type == 0 ? ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.javacClasspath)) : ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.javacTestClasspath));
            this.cache[2 + type] = cp;
        }
        return cp;
    }

    private ClassPath getProcessorClasspath(FileObject file) {
        int type = this.getType(file);
        return this.getProcessorClasspath(type);
    }

    private synchronized ClassPath getProcessorClasspath(int type) {
        if (type < 0 || type > 1) {
            return null;
        }
        ClassPath cp = this.cache[9 + type];
        if (cp == null) {
            cp = type == 0 ? ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.processorClasspath)) : ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])processorTestClasspath));
            this.cache[9 + type] = cp;
        }
        return cp;
    }

    private ClassPath getRunTimeClasspath(FileObject file) {
        int type = this.getType(file);
        if (type < 0 || type > 4) {
            return null;
        }
        return this.getRunTimeClasspath(type);
    }

    private synchronized ClassPath getRunTimeClasspath(int type) {
        int cacheIndex;
        if (type == 0 || type == 2) {
            cacheIndex = 4;
        } else if (type == 1 || type == 3) {
            cacheIndex = 5;
        } else if (type == 4) {
            cacheIndex = 6;
        } else {
            return null;
        }
        ClassPath cp = this.cache[cacheIndex];
        if (cp == null) {
            if (type == 0 || type == 2) {
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.runClasspath));
            } else if (type == 1 || type == 3) {
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.runTestClasspath));
            } else if (type == 4) {
                String[] props = new String[this.runClasspath.length + 1];
                System.arraycopy(this.runClasspath, 0, props, 1, this.runClasspath.length);
                props[0] = this.distJar;
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])props));
            }
            this.cache[cacheIndex] = cp;
        }
        return cp;
    }

    private synchronized ClassPath getEndorsedClasspath() {
        ClassPath cp = this.cache[8];
        if (cp == null) {
            this.cache[8] = cp = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.endorsedClasspath));
        }
        return cp;
    }

    private ClassPath getSourcepath(FileObject file) {
        int type = this.getType(file);
        return this.getSourcepath(type);
    }

    @CheckForNull
    private synchronized ClassPath getSourcepath(int type) {
        if (type < 0 || type > 1) {
            return null;
        }
        ClassPath cp = this.cache[type];
        if (cp == null) {
            switch (type) {
                case 0: {
                    cp = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupportFactory.createSourcePathImplementation(this.sourceRoots, this.helper, this.evaluator));
                    break;
                }
                case 1: {
                    cp = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupportFactory.createSourcePathImplementation(this.testSourceRoots, this.helper, this.evaluator));
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid classpath type: " + type);
                }
            }
            this.cache[type] = cp;
        }
        return cp;
    }

    private synchronized ClassPath getBootClassPath() {
        ClassPath cp = this.cache[7];
        if (cp == null) {
            if (this.platform.hasFirst()) {
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupportFactory.createBootClassPathImplementation(this.evaluator, this.getEndorsedClasspath(), (String)this.platform.first()));
            } else {
                assert (this.platform.hasSecond());
                cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.getEndorsedClasspath(), ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])((String[])this.platform.second())))});
            }
            this.cache[7] = cp;
        }
        return cp;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        if (type.equals("classpath/compile")) {
            return this.getCompileTimeClasspath(file);
        }
        if (type.equals("classpath/processor")) {
            return this.getProcessorClasspath(file);
        }
        if (type.equals("classpath/execute")) {
            return this.getRunTimeClasspath(file);
        }
        if (type.equals("classpath/source")) {
            return this.getSourcepath(file);
        }
        if (type.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        if (type.equals("classpath/endorsed")) {
            return this.getEndorsedClasspath();
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(final String type) {
        return (ClassPath[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<ClassPath[]>(){

            public ClassPath[] run() {
                if ("classpath/boot".equals(type)) {
                    return new ClassPath[]{ClassPathProviderImpl.this.getBootClassPath()};
                }
                if ("classpath/compile".equals(type)) {
                    ClassPath[] l = new ClassPath[]{ClassPathProviderImpl.this.getCompileTimeClasspath(0), ClassPathProviderImpl.this.getCompileTimeClasspath(1)};
                    return l;
                }
                if ("classpath/processor".equals(type)) {
                    ClassPath[] l = new ClassPath[]{ClassPathProviderImpl.this.getProcessorClasspath(0), ClassPathProviderImpl.this.getProcessorClasspath(1)};
                    return l;
                }
                if ("classpath/source".equals(type)) {
                    ClassPath[] l = new ClassPath[]{ClassPathProviderImpl.this.getSourcepath(0), ClassPathProviderImpl.this.getSourcepath(1)};
                    return l;
                }
                assert (false);
                return null;
            }
        });
    }

    public ClassPath getProjectSourcesClassPath(String type) {
        if ("classpath/boot".equals(type)) {
            return this.getBootClassPath();
        }
        if ("classpath/compile".equals(type)) {
            return this.getCompileTimeClasspath(0);
        }
        if ("classpath/processor".equals(type)) {
            return this.getProcessorClasspath(0);
        }
        if ("classpath/source".equals(type)) {
            return this.getSourcepath(0);
        }
        if ("classpath/execute".equals(type)) {
            return this.getRunTimeClasspath(0);
        }
        assert (false) : "Unknown classpath type: " + type;
        return null;
    }

    public String[] getPropertyName(SourceRoots roots, String type) {
        if ("classpath/endorsed".equals(type)) {
            return this.endorsedClasspath;
        }
        if (roots.isTest()) {
            if ("classpath/compile".equals(type)) {
                return this.javacTestClasspath;
            }
            if ("classpath/execute".equals(type)) {
                return this.runTestClasspath;
            }
            if ("classpath/processor".equals(type)) {
                return processorTestClasspath;
            }
            return null;
        }
        if ("classpath/compile".equals(type)) {
            return this.javacClasspath;
        }
        if ("classpath/execute".equals(type)) {
            return this.runClasspath;
        }
        if ("classpath/processor".equals(type)) {
            return this.processorClasspath;
        }
        return null;
    }

    public String[] getPropertyName(SourceGroup sg, String type) {
        int i;
        if ("classpath/endorsed".equals(type)) {
            return this.endorsedClasspath;
        }
        FileObject root = sg.getRootFolder();
        FileObject[] path = this.getPrimarySrcPath();
        for (i = 0; i < path.length; ++i) {
            if (!root.equals(path[i])) continue;
            if ("classpath/compile".equals(type)) {
                return this.javacClasspath;
            }
            if ("classpath/execute".equals(type)) {
                return this.runClasspath;
            }
            if ("classpath/processor".equals(type)) {
                return this.processorClasspath;
            }
            return null;
        }
        path = this.getTestSrcDir();
        for (i = 0; i < path.length; ++i) {
            if (!root.equals(path[i])) continue;
            if ("classpath/compile".equals(type)) {
                return this.javacTestClasspath;
            }
            if ("classpath/execute".equals(type)) {
                return this.runTestClasspath;
            }
            return null;
        }
        return null;
    }

    public static final class Builder {
        private static final String DEFAULT_BUILD_CLASSES_DIR = "build.classes.dir";
        private static final String DEFAULT_BUILD_TEST_CLASSES_DIR = "build.test.classes.dir";
        private static final String DEFAULT_DIST_JAR = "dist.jar";
        private static final String[] DEFAULT_JAVAC_CLASS_PATH = new String[]{"javac.classpath"};
        private static final String[] DEFAULT_PROCESSOR_PATH = new String[]{"javac.processorpath"};
        private static final String[] DEFAULT_JAVAC_TEST_CLASS_PATH = new String[]{"javac.test.classpath"};
        private static final String[] DEFAULT_RUN_CLASS_PATH = new String[]{"run.classpath"};
        private static final String[] DEFAULT_RUN_TEST_CLASS_PATH = new String[]{"run.test.classpath"};
        private static final String[] DEFAULT_ENDORSED_CLASSPATH = new String[]{"endorsed.classpath"};
        private final AntProjectHelper helper;
        private final PropertyEvaluator evaluator;
        private final SourceRoots sourceRoots;
        private final SourceRoots testSourceRoots;
        private String platformType = "j2se";
        private String buildClassesDir = "build.classes.dir";
        private String buildTestClassesDir = "build.test.classes.dir";
        private String distJar = "dist.jar";
        private String[] javacClasspath = DEFAULT_JAVAC_CLASS_PATH;
        private String[] processorPath = DEFAULT_PROCESSOR_PATH;
        private String[] javacTestClasspath = DEFAULT_JAVAC_TEST_CLASS_PATH;
        private String[] runClasspath = DEFAULT_RUN_CLASS_PATH;
        private String[] runTestClasspath = DEFAULT_RUN_TEST_CLASS_PATH;
        private String[] endorsedClasspath = DEFAULT_ENDORSED_CLASSPATH;
        private String[] bootClasspathProperties;

        private Builder(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator evaluator, @NonNull SourceRoots sourceRoots, @NonNull SourceRoots testSourceRoots) {
            Parameters.notNull((CharSequence)"helper", (Object)helper);
            Parameters.notNull((CharSequence)"evaluator", (Object)evaluator);
            Parameters.notNull((CharSequence)"sourceRoots", (Object)sourceRoots);
            Parameters.notNull((CharSequence)"testSourceRoots", (Object)testSourceRoots);
            this.helper = helper;
            this.evaluator = evaluator;
            this.sourceRoots = sourceRoots;
            this.testSourceRoots = testSourceRoots;
        }

        @NonNull
        public Builder setPlatformType(@NonNull String platformType) {
            Parameters.notNull((CharSequence)"platformType", (Object)platformType);
            this.platformType = platformType;
            return this;
        }

        @NonNull
        public Builder setBuildClassesDirProperty(@NonNull String buildClassesDirProperty) {
            Parameters.notNull((CharSequence)"buildClassesDirProperty", (Object)buildClassesDirProperty);
            this.buildClassesDir = buildClassesDirProperty;
            return this;
        }

        @NonNull
        public Builder setBuildTestClassesDirProperty(@NonNull String buildTestClassesDirProperty) {
            Parameters.notNull((CharSequence)"buildTestClassesDirProperty", (Object)buildTestClassesDirProperty);
            this.buildTestClassesDir = buildTestClassesDirProperty;
            return this;
        }

        @NonNull
        public Builder setDistJarProperty(@NonNull String distJarProperty) {
            Parameters.notNull((CharSequence)"distJarProperty", (Object)distJarProperty);
            this.distJar = distJarProperty;
            return this;
        }

        @NonNull
        public Builder setJavacClassPathProperties(@NonNull String[] javacClassPathProperties) {
            Parameters.notNull((CharSequence)"javacClassPathProperties", (Object)javacClassPathProperties);
            this.javacClasspath = Arrays.copyOf(javacClassPathProperties, javacClassPathProperties.length);
            return this;
        }

        @NonNull
        public Builder setProcessorPathProperties(@NonNull String[] processorPathProperties) {
            Parameters.notNull((CharSequence)"processorPathProperties", (Object)processorPathProperties);
            this.processorPath = Arrays.copyOf(processorPathProperties, processorPathProperties.length);
            return this;
        }

        @NonNull
        public Builder setJavacTestClasspathProperties(@NonNull String[] javacTestClasspathProperties) {
            Parameters.notNull((CharSequence)"javacTestClasspathProperties", (Object)javacTestClasspathProperties);
            this.javacTestClasspath = Arrays.copyOf(javacTestClasspathProperties, javacTestClasspathProperties.length);
            return this;
        }

        @NonNull
        public Builder setRunClasspathProperties(@NonNull String[] runClasspathProperties) {
            Parameters.notNull((CharSequence)"runClasspathProperties", (Object)runClasspathProperties);
            this.runClasspath = Arrays.copyOf(runClasspathProperties, runClasspathProperties.length);
            return this;
        }

        @NonNull
        public Builder setRunTestClasspathProperties(@NonNull String[] runTestClasspathProperties) {
            Parameters.notNull((CharSequence)"runTestClasspathProperties", (Object)runTestClasspathProperties);
            this.runTestClasspath = Arrays.copyOf(runTestClasspathProperties, runTestClasspathProperties.length);
            return this;
        }

        @NonNull
        public Builder setEndorsedClasspathProperties(@NonNull String[] endorsedClasspathProperties) {
            Parameters.notNull((CharSequence)"endorsedClasspathProperties", (Object)endorsedClasspathProperties);
            this.endorsedClasspath = Arrays.copyOf(endorsedClasspathProperties, endorsedClasspathProperties.length);
            return this;
        }

        @NonNull
        public Builder setBootClasspathProperties(String ... bootClasspathProperties) {
            Parameters.notNull((CharSequence)"bootClasspathProperties", (Object)bootClasspathProperties);
            this.bootClasspathProperties = Arrays.copyOf(bootClasspathProperties, bootClasspathProperties.length);
            return this;
        }

        @NonNull
        public ClassPathProviderImpl build() {
            Union2 platform = this.bootClasspathProperties == null ? Union2.createFirst((Object)this.platformType) : Union2.createSecond((Object)this.bootClasspathProperties);
            return new ClassPathProviderImpl(this.helper, this.evaluator, this.sourceRoots, this.testSourceRoots, this.buildClassesDir, this.distJar, this.buildTestClassesDir, this.javacClasspath, this.processorPath, this.javacTestClasspath, this.runClasspath, this.runTestClasspath, this.endorsedClasspath, platform);
        }

        @NonNull
        public static Builder create(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator evaluator, @NonNull SourceRoots sourceRoots, @NonNull SourceRoots testSourceRoots) {
            return new Builder(helper, evaluator, sourceRoots, testSourceRoots);
        }
    }
}

