/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ClassLoadUnloadBreakpoint
extends JPDABreakpoint {
    public static final String PROP_CLASS_FILTERS = "classFilters";
    public static final String PROP_CLASS_EXCLUSION_FILTERS = "classExclusionFilters";
    public static final String PROP_BREAKPOINT_TYPE = "breakpointType";
    public static final int TYPE_CLASS_LOADED = 1;
    public static final int TYPE_CLASS_UNLOADED = 2;
    public static final int TYPE_CLASS_LOADED_UNLOADED = 3;
    private int type = 1;
    private String[] classFilters = new String[0];
    private String[] classExclusionFilters = new String[0];

    private ClassLoadUnloadBreakpoint() {
    }

    public static ClassLoadUnloadBreakpoint create(String classNameFilter, boolean isExclusionFilter, int breakpointType) {
        ClassLoadUnloadBreakpointImpl b = new ClassLoadUnloadBreakpointImpl();
        if (isExclusionFilter) {
            b.setClassExclusionFilters(new String[]{classNameFilter});
        } else {
            b.setClassFilters(new String[]{classNameFilter});
        }
        b.setBreakpointType(breakpointType);
        return b;
    }

    public static ClassLoadUnloadBreakpoint create(int breakpointType) {
        ClassLoadUnloadBreakpoint b = new ClassLoadUnloadBreakpoint();
        b.setBreakpointType(breakpointType);
        return b;
    }

    public int getBreakpointType() {
        return this.type;
    }

    public void setBreakpointType(int type) {
        if (type == this.type) {
            return;
        }
        if ((type & 3) == 0) {
            throw new IllegalArgumentException();
        }
        int old = this.type;
        this.type = type;
        this.firePropertyChange(PROP_BREAKPOINT_TYPE, old, type);
    }

    public String[] getClassFilters() {
        return this.classFilters;
    }

    public void setClassFilters(String[] classFilters) {
        if (classFilters == this.classFilters) {
            return;
        }
        String[] old = this.classFilters;
        this.classFilters = classFilters;
        this.firePropertyChange(PROP_CLASS_FILTERS, old, classFilters);
    }

    public String[] getClassExclusionFilters() {
        return this.classExclusionFilters;
    }

    public void setClassExclusionFilters(String[] classExclusionFilters) {
        if (classExclusionFilters == this.classExclusionFilters) {
            return;
        }
        String[] old = this.classExclusionFilters;
        this.classExclusionFilters = classExclusionFilters;
        this.firePropertyChange(PROP_CLASS_EXCLUSION_FILTERS, old, classExclusionFilters);
    }

    public String toString() {
        return "ClassLoadUnloadBreakpoint " + Arrays.toString(this.classFilters);
    }

    private static final class ClassLoadUnloadBreakpointImpl
    extends ClassLoadUnloadBreakpoint
    implements PropertyChangeListener {
        private ClassLoadUnloadBreakpointImpl() {
        }

        public Breakpoint.GroupProperties getGroupProperties() {
            return new ClassGroupProperties();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.enginePropertyChange(evt);
        }

        private final class ClassGroupProperties
        extends Breakpoint.GroupProperties {
            private ClassGroupProperties() {
            }

            public String getType() {
                return NbBundle.getMessage(ClassLoadUnloadBreakpoint.class, (String)"ClassBrkp_Type");
            }

            public String getLanguage() {
                return "Java";
            }

            public FileObject[] getFiles() {
                String[] filters = ClassLoadUnloadBreakpointImpl.this.getClassFilters();
                String[] exfilters = ClassLoadUnloadBreakpointImpl.this.getClassExclusionFilters();
                ArrayList<FileObject> files = new ArrayList<FileObject>();
                for (int i = 0; i < filters.length; ++i) {
                    if (filters[i].startsWith("*") || filters[i].endsWith("*")) continue;
                    JPDABreakpoint.fillFilesForClass(filters[i], files);
                }
                return files.toArray(new FileObject[0]);
            }

            public Project[] getProjects() {
                FileObject[] files = this.getFiles();
                ArrayList<Project> projects = new ArrayList<Project>();
                for (FileObject f : files) {
                    while (!(f == null || (f = f.getParent()) != null && ProjectManager.getDefault().isProject(f))) {
                    }
                    if (f == null) continue;
                    try {
                        projects.add(ProjectManager.getDefault().findProject(f));
                    }
                    catch (IOException ex) {
                    }
                    catch (IllegalArgumentException ex) {
                        // empty catch block
                    }
                }
                return projects.toArray(new Project[0]);
            }

            public DebuggerEngine[] getEngines() {
                return ClassLoadUnloadBreakpointImpl.this.getEngines();
            }

            public boolean isHidden() {
                return ClassLoadUnloadBreakpointImpl.this.isHidden();
            }
        }
    }
}

