/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.wseditor.WSEditor;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.wsitconf.spi.WsitProvider;
import org.netbeans.modules.websvc.wsitconf.ui.ErrorTopComponent;
import org.netbeans.modules.websvc.wsitconf.ui.client.ClientTopComponent;
import org.netbeans.modules.websvc.wsitconf.ui.service.ServiceTopComponent;
import org.netbeans.modules.websvc.wsitconf.util.UndoManagerHolder;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class WSITEditor
implements WSEditor,
UndoManagerHolder {
    private static final Logger logger = Logger.getLogger(WSITEditor.class.getName());
    private JaxWsModel jaxWsModel;
    private UndoManager undoManager;
    private Collection<FileObject> createdFiles = new LinkedList<FileObject>();

    public WSITEditor(JaxWsModel jaxWsModel) {
        this.jaxWsModel = jaxWsModel;
    }

    public String getTitle() {
        return NbBundle.getMessage(WSITEditor.class, (String)"QOS_EDITOR_TITLE");
    }

    public JComponent createWSEditorComponent(Node node) {
        JAXWSSupport wss;
        Client client = (Client)node.getLookup().lookup(Client.class);
        Service service = (Service)node.getLookup().lookup(Service.class);
        final Project p = this.jaxWsModel != null ? FileOwnerQuery.getOwner((FileObject)this.jaxWsModel.getJaxWsFile()) : null;
        if (client != null) {
            JAXWSClientSupport wscs;
            if (p != null && (wscs = JAXWSClientSupport.getJaxWsClientSupport((FileObject)p.getProjectDirectory())) != null) {
                PropertyChangeListener jaxWsClientListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt != null) {
                            Object newV = evt.getNewValue();
                            Object oldV = evt.getOldValue();
                            if (oldV != null && newV == null && oldV instanceof Client) {
                                Client c = (Client)oldV;
                            }
                        }
                    }
                };
                this.jaxWsModel.addPropertyChangeListener(jaxWsClientListener);
                try {
                    WSDLModel clientWsdlModel = WSITModelSupport.getModel(node, this.jaxWsModel, this, true, this.createdFiles);
                    if (clientWsdlModel == null) {
                        return new ErrorTopComponent(NbBundle.getMessage(WSITEditor.class, (String)"TXT_WSIT_ClientWsdlNotFound"));
                    }
                    WSDLModel wsdlModel = WSITModelSupport.getServiceModelForClient(wscs, client);
                    return new ClientTopComponent(client, this.jaxWsModel, clientWsdlModel, wsdlModel, node);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, null, e);
                }
            }
        } else if (p != null && (wss = JAXWSSupport.getJAXWSSupport((FileObject)p.getProjectDirectory())) != null) {
            JaxWsModel.ServiceListener jaxWsServiceListener = new JaxWsModel.ServiceListener(){

                public void serviceAdded(String name, String implementationClass) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void serviceRemoved(String name) {
                    block8: {
                        if (!wss.isFromWSDL(name)) {
                            JaxWsModel jaxWsModel = (JaxWsModel)p.getLookup().lookup(JaxWsModel.class);
                            Service s = jaxWsModel.findServiceByName(name);
                            String implClass = s.getImplementationClass();
                            String configWsdlName = "wsit-" + implClass;
                            if (implClass != null && implClass.length() > 0) {
                                try {
                                    FileObject wsdlFO;
                                    if (wss.getWsdlFolder(true) == null || (wsdlFO = wss.getWsdlFolder(true).getParent().getFileObject(configWsdlName, "xml")) == null || !wsdlFO.isValid()) break block8;
                                    FileLock lock = null;
                                    try {
                                        lock = wsdlFO.lock();
                                        wsdlFO.delete(lock);
                                    }
                                    finally {
                                        if (lock != null) {
                                            lock.releaseLock();
                                        }
                                    }
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            };
            this.jaxWsModel.addServiceListener(jaxWsServiceListener);
            try {
                WSDLModel wsdlModel = WSITModelSupport.getModel(node, this.jaxWsModel, this, true, this.createdFiles);
                return new ServiceTopComponent(service, this.jaxWsModel, wsdlModel, node, this.getUndoManager());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, null, e);
            }
        }
        return new ErrorTopComponent(NbBundle.getMessage(WSITEditor.class, (String)"TXT_WSIT_NotSupported"));
    }

    public void save(Node node) {
        if (node == null) {
            return;
        }
        try {
            WSDLModel model = WSITModelSupport.getModel(node, this.jaxWsModel, this, false, this.createdFiles);
            if (model != null) {
                WSITModelSupport.save(model);
            } else {
                NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WSITEditor.class, (String)"TXT_NO_WSDL_FILE"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
        }
    }

    public void cancel(Node node) {
        FileObject clientConfigFolder;
        WSDLModel mainModel;
        Project p;
        if (node == null) {
            return;
        }
        WSDLModel model = null;
        FileObject srcRoot = (FileObject)node.getLookup().lookup(FileObject.class);
        if (srcRoot != null && (p = FileOwnerQuery.getOwner((FileObject)srcRoot)) != null && (mainModel = WSITModelSupport.getMainClientModel(clientConfigFolder = WSITEditor.getClientConfigFolder(p))) != null) {
            Collection imports = mainModel.getDefinitions().getImports();
            for (Import i : imports) {
                try {
                    WSDLModel importedModel = i.getImportedWSDLModel();
                    ModelSource importedms = importedModel.getModelSource();
                    FileObject importedfo = Utilities.getFileObject((ModelSource)importedms);
                    mainModel.startTransaction();
                    if (this.createdFiles.contains(importedfo)) {
                        mainModel.getDefinitions().removeImport(i);
                    }
                    mainModel.endTransaction();
                    FileObject mainFO = Utilities.getFileObject((ModelSource)mainModel.getModelSource());
                    if (mainFO == null) {
                        logger.log(Level.INFO, "Cannot find fileobject in lookup for: " + mainModel.getModelSource());
                    }
                    try {
                        DataObject mainDO = DataObject.find((FileObject)mainFO);
                        if (mainDO == null || !mainDO.isModified()) continue;
                        SaveCookie wsdlSaveCookie = (SaveCookie)mainDO.getCookie(SaveCookie.class);
                        if (wsdlSaveCookie != null) {
                            wsdlSaveCookie.save();
                        }
                        mainDO.setModified(false);
                    }
                    catch (IOException ioe) {
                    }
                }
                catch (IllegalStateException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                catch (CatalogModelException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
        try {
            model = WSITModelSupport.getModel(node, this.jaxWsModel, this, false, this.createdFiles);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (model != null) {
            try {
                if (this.getUndoManager() != null) {
                    while (this.getUndoManager().canUndo()) {
                        this.getUndoManager().undo();
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, null, e);
            }
            FileObject fo = Utilities.getFileObject((ModelSource)model.getModelSource());
            DataObject dO = null;
            try {
                dO = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            if (dO != null) {
                try {
                    model.sync();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                dO.setModified(false);
                dO.setModified(true);
                dO.setModified(false);
            }
        }
        if (this.createdFiles != null && this.createdFiles.size() > 0) {
            for (FileObject fo : this.createdFiles) {
                if (fo == null) continue;
                try {
                    DataObject dO = DataObject.find((FileObject)fo);
                    if (dO == null) continue;
                    dO.delete();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static FileObject getClientConfigFolder(Project p) {
        FileObject folder = null;
        WsitProvider wsitProvider = (WsitProvider)p.getLookup().lookup(WsitProvider.class);
        if (wsitProvider != null) {
            folder = wsitProvider.getConfigFilesFolder(true);
        }
        if (folder == null) {
            Sources sources = ProjectUtils.getSources((Project)p);
            if (sources == null) {
                return null;
            }
            SourceGroup[] sourceGroups = sources.getSourceGroups("java");
            if (sourceGroups != null && sourceGroups.length > 0) {
                folder = sourceGroups[0].getRootFolder();
                if (folder != null) {
                    folder = folder.getFileObject("META-INF");
                }
                if (folder == null || !folder.isValid()) {
                    try {
                        folder = sourceGroups[0].getRootFolder().createFolder("META-INF");
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        return folder;
    }

    @Override
    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public String getDescription() {
        return NbBundle.getMessage(WSITEditor.class, (String)"WSIT_CONFIG_DESC");
    }
}

