/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Dialog;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.spi.features.AdvancedSecurityFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ClientDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ServiceDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ValidatorsFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBase;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.STSIssued;
import org.netbeans.modules.websvc.wsitconf.util.DefaultSettings;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsitconf.util.UndoCounter;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

public class STSIssuedProfile
extends ProfileBase
implements SecureConversationFeature,
ClientDefaultsFeature,
ServiceDefaultsFeature,
AdvancedSecurityFeature,
ValidatorsFeature {
    @Override
    public int getId() {
        return 90;
    }

    @Override
    public String getDisplayName() {
        return ComboConstants.PROF_STSISSUED;
    }

    @Override
    public String getDescription() {
        return ComboConstants.PROF_STSISSUED_INFO;
    }

    @Override
    public boolean isCurrentProfile(WSDLComponent component) {
        return this.getDisplayName().equals(ProfilesModelHelper.getWSITSecurityProfile(component));
    }

    @Override
    public void displayConfig(WSDLComponent component, UndoManager undoManager) {
        UndoCounter undoCounter = new UndoCounter();
        WSDLModel model = component.getModel();
        model.addUndoableEditListener((UndoableEditListener)undoCounter);
        STSIssued profConfigPanel = new STSIssued(component, this);
        DialogDescriptor dlgDesc = new DialogDescriptor((Object)profConfigPanel, this.getDisplayName());
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dlgDesc);
        dlg.setVisible(true);
        if (dlgDesc.getValue() == DialogDescriptor.CANCEL_OPTION) {
            for (int i = 0; i < undoCounter.getCounter(); ++i) {
                if (!undoManager.canUndo()) continue;
                undoManager.undo();
            }
        }
        model.removeUndoableEditListener((UndoableEditListener)undoCounter);
    }

    @Override
    public void setServiceDefaults(WSDLComponent component, Project p) {
        ProprietarySecurityPolicyModelHelper.clearValidators(component);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, true, false);
        String kstoreLoc = ServerUtils.getStoreLocation(p, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, kstoreLoc, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreType(component, "JKS", false, false);
        ProprietarySecurityPolicyModelHelper.setStorePassword(component, "changeit", false, false);
        ProprietarySecurityPolicyModelHelper.setKeyStoreAlias(component, "xws-security-server", false);
    }

    @Override
    public void setClientDefaults(WSDLComponent component, WSDLComponent securityBinding, Project p) {
        ProprietarySecurityPolicyModelHelper.removeCallbackHandlerConfiguration((Binding)component);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, false, true);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, true, true);
    }

    @Override
    public boolean isServiceDefaultSetupUsed(WSDLComponent component, Project p) {
        if (ProprietarySecurityPolicyModelHelper.isAnyValidatorSet(component)) {
            return false;
        }
        String keyAlias = ProprietarySecurityPolicyModelHelper.getStoreAlias(component, false);
        String keyLoc = ProprietarySecurityPolicyModelHelper.getStoreLocation(component, false);
        String keyPasswd = ProprietarySecurityPolicyModelHelper.getStorePassword(component, false);
        return Util.isEqual(DefaultSettings.getDefaultPassword(p), keyPasswd) && Util.isEqual(ServerUtils.getStoreLocation(p, false, false), keyLoc) && Util.isEqual("xws-security-server", keyAlias);
    }

    @Override
    public boolean isClientDefaultSetupUsed(WSDLComponent component, Binding serviceBinding, Project p) {
        if (ProprietarySecurityPolicyModelHelper.isAnyValidatorSet(component)) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isSecureConversation(WSDLComponent component) {
        ExtensibilityElement topSecBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(component);
        WSDLComponent protTokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)topSecBinding, ProtectionToken.class);
        WSDLComponent protToken = SecurityTokensModelHelper.getTokenTypeElement(protTokenKind);
        return protToken instanceof SecureConversationToken;
    }

    @Override
    public void enableSecureConversation(WSDLComponent component, boolean enable) {
        ProfilesModelHelper.getInstance(PolicyModelHelper.getConfigVersion(component)).setSecureConversation(component, enable);
    }

    @Override
    public boolean isValidatorSupported(ConfigVersion cfgVersion, String validatorType) {
        return ConfigVersion.CONFIG_1_0 != cfgVersion;
    }
}

