/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfileRegistry;
import org.netbeans.modules.websvc.wsitconf.spi.features.AdvancedSecurityFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ClientDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ServiceDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.TrustStoreFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ValidatorsFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AlgoSuiteModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMSequenceBinding;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.websvc.wsitmodelext.addressing.Address;
import org.netbeans.modules.websvc.wsitmodelext.addressing.Address10;
import org.netbeans.modules.websvc.wsitmodelext.policy.All;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.policy.PolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.AsymmetricBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitmodelext.security.SecurityPolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.SymmetricBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.TransportBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.TrustElement;
import org.netbeans.modules.websvc.wsitmodelext.security.Wss10;
import org.netbeans.modules.websvc.wsitmodelext.security.Wss11;
import org.netbeans.modules.websvc.wsitmodelext.security.WssElement;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.InitiatorToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RecipientToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPAddress;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Referenceable;

public class ProfilesModelHelper {
    public static final String XWS_SECURITY_SERVER = "xws-security-server";
    public static final String XWS_SECURITY_CLIENT = "xws-security-client";
    public static final String WSSIP = "wssip";
    public static final String DEFAULT_PASSWORD = "wsit";
    public static final String DEFAULT_USERNAME = "wsit";
    public static final String DEFAULT_KERBEROS_LMODULE_SERVICE = "KerberosService";
    public static final String DEFAULT_KERBEROS_LMODULE_CLIENT = "KerberosClient";
    public static final String DEFAULT_KERBEROS_PRINCIPAL = "websvc/service@SUN.COM";
    private static final Logger logger = Logger.getLogger(ProfilesModelHelper.class.getName());
    private static HashMap<ConfigVersion, ProfilesModelHelper> instances = new HashMap();
    private ConfigVersion configVersion = ConfigVersion.getDefault();

    private ProfilesModelHelper(ConfigVersion configVersion) {
        this.configVersion = configVersion;
    }

    public static final ProfilesModelHelper getInstance(ConfigVersion configVersion) {
        ProfilesModelHelper instance = instances.get(configVersion);
        if (instance == null) {
            instance = new ProfilesModelHelper(configVersion);
            instances.put(configVersion, instance);
        }
        return instance;
    }

    public static boolean isSSLProfile(String s) {
        return ComboConstants.PROF_MSGAUTHSSL.equals(s) || ComboConstants.PROF_SAMLSSL.equals(s) || ComboConstants.PROF_TRANSPORT.equals(s);
    }

    public static String getSecurityProfile(WSDLComponent c) {
        assert (c instanceof BindingOperation || c instanceof Binding);
        Set<SecurityProfile> profiles = SecurityProfileRegistry.getDefault().getSecurityProfiles();
        for (SecurityProfile profile : profiles) {
            if (!profile.isCurrentProfile(c)) continue;
            return profile.getDisplayName();
        }
        return ComboConstants.PROF_NOTRECOGNIZED;
    }

    public static boolean isSCEnabled(WSDLComponent c) {
        assert (c instanceof BindingOperation || c instanceof Binding);
        Policy p = PolicyModelHelper.getPolicyForElement(c);
        SymmetricBinding sb = (SymmetricBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, SymmetricBinding.class, false);
        if (sb == null) {
            return false;
        }
        WSDLComponent protTokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)sb, ProtectionToken.class);
        if (protTokenKind == null) {
            return false;
        }
        WSDLComponent protToken = SecurityTokensModelHelper.getTokenTypeElement(protTokenKind);
        if (protToken == null) {
            return false;
        }
        boolean secConv = protToken instanceof SecureConversationToken;
        return secConv;
    }

    public static String getWSITSecurityProfile(WSDLComponent c) {
        if (c instanceof Binding || c instanceof BindingOperation) {
            Policy p = PolicyModelHelper.getPolicyForElement(c);
            SymmetricBinding sb = (SymmetricBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, SymmetricBinding.class, false);
            WSDLComponent protTokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)sb, ProtectionToken.class);
            WSDLComponent protToken = SecurityTokensModelHelper.getTokenTypeElement(protTokenKind);
            ExtensibilityElement secConvSecBinding = null;
            boolean secConv = protToken instanceof SecureConversationToken;
            WSDLComponent bootPolicy = null;
            if (secConv) {
                bootPolicy = SecurityTokensModelHelper.getTokenElement(protToken, BootstrapPolicy.class);
                secConvSecBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(bootPolicy);
            }
            TransportBinding tb = null;
            tb = secConv && secConvSecBinding instanceof TransportBinding ? (TransportBinding)secConvSecBinding : (TransportBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, TransportBinding.class, false);
            if (tb != null) {
                if (c instanceof BindingOperation) {
                    BindingInput input = ((BindingOperation)c).getBindingInput();
                    WSDLComponent tokenKind = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)input, 2);
                    if (tokenKind != null) {
                        return ComboConstants.PROF_MSGAUTHSSL;
                    }
                    tokenKind = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)input, 1);
                    String tokenType = SecurityTokensModelHelper.getTokenType(tokenKind);
                    if (ComboConstants.SAML.equals(tokenType)) {
                        return ComboConstants.PROF_SAMLSSL;
                    }
                    if (ComboConstants.USERNAME.equals(tokenType) || ComboConstants.X509.equals(tokenType)) {
                        return ComboConstants.PROF_MSGAUTHSSL;
                    }
                    tokenKind = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)input, 5);
                    if (tokenKind != null) {
                        return ComboConstants.PROF_MSGAUTHSSL;
                    }
                    return ComboConstants.PROF_TRANSPORT;
                }
                WSDLComponent tokenKind = SecurityTokensModelHelper.getSupportingToken(c, 2);
                if (tokenKind != null) {
                    return ComboConstants.PROF_MSGAUTHSSL;
                }
                Policy pp = (Policy)PolicyModelHelper.getTopLevelElement(bootPolicy, Policy.class, false);
                tokenKind = secConv ? SecurityTokensModelHelper.getSupportingToken((WSDLComponent)pp, 1) : SecurityTokensModelHelper.getSupportingToken(c, 1);
                String tokenType = SecurityTokensModelHelper.getTokenType(tokenKind);
                if (ComboConstants.SAML.equals(tokenType)) {
                    return ComboConstants.PROF_SAMLSSL;
                }
                if (ComboConstants.USERNAME.equals(tokenType) || ComboConstants.X509.equals(tokenType)) {
                    return ComboConstants.PROF_MSGAUTHSSL;
                }
                tokenKind = secConv ? SecurityTokensModelHelper.getSupportingToken((WSDLComponent)pp, 5) : SecurityTokensModelHelper.getSupportingToken(c, 5);
                if (tokenKind != null) {
                    return ComboConstants.PROF_MSGAUTHSSL;
                }
                return ComboConstants.PROF_TRANSPORT;
            }
            sb = secConv && secConvSecBinding instanceof SymmetricBinding ? (SymmetricBinding)secConvSecBinding : (SymmetricBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, SymmetricBinding.class, false);
            if (sb != null && (protToken = (ProtectionToken)SecurityTokensModelHelper.getTokenElement((WSDLComponent)sb, ProtectionToken.class)) != null) {
                String tokenType = SecurityTokensModelHelper.getTokenType(protToken);
                if (ComboConstants.ISSUED.equals(tokenType)) {
                    return ComboConstants.PROF_STSISSUED;
                }
                if (ComboConstants.KERBEROS.equals(tokenType)) {
                    return ComboConstants.PROF_KERBEROS;
                }
                if (ComboConstants.USERNAME.equals(tokenType)) {
                    return ComboConstants.PROF_USERNAME_PASSWORDDERIVED;
                }
                if (ComboConstants.X509.equals(tokenType)) {
                    WSDLComponent tokenKind = null;
                    if (secConv) {
                        Policy pp = (Policy)PolicyModelHelper.getTopLevelElement(bootPolicy, Policy.class, false);
                        tokenKind = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)pp, 2);
                    } else {
                        tokenKind = SecurityTokensModelHelper.getSupportingToken(c, 2);
                    }
                    tokenType = SecurityTokensModelHelper.getTokenType(tokenKind);
                    if (ComboConstants.ISSUED.equals(tokenType)) {
                        return ComboConstants.PROF_STSISSUEDENDORSE;
                    }
                    if (ComboConstants.X509.equals(tokenType)) {
                        return ComboConstants.PROF_ENDORSCERT;
                    }
                    if (tokenType == null) {
                        WSDLComponent encTokenKind = null;
                        if (secConv) {
                            Policy pp = (Policy)PolicyModelHelper.getTopLevelElement(bootPolicy, Policy.class, false);
                            tokenKind = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)pp, 1);
                            encTokenKind = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)pp, 5);
                        } else {
                            tokenKind = SecurityTokensModelHelper.getSupportingToken(c, 1);
                            encTokenKind = SecurityTokensModelHelper.getSupportingToken(c, 5);
                        }
                        if (encTokenKind != null) {
                            tokenType = SecurityTokensModelHelper.getTokenType(encTokenKind);
                            if (ComboConstants.USERNAME.equals(tokenType)) {
                                return ComboConstants.PROF_USERNAME;
                            }
                            return ComboConstants.PROF_STSISSUEDSUPPORTING;
                        }
                        tokenType = SecurityTokensModelHelper.getTokenType(tokenKind);
                        if (ComboConstants.ISSUED.equals(tokenType)) {
                            return ComboConstants.PROF_STSISSUEDSUPPORTING;
                        }
                        return ComboConstants.PROF_USERNAME;
                    }
                }
            }
            AsymmetricBinding ab = null;
            ab = secConv && secConvSecBinding instanceof AsymmetricBinding ? (AsymmetricBinding)secConvSecBinding : (AsymmetricBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)p, AsymmetricBinding.class, false);
            if (ab != null) {
                InitiatorToken initToken = (InitiatorToken)SecurityTokensModelHelper.getTokenElement((WSDLComponent)ab, InitiatorToken.class);
                RecipientToken recipToken = (RecipientToken)SecurityTokensModelHelper.getTokenElement((WSDLComponent)ab, RecipientToken.class);
                if (initToken != null && recipToken != null) {
                    String initTokenType = SecurityTokensModelHelper.getTokenType((WSDLComponent)initToken);
                    String recipTokenType = SecurityTokensModelHelper.getTokenType((WSDLComponent)recipToken);
                    if (ComboConstants.X509.equals(initTokenType) && ComboConstants.X509.equals(recipTokenType)) {
                        if (c instanceof BindingOperation) {
                            String tokenType;
                            BindingInput input = ((BindingOperation)c).getBindingInput();
                            WSDLComponent tokenKind = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)input, 1);
                            if (tokenKind == null) {
                                tokenKind = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)input, 5);
                            }
                            if (ComboConstants.SAML.equals(tokenType = SecurityTokensModelHelper.getTokenType(tokenKind))) {
                                return ComboConstants.PROF_SAMLSENDER;
                            }
                            if (tokenType == null) {
                                return ComboConstants.PROF_MUTUALCERT;
                            }
                        } else {
                            WSDLComponent tokenKind = null;
                            if (secConv) {
                                Policy pp = (Policy)PolicyModelHelper.getTopLevelElement(bootPolicy, Policy.class, false);
                                tokenKind = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)pp, 1);
                                if (tokenKind == null) {
                                    tokenKind = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)pp, 5);
                                }
                            } else {
                                tokenKind = SecurityTokensModelHelper.getSupportingToken(c, 1);
                                if (tokenKind == null) {
                                    tokenKind = SecurityTokensModelHelper.getSupportingToken(c, 5);
                                }
                            }
                            String tokenType = SecurityTokensModelHelper.getTokenType(tokenKind);
                            if (ComboConstants.SAML.equals(tokenType)) {
                                return ComboConstants.PROF_SAMLSENDER;
                            }
                            if (tokenType == null) {
                                return ComboConstants.PROF_MUTUALCERT;
                            }
                        }
                    }
                    if (ComboConstants.SAML.equals(initTokenType) && ComboConstants.X509.equals(recipTokenType)) {
                        return ComboConstants.PROF_SAMLHOLDER;
                    }
                    if (ComboConstants.ISSUED.equals(initTokenType) && ComboConstants.X509.equals(recipTokenType)) {
                        return ComboConstants.PROF_STSISSUEDCERT;
                    }
                }
            }
        }
        return ComboConstants.PROF_NOTRECOGNIZED;
    }

    private static void updateServiceUrl(WSDLComponent c, boolean toHttps) {
        String portTo;
        String portFrom;
        String to;
        String from;
        if (toHttps) {
            from = "http:";
            to = "https:";
            portFrom = "\\$\\{HttpDefaultPort}";
            portTo = "\\${HttpsDefaultPort}";
        } else {
            from = "https:";
            to = "http:";
            portFrom = "\\$\\{HttpsDefaultPort}";
            portTo = "\\${HttpDefaultPort}";
        }
        if (c instanceof Binding) {
            Collection services = c.getModel().getDefinitions().getServices();
            for (Service s : services) {
                Collection ports = s.getPorts();
                for (Port p : ports) {
                    List soapAddresses;
                    List addresses10;
                    if (!p.getBinding().references((Referenceable)((Binding)c))) continue;
                    List addresses = p.getExtensibilityElements(Address.class);
                    if (addresses != null && !addresses.isEmpty()) {
                        for (Address a : addresses) {
                            String addr = a.getAddress();
                            if (addr == null) continue;
                            addr = addr.replaceFirst(portFrom, portTo);
                            a.setAddress(addr.replaceFirst(from, to));
                        }
                    }
                    if ((addresses10 = p.getExtensibilityElements(Address10.class)) != null && !addresses10.isEmpty()) {
                        for (Address10 a : addresses10) {
                            String addr = a.getAddress();
                            if (addr == null) continue;
                            addr = addr.replaceFirst(portFrom, portTo);
                            a.setAddress(addr.replaceFirst(from, to));
                        }
                    }
                    if ((soapAddresses = p.getExtensibilityElements(SOAPAddress.class)) == null || soapAddresses.isEmpty()) continue;
                    for (SOAPAddress a : soapAddresses) {
                        String addr = a.getLocation();
                        if (addr == null) continue;
                        addr = addr.replaceFirst(portFrom, portTo);
                        a.setLocation(addr.replaceFirst(from, to));
                    }
                }
            }
        }
    }

    public static boolean isServiceUrlHttps(Binding binding) {
        Collection services = binding.getModel().getDefinitions().getServices();
        for (Service s : services) {
            Collection ports = s.getPorts();
            for (Port p : ports) {
                List soapAddresses;
                List addresses10;
                if (!p.getBinding().references((Referenceable)binding)) continue;
                List addresses = p.getExtensibilityElements(Address.class);
                if (addresses != null && !addresses.isEmpty()) {
                    for (Address a : addresses) {
                        String addr = a.getAddress();
                        if (addr == null || !addr.contains("https:")) continue;
                        return true;
                    }
                }
                if ((addresses10 = p.getExtensibilityElements(Address10.class)) != null && !addresses10.isEmpty()) {
                    for (Address10 a : addresses10) {
                        String addr = a.getAddress();
                        if (addr == null || !addr.contains("https:")) continue;
                        return true;
                    }
                }
                if ((soapAddresses = p.getExtensibilityElements(SOAPAddress.class)) == null || soapAddresses.isEmpty()) continue;
                for (SOAPAddress a : soapAddresses) {
                    String addr = a.getLocation();
                    if (addr == null || !addr.contains("https:")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setSecurityProfile(WSDLComponent c, String profile, String oldProfile, boolean updateServiceUrl) {
        assert (c != null);
        assert (profile != null);
        assert (c instanceof BindingOperation || c instanceof Binding);
        SecurityProfile newP = SecurityProfileRegistry.getDefault().getProfile(profile);
        SecurityProfile oldP = SecurityProfileRegistry.getDefault().getProfile(oldProfile);
        if (oldP != null) {
            oldP.profileDeselected(c, this.configVersion);
        }
        newP.profileSelected(c, updateServiceUrl, this.configVersion);
    }

    public static boolean isServiceDefaultSetupSupported(String profile) {
        SecurityProfile p = SecurityProfileRegistry.getDefault().getProfile(profile);
        return p instanceof ServiceDefaultsFeature;
    }

    public static boolean isTruststoreRequired(String profile, WSDLComponent c, boolean client) {
        SecurityProfile p = SecurityProfileRegistry.getDefault().getProfile(profile);
        if (p instanceof TrustStoreFeature) {
            return ((TrustStoreFeature)((Object)p)).isTrustStoreRequired(c, client);
        }
        return !ProfilesModelHelper.isSSLProfile(profile);
    }

    public static boolean isClientDefaultSetupSupported(String profile) {
        SecurityProfile p = SecurityProfileRegistry.getDefault().getProfile(profile);
        return p instanceof ClientDefaultsFeature;
    }

    public static boolean isServiceDefaultSetupUsed(String profile, Binding binding, Project project) {
        SecurityProfile p = SecurityProfileRegistry.getDefault().getProfile(profile);
        if (p instanceof ServiceDefaultsFeature) {
            return ((ServiceDefaultsFeature)((Object)p)).isServiceDefaultSetupUsed((WSDLComponent)binding, project);
        }
        return false;
    }

    public static boolean isClientDefaultSetupUsed(String profile, Binding binding, WSDLComponent serviceBinding, Project project) {
        SecurityProfile p = SecurityProfileRegistry.getDefault().getProfile(profile);
        if (p instanceof ClientDefaultsFeature) {
            return ((ClientDefaultsFeature)((Object)p)).isClientDefaultSetupUsed((WSDLComponent)binding, (Binding)serviceBinding, project);
        }
        return false;
    }

    public static boolean isValidatorsSupported(String profile) {
        SecurityProfile p = SecurityProfileRegistry.getDefault().getProfile(profile);
        return p instanceof ValidatorsFeature;
    }

    public static boolean isAdvancedSecuritySupported(String profile) {
        SecurityProfile p = SecurityProfileRegistry.getDefault().getProfile(profile);
        return p instanceof AdvancedSecurityFeature;
    }

    public static void setClientDefaults(String profile, Binding binding, WSDLComponent serviceBinding, Project project) {
        SecurityProfile p = SecurityProfileRegistry.getDefault().getProfile(profile);
        if (p instanceof ClientDefaultsFeature) {
            ((ClientDefaultsFeature)((Object)p)).setClientDefaults((WSDLComponent)binding, serviceBinding, project);
        }
    }

    public static void setServiceDefaults(String profile, Binding binding, Project project) {
        SecurityProfile p = SecurityProfileRegistry.getDefault().getProfile(profile);
        if (p instanceof ServiceDefaultsFeature) {
            ((ServiceDefaultsFeature)((Object)p)).setServiceDefaults((WSDLComponent)binding, project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSecurityProfile(WSDLComponent c, String profile, boolean updateServiceUrl) {
        WSDLModel model = c.getModel();
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
        SecurityTokensModelHelper stmh = SecurityTokensModelHelper.getInstance(this.configVersion);
        SecurityPolicyModelHelper spmh = SecurityPolicyModelHelper.getInstance(this.configVersion);
        AlgoSuiteModelHelper asmh = AlgoSuiteModelHelper.getInstance(this.configVersion);
        pmh.createPolicy(c, true);
        try {
            boolean rm;
            WSDLComponent bt;
            if (ComboConstants.PROF_TRANSPORT.equals(profile)) {
                bt = spmh.setSecurityBindingType(c, ComboConstants.TRANSPORT);
                stmh.setTokenType(bt, ComboConstants.TRANSPORT, ComboConstants.HTTPS);
                spmh.setLayout(bt, ComboConstants.LAX);
                spmh.enableIncludeTimestamp(bt, true);
                asmh.setAlgorithmSuite(bt, ComboConstants.BASIC128);
                spmh.enableWss(c, false);
                spmh.disableTrust(c);
                SecurityTokensModelHelper.removeSupportingTokens(c);
            } else if (ComboConstants.PROF_MSGAUTHSSL.equals(profile)) {
                bt = spmh.setSecurityBindingType(c, ComboConstants.TRANSPORT);
                stmh.setTokenType(bt, ComboConstants.TRANSPORT, ComboConstants.HTTPS);
                spmh.setLayout(bt, ComboConstants.LAX);
                spmh.enableIncludeTimestamp(bt, true);
                asmh.setAlgorithmSuite(bt, ComboConstants.BASIC128);
                WssElement wss = spmh.enableWss(c, false);
                spmh.disableTrust(c);
                SecurityTokensModelHelper.removeSupportingTokens(c);
                if (ConfigVersion.CONFIG_1_0.equals((Object)this.configVersion)) {
                    stmh.setSupportingTokens(c, ComboConstants.USERNAME, 1);
                } else {
                    stmh.setSupportingTokens(c, ComboConstants.USERNAME, 5);
                }
            } else if (ComboConstants.PROF_SAMLSSL.equals(profile)) {
                bt = spmh.setSecurityBindingType(c, ComboConstants.TRANSPORT);
                stmh.setTokenType(bt, ComboConstants.TRANSPORT, ComboConstants.HTTPS);
                spmh.setLayout(bt, ComboConstants.LAX);
                spmh.enableIncludeTimestamp(bt, true);
                asmh.setAlgorithmSuite(bt, ComboConstants.BASIC128);
                WssElement wss = spmh.enableWss(c, false);
                spmh.disableTrust(c);
                SecurityTokensModelHelper.removeSupportingTokens(c);
                stmh.setSupportingTokens(c, ComboConstants.SAML, 1);
            } else if (ComboConstants.PROF_USERNAME.equals(profile)) {
                bt = spmh.setSecurityBindingType(c, ComboConstants.SYMMETRIC);
                WSDLComponent tokenType = stmh.setTokenType(bt, "protection", ComboConstants.X509);
                stmh.setTokenInclusionLevel(tokenType, ComboConstants.NEVER);
                spmh.setLayout(bt, ComboConstants.STRICT);
                spmh.enableIncludeTimestamp(bt, true);
                spmh.enableSignEntireHeadersAndBody(bt, true);
                asmh.setAlgorithmSuite(bt, ComboConstants.BASIC128);
                WssElement wss = spmh.enableWss(c, true);
                spmh.disableTrust(c);
                spmh.enableMustSupportRefIssuerSerial(wss, true);
                spmh.enableMustSupportRefThumbprint(wss, true);
                spmh.enableMustSupportRefEncryptedKey(wss, true);
                SecurityTokensModelHelper.removeSupportingTokens(c);
                int suppTokenType = ConfigVersion.CONFIG_1_0.equals((Object)this.configVersion) ? 1 : 5;
                stmh.setSupportingTokens(c, ComboConstants.USERNAME, suppTokenType);
            } else if (ComboConstants.PROF_USERNAME_PASSWORDDERIVED.equals(profile)) {
                bt = spmh.setSecurityBindingType(c, ComboConstants.SYMMETRIC);
                WSDLComponent tokenType = stmh.setTokenType(bt, "protection", ComboConstants.USERNAME);
                stmh.setTokenInclusionLevel(tokenType, ComboConstants.ALWAYSRECIPIENT);
                spmh.setLayout(bt, ComboConstants.STRICT);
                spmh.enableIncludeTimestamp(bt, true);
                spmh.enableSignEntireHeadersAndBody(bt, true);
                asmh.setAlgorithmSuite(bt, ComboConstants.BASIC128);
                WssElement wss = spmh.enableWss(c, true);
                spmh.disableTrust(c);
                spmh.enableMustSupportRefIssuerSerial(wss, true);
                spmh.enableMustSupportRefThumbprint(wss, true);
                spmh.enableMustSupportRefEncryptedKey(wss, true);
                SecurityTokensModelHelper.removeSupportingTokens(c);
            } else if (ComboConstants.PROF_MUTUALCERT.equals(profile)) {
                bt = spmh.setSecurityBindingType(c, ComboConstants.ASYMMETRIC);
                WSDLComponent tokenType = stmh.setTokenType(bt, "initiator", ComboConstants.X509);
                SecurityPolicyModelHelper.getInstance(this.configVersion).enableRequireIssuerSerialReference(tokenType, false);
                stmh.setTokenInclusionLevel(tokenType, ComboConstants.ALWAYSRECIPIENT);
                tokenType = stmh.setTokenType(bt, "recipient", ComboConstants.X509);
                stmh.setTokenInclusionLevel(tokenType, ComboConstants.NEVER);
                spmh.setLayout(bt, ComboConstants.STRICT);
                spmh.enableIncludeTimestamp(bt, true);
                spmh.enableSignEntireHeadersAndBody(bt, true);
                asmh.setAlgorithmSuite(bt, ComboConstants.BASIC128);
                WssElement wss = spmh.enableWss(c, false);
                spmh.disableTrust(c);
                spmh.enableMustSupportRefIssuerSerial(wss, true);
                SecurityTokensModelHelper.removeSupportingTokens(c);
            } else if (ComboConstants.PROF_ENDORSCERT.equals(profile)) {
                bt = spmh.setSecurityBindingType(c, ComboConstants.SYMMETRIC);
                WSDLComponent tokenType = stmh.setTokenType(bt, "protection", ComboConstants.X509);
                stmh.setTokenInclusionLevel(tokenType, ComboConstants.NEVER);
                spmh.setLayout(bt, ComboConstants.LAX);
                spmh.enableIncludeTimestamp(bt, true);
                spmh.enableSignEntireHeadersAndBody(bt, true);
                asmh.setAlgorithmSuite(bt, ComboConstants.BASIC128);
                WssElement wss = spmh.enableWss(c, true);
                spmh.disableTrust(c);
                spmh.enableMustSupportRefIssuerSerial(wss, true);
                spmh.enableMustSupportRefThumbprint(wss, true);
                spmh.enableMustSupportRefEncryptedKey(wss, true);
                SecurityTokensModelHelper.removeSupportingTokens(c);
                tokenType = stmh.setSupportingTokens(c, ComboConstants.X509, 2);
            } else if (ComboConstants.PROF_SAMLSENDER.equals(profile)) {
                bt = spmh.setSecurityBindingType(c, ComboConstants.ASYMMETRIC);
                WSDLComponent tokenType = stmh.setTokenType(bt, "initiator", ComboConstants.X509);
                stmh.setTokenInclusionLevel(tokenType, ComboConstants.ALWAYSRECIPIENT);
                tokenType = stmh.setTokenType(bt, "recipient", ComboConstants.X509);
                stmh.setTokenInclusionLevel(tokenType, ComboConstants.NEVER);
                spmh.setLayout(bt, ComboConstants.STRICT);
                spmh.enableIncludeTimestamp(bt, true);
                spmh.enableSignEntireHeadersAndBody(bt, true);
                asmh.setAlgorithmSuite(bt, ComboConstants.BASIC128);
                WssElement wss = spmh.enableWss(c, false);
                spmh.disableTrust(c);
                spmh.enableMustSupportRefIssuerSerial(wss, true);
                SecurityTokensModelHelper.removeSupportingTokens(c);
                tokenType = this.configVersion.equals((Object)ConfigVersion.CONFIG_1_0) ? stmh.setSupportingTokens(c, ComboConstants.SAML, 1) : stmh.setSupportingTokens(c, ComboConstants.SAML, 5);
            } else if (ComboConstants.PROF_SAMLHOLDER.equals(profile)) {
                bt = spmh.setSecurityBindingType(c, ComboConstants.ASYMMETRIC);
                WSDLComponent tokenType = stmh.setTokenType(bt, "initiator", ComboConstants.SAML);
                stmh.setTokenInclusionLevel(tokenType, ComboConstants.ALWAYSRECIPIENT);
                tokenType = stmh.setTokenType(bt, "recipient", ComboConstants.X509);
                stmh.setTokenInclusionLevel(tokenType, ComboConstants.NEVER);
                spmh.setLayout(bt, ComboConstants.STRICT);
                spmh.enableIncludeTimestamp(bt, true);
                spmh.enableSignEntireHeadersAndBody(bt, true);
                asmh.setAlgorithmSuite(bt, ComboConstants.BASIC128);
                WssElement wss = spmh.enableWss(c, false);
                spmh.disableTrust(c);
                spmh.enableMustSupportRefIssuerSerial(wss, true);
                SecurityTokensModelHelper.removeSupportingTokens(c);
            } else if (ComboConstants.PROF_KERBEROS.equals(profile)) {
                bt = spmh.setSecurityBindingType(c, ComboConstants.SYMMETRIC);
                WSDLComponent tokenType = stmh.setTokenType(bt, "protection", ComboConstants.KERBEROS);
                stmh.setTokenInclusionLevel(tokenType, ComboConstants.ONCE);
                spmh.setLayout(bt, ComboConstants.STRICT);
                spmh.enableIncludeTimestamp(bt, true);
                spmh.enableSignEntireHeadersAndBody(bt, true);
                asmh.setAlgorithmSuite(bt, ComboConstants.BASIC128);
                WssElement wss = spmh.enableWss(c, true);
                spmh.disableTrust(c);
                spmh.enableMustSupportRefIssuerSerial(wss, true);
                spmh.enableMustSupportRefThumbprint(wss, true);
                spmh.enableMustSupportRefEncryptedKey(wss, true);
                SecurityTokensModelHelper.removeSupportingTokens(c);
            } else if (ComboConstants.PROF_STSISSUED.equals(profile)) {
                bt = spmh.setSecurityBindingType(c, ComboConstants.SYMMETRIC);
                WSDLComponent tokenType = stmh.setTokenType(bt, "protection", ComboConstants.ISSUED);
                stmh.setTokenInclusionLevel(tokenType, ComboConstants.ALWAYSRECIPIENT);
                spmh.setLayout(bt, ComboConstants.LAX);
                spmh.enableIncludeTimestamp(bt, true);
                spmh.enableSignEntireHeadersAndBody(bt, true);
                asmh.setAlgorithmSuite(bt, ComboConstants.BASIC128);
                WssElement wss = spmh.enableWss(c, true);
                spmh.enableMustSupportRefIssuerSerial(wss, true);
                spmh.enableMustSupportRefThumbprint(wss, true);
                spmh.enableMustSupportRefEncryptedKey(wss, true);
                TrustElement trust = spmh.enableTrust(c, this.configVersion);
                spmh.enableMustSupportIssuedTokens(trust, true);
                spmh.enableRequireClientEntropy(trust, true);
                spmh.enableRequireServerEntropy(trust, true);
                SecurityTokensModelHelper.removeSupportingTokens(c);
            } else if (ComboConstants.PROF_STSISSUEDCERT.equals(profile)) {
                bt = spmh.setSecurityBindingType(c, ComboConstants.ASYMMETRIC);
                WSDLComponent tokenType = stmh.setTokenType(bt, "initiator", ComboConstants.ISSUED);
                stmh.setTokenInclusionLevel(tokenType, ComboConstants.ALWAYSRECIPIENT);
                tokenType = stmh.setTokenType(bt, "recipient", ComboConstants.X509);
                stmh.setTokenInclusionLevel(tokenType, ComboConstants.NEVER);
                spmh.setLayout(bt, ComboConstants.LAX);
                spmh.enableIncludeTimestamp(bt, true);
                spmh.enableSignEntireHeadersAndBody(bt, true);
                asmh.setAlgorithmSuite(bt, ComboConstants.BASIC128);
                WssElement wss = spmh.enableWss(c, true);
                spmh.enableMustSupportRefIssuerSerial(wss, true);
                spmh.enableMustSupportRefThumbprint(wss, true);
                spmh.enableMustSupportRefEncryptedKey(wss, true);
                TrustElement trust = spmh.enableTrust(c, this.configVersion);
                spmh.enableMustSupportIssuedTokens(trust, true);
                spmh.enableRequireClientEntropy(trust, true);
                spmh.enableRequireServerEntropy(trust, true);
                SecurityTokensModelHelper.removeSupportingTokens(c);
            } else if (ComboConstants.PROF_STSISSUEDENDORSE.equals(profile)) {
                bt = spmh.setSecurityBindingType(c, ComboConstants.SYMMETRIC);
                WSDLComponent tokenType = stmh.setTokenType(bt, "protection", ComboConstants.X509);
                stmh.setTokenInclusionLevel(tokenType, ComboConstants.ALWAYS);
                spmh.setLayout(bt, ComboConstants.LAX);
                spmh.enableIncludeTimestamp(bt, true);
                spmh.enableSignEntireHeadersAndBody(bt, true);
                asmh.setAlgorithmSuite(bt, ComboConstants.BASIC128);
                WssElement wss = spmh.enableWss(c, true);
                spmh.enableMustSupportRefKeyIdentifier(wss, true);
                spmh.enableMustSupportRefIssuerSerial(wss, true);
                spmh.enableMustSupportRefThumbprint(wss, true);
                spmh.enableMustSupportRefEncryptedKey(wss, true);
                TrustElement trust = spmh.enableTrust(c, this.configVersion);
                spmh.enableMustSupportIssuedTokens(trust, true);
                spmh.enableRequireClientEntropy(trust, true);
                spmh.enableRequireServerEntropy(trust, true);
                SecurityTokensModelHelper.removeSupportingTokens(c);
                tokenType = stmh.setSupportingTokens(c, ComboConstants.ISSUED, 2);
            } else if (ComboConstants.PROF_STSISSUEDSUPPORTING.equals(profile)) {
                bt = spmh.setSecurityBindingType(c, ComboConstants.SYMMETRIC);
                WSDLComponent tokenType = stmh.setTokenType(bt, "protection", ComboConstants.X509);
                stmh.setTokenInclusionLevel(tokenType, ComboConstants.ALWAYS);
                spmh.setLayout(bt, ComboConstants.LAX);
                spmh.enableIncludeTimestamp(bt, true);
                spmh.enableSignEntireHeadersAndBody(bt, true);
                asmh.setAlgorithmSuite(bt, ComboConstants.BASIC128);
                WssElement wss = spmh.enableWss(c, true);
                spmh.enableMustSupportRefIssuerSerial(wss, true);
                spmh.enableMustSupportRefThumbprint(wss, true);
                spmh.enableMustSupportRefEncryptedKey(wss, true);
                TrustElement trust = spmh.enableTrust(c, this.configVersion);
                spmh.enableMustSupportIssuedTokens(trust, true);
                spmh.enableRequireClientEntropy(trust, true);
                spmh.enableRequireServerEntropy(trust, true);
                SecurityTokensModelHelper.removeSupportingTokens(c);
                tokenType = this.configVersion.equals((Object)ConfigVersion.CONFIG_1_0) ? stmh.setSupportingTokens(c, ComboConstants.ISSUED, 1) : stmh.setSupportingTokens(c, ComboConstants.ISSUED, 5);
            }
            this.setMessageLevelSecurityProfilePolicies(c, profile);
            if (updateServiceUrl) {
                ProfilesModelHelper.updateServiceUrl(c, ProfilesModelHelper.isSSLProfile(profile));
            }
            if (!ConfigVersion.CONFIG_1_0.equals((Object)this.configVersion) && (rm = RMModelHelper.getInstance(this.configVersion).isRMEnabled(c)) && ProfilesModelHelper.isSSLProfile(profile)) {
                if (ProfilesModelHelper.isSSLProfile(profile)) {
                    RMSequenceBinding.SECURED_TRANSPORT.set(this.configVersion, (Binding)c);
                } else {
                    RMSequenceBinding.SECURED_TOKEN.set(this.configVersion, (Binding)c);
                }
            }
        }
        finally {
            if (!isTransaction) {
                WSITModelSupport.doEndTransaction((Model)model);
            }
        }
    }

    public void setMessageLevelSecurityProfilePolicies(WSDLComponent c, String profile) {
        assert (c instanceof BindingOperation || c instanceof Binding);
        PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
        if (c instanceof Binding) {
            Collection ops = ((Binding)c).getBindingOperations();
            Iterator i = null;
            if (ops != null && ops.size() > 0) {
                i = ops.iterator();
                BindingOperation bOp = (BindingOperation)i.next();
                this.setMessageLevelSecurityProfilePolicies(bOp, profile);
                BindingInput inputB = bOp.getBindingInput();
                BindingOutput outputB = bOp.getBindingOutput();
                String inputPolicyUri = null;
                if (inputB != null) {
                    inputPolicyUri = PolicyModelHelper.getPolicyUriForElement((WSDLComponent)inputB);
                }
                String outputPolicyUri = null;
                if (outputB != null) {
                    outputPolicyUri = PolicyModelHelper.getPolicyUriForElement((WSDLComponent)outputB);
                }
                while (i.hasNext()) {
                    BindingOperation op = (BindingOperation)i.next();
                    if (inputB != null) {
                        inputB = op.getBindingInput();
                        pmh.attachPolicyToElement(inputPolicyUri, (WSDLComponent)inputB);
                    }
                    if (outputB == null) continue;
                    outputB = op.getBindingOutput();
                    pmh.attachPolicyToElement(outputPolicyUri, (WSDLComponent)outputB);
                }
            }
        } else {
            this.setMessageLevelSecurityProfilePolicies((BindingOperation)c, profile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMessageLevelSecurityProfilePolicies(BindingOperation o, String profile) {
        assert (o != null);
        WSDLModel model = o.getModel();
        BindingInput input = o.getBindingInput();
        BindingOutput output = o.getBindingOutput();
        Binding b = (Binding)o.getParent();
        boolean wss11 = SecurityPolicyModelHelper.isWss11((WSDLComponent)b);
        boolean rm = RMModelHelper.getInstance(this.configVersion).isRMEnabled((WSDLComponent)b);
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            SecurityPolicyModelHelper spmh = SecurityPolicyModelHelper.getInstance(this.configVersion);
            if (ComboConstants.PROF_TRANSPORT.equals(profile)) {
                return;
            }
            if (ComboConstants.PROF_MSGAUTHSSL.equals(profile)) {
                return;
            }
            if (ComboConstants.PROF_SAMLSSL.equals(profile)) {
                return;
            }
            if (ComboConstants.PROF_MUTUALCERT.equals(profile)) {
                spmh.setDefaultTargets((WSDLComponent)input, true, rm);
                spmh.setDefaultTargets((WSDLComponent)output, true, rm);
                return;
            }
            spmh.setDefaultTargets((WSDLComponent)input, wss11, rm);
            spmh.setDefaultTargets((WSDLComponent)output, wss11, rm);
        }
        finally {
            if (!isTransaction) {
                WSITModelSupport.doEndTransaction((Model)model);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSecureConversation(WSDLComponent c, boolean enable) {
        assert (c != null);
        assert (c instanceof BindingOperation || c instanceof Binding);
        Binding b = null;
        b = c instanceof BindingOperation ? (Binding)c.getParent() : (Binding)c;
        WSDLModel model = c.getModel();
        WSDLComponentFactory wcf = model.getFactory();
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
            SecurityPolicyModelHelper spmh = SecurityPolicyModelHelper.getInstance(this.configVersion);
            SecurityTokensModelHelper stmh = SecurityTokensModelHelper.getInstance(this.configVersion);
            if (enable) {
                TrustElement trust;
                Wss11 wss11;
                ExtensibilityElement secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(c);
                WSDLComponent par = (WSDLComponent)secBinding.getParent();
                boolean onlySign = SecurityPolicyModelHelper.isSignEntireHeadersAndBody(c);
                boolean includeTimestamp = SecurityPolicyModelHelper.isSignEntireHeadersAndBody(c);
                String algoSuite = AlgoSuiteModelHelper.getAlgorithmSuite(c);
                BootstrapPolicy bp = (BootstrapPolicy)wcf.create(par, SecurityPolicyQName.BOOTSTRAPPOLICY.getQName(this.configVersion));
                par.addExtensibilityElement((ExtensibilityElement)bp);
                Policy p = (Policy)pmh.createElement((WSDLComponent)bp, PolicyQName.POLICY.getQName(this.configVersion), Policy.class, false);
                ExtensibilityElement ec = (ExtensibilityElement)secBinding.copy((Component)p);
                p.addExtensibilityElement(ec);
                for (int suppTokenType = 0; suppTokenType < 3; ++suppTokenType) {
                    ExtensibilityElement suppToken = (ExtensibilityElement)SecurityTokensModelHelper.getSupportingToken(c, suppTokenType);
                    if (suppToken == null) continue;
                    p.addExtensibilityElement((ExtensibilityElement)suppToken.copy((Component)p));
                    ((WSDLComponent)suppToken.getParent()).removeExtensibilityElement(suppToken);
                }
                WSDLComponent bType = spmh.setSecurityBindingType(c, ComboConstants.SYMMETRIC);
                SecureConversationToken tType = (SecureConversationToken)SecurityTokensModelHelper.getInstance(this.configVersion).setTokenType(bType, "protection", ComboConstants.SECURECONVERSATION);
                stmh.setTokenInclusionLevel((WSDLComponent)tType, ComboConstants.ALWAYSRECIPIENT);
                p = (Policy)pmh.createElement((WSDLComponent)tType, PolicyQName.POLICY.getQName(this.configVersion), Policy.class, false);
                ExtensibilityElement bpcopy = (ExtensibilityElement)bp.copy((Component)p);
                p.addExtensibilityElement(bpcopy);
                par.removeExtensibilityElement((ExtensibilityElement)bp);
                p = (Policy)PolicyModelHelper.getTopLevelElement((WSDLComponent)bpcopy, Policy.class, false);
                Wss10 wss10 = SecurityPolicyModelHelper.getWss10(par);
                if (wss10 != null) {
                    p.addExtensibilityElement((ExtensibilityElement)wss10.copy((Component)p));
                }
                if ((wss11 = SecurityPolicyModelHelper.getWss11(par)) != null) {
                    p.addExtensibilityElement((ExtensibilityElement)wss11.copy((Component)p));
                }
                if ((trust = SecurityPolicyModelHelper.getTrust(par, this.configVersion)) != null) {
                    p.addExtensibilityElement((ExtensibilityElement)trust.copy((Component)p));
                }
                spmh.setLayout(bType, ComboConstants.STRICT);
                if (algoSuite != null) {
                    AlgoSuiteModelHelper.getInstance(this.configVersion).setAlgorithmSuite(bType, algoSuite);
                } else {
                    AlgoSuiteModelHelper.getInstance(this.configVersion).setAlgorithmSuite(bType, ComboConstants.BASIC128);
                }
                if (includeTimestamp) {
                    spmh.enableIncludeTimestamp(bType, true);
                }
                if (onlySign) {
                    spmh.enableSignEntireHeadersAndBody(bType, true);
                }
                boolean rm = RMModelHelper.getInstance(this.configVersion).isRMEnabled((WSDLComponent)b);
                spmh.setDefaultTargets((WSDLComponent)p, true, rm);
                spmh.disableWss(par);
                WssElement wss = spmh.enableWss(par, true);
                spmh.enableMustSupportRefIssuerSerial(wss, true);
                spmh.enableMustSupportRefThumbprint(wss, true);
                spmh.enableMustSupportRefEncryptedKey(wss, true);
                spmh.disableTrust(par);
                trust = spmh.enableTrust(par, this.configVersion);
                spmh.enableRequireClientEntropy(trust, true);
                spmh.enableRequireServerEntropy(trust, true);
                spmh.enableMustSupportIssuedTokens(trust, true);
            } else {
                TrustElement trust;
                Wss11 wss11;
                ExtensibilityElement topSecBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(c);
                WSDLComponent protTokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)topSecBinding, ProtectionToken.class);
                WSDLComponent protToken = SecurityTokensModelHelper.getTokenTypeElement(protTokenKind);
                WSDLComponent bootPolicy = SecurityTokensModelHelper.getTokenElement(protToken, BootstrapPolicy.class);
                ExtensibilityElement secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(bootPolicy);
                WSDLComponent par = (WSDLComponent)((WSDLComponent)topSecBinding.getParent()).getParent();
                par.addExtensibilityElement((ExtensibilityElement)secBinding.copy((Component)par));
                for (int suppTokenType = 0; suppTokenType < 3; ++suppTokenType) {
                    ExtensibilityElement suppToken = (ExtensibilityElement)SecurityTokensModelHelper.getSupportingToken((WSDLComponent)secBinding.getParent(), suppTokenType);
                    if (suppToken == null) continue;
                    par.addExtensibilityElement((ExtensibilityElement)suppToken.copy((Component)par));
                    ((WSDLComponent)suppToken.getParent()).removeExtensibilityElement(suppToken);
                }
                Wss10 wss10 = SecurityPolicyModelHelper.getWss10((WSDLComponent)secBinding.getParent());
                if (wss10 != null) {
                    par.addExtensibilityElement((ExtensibilityElement)wss10.copy((Component)par));
                }
                if ((wss11 = SecurityPolicyModelHelper.getWss11((WSDLComponent)secBinding.getParent())) != null) {
                    par.addExtensibilityElement((ExtensibilityElement)wss11.copy((Component)par));
                }
                if ((trust = SecurityPolicyModelHelper.getTrust((WSDLComponent)secBinding.getParent(), this.configVersion)) != null) {
                    par.addExtensibilityElement((ExtensibilityElement)trust.copy((Component)par));
                }
                spmh.setSecurityBindingType(c, null);
                spmh.disableWss(c);
                spmh.disableTrust(c);
                Object copyto = PolicyModelHelper.getTopLevelElement(par, All.class, false);
                ExtensibilityElement bType = SecurityPolicyModelHelper.getSecurityBindingTypeElement(par);
                copyto.addExtensibilityElement((ExtensibilityElement)bType.copy(copyto));
                ((WSDLComponent)bType.getParent()).removeExtensibilityElement(bType);
                wss10 = SecurityPolicyModelHelper.getWss10(par);
                if (wss10 != null) {
                    copyto.addExtensibilityElement((ExtensibilityElement)wss10.copy(copyto));
                    ((WSDLComponent)wss10.getParent()).removeExtensibilityElement((ExtensibilityElement)wss10);
                }
                if ((wss11 = SecurityPolicyModelHelper.getWss11(par)) != null) {
                    copyto.addExtensibilityElement((ExtensibilityElement)wss11.copy(copyto));
                    ((WSDLComponent)wss11.getParent()).removeExtensibilityElement((ExtensibilityElement)wss11);
                }
                if ((trust = SecurityPolicyModelHelper.getTrust(par, this.configVersion)) != null) {
                    copyto.addExtensibilityElement((ExtensibilityElement)trust.copy(copyto));
                    ((WSDLComponent)trust.getParent()).removeExtensibilityElement((ExtensibilityElement)trust);
                }
                for (int suppTokenType = 0; suppTokenType < 3; ++suppTokenType) {
                    ExtensibilityElement suppToken = (ExtensibilityElement)SecurityTokensModelHelper.getSupportingToken(par, suppTokenType);
                    if (suppToken == null) continue;
                    copyto.addExtensibilityElement((ExtensibilityElement)suppToken.copy(copyto));
                    ((WSDLComponent)suppToken.getParent()).removeExtensibilityElement(suppToken);
                }
            }
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
    }
}

