/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.ri.platform.loader;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.modules.javacard.common.NodeRefresher;
import org.netbeans.modules.javacard.common.Utils;
import org.netbeans.modules.javacard.ri.card.RICard;
import org.netbeans.modules.javacard.ri.platform.loader.CardChildren;
import org.netbeans.modules.javacard.spi.AbstractCard;
import org.netbeans.modules.javacard.spi.Card;
import org.netbeans.modules.javacard.spi.CardState;
import org.netbeans.modules.javacard.spi.CardStateObserver;
import org.netbeans.modules.javacard.spi.ICardCapability;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.netbeans.modules.javacard.spi.actions.CardActions;
import org.netbeans.modules.javacard.spi.capabilities.CardInfo;
import org.netbeans.modules.javacard.spi.capabilities.StopCapability;
import org.netbeans.modules.propdos.ObservableProperties;
import org.netbeans.modules.propdos.PropertiesAdapter;
import org.netbeans.modules.propdos.PropertiesBasedDataObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.InstanceContent;

public class CardDataObject
extends PropertiesBasedDataObject<Card>
implements CardStateObserver {
    private static final String ICON_BASE = "org/netbeans/modules/javacard/ri/platform/loader/card.png";
    private Reference<Card> cardRef;
    private Reference<CardDataNode> nodeRef;
    private String platformName;
    private String myName;
    private static final RequestProcessor RP = new RequestProcessor(CardDataObject.class);
    private boolean deleting;
    private final Object cardLock = new Object();

    public CardDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader, Card.class);
        this.content.add((Object)new StringBuilder("platform"), (InstanceContent.Convertor)new PlatformConverter());
        this.content.add((Object)new NR());
        this.platformName = pf.getParent().getName();
        this.myName = pf.getName();
    }

    protected Node createNodeDelegate() {
        CardDataNode result = new CardDataNode(this);
        this.nodeRef = new WeakReference<CardDataNode>(result);
        return result;
    }

    public void refreshNode() {
        CardDataNode nd;
        if (this.deleting || !this.isValid()) {
            return;
        }
        CardDataNode cardDataNode = nd = this.nodeRef == null ? null : this.nodeRef.get();
        if (nd != null) {
            nd.checkForRunningStateChange();
            nd.updateChildren();
        }
    }

    public boolean isDeleteAllowed() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDelete(FileObject parentFolder) throws Exception {
        this.deleting = true;
        try {
            FileObject fo;
            File eepromfile;
            StopCapability c;
            Card card = (Card)this.getLookup().lookup(Card.class);
            if (card != null && card.getState().isRunning() && (c = (StopCapability)card.getCapability(StopCapability.class)) != null) {
                c.stop();
            }
            if ((eepromfile = Utils.eepromFileForDevice((String)this.platformName, (String)this.myName, (boolean)false)) != null && (fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)eepromfile))) != null) {
                fo.delete();
            }
        }
        finally {
            this.deleting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onReplaceObject() {
        StopCapability stopper;
        Card old;
        Object object = this.cardLock;
        synchronized (object) {
            old = this.cardRef == null ? null : this.cardRef.get();
            this.cardRef = null;
        }
        if (old != null && old.getState().isRunning() && (stopper = (StopCapability)old.getCapability(StopCapability.class)) != null) {
            stopper.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Card createFrom(ObservableProperties properties) {
        CardDataNode nd;
        Object platform;
        Object result = null;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "CardDataObject.createFrom() " + this.getPrimaryFile().getPath());
        }
        Object object = this.cardLock;
        synchronized (object) {
            if (this.cardRef != null && (result = this.cardRef.get()) != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "CardDataObject.createFrom() returning cached instance");
                }
                return result;
            }
        }
        if (result == null) {
            platform = this.findPlatform();
            if (properties.isEmpty() || platform == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Empty properties - returning broken card instance");
                }
                result = AbstractCard.createBrokenCard((String)this.getName());
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "No cached instance - invoking Card.create() for {0} with {1}", new Object[]{platform.getDisplayName(), properties});
                }
                result = new RICard((DataObject)this, (JavacardPlatform)platform, this.getName());
            }
        }
        assert (result != null);
        result.addCardStateObserver((CardStateObserver)WeakListeners.create(CardStateObserver.class, (EventListener)((Object)this), (Object)result));
        platform = this.cardLock;
        synchronized (platform) {
            this.cardRef = new WeakReference<Card>((Card)result);
        }
        CardDataNode cardDataNode = nd = this.nodeRef == null ? null : this.nodeRef.get();
        if (nd != null) {
            nd.checkForRunningStateChange();
        }
        return result;
    }

    public JavacardPlatform findPlatform() {
        DataObject ob = this.findPlatformDataObject();
        JavacardPlatform platform = ob == null ? null : (JavacardPlatform)ob.getLookup().lookup(JavacardPlatform.class);
        return platform;
    }

    private DataObject findPlatformDataObject() {
        FileObject fo = this.getPrimaryFile().getParent();
        String lookFor = fo.getName();
        return Utils.findPlatformDataObjectNamed((String)lookFor);
    }

    public void onStateChange(Card card, CardState old, CardState nue) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                CardDataNode nd;
                CardDataNode cardDataNode = nd = CardDataObject.this.nodeRef == null ? null : (CardDataNode)((Object)CardDataObject.this.nodeRef.get());
                if (nd != null) {
                    nd.checkForRunningStateChange();
                }
            }
        });
    }

    protected void propertyChanged(String propertyName, String newValue) {
        this.firePropertyChange(propertyName, null, newValue);
    }

    final class CardDataNode
    extends DataNode {
        private volatile boolean listening;
        private CardStateObserver childrenUpdater;
        private Card card;
        boolean checkingState;

        CardDataNode(CardDataObject ob) {
            super((DataObject)ob, Children.LEAF, ob.getLookup());
            this.childrenUpdater = new CardStateObserver(){

                public void onStateChange(Card card, CardState old, CardState nue) {
                    if (CardDataNode.this.getDataObject().isValid()) {
                        CardDataNode.this.updateChildren();
                    }
                }
            };
            this.setName(ob.getName());
            this.updateChildren();
        }

        private void startListening(Card card) {
            if (!(card == null || this.listening && this.card == card)) {
                card.addCardStateObserver((CardStateObserver)new WeakCardStateObserver(card, this.childrenUpdater));
                this.listening = true;
            }
            this.card = card;
        }

        void updateChildren() {
            this.checkForRunningStateChange();
            if (!this.getDataObject().isValid()) {
                this.setChildren(Children.LEAF);
                return;
            }
            Card c = (Card)this.getDataObject().getLookup().lookup(Card.class);
            boolean activeChildren = c == null ? false : !c.getState().isNotRunning();
            this.startListening(this.card);
            if (activeChildren) {
                Children kids = Children.create((ChildFactory)new CardChildren(CardDataObject.this), (boolean)true);
                this.setChildren(kids);
            } else {
                AbstractNode nd = new AbstractNode(Children.LEAF){

                    public String getHtmlDisplayName() {
                        return "<font color='!controlShadow'>" + this.getDisplayName();
                    }

                    public Image getIcon(int icon) {
                        return super.getIcon(icon);
                    }

                    public Image getOpenedIcon(int type) {
                        return super.getOpenedIcon(type);
                    }
                };
                nd.setDisplayName(NbBundle.getMessage(CardDataNode.class, (String)"MSG_NOT_STARTED"));
                Children.Array kids = new Children.Array();
                kids.add(new Node[]{nd});
                this.setChildren((Children)kids);
            }
        }

        public Image getIcon(int ignored) {
            Card cardLocal;
            Image result = ImageUtilities.loadImage((String)CardDataObject.ICON_BASE);
            Card card = cardLocal = CardDataObject.this.cardRef == null ? null : (Card)CardDataObject.this.cardRef.get();
            if (cardLocal != null && cardLocal.getState().isRunning()) {
                Image badge = ImageUtilities.loadImage((String)"org/netbeans/modules/javacard/spi/resources/running.png");
                result = ImageUtilities.mergeImages((Image)result, (Image)badge, (int)11, (int)11);
            } else if (cardLocal != null && !cardLocal.isValid()) {
                Image badge = ImageUtilities.loadImage((String)"org/netbeans/modules/javacard/ri/platform/loader/errorBadge.png");
                result = ImageUtilities.mergeImages((Image)result, (Image)badge, (int)11, (int)11);
            }
            return result;
        }

        protected Sheet createSheet() {
            Sheet sheet = super.createSheet();
            PropertiesBasedDataObject ob = (PropertiesBasedDataObject)this.getLookup().lookup(PropertiesBasedDataObject.class);
            sheet.put(ob.getPropertiesAsPropertySet());
            Sheet.Set set = new Sheet.Set();
            set.setDisplayName(NbBundle.getMessage(CardDataNode.class, (String)"PROP_SET_OTHER"));
            set.setName(set.getDisplayName());
            set.put((Node.Property)new StateProp());
            set.put((Node.Property)new CapabilitiesProp());
            set.put((Node.Property)new EnabledCapabilitiesProp());
            sheet.put(set);
            return sheet;
        }

        public Action getPreferredAction() {
            return CardActions.createCustomizeAction();
        }

        public String getHtmlDisplayName() {
            if (this.card != null && !this.card.isValid()) {
                CardInfo info = (CardInfo)this.card.getCapability(CardInfo.class);
                String name = info == null ? this.card.toString() : info.getDisplayName();
                return "<font color='!nb.errorForeground'>" + name;
            }
            return null;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getName() {
            DataObject dob = (DataObject)this.getLookup().lookup(DataObject.class);
            return dob.getName();
        }

        public String getDisplayName() {
            DataObject dob = (DataObject)this.getLookup().lookup(DataObject.class);
            String result = null;
            if (dob != null) {
                if ("Default Device".equals(dob.getName())) {
                    result = NbBundle.getMessage(CardDataObject.class, (String)"DEFAULT_DEVICE_NAME");
                }
            } else {
                PropertiesAdapter p = (PropertiesAdapter)this.getLookup().lookup(PropertiesAdapter.class);
                result = p.asProperties().getProperty("javacard.device.name");
            }
            if (result == null) {
                result = dob.getName();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkForRunningStateChange() {
            if (this.checkingState) {
                return;
            }
            this.checkingState = true;
            try {
                this.fireIconChange();
            }
            finally {
                this.checkingState = false;
            }
        }

        private class StateProp
        extends PropertySupport.ReadOnly<String> {
            StateProp() {
                super("state", String.class, NbBundle.getMessage(StateProp.class, (String)"PROP_STATE"), NbBundle.getMessage(StateProp.class, (String)"DESC_PROP_STATE"));
            }

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                Card card = (Card)CardDataNode.this.getLookup().lookup(Card.class);
                return card.getState().toString();
            }
        }

        private class EnabledCapabilitiesProp
        extends CapabilitiesProp {
            EnabledCapabilitiesProp() {
                super("enabledCapabilities", "PROP_ENABLED_CAPABILITIES");
            }

            @Override
            protected Set<? extends Class<? extends ICardCapability>> value() {
                Card card = (Card)CardDataNode.this.getLookup().lookup(Card.class);
                return card.getEnabledCapabilities();
            }
        }

        private class CapabilitiesProp
        extends PropertySupport.ReadOnly<String> {
            CapabilitiesProp() {
                this("capabilities", "PROP_CAPABILITIES");
            }

            CapabilitiesProp(String name, String key) {
                super(name, String.class, NbBundle.getMessage(CapabilitiesProp.class, (String)key), NbBundle.getMessage(CapabilitiesProp.class, (String)("DESC_" + key)));
            }

            protected Set<? extends Class<? extends ICardCapability>> value() {
                Card card = (Card)CardDataNode.this.getLookup().lookup(Card.class);
                return card.getSupportedCapabilities();
            }

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                Set<? extends Class<? extends ICardCapability>> set = this.value();
                ArrayList<String> s = new ArrayList<String>();
                for (Class<? extends ICardCapability> clazz : set) {
                    s.add(clazz.getName());
                }
                Collections.sort(s);
                StringBuilder sb = new StringBuilder();
                for (String st : s) {
                    if (sb.length() != 0) {
                        sb.append(',');
                    }
                    sb.append(st);
                }
                return sb.toString();
            }
        }
    }

    private static final class WeakCardStateObserver
    implements CardStateObserver {
        private final Reference<CardStateObserver> proxy;

        WeakCardStateObserver(Card card, CardStateObserver real) {
            this.proxy = new WeakReference<CardStateObserver>(real);
        }

        public void onStateChange(Card card, CardState old, CardState nue) {
            CardStateObserver real = this.proxy.get();
            if (real == null) {
                card.removeCardStateObserver((CardStateObserver)this);
            } else {
                real.onStateChange(card, old, nue);
            }
        }
    }

    private class PlatformConverter
    implements InstanceContent.Convertor<StringBuilder, JavacardPlatform> {
        private PlatformConverter() {
        }

        public JavacardPlatform convert(StringBuilder arg0) {
            return CardDataObject.this.findPlatform();
        }

        public Class<? extends JavacardPlatform> type(StringBuilder arg0) {
            return JavacardPlatform.class;
        }

        public String id(StringBuilder arg0) {
            return "platform";
        }

        public String displayName(StringBuilder arg0) {
            return CardDataObject.this.getName();
        }
    }

    private class NR
    implements NodeRefresher {
        private NR() {
        }

        public void refreshNode() {
            CardDataObject.this.refreshNode();
        }
    }
}

