/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.ParseException;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.nativeexecution.api.util.RemoteStatistics;
import org.netbeans.modules.nativeexecution.support.Encrypter;
import org.netbeans.modules.nativeexecution.support.InstalledFileLocatorProvider;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.MiscUtils;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public class HelperUtility {
    protected static final java.util.logging.Logger log = Logger.getInstance();
    private final HashMap<ExecutionEnvironment, String> cache = new HashMap();
    private final String pattern;
    protected final String codeNameBase;

    public HelperUtility(String searchPattern) {
        this("org.netbeans.modules.dlight.nativeexecution", searchPattern);
    }

    public HelperUtility(String codeNameBase, String searchPattern) {
        this.codeNameBase = codeNameBase;
        this.pattern = searchPattern;
    }

    public final String getPath(ExecutionEnvironment env) throws IOException {
        HostInfo hinfo;
        try {
            hinfo = HostInfoUtils.getHostInfo(env);
        }
        catch (ConnectionManager.CancellationException ex) {
            return null;
        }
        return this.getPath(env, hinfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getPath(ExecutionEnvironment env, HostInfo hinfo) throws IOException {
        String result;
        if (!ConnectionManager.getInstance().isConnectedTo(env, false)) {
            log.log(Level.FINE, env.toString() + " is not connected", new IllegalStateException(env.toString() + " is not connected"));
        }
        HashMap<ExecutionEnvironment, String> hashMap = this.cache;
        synchronized (hashMap) {
            result = this.cache.get(env);
            if (result == null) {
                try {
                    File localFile = this.getLocalFileFromSysProp(hinfo);
                    if (localFile == null) {
                        localFile = this.getLocalFile(hinfo);
                    }
                    if (localFile == null) {
                        localFile = this.getLocalFile(env);
                    }
                    String fileName = localFile.getName();
                    HostInfo localHostInfo = env.isLocal() ? hinfo : HostInfoUtils.getHostInfo(ExecutionEnvironmentFactory.getLocal());
                    File localTmpBase = localHostInfo.getTempDirFile();
                    String key = localFile.getAbsolutePath().concat(env.getDisplayName());
                    String hash = Integer.toString(key.hashCode()).replace('-', '0');
                    File safeLocalDir = new File(localTmpBase, hash);
                    safeLocalDir.mkdirs();
                    File safeLocalFile = new File(safeLocalDir, fileName);
                    HelperUtility.copyFile(localFile, safeLocalFile);
                    if (env.isLocal()) {
                        result = safeLocalFile.getAbsolutePath();
                    } else {
                        Logger.assertNonUiThread("Potentially long method " + this.getClass().getName() + ".getPath() is invoked in AWT thread");
                        String remoteDir = hinfo.getTempDir() + '/' + hash;
                        String remoteFile = remoteDir + '/' + fileName;
                        ConnectionManagerAccessor cmAccess = ConnectionManagerAccessor.getDefault();
                        ChannelSftp channel = (ChannelSftp)cmAccess.openAndAcquireChannel(env, "sftp", true);
                        if (channel == null) {
                            return null;
                        }
                        RemoteStatistics.ActivityID activityID = RemoteStatistics.startChannelActivity("UploadHelperUtility", localFile.getAbsolutePath());
                        long remoteSize = -1L;
                        try {
                            channel.connect();
                            long localSize = safeLocalFile.length();
                            try {
                                SftpATTRS rstat = channel.stat(remoteFile);
                                remoteSize = rstat.getSize();
                            }
                            catch (SftpException ex) {
                                // empty catch block
                            }
                            if (remoteSize >= 0L && localSize != remoteSize) {
                                channel.rm(remoteFile);
                                remoteSize = -1L;
                            }
                            if (remoteSize < 0L) {
                                try {
                                    channel.lstat(remoteDir);
                                }
                                catch (SftpException ex) {
                                    channel.mkdir(remoteDir);
                                }
                                channel.put(safeLocalFile.getAbsolutePath(), remoteFile);
                                channel.chmod(448, remoteFile);
                            }
                            result = remoteFile;
                        }
                        catch (SftpException ex) {
                            log.log(Level.WARNING, "Failed to upload {0}", fileName);
                            if (remoteSize >= 0L) {
                                log.log(Level.WARNING, "File {0} exists, but cannot be updated. Used by other process?", remoteFile);
                            } else {
                                log.log(Level.WARNING, "File {0} doesn't exist, and cannot be uploaded. Do you have enough privileges?", remoteFile);
                            }
                            log.log(Level.WARNING, "You could try to use -J-Dcnd.tmpbase=<other base location> to re-define default one.");
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        finally {
                            RemoteStatistics.stopChannelActivity(activityID);
                            cmAccess.closeAndReleaseChannel(env, (Channel)channel);
                        }
                    }
                    this.cache.put(env, result);
                }
                catch (MissingResourceException ex) {
                    return null;
                }
                catch (JSchException ex) {
                    if (MiscUtils.isJSCHTooLongException((Exception)((Object)ex))) {
                        MiscUtils.showJSCHTooLongNotification(env.getDisplayName());
                    }
                    throw new IOException(ex);
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    if (ex.getCause() instanceof IOException) {
                        throw (IOException)ex.getCause();
                    }
                    throw new IOException(ex);
                }
            }
        }
        return result;
    }

    protected File getLocalFile(HostInfo hinfo) throws MissingResourceException {
        return null;
    }

    protected File getLocalFile(ExecutionEnvironment env) throws ParseException, MissingResourceException {
        MacroExpanderFactory.MacroExpander expander;
        String path;
        InstalledFileLocator fl = InstalledFileLocatorProvider.getDefault();
        File file = fl.locate(path = (expander = MacroExpanderFactory.getExpander(env)).expandPredefinedMacros(this.pattern), this.codeNameBase, false);
        if (file == null || !file.exists()) {
            throw new MissingResourceException(path, null, null);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File srcFile, File dstFile) throws IOException {
        boolean wasRemoved;
        if (dstFile.exists() && !(wasRemoved = dstFile.delete())) {
            long dstCRC;
            long srcCRC = Encrypter.getFileChecksum(srcFile.getAbsolutePath());
            if (srcCRC == (dstCRC = Encrypter.getFileChecksum(dstFile.getAbsolutePath()))) {
                return;
            }
            log.log(Level.INFO, "Failed to copy {0} to {1}", new Object[]{srcFile, dstFile});
        }
        dstFile.getParentFile().mkdirs();
        dstFile.createNewFile();
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(srcFile).getChannel();
            destination = new FileOutputStream(dstFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
            dstFile.setExecutable(true);
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    private File getLocalFileFromSysProp(HostInfo hostInfo) {
        File res;
        String osname = hostInfo.getOS().getFamily().cname();
        String platform = hostInfo.getCpuFamily().name().toLowerCase();
        String bitness = hostInfo.getOS().getBitness() == HostInfo.Bitness._64 ? "_64" : "";
        StringBuilder propName = new StringBuilder(this.getClass().getSimpleName());
        propName.append('.').append(osname).append('-').append(platform).append(bitness).append(".exec");
        String prop = System.getProperty(propName.toString());
        if (prop != null && (res = new File(prop)).canRead()) {
            log.log(Level.WARNING, "Using an executable specified by {0} system property for {1}: {2}", new Object[]{propName, this.getClass().getSimpleName(), res.getAbsolutePath()});
            return res;
        }
        return null;
    }
}

