/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.nativeexecution.api.util.SftpSupport;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.filesearch.FileSearchParams;
import org.netbeans.modules.nativeexecution.support.filesearch.FileSearchSupport;
import org.netbeans.modules.nativeexecution.support.hostinfo.FetchHostInfoTask;
import org.openide.util.RequestProcessor;

public final class HostInfoUtils {
    public static final String LOCALHOST = "localhost";
    private static final Future<List<String>> myAddresses;
    private static final ConcurrentHashMap<ExecutionEnvironment, HostInfo> cache;

    private HostInfoUtils() {
    }

    public static void dumpInfo(HostInfo hostinfo, PrintStream stream) {
        stream.println("------------");
        if (hostinfo == null) {
            stream.println("HostInfo is NULL");
        } else {
            stream.println("Hostname      : " + hostinfo.getHostname());
            stream.println("OS Family     : " + (Object)((Object)hostinfo.getOSFamily()));
            stream.println("OS            : " + hostinfo.getOS().getName());
            stream.println("OS Version    : " + hostinfo.getOS().getVersion());
            stream.println("OS Bitness    : " + (Object)((Object)hostinfo.getOS().getBitness()));
            stream.println("CPU Family    : " + (Object)((Object)hostinfo.getCpuFamily()));
            stream.println("CPU #         : " + hostinfo.getCpuNum());
            stream.println("login shell   : " + hostinfo.getLoginShell());
            stream.println("shell         : " + hostinfo.getShell());
            stream.println("tmpdir to use : " + hostinfo.getTempDir());
            stream.println("tmpdir (file) to use : " + hostinfo.getTempDirFile().toString());
        }
        stream.println("------------");
    }

    public static boolean fileExists(ExecutionEnvironment execEnv, String fname) throws ConnectException, IOException, InterruptedException {
        if (execEnv.isLocal()) {
            return new File(fname).exists();
        }
        if (!ConnectionManager.getInstance().isConnectedTo(execEnv)) {
            throw new ConnectException();
        }
        try {
            SftpSupport.getInstance(execEnv).lstat(fname).get();
            return true;
        }
        catch (ExecutionException ex) {
            FileInfoProvider.SftpIOException e;
            if (ex.getCause() instanceof FileInfoProvider.SftpIOException && 2 == (e = (FileInfoProvider.SftpIOException)ex.getCause()).getId()) {
                return false;
            }
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw new IOException(ex);
        }
    }

    public static boolean directoryExists(ExecutionEnvironment execEnv, String fname) throws ConnectException, IOException, InterruptedException {
        if (execEnv.isLocal()) {
            return new File(fname).exists();
        }
        if (!ConnectionManager.getInstance().isConnectedTo(execEnv)) {
            throw new ConnectException();
        }
        try {
            FileInfoProvider.StatInfo statInfo = SftpSupport.getInstance(execEnv).stat(fname).get();
            return statInfo.isDirectory();
        }
        catch (ExecutionException ex) {
            FileInfoProvider.SftpIOException e;
            if (ex.getCause() instanceof FileInfoProvider.SftpIOException && 2 == (e = (FileInfoProvider.SftpIOException)ex.getCause()).getId()) {
                return false;
            }
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw new IOException(ex);
        }
    }

    public static String searchFile(ExecutionEnvironment execEnv, List<String> searchPaths, String file, boolean searchInUserPaths) {
        String result = null;
        try {
            result = new FileSearchSupport().searchFile(new FileSearchParams(execEnv, searchPaths, file, searchInUserPaths));
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return result;
    }

    public static boolean isLocalhost(String host) {
        if (LOCALHOST.equals(host)) {
            return true;
        }
        boolean result = false;
        try {
            result = myAddresses.get().contains(InetAddress.getByName(host).getHostAddress());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static boolean isHostInfoAvailable(ExecutionEnvironment execEnv) {
        return cache.containsKey(execEnv);
    }

    public static HostInfo getHostInfo(ExecutionEnvironment execEnv) throws IOException, ConnectionManager.CancellationException {
        return HostInfoUtils.getHostInfo(execEnv, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HostInfo getHostInfo(ExecutionEnvironment execEnv, boolean connecting) throws IOException, ConnectionManager.CancellationException {
        if (execEnv == null) {
            throw new IllegalArgumentException("ExecutionEnvironment should not be null");
        }
        if (!HostInfoUtils.isHostInfoAvailable(execEnv)) {
            Logger.assertNonUiThread("Don't call getHostInfo() from the UI thread while info is not known. Use quick isHostInfoAvailable() to detect whether info is available or not and go out of EDT if not");
        }
        Class<HostInfoUtils> clazz = HostInfoUtils.class;
        synchronized (HostInfoUtils.class) {
            HostInfo result = cache.get(execEnv);
            if (result == null) {
                try {
                    if (!ConnectionManager.getInstance().isConnectedTo(execEnv, !connecting)) {
                        ConnectionManager.getInstance().connectTo(execEnv);
                        result = cache.get(execEnv);
                        if (result != null) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return result;
                        }
                    }
                    if ((result = new FetchHostInfoTask().compute(execEnv)) == null) {
                        throw new IOException("Error getting host info for " + execEnv);
                    }
                    cache.put(execEnv, result);
                }
                catch (InterruptedException ex) {
                    throw new ConnectionManager.CancellationException("getHostInfo(" + execEnv.getDisplayName() + ") cancelled.");
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    public static void updateHostInfo(ExecutionEnvironment execEnv) throws IOException, InterruptedException {
        HostInfo result = new FetchHostInfoTask().compute(execEnv);
        if (result != null) {
            cache.put(execEnv, result);
        }
    }

    protected static void resetHostsData() {
        cache.clear();
    }

    static {
        cache = new ConcurrentHashMap();
        myAddresses = RequestProcessor.getDefault().submit((Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                ArrayList<String> result = new ArrayList<String>();
                try {
                    Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
                    while (ifaces.hasMoreElements()) {
                        NetworkInterface iface = ifaces.nextElement();
                        Enumeration<InetAddress> ips = iface.getInetAddresses();
                        while (ips.hasMoreElements()) {
                            result.add(ips.nextElement().getHostAddress());
                        }
                    }
                }
                catch (Throwable th) {
                    Logger.getInstance().log(Level.INFO, "Exception while getting localhost IP", th);
                }
                return result;
            }
        });
    }
}

