/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.downloader.dispatcher.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.netbeans.installer.downloader.dispatcher.LoadFactor;
import org.netbeans.installer.downloader.dispatcher.Process;
import org.netbeans.installer.downloader.dispatcher.ProcessDispatcher;
import org.netbeans.installer.downloader.dispatcher.impl.Worker;
import org.netbeans.installer.downloader.dispatcher.impl.WorkersPool;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.helper.MutualHashMap;
import org.netbeans.installer.utils.helper.MutualMap;

public class RoundRobinDispatcher
implements ProcessDispatcher {
    private static final Map<LoadFactor, Byte> quantumToSkip = new HashMap<LoadFactor, Byte>();
    private final int timeQuantum;
    private final WorkersPool pool;
    private final BlockingQueue<Worker> workingQueue;
    private final Queue<Process> waitingQueue;
    private final MutualMap<Process, Worker> proc2Worker;
    private Set<Worker> makedToStop = new HashSet<Worker>();
    private Thread dispatcherThread;
    private Terminator terminator = new Terminator();
    private boolean isActive;
    private LoadFactor factor;

    public RoundRobinDispatcher(int quantum, int poolSize) {
        if (quantum < 10 || poolSize < 1) {
            throw new IllegalArgumentException();
        }
        this.timeQuantum = quantum;
        this.pool = new WorkersPool(poolSize);
        this.workingQueue = new ArrayBlockingQueue<Worker>(poolSize);
        this.waitingQueue = new LinkedList<Process>();
        this.proc2Worker = new MutualHashMap<Process, Worker>();
        this.factor = LoadFactor.FULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean schedule(Process process) {
        Queue<Process> queue = this.waitingQueue;
        synchronized (queue) {
            this.waitingQueue.offer(process);
            this.waitingQueue.notify();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void terminate(Process process) {
        Queue<Process> queue = this.waitingQueue;
        synchronized (queue) {
            if (this.waitingQueue.remove(process)) {
                return;
            }
        }
        Worker stoped = (Worker)this.proc2Worker.get(process);
        this.makedToStop.add(stoped);
        this.terminateInternal(process);
    }

    @Override
    public void setLoadFactor(LoadFactor factor) {
        this.factor = factor;
    }

    @Override
    public LoadFactor loadFactor() {
        return this.factor;
    }

    private void terminateInternal(Process process) {
        Worker worker = (Worker)this.proc2Worker.get(process);
        if (worker == null) {
            return;
        }
        if (worker.isFree()) {
            return;
        }
        if (!this.terminator.isAlive()) {
            this.terminator.start();
        }
        this.terminator.terminate(process);
        SystemUtils.sleep(this.timeQuantum);
        if (this.terminator.isBusy()) {
            this.terminator.stop();
            this.terminator = new Terminator();
        }
        if (!worker.isFree()) {
            worker.stop();
        }
        this.proc2Worker.remove(process);
        this.pool.release(worker);
        this.workingQueue.remove(worker);
    }

    @Override
    public synchronized boolean isActive() {
        return this.isActive;
    }

    @Override
    public int activeCount() {
        return this.proc2Worker.size();
    }

    @Override
    public int waitingCount() {
        return this.waitingQueue.size();
    }

    @Override
    public synchronized void start() {
        if (this.isActive) {
            return;
        }
        this.dispatcherThread = new Thread(new DispatcherWorker());
        this.dispatcherThread.setDaemon(true);
        this.dispatcherThread.start();
        this.isActive = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (!this.isActive) {
            return;
        }
        this.dispatcherThread.interrupt();
        try {
            this.dispatcherThread.join(this.timeQuantum * (this.pool.capacity() + 3));
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (this.dispatcherThread.isAlive()) {
                this.dispatcherThread.stop();
            }
        }
        this.waitingQueue.clear();
        this.isActive = false;
    }

    static {
        quantumToSkip.put(LoadFactor.FULL, (byte)0);
        quantumToSkip.put(LoadFactor.AVERAGE, (byte)2);
        quantumToSkip.put(LoadFactor.LOW, (byte)10);
    }

    private class Terminator
    extends Thread {
        private Process current;

        public Terminator() {
            this.setDaemon(true);
        }

        public synchronized void terminate(Process process) {
            this.current = process;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Terminator terminator = this;
                synchronized (terminator) {
                    try {
                        Thread.interrupted();
                        if (this.current == null) {
                            this.wait();
                            if (this.current == null) {
                                continue;
                            }
                        }
                        Worker worker = (Worker)RoundRobinDispatcher.this.proc2Worker.get(this.current);
                        worker.resume();
                        worker.interrupt();
                        try {
                            this.current.terminate();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.current = null;
                    }
                    catch (InterruptedException e) {
                        ErrorManager.notifyDebug("Terminator thread interrupted", e);
                        break;
                    }
                }
            }
        }

        public synchronized boolean isBusy() {
            return this.current == null;
        }
    }

    private class DispatcherWorker
    implements Runnable {
        Worker current;

        private DispatcherWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    this.current = (Worker)RoundRobinDispatcher.this.workingQueue.poll();
                    if (this.current == null || RoundRobinDispatcher.this.makedToStop.contains(this.current)) {
                        Queue queue = RoundRobinDispatcher.this.waitingQueue;
                        synchronized (queue) {
                            if (RoundRobinDispatcher.this.waitingQueue.isEmpty()) {
                                RoundRobinDispatcher.this.waitingQueue.wait();
                            }
                        }
                        this.filWorkingQueue();
                        continue;
                    }
                    this.invokeCurrent();
                    Thread.sleep(RoundRobinDispatcher.this.timeQuantum);
                    this.suspendCurrent();
                    if (RoundRobinDispatcher.this.factor == LoadFactor.FULL) continue;
                    Thread.sleep((Byte)quantumToSkip.get((Object)RoundRobinDispatcher.this.factor) * RoundRobinDispatcher.this.timeQuantum);
                }
                catch (InterruptedException exit) {
                    this.suspendCurrent();
                    break;
                }
            }
            this.terminateAll();
        }

        private void terminateAll() {
            for (Worker worker : RoundRobinDispatcher.this.workingQueue.toArray(new Worker[0])) {
                RoundRobinDispatcher.this.terminateInternal((Process)RoundRobinDispatcher.this.proc2Worker.reversedGet(worker));
            }
        }

        private void invokeCurrent() {
            switch (this.current.getState()) {
                case NEW: {
                    this.current.start();
                    break;
                }
                case RUNNABLE: {
                    this.current.resume();
                    break;
                }
                case TERMINATED: {
                    break;
                }
                default: {
                    this.current.resume();
                }
            }
        }

        private void suspendCurrent() {
            if (this.current == null) {
                return;
            }
            if (RoundRobinDispatcher.this.makedToStop.contains(this.current)) {
                return;
            }
            this.current.suspend();
            if (this.current.isAlive() && !this.current.isFree()) {
                RoundRobinDispatcher.this.workingQueue.offer(this.current);
            } else {
                RoundRobinDispatcher.this.proc2Worker.reversedRemove(this.current);
                RoundRobinDispatcher.this.pool.release(this.current);
            }
            this.filWorkingQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void filWorkingQueue() {
            if (RoundRobinDispatcher.this.waitingQueue.size() == 0 || RoundRobinDispatcher.this.pool.remaining() == 0) {
                return;
            }
            Queue queue = RoundRobinDispatcher.this.waitingQueue;
            synchronized (queue) {
                while (RoundRobinDispatcher.this.workingQueue.remainingCapacity() > 0) {
                    if (RoundRobinDispatcher.this.waitingQueue.isEmpty()) {
                        return;
                    }
                    Worker worker = RoundRobinDispatcher.this.pool.tryAcquire();
                    Process process = (Process)RoundRobinDispatcher.this.waitingQueue.poll();
                    worker.setCurrent(process);
                    RoundRobinDispatcher.this.proc2Worker.put(process, worker);
                    RoundRobinDispatcher.this.makedToStop.remove(worker);
                    RoundRobinDispatcher.this.workingQueue.add(worker);
                }
            }
        }
    }
}

