/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.global;

import java.util.Arrays;

public class InstrumentationFilter
implements Cloneable {
    public static final int INSTR_FILTER_NONE = 0;
    public static final int INSTR_FILTER_EXCLUSIVE = 10;
    public static final int INSTR_FILTER_INCLUSIVE = 20;
    public static final int INSTR_FILTER_EXCLUSIVE_EXACT = 30;
    public static final int INSTR_FILTER_INCLUSIVE_EXACT = 40;
    private static final int FILTER_MATCHES = 1;
    private static final int FILTER_STARTS = 2;
    private static final int FILTER_STARTS_EX = 3;
    private static InstrumentationFilter defaultInstance;
    private String[] instrFilterUserStrings;
    private String[] instrFilterStrings;
    private int[] instrFilterTypes;
    private int instrFilterType;
    private boolean hasArray;

    public InstrumentationFilter() {
        this.clearFilter();
    }

    public static InstrumentationFilter getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new InstrumentationFilter();
        }
        return defaultInstance;
    }

    public void setFilterStrings(String flatFilterString) {
        this.hasArray = (flatFilterString = flatFilterString.replace(',', ' ')).indexOf(91) > -1;
        this.setSlashedFilterStrings(flatFilterString.trim().split(" +"));
    }

    public String[] getFilterStrings() {
        return this.instrFilterStrings;
    }

    public String[] getUserFilterStrings() {
        return this.instrFilterUserStrings;
    }

    public void setFilterType(int filterType) {
        this.instrFilterType = filterType;
    }

    public int getFilterType() {
        return this.instrFilterType;
    }

    public void setSlashedFilterStrings(String[] slashedFilterStrings) {
        this.instrFilterStrings = slashedFilterStrings;
        this.instrFilterUserStrings = Arrays.copyOf(this.instrFilterStrings, this.instrFilterStrings.length);
        if (this.instrFilterType == 40 || this.instrFilterType == 30) {
            this.instrFilterTypes = new int[this.instrFilterStrings.length];
            Arrays.fill(this.instrFilterTypes, 1);
        } else {
            this.instrFilterTypes = null;
        }
        for (int i = 0; i < this.instrFilterStrings.length; ++i) {
            this.instrFilterStrings[i] = this.instrFilterStrings[i].replace('.', '/');
            if (this.instrFilterStrings[i].equals("*") || this.instrFilterStrings[i].equals("**")) {
                if (this.instrFilterTypes == null) continue;
                boolean _hasArray = this.hasArray;
                this.clearFilter();
                this.hasArray = _hasArray;
                break;
            }
            if (this.instrFilterStrings[i].endsWith("**")) {
                this.instrFilterStrings[i] = this.instrFilterStrings[i].substring(0, this.instrFilterStrings[i].length() - 2);
                if (this.instrFilterTypes == null) continue;
                this.instrFilterTypes[i] = 2;
                continue;
            }
            if (!this.instrFilterStrings[i].endsWith("*")) continue;
            this.instrFilterStrings[i] = this.instrFilterStrings[i].substring(0, this.instrFilterStrings[i].length() - 1);
            if (this.instrFilterTypes == null) continue;
            this.instrFilterTypes[i] = 3;
        }
    }

    public void clearFilter() {
        this.instrFilterType = 0;
        this.instrFilterStrings = new String[0];
        this.instrFilterTypes = null;
        this.hasArray = false;
    }

    public Object clone() throws CloneNotSupportedException {
        InstrumentationFilter clone = (InstrumentationFilter)super.clone();
        clone.instrFilterStrings = Arrays.copyOf(this.instrFilterStrings, this.instrFilterStrings.length);
        clone.instrFilterUserStrings = Arrays.copyOf(this.instrFilterUserStrings, this.instrFilterUserStrings.length);
        clone.instrFilterTypes = this.instrFilterTypes == null ? null : Arrays.copyOf(this.instrFilterTypes, this.instrFilterTypes.length);
        clone.hasArray = this.hasArray;
        return clone;
    }

    public String debug() {
        StringBuffer filterStringsBuffer = new StringBuffer();
        switch (this.instrFilterType) {
            case 0: {
                filterStringsBuffer.append("  Filter type: None\n");
                break;
            }
            case 10: {
                filterStringsBuffer.append("  Filter type: Exclusive\n");
                break;
            }
            case 20: {
                filterStringsBuffer.append("  Filter type: Inclusive\n");
                break;
            }
            case 30: {
                filterStringsBuffer.append("  Filter type: Exclusive exact\n");
                break;
            }
            case 40: {
                filterStringsBuffer.append("  Filter type: Inclusive exact\n");
            }
        }
        filterStringsBuffer.append("  Filter value: ");
        for (int i = 0; i < this.instrFilterStrings.length; ++i) {
            filterStringsBuffer.append(this.instrFilterStrings[i]);
            filterStringsBuffer.append(" ");
        }
        filterStringsBuffer.append("\n");
        return filterStringsBuffer.toString();
    }

    public boolean acceptsArrays() {
        switch (this.instrFilterType) {
            case 10: 
            case 20: {
                return true;
            }
            case 0: 
            case 40: {
                return this.hasArray;
            }
        }
        return true;
    }

    public void debugDump() {
        System.err.println("----------------------------------");
        System.err.println("Instrumentation filter debug dump:");
        switch (this.instrFilterType) {
            case 0: {
                System.err.println("  Filter type: None");
                break;
            }
            case 10: {
                System.err.println("  Filter type: Exclusive");
                break;
            }
            case 20: {
                System.err.println("  Filter type: Inclusive");
                break;
            }
            case 30: {
                System.err.println("  Filter type: Exclusive exact");
                break;
            }
            case 40: {
                System.err.println("  Filter type: Inclusive exact");
            }
        }
        StringBuffer filterStringsBuffer = new StringBuffer();
        for (int i = 0; i < this.instrFilterStrings.length; ++i) {
            filterStringsBuffer.append(this.instrFilterStrings[i]);
            filterStringsBuffer.append(" ");
        }
        System.err.println("  Filter strings: " + filterStringsBuffer.toString());
    }

    public boolean passesFilter(String string) {
        if (this.instrFilterType == 0) {
            return true;
        }
        if (this.instrFilterStrings.length == 0) {
            return true;
        }
        boolean filterInclusive = this.instrFilterType == 20 || this.instrFilterType == 40;
        for (int i = 0; i < this.instrFilterStrings.length; ++i) {
            int filterType;
            int n = filterType = this.instrFilterTypes == null ? this.instrFilterType : this.instrFilterTypes[i];
            if (!InstrumentationFilter.matches(filterType, string, this.instrFilterStrings[i])) continue;
            return filterInclusive;
        }
        return !filterInclusive;
    }

    private static boolean matches(int type, String string, String filter) {
        switch (type) {
            case 2: 
            case 10: 
            case 20: {
                return string.startsWith(filter);
            }
            case 1: 
            case 30: 
            case 40: {
                return string.equals(filter);
            }
            case 3: {
                if (!string.startsWith(filter)) {
                    return false;
                }
                for (int i = filter.length(); i < string.length(); ++i) {
                    if (string.charAt(i) != '/') continue;
                    return false;
                }
                return true;
            }
        }
        throw new IllegalArgumentException("Illegal filter type:" + type);
    }
}

