/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.StackTrace;
import org.netbeans.lib.profiler.heap.TagBounds;

class StackTraceSegment
extends TagBounds {
    HprofHeap hprofHeap;
    final int threadSerialNumberOffset;
    final int stackTraceSerialNumberOffset;
    final int lengthOffset;
    final int framesListOffset;
    final int numberOfFramesOffset;
    final int timeOffset;

    StackTraceSegment(HprofHeap heap, long start, long end) {
        super(5, start, end);
        this.hprofHeap = heap;
        this.timeOffset = 1;
        this.lengthOffset = this.timeOffset + 4;
        this.stackTraceSerialNumberOffset = this.lengthOffset + 4;
        this.threadSerialNumberOffset = this.stackTraceSerialNumberOffset + 4;
        this.numberOfFramesOffset = this.threadSerialNumberOffset + 4;
        this.framesListOffset = this.numberOfFramesOffset + 4;
    }

    StackTrace getStackTraceBySerialNumber(long stackTraceSerialNumber) {
        long[] offset = new long[]{this.startOffset};
        while (offset[0] < this.endOffset) {
            long start = offset[0];
            long serialNumber = this.readStackTraceTag(offset);
            if (serialNumber != stackTraceSerialNumber) continue;
            return new StackTrace(this, start);
        }
        return null;
    }

    private HprofByteBuffer getDumpBuffer() {
        HprofByteBuffer dumpBuffer = this.hprofHeap.dumpBuffer;
        return dumpBuffer;
    }

    private int readStackTraceTag(long[] offset) {
        long start = offset[0];
        if (this.hprofHeap.readTag(offset) != 5) {
            return 0;
        }
        return this.getDumpBuffer().getInt(start + (long)this.stackTraceSerialNumberOffset);
    }
}

