/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.ant;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.java.testrunner.OutputUtils;
import org.netbeans.modules.testng.api.TestNGTestSuite;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;

public class TestNGTestSession
extends TestSession {
    private LineConvertors.FileLocator projectFileLocator = null;
    private final List<TestNGTestSuite> suites = new ArrayList<TestNGTestSuite>();
    private TestSuite currentSuite;

    public TestNGTestSession(String name, Project project, TestSession.SessionType sessionType) {
        super(name, project, sessionType);
        if (project != null) {
            this.projectFileLocator = new ProjectFileLocator(project);
        }
    }

    public LineConvertors.FileLocator getFileLocator() {
        LineConvertors.FileLocator locator = super.getFileLocator();
        if (locator == null) {
            return this.projectFileLocator;
        }
        return locator;
    }

    public void addSuite(TestSuite suite) {
        super.addSuite(suite);
        this.suites.add((TestNGTestSuite)suite);
    }

    public TestSuite getCurrentSuite() {
        if (this.currentSuite == null) {
            return super.getCurrentSuite();
        }
        return this.currentSuite;
    }

    public void setCurrentSuite(String name) {
        for (TestNGTestSuite ts : this.suites) {
            if (!ts.getName().equals(name)) continue;
            this.currentSuite = ts;
            break;
        }
    }

    public String getSuiteName(String name) {
        int suitesNum = 0;
        for (TestNGTestSuite suite : this.suites) {
            if (!suite.getName().startsWith(name)) continue;
            ++suitesNum;
        }
        name = suitesNum == 0 ? name : name.concat(" ").concat(Integer.toString(suitesNum));
        return name;
    }

    class ProjectFileLocator
    implements LineConvertors.FileLocator {
        private ClassPath classpath;

        ProjectFileLocator(Project project) {
            this.classpath = this.getProjectClasspath(project);
        }

        public FileObject find(String filename) {
            return this.classpath.findResource(filename);
        }

        private ClassPath getProjectClasspath(Project p) {
            ClassPath result = null;
            HashSet<FileObject> roots = new HashSet<FileObject>();
            Sources sources = ProjectUtils.getSources((Project)p);
            if (sources != null) {
                SourceGroup[] groups;
                for (SourceGroup group : groups = sources.getSourceGroups("java")) {
                    roots.add(group.getRootFolder());
                }
            }
            ClassPathProvider cpp = (ClassPathProvider)p.getLookup().lookup(ClassPathProvider.class);
            HashSet<ClassPath> setCP = new HashSet<ClassPath>();
            if (cpp != null) {
                for (FileObject file : roots) {
                    ClassPath path = cpp.findClassPath(file, "classpath/compile");
                    setCP.add(path);
                }
            }
            for (ClassPath cp : setCP) {
                FileObject[] rootsCP;
                for (FileObject fo : rootsCP = cp.getRoots()) {
                    try {
                        FileObject[] aaa = SourceForBinaryQuery.findSourceRoots((URL)fo.getURL()).getRoots();
                        roots.addAll(Arrays.asList(aaa));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            String platformId = null;
            try {
                Method evalMethod = p.getClass().getDeclaredMethod("evaluator", new Class[0]);
                PropertyEvaluator evaluator = (PropertyEvaluator)evalMethod.invoke((Object)p, new Object[0]);
                if (evaluator != null) {
                    platformId = evaluator.getProperty("platform.active");
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            JavaPlatform platform = OutputUtils.getActivePlatform(platformId);
            if (platform != null) {
                roots.addAll(Arrays.asList(platform.getSourceFolders().getRoots()));
            }
            result = ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[roots.size()]));
            return result;
        }
    }
}

