/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.impl;

import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticIDs;
import org.clang.driver.Action;
import org.clang.driver.AssembleJobAction;
import org.clang.driver.BackendJobAction;
import org.clang.driver.BindArchAction;
import org.clang.driver.Compilation;
import org.clang.driver.CompileJobAction;
import org.clang.driver.Driver;
import org.clang.driver.InputAction;
import org.clang.driver.JobAction;
import org.clang.driver.PreprocessJobAction;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.options;
import org.clang.driver.tools.impl.darwin;
import org.clang.driver.types;
import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.DerivedArgList;
import org.llvm.option.OptSpecifier;
import org.llvm.option.OptTable;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_string_ostream;
import org.llvm.support.sys.Process;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;

public final class DriverStatics {
    public static Arg MakeInputArg(DerivedArgList Args, OptTable Opts, StringRef Value) {
        Arg A = new Arg(Opts.getOption(new OptSpecifier((long)options.ID.OPT_INPUT.getValue())), Value, Args.getBaseArgs().MakeIndex(Value), Value.data());
        Args.AddSynthesizedArg(A);
        A.claim();
        return A;
    }

    public static boolean ScanDirForExecutable(SmallString Dir, ArrayRef<std.string> Names) {
        for (std.string Name : Names) {
            path.append((SmallString)Dir, (std.string)Name);
            if (fs.can_execute((Twine)new Twine(Dir.$StringRef()))) {
                return true;
            }
            path.remove_filename((SmallString)Dir);
        }
        return false;
    }

    public static void PrintDiagnosticCategories(raw_ostream OS) {
        long max = DiagnosticIDs.getNumberOfCategories();
        for (long i = 1L; i != max; ++i) {
            OS.$out(i).$out(',').$out(DiagnosticIDs.getCategoryNameFromID((long)i)).$out('\n');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long PrintActions1(Compilation C, Action A, std.mapTypeUInt<Action> Ids) {
        std.string str = null;
        raw_string_ostream os = null;
        try {
            if (Ids.count((Object)A)) {
                long l = Ids.$at((Object)A);
                return l;
            }
            str = new std.string();
            os = new raw_string_ostream(str);
            os.$out(Action.getClassName(A.getKind())).$out((CharSequence)", ");
            InputAction IA = (InputAction)Casts.dyn_cast(InputAction.class, (Object)A);
            if (IA != null) {
                os.$out((CharSequence)"\"").$out(IA.getInputArg().getValue()).$out((CharSequence)"\"");
            } else {
                BindArchAction BIA = (BindArchAction)Casts.dyn_cast(BindArchAction.class, (Object)A);
                if (BIA != null) {
                    os.$out('\"').$out(BIA.getArchName()).$out('\"').$out((CharSequence)", {").$out(DriverStatics.PrintActions1(C, (Action)BIA.begin().$star(), Ids)).$out((CharSequence)"}");
                } else {
                    os.$out((CharSequence)"{");
                    SmallVectorImpl.iterator it = (SmallVectorImpl.iterator)Native.$tryClone(A.begin());
                    SmallVectorImpl.iterator ie = (SmallVectorImpl.iterator)Native.$tryClone(A.end());
                    while (it.$noteq((Object)ie)) {
                        os.$out(DriverStatics.PrintActions1(C, (Action)it.$star(), Ids));
                        it.$preInc();
                        if (!it.$noteq((Object)ie)) continue;
                        os.$out((CharSequence)", ");
                    }
                    os.$out((CharSequence)"}");
                }
            }
            long Id = Ids.size();
            Ids.ref$at((Object)A).$set(Id);
            llvm.errs().$out(Id).$out((CharSequence)": ").$out(os.str()).$out((CharSequence)", ").$out(types.getTypeName(A.getType())).$out((CharSequence)"\n");
            long l = Id;
            return l;
        }
        finally {
            if (os != null) {
                os.$destroy();
            }
            if (str != null) {
                str.$destroy();
            }
        }
    }

    public static boolean ContainsCompileOrAssembleAction(Action A) {
        if (llvm.isa(CompileJobAction.class, (Object)A) || llvm.isa(BackendJobAction.class, (Object)A) || llvm.isa(AssembleJobAction.class, (Object)A)) {
            return true;
        }
        SmallVectorImpl.iterator it = (SmallVectorImpl.iterator)Native.$tryClone(A.begin());
        SmallVectorImpl.iterator<Action> ie = A.end();
        while (it.$noteq(ie)) {
            if (DriverStatics.ContainsCompileOrAssembleAction((Action)it.$star())) {
                return true;
            }
            it.$preInc();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean DiagnoseInputExistence(Driver D, DerivedArgList Args, StringRef Value) {
        SmallString Path = null;
        try {
            if (!D.getCheckInputsExist()) {
                boolean bl = true;
                return bl;
            }
            if (llvm.$eq_StringRef((StringRef)Value, (StringRef)StringRef.MINUS)) {
                boolean bl = true;
                return bl;
            }
            Path = new SmallString(Value, 64);
            Arg WorkDir = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_working_directory.getValue()));
            if (WorkDir != null && !path.is_absolute((StringRef)Path.str())) {
                SmallString Directory = null;
                try {
                    Directory = new SmallString(new StringRef(WorkDir.getValue()), 64);
                    path.append((SmallString)Directory, (StringRef)Value);
                    Path.assign((SmallVectorImplChar)Directory);
                }
                finally {
                    if (Directory != null) {
                        Directory.$destroy();
                    }
                }
            }
            if (fs.exists((Twine)new Twine(Path.$StringRef()))) {
                boolean bl = true;
                return bl;
            }
            if (D.IsCLMode() && Process.FindInEnvPath((std.string)new std.string((CharSequence)"LIB"), (std.string)Value.$basic_string()).$boolean()) {
                boolean bl = true;
                return bl;
            }
            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)D.Diag(342L), (StringRef)Path.str()).$destroy();
            boolean bl = false;
            return bl;
        }
        finally {
            if (Path != null) {
                Path.$destroy();
            }
        }
    }

    public static Tool SelectToolForJob(Compilation C, ToolChain TC, JobAction JA, SmallVector<Action> Inputs) {
        Tool ToolForJob = null;
        if (TC.useIntegratedAs() && !C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_save_temps.getValue())) && !C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_via_file_asm.getValue())) && !C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT__SLASH_FA.getValue())) && !C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT__SLASH_Fa.getValue())) && llvm.isa(AssembleJobAction.class, (Object)JA) && Inputs.size() == 1 && llvm.isa(BackendJobAction.class, (Object)Inputs.begin())) {
            SmallVector<Action> BackendInputs = ((Action)Inputs.$at(0)).getInputs();
            JobAction CompileJA = (JobAction)llvm.cast(CompileJobAction.class, (Object)BackendInputs.begin());
            Tool Compiler = TC.SelectTool(CompileJA);
            if (Compiler == null) {
                return null;
            }
            if (Compiler.hasIntegratedAssembler()) {
                Inputs = ((Action)BackendInputs.$at(0)).getInputs();
                ToolForJob = Compiler;
            }
        }
        if (llvm.isa(BackendJobAction.class, (Object)JA)) {
            assert (Inputs.size() == 1);
            JobAction CompileJA = (JobAction)llvm.cast(CompileJobAction.class, (Object)Inputs.begin());
            Tool Compiler = TC.SelectTool(CompileJA);
            if (Compiler == null) {
                return null;
            }
            if (!Compiler.canEmitIR() || !C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_save_temps.getValue()))) {
                Inputs = ((Action)Inputs.$at(0)).getInputs();
                ToolForJob = Compiler;
            }
        }
        if (ToolForJob == null) {
            ToolForJob = TC.SelectTool(JA);
        }
        if (Inputs.size() == 1 && llvm.isa(PreprocessJobAction.class, (Object)Inputs.begin()) && !C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_no_integrated_cpp.getValue())) && !C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_traditional_cpp.getValue())) && !C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_save_temps.getValue())) && !C.getArgs().hasArg(new OptSpecifier((long)options.ID.OPT_rewrite_objc.getValue())) && ToolForJob.hasIntegratedCPP()) {
            Inputs = ((Action)Inputs.$at(0)).getInputs();
        }
        return ToolForJob;
    }

    public static char.ptr MakeCLOutputFilename(ArgList Args, StringRef ArgValue, StringRef BaseName, types.ID FileType) {
        SmallString Filename = new SmallString(ArgValue, 128);
        if (ArgValue.empty()) {
            Filename.$assign(BaseName);
        } else if (path.is_separator((byte)Filename.back())) {
            path.append((SmallString)Filename, (StringRef)BaseName);
        }
        if (!path.has_extension((Twine)new Twine(ArgValue))) {
            char.ptr Extension = Native.$tryClone((char.ptr)types.getTypeTempSuffix(FileType, true));
            if (FileType == types.ID.TY_Image && Args.hasArg(new OptSpecifier((long)options.ID.OPT__SLASH_LD.getValue()), new OptSpecifier((long)options.ID.OPT__SLASH_LDd.getValue()))) {
                Extension = NativePointer.$((String)"dll");
            }
            path.replace_extension((SmallString)Filename, (Twine)new Twine(Extension));
        }
        return Args.MakeArgString(Filename.c_str());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Triple computeTargetTriple(StringRef DefaultTargetTriple, ArgList Args, StringRef DarwinArchName) {
        Triple Target = null;
        try {
            Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_target.getValue()));
            if (A != null) {
                DefaultTargetTriple.$assign(new StringRef(A.getValue()));
            }
            if ((Target = new Triple(new Twine(Triple.normalize((StringRef)new StringRef(DefaultTargetTriple))))).isOSBinFormatMachO()) {
                if (!DarwinArchName.empty()) {
                    darwin.setTripleTypeForMachOArchName(Target, new StringRef(DarwinArchName));
                    A = new Triple(Target);
                    return A;
                }
                A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_arch.getValue()));
                if (A != null) {
                    StringRef ArchName = new StringRef(A.getValue());
                    darwin.setTripleTypeForMachOArchName(Target, new StringRef(ArchName));
                }
            }
            if ((A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mlittle_endian.getValue()), new OptSpecifier((long)options.ID.OPT_mbig_endian.getValue()))) != null) {
                if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mlittle_endian.getValue()))) {
                    if (Target.getArch() == Triple.ArchType.mips) {
                        Target.setArch(Triple.ArchType.mipsel);
                    } else if (Target.getArch() == Triple.ArchType.mips64) {
                        Target.setArch(Triple.ArchType.mips64el);
                    } else if (Target.getArch() == Triple.ArchType.aarch64_be) {
                        Target.setArch(Triple.ArchType.aarch64);
                    }
                } else if (Target.getArch() == Triple.ArchType.mipsel) {
                    Target.setArch(Triple.ArchType.mips);
                } else if (Target.getArch() == Triple.ArchType.mips64el) {
                    Target.setArch(Triple.ArchType.mips64);
                } else if (Target.getArch() == Triple.ArchType.aarch64) {
                    Target.setArch(Triple.ArchType.aarch64_be);
                }
            }
            if (llvm.$eq_StringRef((StringRef)Target.getArchName(), (StringRef)new StringRef(NativePointer.$((String)"tce"))) || Target.getOS() == Triple.OSType.Minix) {
                A = new Triple(Target);
                return A;
            }
            A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_m64.getValue()), new OptSpecifier((long)options.ID.OPT_mx32.getValue()), new OptSpecifier((long)options.ID.OPT_m32.getValue()), new OptSpecifier((long)options.ID.OPT_m16.getValue()));
            if (A != null) {
                Triple.ArchType AT = Triple.ArchType.UnknownArch;
                if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_m64.getValue()))) {
                    AT = Target.get64BitArchVariant().getArch();
                    if (Target.getEnvironment() == Triple.EnvironmentType.GNUX32) {
                        Target.setEnvironment(Triple.EnvironmentType.GNU);
                    }
                } else if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_mx32.getValue())) && Target.get64BitArchVariant().getArch() == Triple.ArchType.x86_64) {
                    AT = Triple.ArchType.x86_64;
                    Target.setEnvironment(Triple.EnvironmentType.GNUX32);
                } else if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_m32.getValue()))) {
                    AT = Target.get32BitArchVariant().getArch();
                    if (Target.getEnvironment() == Triple.EnvironmentType.GNUX32) {
                        Target.setEnvironment(Triple.EnvironmentType.GNU);
                    }
                } else if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_m16.getValue())) && Target.get32BitArchVariant().getArch() == Triple.ArchType.x86) {
                    AT = Triple.ArchType.x86;
                    Target.setEnvironment(Triple.EnvironmentType.CODE16);
                }
                if (AT != Triple.ArchType.UnknownArch && AT != Target.getArch()) {
                    Target.setArch(AT);
                }
            }
            Triple triple = new Triple(Target);
            return triple;
        }
        finally {
            if (Target != null) {
                Target.$destroy();
            }
        }
    }
}

