/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import java.util.Iterator;
import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.Driver;
import org.clang.driver.JobAction;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.impl.ToolsStatics;
import org.clang.driver.impl.toolchains;
import org.clang.driver.options;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.sys.path;

public final class CrossWindows {

    public static class Link
    extends Tool
    implements Destructors.ClassWithDestructor {
        public Link(ToolChain TC) {
            super(NativePointer.$((String)"CrossWindows::Link"), NativePointer.$((String)"ld"), TC, Tool.ResponseFileSupport.RF_Full);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        @Override
        public boolean isLinkJob() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            SmallString EntryPoint = null;
            ArgStringList CmdArgs = null;
            try {
                toolchains.CrossWindowsToolChain TC = (toolchains.CrossWindowsToolChain)this.getToolChain();
                Triple T = TC.getTriple();
                Driver D = TC.getDriver();
                EntryPoint = new SmallString(128);
                CmdArgs = new ArgStringList();
                Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_g_Group.getValue()));
                Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_emit_llvm.getValue()));
                Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_w.getValue()));
                if (!D.SysRoot.empty()) {
                    CmdArgs.push_back((Object)Args.MakeArgString(std.$plus_T_str((Object)NativePointer.$((String)"--sysroot="), (std.string)D.SysRoot)));
                }
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_pie.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-pie"));
                }
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_rdynamic.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-export-dynamic"));
                }
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_s.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"--strip-all"));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                switch (TC.getArch()) {
                    default: {
                        throw new llvm_unreachable((CharSequence)"unsupported architecture");
                    }
                    case arm: 
                    case thumb: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"thumb2pe"));
                        break;
                    }
                    case x86: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"i386pe"));
                        EntryPoint.append(new StringRef(NativePointer.$((String)"_")));
                        break;
                    }
                    case x86_64: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"i386pep"));
                    }
                }
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue()))) {
                    switch (T.getArch()) {
                        default: {
                            throw new llvm_unreachable((CharSequence)"unsupported architecture");
                        }
                        case arm: 
                        case thumb: 
                        case x86_64: {
                            EntryPoint.append(new StringRef(NativePointer.$((String)"_DllMainCRTStartup")));
                            break;
                        }
                        case x86: {
                            EntryPoint.append(new StringRef(NativePointer.$((String)"_DllMainCRTStartup@12")));
                        }
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-shared"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-Bdynamic"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"--enable-auto-image-base"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"--entry"));
                    CmdArgs.push_back((Object)Args.MakeArgString(EntryPoint.$StringRef()));
                } else {
                    EntryPoint.append(new StringRef(NativePointer.$((String)"mainCRTStartup")));
                    CmdArgs.push_back((Object)(Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue())) ? NativePointer.$((String)"-Bstatic") : NativePointer.$((String)"-Bdynamic")));
                    if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostartfiles.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--entry"));
                        CmdArgs.push_back((Object)Args.MakeArgString(EntryPoint.$StringRef()));
                    }
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"--allow-multiple-definition"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_rdynamic.getValue()))) {
                    SmallString ImpLib = null;
                    try {
                        ImpLib = new SmallString(new StringRef(Output.getFilename()), 261);
                        path.replace_extension((SmallString)ImpLib, (Twine)new Twine(NativePointer.$((String)".lib")));
                        CmdArgs.push_back((Object)NativePointer.$((String)"--out-implib"));
                        CmdArgs.push_back((Object)Args.MakeArgString(ImpLib.$StringRef()));
                    }
                    finally {
                        if (ImpLib != null) {
                            ImpLib.$destroy();
                        }
                    }
                }
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostartfiles.getValue()))) {
                    std.string CRTPath = null;
                    try {
                        CRTPath = std.$plus_str_T((std.string)D.SysRoot, (char.iterator)NativePointer.$((String)"/usr/lib/"));
                        Iterator CRTBegin = Native.$tryClone((char.ptr)(Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue())) ? NativePointer.$((String)"crtbeginS.obj") : NativePointer.$((String)"crtbegin.obj")));
                        CmdArgs.push_back((Object)Args.MakeArgString(std.$plus_str_T((std.string)CRTPath, (char.iterator)CRTBegin)));
                    }
                    finally {
                        if (CRTPath != null) {
                            CRTPath.$destroy();
                        }
                    }
                }
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_L.getValue()));
                SmallVector<std.string> Paths = TC.getFilePaths();
                for (std.string Path : Paths) {
                    CmdArgs.push_back((Object)Args.MakeArgString(llvm.$plus_Twine((Twine)new Twine(new StringRef(NativePointer.$((String)"-L"))), (Twine)new Twine(Path))));
                }
                ToolsStatics.AddLinkerInputs(TC, Inputs, Args, CmdArgs);
                if (D.CCCIsCXX() && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nodefaultlibs.getValue()))) {
                    boolean StaticCXX;
                    boolean bl = StaticCXX = Args.hasArg(new OptSpecifier((long)options.ID.OPT_static_libstdcxx.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue()));
                    if (StaticCXX) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Bstatic"));
                    }
                    TC.AddCXXStdlibLibArgs(Args, CmdArgs);
                    if (StaticCXX) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Bdynamic"));
                    }
                }
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nodefaultlibs.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lmsvcrt"));
                    ToolsStatics.AddRunTimeLibs(TC, D, CmdArgs, Args);
                }
                std.string Linker = TC.GetProgramPath(NativePointer.$((String)"ld"));
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new std.string(Linker)));
                C.addCommand((std_ptr.unique_ptr<Command>)llvm.make_unique((Object)new Command(JA, this, Exec, CmdArgs)));
            }
            finally {
                if (CmdArgs != null) {
                    CmdArgs.$destroy();
                }
                if (EntryPoint != null) {
                    EntryPoint.$destroy();
                }
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Assemble
    extends Tool
    implements Destructors.ClassWithDestructor {
        public Assemble(ToolChain TC) {
            super(NativePointer.$((String)"CrossWindows::Assemble"), NativePointer.$((String)"as"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            ArgStringList CmdArgs = null;
            try {
                ToolsStatics.claimNoWarnArgs(Args);
                toolchains.CrossWindowsToolChain TC = (toolchains.CrossWindowsToolChain)this.getToolChain();
                CmdArgs = new ArgStringList();
                switch (TC.getArch()) {
                    default: {
                        throw new llvm_unreachable((CharSequence)"unsupported architecture");
                    }
                    case arm: 
                    case thumb: {
                        break;
                    }
                    case x86: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--32"));
                        break;
                    }
                    case x86_64: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--64"));
                    }
                }
                Args.AddAllArgValues((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_Wa_COMMA.getValue()), new OptSpecifier((long)options.ID.OPT_Xassembler.getValue()));
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                for (InputInfo Input : Inputs) {
                    CmdArgs.push_back((Object)Input.getFilename());
                }
                std.string Assembler = TC.GetProgramPath(NativePointer.$((String)"as"));
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new std.string(Assembler)));
                C.addCommand((std_ptr.unique_ptr<Command>)llvm.make_unique((Object)new Command(JA, this, Exec, CmdArgs)));
            }
            finally {
                if (CmdArgs != null) {
                    CmdArgs.$destroy();
                }
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }
}

