/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.grunt;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.grunt.Bundle;
import org.netbeans.modules.javascript.grunt.exec.GruntExecutable;
import org.netbeans.modules.javascript.grunt.file.GruntTasks;
import org.netbeans.modules.javascript.grunt.file.Gruntfile;
import org.netbeans.modules.javascript.grunt.preferences.GruntPreferences;
import org.netbeans.modules.javascript.grunt.util.GruntUtils;
import org.netbeans.modules.web.clientproject.spi.build.BuildToolImplementation;
import org.netbeans.spi.project.ui.CustomizerProvider2;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public final class GruntBuildTool
implements BuildToolImplementation {
    private static final Logger LOGGER = Logger.getLogger(GruntBuildTool.class.getName());
    public static final String IDENTIFIER = "Grunt";
    private final Project project;
    private final Gruntfile gruntfile;
    private final GruntTasks gruntTasks;
    private final GruntPreferences gruntPreferences;

    public GruntBuildTool(Project project) {
        assert (project != null);
        this.project = project;
        this.gruntfile = Gruntfile.create(project.getProjectDirectory());
        this.gruntTasks = GruntTasks.create(project, this.gruntfile);
        this.gruntPreferences = new GruntPreferences(project);
    }

    @NonNull
    public static GruntBuildTool forProject(Project project) {
        GruntBuildTool buildTool = GruntBuildTool.inProject(project);
        assert (buildTool != null) : "GruntBuildTool should be found in project " + project.getClass().getName() + " (lookup: " + project.getLookup() + ")";
        return buildTool;
    }

    @CheckForNull
    public static GruntBuildTool inProject(Project project) {
        assert (project != null);
        return (GruntBuildTool)project.getLookup().lookup(GruntBuildTool.class);
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getDisplayName() {
        return Bundle.GruntBuildTool_name();
    }

    public Gruntfile getGruntfile() {
        return this.gruntfile;
    }

    public GruntTasks getGruntTasks() {
        return this.gruntTasks;
    }

    public GruntPreferences getGruntPreferences() {
        return this.gruntPreferences;
    }

    public boolean isEnabled() {
        return this.gruntfile.exists();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean run(String commandId, boolean waitFinished, boolean warnUser) {
        assert (this.isEnabled()) : this.project.getProjectDirectory().getNameExt();
        assert (this.gruntfile.exists()) : this.project.getProjectDirectory().getNameExt();
        String gruntBuild = this.gruntPreferences.getTask(commandId);
        if (gruntBuild != null) {
            GruntExecutable grunt = GruntExecutable.getDefault(this.project, warnUser);
            if (grunt == null) return true;
            GruntUtils.logUsageGruntBuild();
            Future<Integer> result = grunt.run(gruntBuild.split(" "));
            if (!waitFinished) return true;
            try {
                result.get();
                return true;
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.INFO, null, ex);
                return true;
            }
            catch (CancellationException ex) {
                LOGGER.log(Level.FINE, null, ex);
                return true;
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.INFO, null, ex);
                if (!warnUser) return true;
            }
            return true;
        } else {
            Object option;
            if (!warnUser || (option = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.GruntBuildTool_configure(), 0))) != NotifyDescriptor.YES_OPTION) return true;
            ((CustomizerProvider2)this.project.getLookup().lookup(CustomizerProvider2.class)).showCustomizer(IDENTIFIER, null);
        }
        return true;
    }
}

