/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.grunt.exec;

import java.awt.EventQueue;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.extexecution.base.input.LineProcessor;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.grunt.GruntBuildTool;
import org.netbeans.modules.javascript.grunt.exec.Bundle;
import org.netbeans.modules.javascript.grunt.file.Gruntfile;
import org.netbeans.modules.javascript.grunt.options.GruntOptions;
import org.netbeans.modules.javascript.grunt.options.GruntOptionsValidator;
import org.netbeans.modules.javascript.grunt.util.FileUtils;
import org.netbeans.modules.javascript.grunt.util.GruntUtils;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.netbeans.modules.web.common.api.ExternalExecutable;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public class GruntExecutable {
    static final Logger LOGGER = Logger.getLogger(GruntExecutable.class.getName());
    public static final String GRUNT_NAME = Utilities.isWindows() ? "grunt.cmd" : "grunt";
    private static final String HELP_PARAM = "--help";
    private static final String NO_COLOR_PARAM = "--no-color";
    protected final Project project;
    protected final String gruntPath;

    GruntExecutable(String gruntPath, @NullAllowed Project project) {
        assert (gruntPath != null);
        this.gruntPath = gruntPath;
        this.project = project;
    }

    @CheckForNull
    public static GruntExecutable getDefault(@NullAllowed Project project, boolean showOptions) {
        ValidationResult result = new GruntOptionsValidator().validateGrunt().getResult();
        if (GruntExecutable.validateResult(result) != null) {
            if (showOptions) {
                OptionsDisplayer.getDefault().open("Html5/Grunt");
            }
            return null;
        }
        return GruntExecutable.createExecutable(GruntOptions.getInstance().getGrunt(), project);
    }

    private static GruntExecutable createExecutable(String grunt, Project project) {
        if (Utilities.isMac()) {
            return new MacGruntExecutable(grunt, project);
        }
        return new GruntExecutable(grunt, project);
    }

    String getCommand() {
        return this.gruntPath;
    }

    public Future<Integer> run(String ... args) {
        assert (!EventQueue.isDispatchThread());
        assert (this.project != null);
        String projectName = GruntUtils.getProjectDisplayName(this.project);
        Future task = this.getExecutable(Bundle.GruntExecutable_run(projectName)).additionalParameters(this.getRunParams(args)).run(this.getDescriptor());
        assert (task != null) : this.gruntPath;
        return task;
    }

    public Future<List<String>> listTasks() {
        final GruntTasksLineProcessor gruntTasksLineProcessor = new GruntTasksLineProcessor();
        Future task = this.getExecutable("list grunt tasks").noInfo(true).additionalParameters(Arrays.asList(NO_COLOR_PARAM, HELP_PARAM)).redirectErrorStream(false).run(GruntExecutable.getSilentDescriptor(), new ExecutionDescriptor.InputProcessorFactory2(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.bridge((LineProcessor)gruntTasksLineProcessor);
            }
        });
        assert (task != null) : this.gruntPath;
        return new TaskList(task, gruntTasksLineProcessor);
    }

    private ExternalExecutable getExecutable(String title) {
        assert (title != null);
        return new ExternalExecutable(this.getCommand()).workDir(this.getWorkDir()).displayName(title).optionsPath("Html5/Grunt").noOutput(false);
    }

    private ExecutionDescriptor getDescriptor() {
        assert (this.project != null);
        return ExternalExecutable.DEFAULT_EXECUTION_DESCRIPTOR.showSuspended(true).optionsPath("Html5/Grunt").outLineBased(true).errLineBased(true).postExecution(new Runnable(){

            @Override
            public void run() {
                FileUtil.refreshFor((File[])new File[]{GruntExecutable.this.getWorkDir()});
            }
        });
    }

    private static ExecutionDescriptor getSilentDescriptor() {
        return new ExecutionDescriptor().inputOutput(InputOutput.NULL).inputVisible(false).frontWindow(false).showProgress(false).charset(StandardCharsets.UTF_8).outLineBased(true);
    }

    private File getWorkDir() {
        if (this.project == null) {
            return FileUtils.TMP_DIR;
        }
        Gruntfile gruntfile = GruntBuildTool.forProject(this.project).getGruntfile();
        if (gruntfile.exists()) {
            return gruntfile.getFile().getParentFile();
        }
        File workDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        assert (workDir != null) : this.project.getProjectDirectory();
        return workDir;
    }

    private List<String> getRunParams(String ... args) {
        return this.getParams(Arrays.asList(args));
    }

    List<String> getParams(List<String> params) {
        assert (params != null);
        return params;
    }

    @CheckForNull
    private static String validateResult(ValidationResult result) {
        if (result.isFaultless()) {
            return null;
        }
        if (result.hasErrors()) {
            return result.getFirstErrorMessage();
        }
        return result.getFirstWarningMessage();
    }

    private static final class TaskList
    implements Future<List<String>> {
        private final Future<Integer> task;
        private final GruntTasksLineProcessor convertor;
        private List<String> gruntTasks = null;

        TaskList(Future<Integer> task, GruntTasksLineProcessor convertor) {
            assert (task != null);
            assert (convertor != null);
            this.task = task;
            this.convertor = convertor;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.task.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.task.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.task.isDone();
        }

        @Override
        public List<String> get() throws InterruptedException, ExecutionException {
            try {
                this.task.get();
            }
            catch (CancellationException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            return this.getGruntTasks();
        }

        @Override
        public List<String> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                this.task.get(timeout, unit);
            }
            catch (CancellationException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            return this.getGruntTasks();
        }

        private synchronized List<String> getGruntTasks() {
            if (this.gruntTasks != null) {
                return Collections.unmodifiableList(this.gruntTasks);
            }
            ArrayList<String> tasks = new ArrayList<String>(this.convertor.getTasks());
            Collections.sort(tasks);
            this.gruntTasks = new CopyOnWriteArrayList<String>(tasks);
            return Collections.unmodifiableList(this.gruntTasks);
        }
    }

    static final class GruntTasksLineProcessor
    implements LineProcessor {
        private static final String AVAILABLE_TASKS = "Available tasks";
        private static final String NO_TASKS = "(no tasks found)";
        final List<String> tasks = new ArrayList<String>();
        private int state = 0;
        private int spaceIndex = -1;

        GruntTasksLineProcessor() {
        }

        public void processLine(String line) {
            LOGGER.log(Level.FINE, line);
            switch (this.state) {
                case 0: {
                    if (!AVAILABLE_TASKS.equals(line)) break;
                    this.state = 1;
                    break;
                }
                case 1: {
                    String task;
                    if (!StringUtilities.hasText((String)line)) {
                        this.state = 2;
                        break;
                    }
                    if (NO_TASKS.equals(line.trim())) {
                        this.state = 2;
                        break;
                    }
                    if (this.spaceIndex == -1) {
                        task = (String)StringUtilities.explode((String)line.trim(), (String)"  ").get(0);
                        assert (StringUtilities.hasText((String)task)) : line;
                        this.spaceIndex = line.indexOf(task) + task.length();
                    }
                    if (!StringUtilities.hasText((String)(task = line.substring(0, this.spaceIndex).trim()))) break;
                    this.tasks.add(task);
                    break;
                }
            }
        }

        public void reset() {
        }

        public void close() {
        }

        public List<String> getTasks() {
            return Collections.unmodifiableList(this.tasks);
        }
    }

    private static final class MacGruntExecutable
    extends GruntExecutable {
        private static final String BASH_COMMAND = "/bin/bash -lc";

        MacGruntExecutable(String gruntPath, Project project) {
            super(gruntPath, project);
        }

        @Override
        String getCommand() {
            return BASH_COMMAND;
        }

        @Override
        List<String> getParams(List<String> params) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("\"");
            sb.append(this.gruntPath);
            sb.append("\" \"");
            sb.append(StringUtilities.implode(super.getParams(params), (String)"\" \""));
            sb.append("\"");
            return Collections.singletonList(sb.toString());
        }
    }
}

