/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.model.jclank.bridge.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.clang.frontend.InputKind;
import org.clang.frontend.LangStandard;
import org.clang.tools.services.ClankCompilationDataBase;
import org.clang.tools.services.support.DataBaseEntryBuilder;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.FSPath;
import org.openide.filesystems.FileObject;

public final class CsmJClankCompilationDB
implements ClankCompilationDataBase {
    private final Collection<ClankCompilationDataBase.Entry> compilations;
    private final String name;

    private CsmJClankCompilationDB(Collection<ClankCompilationDataBase.Entry> compilations) {
        this("JClankDB with [" + compilations.size() + "] entries", compilations);
    }

    private CsmJClankCompilationDB(String dbName, Collection<ClankCompilationDataBase.Entry> compilations) {
        this.name = dbName;
        this.compilations = Collections.unmodifiableCollection(compilations);
    }

    public Collection<ClankCompilationDataBase.Entry> getCompilations() {
        return this.compilations;
    }

    public String getName() {
        return this.name;
    }

    public static Set<NativeFileItem> getSources(NativeProject project) {
        TreeSet<NativeFileItem> srcFiles = new TreeSet<NativeFileItem>(new NFIComparator());
        for (NativeFileItem nfi : project.getAllFiles()) {
            if (nfi.isExcluded()) continue;
            switch (nfi.getLanguage()) {
                case C: 
                case CPP: {
                    srcFiles.add(nfi);
                    break;
                }
            }
        }
        return srcFiles;
    }

    public static ClankCompilationDataBase convertNativeFileItems(Collection<NativeFileItem> nfis, String dbName) {
        ArrayList<ClankCompilationDataBase.Entry> compilations = new ArrayList<ClankCompilationDataBase.Entry>();
        for (NativeFileItem nfi : nfis) {
            ClankCompilationDataBase.Entry entry = CsmJClankCompilationDB.createEntry(nfi);
            assert (entry != null);
            compilations.add(entry);
        }
        return new CsmJClankCompilationDB(dbName, compilations);
    }

    public static ClankCompilationDataBase convertProject(NativeProject prj) {
        return CsmJClankCompilationDB.convertNativeFileItems(CsmJClankCompilationDB.getSources(prj), prj.getProjectDisplayName());
    }

    public static Collection<ClankCompilationDataBase> convertProjects(Collection<NativeProject> prjs) {
        ArrayList<ClankCompilationDataBase> out = new ArrayList<ClankCompilationDataBase>();
        for (NativeProject prj : prjs) {
            out.add(CsmJClankCompilationDB.convertProject(prj));
        }
        return out;
    }

    public static ClankCompilationDataBase.Entry createEntry(NativeFileItem nfi) {
        FileObject fileObject;
        DataBaseEntryBuilder builder = new DataBaseEntryBuilder(CndFileSystemProvider.toUrl((FSPath)FSPath.toFSPath((FileObject)nfi.getFileObject())), null);
        builder.setLang(CsmJClankCompilationDB.getLang(nfi)).setLangStd(CsmJClankCompilationDB.getLangStd(nfi));
        for (FSPath fSPath : nfi.getUserIncludePaths()) {
            fileObject = fSPath.getFileObject();
            if (fileObject == null || !fileObject.isFolder()) continue;
            builder.addUserIncludePath(fSPath.getURL());
        }
        for (FSPath fSPath : nfi.getSystemIncludePaths()) {
            fileObject = fSPath.getFileObject();
            if (fileObject == null || !fileObject.isFolder()) continue;
            builder.addPredefinedSystemIncludePath(fSPath.getURL());
        }
        for (String path : nfi.getIncludeFiles()) {
            builder.addIncFile(path);
        }
        for (String macro : nfi.getSystemMacroDefinitions()) {
            builder.addPredefinedSystemMacroDef(macro);
        }
        for (String macro : nfi.getUserMacroDefinitions()) {
            builder.addUserMacroDef(macro);
        }
        return builder.createDataBaseEntry();
    }

    private static LangStandard.Kind getLangStd(NativeFileItem startEntry) throws AssertionError {
        LangStandard.Kind lang_std = LangStandard.Kind.lang_unspecified;
        switch (startEntry.getLanguageFlavor()) {
            case DEFAULT: 
            case UNKNOWN: {
                break;
            }
            case C: {
                break;
            }
            case C89: {
                lang_std = LangStandard.Kind.lang_gnu89;
                break;
            }
            case C99: {
                lang_std = LangStandard.Kind.lang_gnu99;
                break;
            }
            case CPP: {
                lang_std = LangStandard.Kind.lang_cxx03;
                break;
            }
            case CPP11: {
                lang_std = LangStandard.Kind.lang_gnucxx11;
                break;
            }
            case C11: {
                lang_std = LangStandard.Kind.lang_gnu11;
                break;
            }
            case CPP14: {
                lang_std = LangStandard.Kind.lang_gnucxx1y;
                break;
            }
            default: {
                throw new AssertionError((Object)startEntry.getLanguageFlavor().name());
            }
        }
        return lang_std;
    }

    private static InputKind getLang(NativeFileItem startEntry) throws AssertionError {
        InputKind lang = InputKind.IK_None;
        switch (startEntry.getLanguage()) {
            case C: 
            case C_HEADER: {
                lang = InputKind.IK_C;
                break;
            }
            case CPP: {
                lang = InputKind.IK_CXX;
                break;
            }
            default: {
                throw new AssertionError((Object)startEntry.getLanguage().name());
            }
        }
        return lang;
    }

    private static final class NFIComparator
    implements Comparator<NativeFileItem> {
        @Override
        public int compare(NativeFileItem o1, NativeFileItem o2) {
            return o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
        }
    }
}

