/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.commons;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.modules.bugtracking.commons.LinkButton;
import org.netbeans.modules.bugtracking.commons.TransparentSectionButton;
import org.openide.awt.Mnemonics;

public final class CollapsibleSectionPanel
extends JPanel
implements FocusListener {
    final boolean isGTK = "GTK".equals(UIManager.getLookAndFeel().getID());
    final boolean isNimbus = "Nimbus".equals(UIManager.getLookAndFeel().getID());
    final boolean isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private JPanel actionsPanel;
    private final JPanel dummyContentPanel = new JPanel();
    private JPanel headerPanel;
    private JLabel jLabel1;
    private final TransparentSectionButton sectionButton1 = new TransparentSectionButton();
    private JComponent content = this.dummyContentPanel;

    public CollapsibleSectionPanel() {
        this.initComponents();
        Color c = this.getHeaderBackground();
        this.headerPanel.setBackground(c);
        this.sectionButton1.addFocusListener(this);
    }

    public void setLabel(String label) {
        this.sectionButton1.setText(label);
    }

    public String getLabel() {
        return this.sectionButton1.getText();
    }

    public void setContent(JComponent content) {
        ((GroupLayout)this.getLayout()).replace(this.content, content);
        this.content = content;
    }

    public AbstractButton getLabelComponent() {
        return this.sectionButton1;
    }

    public boolean isExpanded() {
        return this.sectionButton1.isSelected();
    }

    public void setExpanded(boolean expanded) {
        this.sectionButton1.setSelected(expanded);
        this.sectionButtonStateChanged();
    }

    public void setActions(Action[] sectionActions) {
        ActionsBuilder builder = new ActionsBuilder(this.actionsPanel, this);
        for (Action action : sectionActions) {
            builder.addAction(action);
        }
        builder.finish();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.focusEvent(e);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.focusEvent(e);
    }

    private Color getHeaderBackground() {
        if (this.sectionButton1.isFocusOwner()) {
            if (this.isGTK || this.isNimbus) {
                return UIManager.getColor("Tree.selectionBackground");
            }
            return UIManager.getColor("PropSheet.selectedSetBackground");
        }
        if (this.isAqua) {
            Color defBk = UIManager.getColor("NbExplorerView.background");
            if (null == defBk) {
                defBk = Color.gray;
            }
            return new Color(defBk.getRed() - 10, defBk.getGreen() - 10, defBk.getBlue() - 10);
        }
        if (this.isGTK || this.isNimbus) {
            return new Color(UIManager.getColor("Menu.background").getRGB());
        }
        return UIManager.getColor("PropSheet.setBackground");
    }

    private void initComponents() {
        this.headerPanel = new JPanel();
        this.actionsPanel = new JPanel();
        this.jLabel1 = new JLabel();
        GroupLayout dummyContentPanelLayout = new GroupLayout(this.dummyContentPanel);
        this.dummyContentPanel.setLayout(dummyContentPanelLayout);
        dummyContentPanelLayout.setHorizontalGroup(dummyContentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 388, Short.MAX_VALUE));
        dummyContentPanelLayout.setVerticalGroup(dummyContentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.headerPanel.setBackground(this.getHeaderBackground());
        this.sectionButton1.setSelected(true);
        this.sectionButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CollapsibleSectionPanel.this.sectionButton1ActionPerformed(evt);
            }
        });
        this.actionsPanel.setOpaque(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)" ");
        GroupLayout actionsPanelLayout = new GroupLayout(this.actionsPanel);
        this.actionsPanel.setLayout(actionsPanelLayout);
        actionsPanelLayout.setHorizontalGroup(actionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1));
        actionsPanelLayout.setVerticalGroup(actionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(actionsPanelLayout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jLabel1)));
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.sectionButton1, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.actionsPanel, -2, -1, -2).addContainerGap()));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.actionsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.sectionButton1, -2, -1, -2)).addGap(0, 0, 0)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.dummyContentPanel, -1, -1, Short.MAX_VALUE)).addComponent(this.headerPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.headerPanel, -2, -1, -2).addGap(9, 9, 9).addComponent(this.dummyContentPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void sectionButton1ActionPerformed(ActionEvent evt) {
        this.sectionButtonStateChanged();
    }

    private void sectionButtonStateChanged() {
        this.content.setVisible(this.sectionButton1.isSelected());
    }

    private void focusEvent(FocusEvent e) {
        if (this.sectionButton1 == e.getSource()) {
            Color c = this.getHeaderBackground();
            this.headerPanel.setBackground(c);
        }
    }

    private static class ActionsBuilder {
        private final GroupLayout.SequentialGroup horizontalSeqGroup;
        private final GroupLayout.ParallelGroup verticalParallelGroup;
        private boolean notEmpty = false;
        private final FocusListener focusListener;

        public ActionsBuilder(JPanel panel, FocusListener listener) {
            this.focusListener = listener;
            panel.removeAll();
            GroupLayout layout = (GroupLayout)panel.getLayout();
            this.horizontalSeqGroup = layout.createSequentialGroup();
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(this.horizontalSeqGroup));
            this.verticalParallelGroup = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(this.verticalParallelGroup));
        }

        private void addAction(Action action) {
            String name = (String)action.getValue("Name");
            LinkButton btn = new LinkButton(name);
            btn.addActionListener(action);
            btn.addFocusListener(this.focusListener);
            if (this.notEmpty) {
                JLabel separator = new JLabel();
                separator.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0), BorderFactory.createLineBorder(Color.BLACK, 1)));
                this.horizontalSeqGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(separator).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
                this.verticalParallelGroup.addComponent(separator, -1, -1, Short.MAX_VALUE);
            }
            this.horizontalSeqGroup.addComponent(btn, -2, -1, -2);
            this.verticalParallelGroup.addComponent(btn, -2, -1, -2);
            this.notEmpty = true;
        }

        private void finish() {
            this.horizontalSeqGroup.addContainerGap(-1, Short.MAX_VALUE);
        }
    }
}

