/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.persistence.jpa.jpql.AbstractGrammarValidator;
import org.eclipse.persistence.jpa.jpql.AbstractSemanticValidator;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblem;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.tools.AbstractContentAssistVisitor;
import org.eclipse.persistence.jpa.jpql.tools.BasicRefactoringTool;
import org.eclipse.persistence.jpa.jpql.tools.ContentAssistExtension;
import org.eclipse.persistence.jpa.jpql.tools.ContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.tools.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.tools.NumericTypeComparator;
import org.eclipse.persistence.jpa.jpql.tools.RefactoringTool;
import org.eclipse.persistence.jpa.jpql.tools.TypeHelper;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.tools.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJPQLQueryHelper {
    private AbstractContentAssistVisitor contentAssistVisitor;
    private AbstractGrammarValidator grammarValidator;
    private JPQLGrammar jpqlGrammar;
    private JPQLQueryContext queryContext;
    private AbstractSemanticValidator semanticValidator;

    public AbstractJPQLQueryHelper(JPQLGrammar jpqlGrammar) {
        Assert.isNotNull(jpqlGrammar, "The JPQLGrammar cannot be null");
        this.jpqlGrammar = jpqlGrammar;
    }

    protected AbstractJPQLQueryHelper(JPQLQueryContext queryContext) {
        Assert.isNotNull(queryContext, "The JPQLQueryContext cannot be null");
        this.queryContext = queryContext;
        this.jpqlGrammar = queryContext.getGrammar();
    }

    public abstract BasicRefactoringTool buildBasicRefactoringTool();

    public ContentAssistProposals buildContentAssistProposals(int position) {
        return this.buildContentAssistProposals(position, ContentAssistExtension.NULL_HELPER);
    }

    public ContentAssistProposals buildContentAssistProposals(int position, ContentAssistExtension extension) {
        return this.getContentAssistVisitor().buildProposals(position, extension);
    }

    protected abstract AbstractContentAssistVisitor buildContentAssistVisitor(JPQLQueryContext var1);

    protected abstract AbstractGrammarValidator buildGrammarValidator(JPQLGrammar var1);

    protected abstract JPQLQueryContext buildJPQLQueryContext(JPQLGrammar var1);

    protected Comparator<IType> buildNumericTypeComparator() {
        return new NumericTypeComparator(this.getTypeHelper());
    }

    public abstract RefactoringTool buildRefactoringTool();

    protected abstract AbstractSemanticValidator buildSemanticValidator(JPQLQueryContext var1);

    public void dispose() {
        if (this.queryContext != null) {
            this.queryContext.dispose();
        }
        if (this.contentAssistVisitor != null) {
            this.contentAssistVisitor.dispose();
        }
    }

    protected AbstractContentAssistVisitor getContentAssistVisitor() {
        if (this.contentAssistVisitor == null) {
            this.contentAssistVisitor = this.buildContentAssistVisitor(this.getQueryContext());
        }
        return this.contentAssistVisitor;
    }

    public JPQLGrammar getGrammar() {
        return this.jpqlGrammar;
    }

    protected AbstractGrammarValidator getGrammarValidator() {
        if (this.grammarValidator == null) {
            this.grammarValidator = this.buildGrammarValidator(this.jpqlGrammar);
        }
        return this.grammarValidator;
    }

    public JPQLExpression getJPQLExpression() {
        return this.getQueryContext().getJPQLExpression();
    }

    public IType getParameterType(String parameterName) {
        char character;
        char c = character = parameterName.length() > 0 ? parameterName.charAt(0) : (char)'\u0000';
        if (character != ':' && character != '?') {
            return this.getTypeHelper().objectType();
        }
        Collection<InputParameter> inputParameters = this.getQueryContext().findInputParameters(parameterName);
        if (inputParameters.isEmpty()) {
            return this.getTypeHelper().objectType();
        }
        TreeSet<IType> types = new TreeSet<IType>(this.buildNumericTypeComparator());
        for (InputParameter inputParameter : inputParameters) {
            IType type = this.queryContext.getParameterType(inputParameter);
            if (!type.isResolvable()) continue;
            types.add(type);
        }
        return types.isEmpty() ? this.getTypeHelper().objectType() : types.first();
    }

    public String getParsedJPQLQuery() {
        return this.getJPQLExpression().toParsedText();
    }

    public IManagedTypeProvider getProvider() {
        return this.getQuery().getProvider();
    }

    public IQuery getQuery() {
        return this.getQueryContext().getQuery();
    }

    public JPQLQueryContext getQueryContext() {
        if (this.queryContext == null) {
            this.queryContext = this.buildJPQLQueryContext(this.jpqlGrammar);
        }
        return this.queryContext;
    }

    public IType getResultType() {
        IType type = this.queryContext.getType(this.getJPQLExpression());
        if (!type.isResolvable()) {
            type = this.getTypeHelper().objectType();
        }
        return type;
    }

    protected AbstractSemanticValidator getSemanticValidator() {
        if (this.semanticValidator == null) {
            this.semanticValidator = this.buildSemanticValidator(this.getQueryContext());
        }
        return this.semanticValidator;
    }

    public IType getType(Class<?> type) {
        return this.getTypeRepository().getType(type);
    }

    public TypeHelper getTypeHelper() {
        return this.getTypeRepository().getTypeHelper();
    }

    public ITypeRepository getTypeRepository() {
        return this.getProvider().getTypeRepository();
    }

    public void setJPQLExpression(JPQLExpression jpqlExpression) {
        this.getQueryContext().setJPQLExpression(jpqlExpression);
    }

    public void setQuery(IQuery query) {
        this.getQueryContext().setQuery(query);
    }

    public List<JPQLQueryProblem> validate() {
        LinkedList<JPQLQueryProblem> problems = new LinkedList<JPQLQueryProblem>();
        this.validate(this.getJPQLExpression(), problems);
        return problems;
    }

    public void validate(Expression expression, List<JPQLQueryProblem> problems) {
        this.validateGrammar(expression, problems);
        this.validateSemantic(expression, problems);
    }

    public List<JPQLQueryProblem> validateGrammar() {
        LinkedList<JPQLQueryProblem> problems = new LinkedList<JPQLQueryProblem>();
        this.validateGrammar(this.getJPQLExpression(), problems);
        return problems;
    }

    public void validateGrammar(Expression expression, List<JPQLQueryProblem> problems) {
        AbstractGrammarValidator visitor = this.getGrammarValidator();
        try {
            visitor.setProblems(problems);
            expression.accept(visitor);
        }
        finally {
            visitor.dispose();
        }
    }

    public List<JPQLQueryProblem> validateSemantic() {
        LinkedList<JPQLQueryProblem> problems = new LinkedList<JPQLQueryProblem>();
        this.validateSemantic(this.getJPQLExpression(), problems);
        return problems;
    }

    public void validateSemantic(Expression expression, List<JPQLQueryProblem> problems) {
        AbstractSemanticValidator visitor = this.getSemanticValidator();
        try {
            visitor.setProblems(problems);
            expression.accept(visitor);
        }
        finally {
            visitor.dispose();
        }
    }
}

