/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug.breakpoints.io;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.javascript2.debug.breakpoints.FutureLine;
import org.netbeans.modules.javascript2.debug.breakpoints.JSBreakpointsInfoManager;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.modules.javascript2.debug.breakpoints.io.BreakpointsFromGroup;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;

public class JSBreakpointReader
implements Properties.Reader {
    private static final Logger LOG = Logger.getLogger(JSBreakpointReader.class.getName());
    private static final String BREAKPOINTS_TO_ENABLE = "breakpointsToEnable";
    private static final String BREAKPOINTS_TO_DISABLE = "breakpointsToDisable";
    private static final String BP_CUSTOM_GROUP = "CustomGroup";
    private static final String BP_FILE_GROUP = "FileGroup";
    private static final String BP_PROJECT_GROUP = "ProjectGroup";
    private static final String BP_TYPE_GROUP = "TypeGroup";

    public String[] getSupportedClassNames() {
        return new String[]{JSLineBreakpoint.class.getName()};
    }

    public Object read(String className, Properties properties) {
        JSLineBreakpoint b = null;
        if (className.equals(JSLineBreakpoint.class.getName())) {
            String urlStr = properties.getString("url", null);
            int lineNumber = properties.getInt("lineNumber", 1);
            try {
                URL url = new URL(urlStr);
                FileObject fo = URLMapper.findFileObject((URL)url);
                if (fo == null) {
                    if (JSBreakpointsInfoManager.getDefault().isTransientURL(url)) {
                        FutureLine line = new FutureLine(url, lineNumber - 1);
                        return new JSLineBreakpoint(line);
                    }
                    return null;
                }
                try {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    LineCookie lineCookie = (LineCookie)dobj.getLookup().lookup(LineCookie.class);
                    if (lineCookie == null) {
                        return null;
                    }
                    try {
                        Line line = lineCookie.getLineSet().getCurrent(lineNumber - 1);
                        b = new JSLineBreakpoint(line);
                    }
                    catch (IndexOutOfBoundsException ioobex) {
                        return null;
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    return null;
                }
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.CONFIG, "urlStr = " + urlStr, ex);
                return null;
            }
        }
        if (b == null) {
            throw new IllegalStateException("Unknown breakpoint type: \"" + className + "\"");
        }
        b.setCondition(properties.getString("condition", null));
        b.setGroupName(properties.getString("groupName", ""));
        int hitCountFilter = properties.getInt("hitCountFilter", 0);
        Breakpoint.HIT_COUNT_FILTERING_STYLE hitCountFilteringStyle = hitCountFilter > 0 ? Breakpoint.HIT_COUNT_FILTERING_STYLE.values()[properties.getInt("hitCountFilter_style", 0)] : null;
        b.setHitCountFilter(hitCountFilter, hitCountFilteringStyle);
        if (properties.getBoolean("enabled", true)) {
            b.enable();
        } else {
            b.disable();
        }
        if (b.canHaveDependentBreakpoints()) {
            b.setBreakpointsToEnable(JSBreakpointReader.getBreakpointsFromGroup(properties, BREAKPOINTS_TO_ENABLE));
            b.setBreakpointsToDisable(JSBreakpointReader.getBreakpointsFromGroup(properties, BREAKPOINTS_TO_DISABLE));
        }
        return b;
    }

    public void write(Object object, Properties properties) {
        JSLineBreakpoint b = (JSLineBreakpoint)((Object)object);
        properties.setString("groupName", b.getGroupName());
        properties.setBoolean("enabled", b.isEnabled());
        properties.setInt("hitCountFilter", b.getHitCountFilter());
        Breakpoint.HIT_COUNT_FILTERING_STYLE style = b.getHitCountFilteringStyle();
        properties.setInt("hitCountFilter_style", style != null ? style.ordinal() : 0);
        if (b.canHaveDependentBreakpoints()) {
            Set breakpointsToEnable = b.getBreakpointsToEnable();
            JSBreakpointReader.setBreakpointsFromGroup(properties, BREAKPOINTS_TO_ENABLE, breakpointsToEnable);
            Set breakpointsToDisable = b.getBreakpointsToDisable();
            JSBreakpointReader.setBreakpointsFromGroup(properties, BREAKPOINTS_TO_DISABLE, breakpointsToDisable);
        }
        properties.setString("condition", b.getCondition());
        if (b instanceof JSLineBreakpoint) {
            JSLineBreakpoint lb = b;
            URL url = lb.getURL();
            int line = lb.getLineNumber();
            properties.setString("url", url.toExternalForm());
            properties.setInt("lineNumber", line);
        }
    }

    private static Set<Breakpoint> getBreakpointsFromGroup(Properties properties, String base) {
        FileObject fo;
        URL url;
        String bpGroup = properties.getString(base + BP_CUSTOM_GROUP, null);
        if (bpGroup != null) {
            return new BreakpointsFromGroup(bpGroup);
        }
        bpGroup = properties.getString(base + BP_FILE_GROUP, null);
        if (bpGroup != null) {
            try {
                url = new URL(bpGroup);
                fo = URLMapper.findFileObject((URL)url);
                if (fo != null) {
                    return new BreakpointsFromGroup(new BreakpointsFromGroup.TestGroupProperties(fo));
                }
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
        }
        if ((bpGroup = properties.getString(base + BP_PROJECT_GROUP, null)) != null) {
            try {
                Project project;
                url = new URL(bpGroup);
                fo = URLMapper.findFileObject((URL)url);
                if (fo != null && (project = ProjectManager.getDefault().findProject(fo)) != null) {
                    return new BreakpointsFromGroup(new BreakpointsFromGroup.TestGroupProperties(project));
                }
            }
            catch (IOException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        if ((bpGroup = properties.getString(base + BP_TYPE_GROUP, null)) != null) {
            return new BreakpointsFromGroup(new BreakpointsFromGroup.TestGroupProperties(bpGroup));
        }
        return Collections.emptySet();
    }

    private static void setBreakpointsFromGroup(Properties properties, String base, Set<Breakpoint> breakpointsFromGroup) {
        String customGroup = null;
        String fileURL = null;
        String projectURL = null;
        String type = null;
        if (breakpointsFromGroup instanceof BreakpointsFromGroup) {
            BreakpointsFromGroup bfg = (BreakpointsFromGroup)breakpointsFromGroup;
            customGroup = bfg.getGroupName();
            BreakpointsFromGroup.TestGroupProperties tgp = bfg.getTestGroupProperties();
            if (tgp != null) {
                Project project;
                FileObject fo = tgp.getFileObject();
                if (fo != null) {
                    URL url = fo.toURL();
                    fileURL = url.toExternalForm();
                }
                if ((project = tgp.getProject()) != null) {
                    fo = project.getProjectDirectory();
                    URL url = fo.toURL();
                    projectURL = url.toExternalForm();
                }
                type = tgp.getType();
            }
        }
        properties.setString(base + BP_CUSTOM_GROUP, customGroup);
        properties.setString(base + BP_FILE_GROUP, fileURL);
        properties.setString(base + BP_PROJECT_GROUP, projectURL);
        properties.setString(base + BP_TYPE_GROUP, type);
    }
}

