/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.bugtracking.DelegatingConnector;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.team.ide.spi.IDEServices;
import org.netbeans.modules.team.ide.spi.ProjectServices;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;

public final class BugtrackingManager
implements LookupListener {
    public static final String PROP_RECENT_ISSUES_CHANGED = "recent.issues.changed";
    private static BugtrackingManager instance;
    public static final Logger LOG;
    private final RequestProcessor rp = new RequestProcessor("Bugtracking manager");
    private final Collection<DelegatingConnector> connectors = new ArrayList<DelegatingConnector>(2);
    private Lookup.Result<BugtrackingConnector> connectorsLookup;
    private List<IssueImpl> recentIssues;
    private final Object recentIssuesLock = new Object();
    private IDEServices ideServices;
    private ProjectServices projectServices;
    private static final String LOCAL_CONNECTOR_ID = "NB_LOCAL_TASKS";
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);

    public static synchronized BugtrackingManager getInstance() {
        if (instance == null) {
            instance = new BugtrackingManager();
        }
        return instance;
    }

    private BugtrackingManager() {
    }

    public RequestProcessor getRequestProcessor() {
        return this.rp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DelegatingConnector[] getConnectors() {
        Collection<DelegatingConnector> collection = this.connectors;
        synchronized (collection) {
            if (this.connectorsLookup == null) {
                this.refreshConnectors();
            }
            return this.connectors.toArray(new DelegatingConnector[this.connectors.size()]);
        }
    }

    public void resultChanged(LookupEvent ev) {
        this.refreshConnectors();
    }

    public List<IssueImpl> getRecentIssues(RepositoryImpl repo) {
        assert (repo != null);
        List<IssueImpl> l = this.getRecentIssues();
        ArrayList<IssueImpl> ret = new ArrayList<IssueImpl>(l.size());
        for (IssueImpl recentIssue : l) {
            if (!repo.getId().equals(recentIssue.getRepositoryImpl().getId()) || !repo.getConnectorId().equals(recentIssue.getRepositoryImpl().getConnectorId())) continue;
            ret.add(recentIssue);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecentIssue(RepositoryImpl repo, IssueImpl issue) {
        assert (repo != null && issue != null);
        if (issue.getID() == null) {
            return;
        }
        List<IssueImpl> l = this.getRecentIssues();
        Object object = this.recentIssuesLock;
        synchronized (object) {
            for (IssueImpl i : l) {
                if (!i.getIssue().getID().equals(issue.getID())) continue;
                l.remove(i);
                break;
            }
            l.add(0, issue);
        }
        issue.addPropertyChangeListener(new IssuePropertyListener(issue));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "recent issue: [{0}, {1}]", new Object[]{issue.getRepositoryImpl().getDisplayName(), issue.getID()});
        }
        this.fireRecentIssuesChanged();
    }

    public List<IssueImpl> getAllRecentIssues() {
        return Collections.unmodifiableList(this.getRecentIssues());
    }

    private List<IssueImpl> getRecentIssues() {
        if (this.recentIssues == null) {
            this.recentIssues = new LinkedList<IssueImpl>();
        }
        return this.recentIssues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshConnectors() {
        Collection<DelegatingConnector> collection = this.connectors;
        synchronized (collection) {
            if (this.connectorsLookup == null) {
                this.connectorsLookup = Lookup.getDefault().lookupResult(BugtrackingConnector.class);
                this.connectorsLookup.addLookupListener((LookupListener)this);
            }
            this.connectors.clear();
            Collection conns = this.connectorsLookup.allInstances();
            for (BugtrackingConnector c : conns) {
                DelegatingConnector dc = c instanceof DelegatingConnector ? (DelegatingConnector)c : new DelegatingConnector(c, "Unknown", "Unknown", "Unknown", null);
                this.connectors.add(dc);
                LOG.log(Level.FINER, "registered provider: {0}", dc.getDisplayName());
            }
        }
    }

    public DelegatingConnector getConnector(String connectorId) {
        assert (connectorId != null);
        for (DelegatingConnector c : this.getConnectors()) {
            if (!connectorId.equals(c.getID())) continue;
            return c;
        }
        return null;
    }

    public synchronized IDEServices getIDEServices() {
        if (this.ideServices == null) {
            this.ideServices = (IDEServices)Lookup.getDefault().lookup(IDEServices.class);
        }
        return this.ideServices;
    }

    public synchronized ProjectServices getProjectServices() {
        if (this.projectServices == null) {
            this.projectServices = (ProjectServices)Lookup.getDefault().lookup(ProjectServices.class);
        }
        return this.projectServices;
    }

    public static boolean isLocalConnectorID(String connectorID) {
        return LOCAL_CONNECTOR_ID.equals(connectorID);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    private void fireRecentIssuesChanged() {
        this.support.firePropertyChange(PROP_RECENT_ISSUES_CHANGED, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRecentIssue(IssueImpl issue) {
        boolean changed;
        List<IssueImpl> l = this.getRecentIssues();
        Object object = this.recentIssuesLock;
        synchronized (object) {
            changed = l.remove(issue);
        }
        if (changed) {
            this.fireRecentIssuesChanged();
        }
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.bugtracking.BugtrackingManager");
    }

    private static class IssuePropertyListener
    implements PropertyChangeListener {
        private final IssueImpl issue;

        public IssuePropertyListener(IssueImpl issue) {
            this.issue = issue;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("issue.deleted".equals(evt.getPropertyName())) {
                this.issue.removePropertyChangeListener(this);
                BugtrackingManager.getInstance().removeRecentIssue(this.issue);
            }
        }
    }
}

