/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.checkout;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.git.remote.ui.checkout.CheckoutPathsPanel;
import org.netbeans.modules.git.remote.ui.repository.RevisionDialogController;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CheckoutPaths
implements ActionListener {
    private final CheckoutPathsPanel panel;
    private final RevisionDialogController revisionPicker;
    private JButton okButton;
    private DialogDescriptor dd;
    private boolean valid = true;

    CheckoutPaths(VCSFileProxy repository, VCSFileProxy[] roots) {
        this.revisionPicker = new RevisionDialogController(repository, roots, "HEAD");
        this.panel = new CheckoutPathsPanel(this.revisionPicker.getPanel());
    }

    String getRevision() {
        String revision = null;
        if (this.panel.cbUpdateIndex.isSelected()) {
            revision = this.revisionPicker.getRevision().getRevision();
        }
        return revision;
    }

    boolean show() {
        this.panel.cbUpdateIndex.addActionListener(this);
        this.okButton = new JButton(NbBundle.getMessage(CheckoutPaths.class, (String)"LBL_CheckoutPaths.OKButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)this.okButton.getText());
        this.dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(CheckoutPaths.class, (String)"LBL_CheckoutPaths.title"), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, new HelpCtx(CheckoutPaths.class), null);
        this.enableRevisionPanel();
        this.revisionPicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "RevisionDialogController.valid") {
                    CheckoutPaths.this.setValid(Boolean.TRUE.equals(evt.getNewValue()));
                }
            }
        });
        Dialog d = DialogDisplayer.getDefault().createDialog(this.dd);
        d.setVisible(true);
        return this.okButton == this.dd.getValue();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.panel.cbUpdateIndex == e.getSource()) {
            this.enableRevisionPanel();
        }
    }

    private void enableRevisionPanel() {
        this.revisionPicker.setEnabled(this.panel.cbUpdateIndex.isSelected());
        this.setValid(this.valid);
    }

    private void setValid(boolean flag) {
        this.valid = flag;
        this.okButton.setEnabled(flag |= !this.panel.cbUpdateIndex.isSelected());
        this.dd.setValid(flag);
    }
}

