/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.conflicts;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.git.remote.cli.GitConflictDescriptor;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.GitStatus;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.conflicts.MarkResolvedAction;
import org.netbeans.modules.git.remote.ui.conflicts.ResolveTreeConflictPanel;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.spi.diff.MergeVisualizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public class ResolveConflictsExecutor
extends GitProgressSupport {
    private static final String TMP_PREFIX = "merge-";
    static final String CHANGE_LEFT = "<<<<<<< ";
    static final String CHANGE_RIGHT = ">>>>>>> ";
    static final String CHANGE_DELIMETER = "=======";
    static final String CHANGE_BASE_DELIMETER = "|||||||";
    private String leftFileRevision = null;
    private String rightFileRevision = null;
    private static final Logger LOG = Logger.getLogger(ResolveConflictsExecutor.class.getName());
    private final VCSFileProxy[] files;
    private final Set<VCSFileProxy> toResolve;
    private static final int MAX_LEN = 40;

    public ResolveConflictsExecutor(VCSFileProxy[] files) {
        this.files = files;
        this.toResolve = new HashSet<VCSFileProxy>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec(MergeVisualizer merge, VCSFileProxy file) {
        try {
            FileObject fo = file.toFileObject();
            if (fo == null) {
                LOG.warning("can't resolve conflicts for null fileobject : " + file + ", exists: " + file.exists());
                return;
            }
            FileLock lock = fo.lock();
            boolean mergeViewerDisplayed = false;
            try {
                mergeViewerDisplayed = this.handleMergeFor(file, fo, lock, merge);
            }
            finally {
                if (!mergeViewerDisplayed) {
                    lock.releaseLock();
                }
            }
        }
        catch (FileAlreadyLockedException e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Set components = TopComponent.getRegistry().getOpened();
                    for (TopComponent tc : components) {
                        if (tc.getClientProperty((Object)ResolveConflictsExecutor.class.getName()) == null) continue;
                        tc.requestActive();
                    }
                }
            });
        }
        catch (Exception ex) {
            GitClientExceptionHandler.notifyException(ex, true);
        }
    }

    private boolean handleMergeFor(VCSFileProxy file, FileObject fo, FileLock lock, final MergeVisualizer merge) throws IOException {
        String mimeType = fo == null ? "text/plain" : fo.getMIMEType();
        File folder = Utils.getTempFolder();
        File f1 = new File(folder, "merge-ours-" + file.getName());
        f1.createNewFile();
        f1.deleteOnExit();
        File f2 = new File(folder, "merge-theirs-" + file.getName());
        f1.createNewFile();
        f2.deleteOnExit();
        File f3 = new File(folder, "merge-result-" + file.getName());
        f3.deleteOnExit();
        Charset encoding = FileEncodingQuery.getEncoding((FileObject)fo);
        final Difference[] diffs = this.copyParts(true, file, f1, true, encoding);
        if (diffs.length == 0) {
            this.toResolve.add(file);
            return false;
        }
        this.copyParts(false, file, f2, false, encoding);
        String originalLeftFileRevision = this.leftFileRevision;
        String originalRightFileRevision = this.rightFileRevision;
        if (this.leftFileRevision != null) {
            this.leftFileRevision = this.leftFileRevision.trim();
        }
        if (this.rightFileRevision != null) {
            this.rightFileRevision = this.rightFileRevision.trim();
        }
        this.leftFileRevision = this.leftFileRevision == null || this.leftFileRevision.isEmpty() ? NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"Diff.titleWorkingFile") : this.formatRevision(this.leftFileRevision);
        this.rightFileRevision = this.rightFileRevision == null || this.rightFileRevision.isEmpty() ? NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"Diff.titleWorkingFile") : this.formatRevision(this.rightFileRevision);
        VCSFileProxySupport.associateEncoding((VCSFileProxy)VCSFileProxy.createFileProxy((File)f1), (Charset)encoding);
        VCSFileProxySupport.associateEncoding((VCSFileProxy)VCSFileProxy.createFileProxy((File)f2), (Charset)encoding);
        final StreamSource s1 = StreamSource.createSource((String)file.getName(), (String)this.leftFileRevision, (String)mimeType, (File)f1);
        final StreamSource s2 = StreamSource.createSource((String)file.getName(), (String)this.rightFileRevision, (String)mimeType, (File)f2);
        final MergeResultWriterInfo result = new MergeResultWriterInfo(f1, f2, f3, file, mimeType, originalLeftFileRevision, originalRightFileRevision, fo, lock, encoding);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Component c = merge.createView(diffs, s1, s2, result);
                    if (c instanceof TopComponent) {
                        ((TopComponent)c).putClientProperty((Object)ResolveConflictsExecutor.class.getName(), (Object)Boolean.TRUE);
                    }
                }
                catch (IOException ioex) {
                    GitClientExceptionHandler.notifyException(ioex, true);
                }
            }
        });
        return true;
    }

    private String formatRevision(String commit) {
        try {
            GitClient client = this.getClient();
            GitRevisionInfo info = client.log(commit, GitUtils.NULL_PROGRESS_MONITOR);
            StringBuilder sb = new StringBuilder(100);
            sb.append(commit);
            if (!info.getRevision().startsWith(commit)) {
                String commitId = info.getRevision();
                if (commitId.length() > 7) {
                    commitId = commitId.substring(0, 7);
                }
                sb.append(" (").append(commitId).append(")");
            }
            sb.append(" - ").append(info.getShortMessage().replace('\n', ' '));
            if (sb.length() > 40) {
                sb.delete(40, sb.length());
            }
            return sb.toString();
        }
        catch (GitException ex) {
            LOG.log(Level.FINE, null, ex);
            return commit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Difference[] copyParts(boolean generateDiffs, VCSFileProxy source, File dest, boolean leftPart, Charset charset) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(source.getInputStream(false), charset));
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dest), charset));
        ArrayList<Difference> diffList = null;
        if (generateDiffs) {
            diffList = new ArrayList<Difference>();
        }
        try {
            String line;
            boolean isChangeLeft = false;
            boolean isChangeRight = false;
            boolean isChangeBase = false;
            int f1l1 = 0;
            int f1l2 = 0;
            int f2l1 = 0;
            int f2l2 = 0;
            StringBuilder text1 = new StringBuilder();
            StringBuilder text2 = new StringBuilder();
            int i = 1;
            int j = 1;
            while ((line = r.readLine()) != null) {
                String lineText;
                if (line.startsWith(CHANGE_BASE_DELIMETER)) {
                    isChangeBase = true;
                    continue;
                }
                if (isChangeBase && line.startsWith(CHANGE_DELIMETER)) {
                    isChangeBase = false;
                } else if (isChangeBase) continue;
                if (line.startsWith(CHANGE_LEFT)) {
                    if (generateDiffs) {
                        if (this.leftFileRevision == null) {
                            this.leftFileRevision = line.substring(CHANGE_LEFT.length());
                        }
                        if (isChangeLeft) {
                            f1l2 = i - 1;
                            diffList.add(f1l1 > f1l2 ? new Difference(1, f1l1 - 1, 0, f2l1, f2l2, text1.toString(), text2.toString()) : (f2l1 > f2l2 ? new Difference(0, f1l1, f1l2, f2l1 - 1, 0, text1.toString(), text2.toString()) : new Difference(2, f1l1, f1l2, f2l1, f2l2, text1.toString(), text2.toString())));
                            f2l2 = 0;
                            f2l1 = 0;
                            f1l2 = 0;
                            f1l1 = 0;
                            text1.delete(0, text1.length());
                            text2.delete(0, text2.length());
                        } else {
                            f1l1 = i;
                        }
                    }
                    isChangeLeft = !isChangeLeft;
                    continue;
                }
                if (line.startsWith(CHANGE_RIGHT)) {
                    if (generateDiffs) {
                        if (this.rightFileRevision == null) {
                            this.rightFileRevision = line.substring(CHANGE_RIGHT.length());
                        }
                        if (isChangeRight) {
                            f2l2 = j - 1;
                            diffList.add(f1l1 > f1l2 ? new Difference(1, f1l1 - 1, 0, f2l1, f2l2, text1.toString(), text2.toString()) : (f2l1 > f2l2 ? new Difference(0, f1l1, f1l2, f2l1 - 1, 0, text1.toString(), text2.toString()) : new Difference(2, f1l1, f1l2, f2l1, f2l2, text1.toString(), text2.toString())));
                            f2l2 = 0;
                            f2l1 = 0;
                            f1l2 = 0;
                            f1l1 = 0;
                            text1.delete(0, text1.length());
                            text2.delete(0, text2.length());
                        } else {
                            f2l1 = j;
                        }
                    }
                    isChangeRight = !isChangeRight;
                    continue;
                }
                if (isChangeRight && line.indexOf(CHANGE_RIGHT) != -1) {
                    lineText = line.substring(0, line.lastIndexOf(CHANGE_RIGHT));
                    if (generateDiffs) {
                        if (this.rightFileRevision == null) {
                            this.rightFileRevision = line.substring(line.lastIndexOf(CHANGE_RIGHT) + CHANGE_RIGHT.length());
                        }
                        text2.append(lineText);
                        f2l2 = j;
                        diffList.add(f1l1 > f1l2 ? new Difference(1, f1l1 - 1, 0, f2l1, f2l2, text1.toString(), text2.toString()) : (f2l1 > f2l2 ? new Difference(0, f1l1, f1l2, f2l1 - 1, 0, text1.toString(), text2.toString()) : new Difference(2, f1l1, f1l2, f2l1, f2l2, text1.toString(), text2.toString())));
                        f2l2 = 0;
                        f2l1 = 0;
                        f1l2 = 0;
                        f1l1 = 0;
                        text1.delete(0, text1.length());
                        text2.delete(0, text2.length());
                    }
                    if (!leftPart) {
                        w.write(lineText);
                        w.newLine();
                    }
                    isChangeRight = !isChangeRight;
                    continue;
                }
                if (line.equals(CHANGE_DELIMETER)) {
                    if (isChangeLeft) {
                        isChangeLeft = false;
                        isChangeRight = true;
                        f1l2 = i - 1;
                        f2l1 = j;
                        continue;
                    }
                    if (isChangeRight) {
                        isChangeRight = false;
                        isChangeLeft = true;
                        f2l2 = j - 1;
                        f1l1 = i;
                        continue;
                    }
                } else if (line.endsWith(CHANGE_DELIMETER) && !line.endsWith(CHANGE_DELIMETER + CHANGE_DELIMETER.charAt(0))) {
                    lineText = line.substring(0, line.length() - CHANGE_DELIMETER.length()) + "\n";
                    if (isChangeLeft) {
                        text1.append(lineText);
                        if (leftPart) {
                            w.write(lineText);
                            w.newLine();
                        }
                        isChangeLeft = false;
                        isChangeRight = true;
                        f1l2 = i;
                        f2l1 = j;
                        continue;
                    }
                    if (!isChangeRight) continue;
                    text2.append(lineText);
                    if (!leftPart) {
                        w.write(lineText);
                        w.newLine();
                    }
                    isChangeRight = false;
                    isChangeLeft = true;
                    f2l2 = j;
                    f1l1 = i;
                    continue;
                }
                if (!isChangeLeft && !isChangeRight || leftPart == isChangeLeft) {
                    w.write(line);
                    w.newLine();
                }
                if (isChangeLeft) {
                    text1.append(line).append("\n");
                }
                if (isChangeRight) {
                    text2.append(line).append("\n");
                }
                if (!generateDiffs) continue;
                if (isChangeLeft) {
                    ++i;
                    continue;
                }
                if (isChangeRight) {
                    ++j;
                    continue;
                }
                ++i;
                ++j;
            }
        }
        finally {
            try {
                r.close();
            }
            finally {
                w.close();
            }
        }
        if (generateDiffs) {
            return diffList.toArray(new Difference[diffList.size()]);
        }
        return null;
    }

    @Override
    public void perform() {
        MergeVisualizer merge = (MergeVisualizer)Lookup.getDefault().lookup(MergeVisualizer.class);
        if (merge == null) {
            throw new IllegalStateException("No Merge engine found.");
        }
        try {
            GitClient client = this.getClient();
            Map<VCSFileProxy, GitStatus> statuses = client.getStatus(this.files, this.getProgressMonitor());
            for (Map.Entry<VCSFileProxy, GitStatus> e : statuses.entrySet()) {
                if (this.isCanceled()) break;
                GitConflictDescriptor desc = e.getValue().getConflictDescriptor();
                if (desc != null) {
                    boolean remove;
                    boolean bl = remove = desc.getType() == GitConflictDescriptor.Type.BOTH_DELETED;
                    if (desc.getType() == GitConflictDescriptor.Type.DELETED_BY_THEM || desc.getType() == GitConflictDescriptor.Type.DELETED_BY_US) {
                        ResolveTreeConflictPanel panel = new ResolveTreeConflictPanel(e.getKey(), e.getValue().getRelativePath(), desc.getType());
                        final JButton resolveButton = new JButton();
                        Mnemonics.setLocalizedText((AbstractButton)resolveButton, (String)NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"LBL_TreeConflict_ResolveButton.title"));
                        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"LBL_TreeConflict.title"), true, new Object[]{resolveButton, DialogDescriptor.CANCEL_OPTION}, (Object)resolveButton, 0, new HelpCtx(ResolveTreeConflictPanel.class), null);
                        resolveButton.setEnabled(false);
                        ActionListener list = new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                resolveButton.setEnabled(true);
                            }
                        };
                        panel.rbAdd.addActionListener(list);
                        panel.rbRemove.addActionListener(list);
                        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
                        dialog.setVisible(true);
                        if (dd.getValue() != resolveButton) continue;
                        remove = panel.rbRemove.isSelected();
                    }
                    if (remove) {
                        VCSFileProxySupport.delete((VCSFileProxy)e.getKey());
                    }
                    if (desc.getType() != GitConflictDescriptor.Type.BOTH_ADDED && desc.getType() != GitConflictDescriptor.Type.BOTH_MODIFIED) {
                        this.toResolve.add(e.getKey());
                        continue;
                    }
                }
                this.exec(merge, e.getKey());
            }
            if (!this.isCanceled()) {
                ArrayList<AbstractNode> nodes = new ArrayList<AbstractNode>(this.toResolve.size());
                for (VCSFileProxy f : this.toResolve) {
                    nodes.add(new AbstractNode(Children.LEAF, Lookups.fixed((Object[])new Object[]{f})));
                }
                ((MarkResolvedAction)SystemAction.get(MarkResolvedAction.class)).performAction(VCSContext.forNodes((Node[])nodes.toArray(new Node[nodes.size()])));
            }
        }
        catch (GitException ex) {
            GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
        }
    }

    private static class MergeConflictFileWriter
    extends FilterWriter {
        private final Difference[] conflicts;
        private int lineNumber;
        private int currentConflict;
        private final String leftName;
        private final String rightName;
        private final FileObject fo;

        public MergeConflictFileWriter(Writer delegate, FileObject fo, Difference[] conflicts, String leftName, String rightName) throws IOException {
            super(delegate);
            this.conflicts = conflicts;
            this.leftName = leftName;
            this.rightName = rightName;
            this.lineNumber = 1;
            this.currentConflict = 0;
            if (this.lineNumber == conflicts[this.currentConflict].getFirstStart()) {
                this.writeConflict(conflicts[this.currentConflict]);
                ++this.currentConflict;
            }
            this.fo = fo;
        }

        @Override
        public void write(String str) throws IOException {
            super.write(str);
            this.lineNumber += MergeConflictFileWriter.numChars('\n', str);
            if (this.currentConflict < this.conflicts.length && this.lineNumber >= this.conflicts[this.currentConflict].getFirstStart()) {
                this.writeConflict(this.conflicts[this.currentConflict]);
                ++this.currentConflict;
            }
        }

        private void writeConflict(Difference conflict) throws IOException {
            super.write(ResolveConflictsExecutor.CHANGE_LEFT + this.leftName + "\n");
            super.write(conflict.getFirstText());
            super.write("=======\n");
            super.write(conflict.getSecondText());
            super.write(ResolveConflictsExecutor.CHANGE_RIGHT + this.rightName + "\n");
        }

        private static int numChars(char c, String str) {
            int n = 0;
            int pos = str.indexOf(c);
            while (pos >= 0 && pos < str.length()) {
                ++n;
                pos = str.indexOf(c, pos + 1);
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.fo != null) {
                this.fo.refresh(true);
            }
        }
    }

    private static class MergeResultWriterInfo
    extends StreamSource {
        private final File tempf1;
        private final File tempf2;
        private final File tempf3;
        private final VCSFileProxy outputFile;
        private VCSFileProxy fileToRepairEntriesOf;
        private final String mimeType;
        private final String leftFileRevision;
        private final String rightFileRevision;
        private FileObject fo;
        private FileLock lock;
        private final Charset encoding;

        public MergeResultWriterInfo(File tempf1, File tempf2, File tempf3, VCSFileProxy outputFile, String mimeType, String leftFileRevision, String rightFileRevision, FileObject fo, FileLock lock, Charset encoding) {
            this.tempf1 = tempf1;
            this.tempf2 = tempf2;
            this.tempf3 = tempf3;
            this.outputFile = outputFile;
            this.mimeType = mimeType;
            this.leftFileRevision = leftFileRevision;
            this.rightFileRevision = rightFileRevision;
            this.fo = fo;
            this.lock = lock;
            if (encoding == null) {
                encoding = FileEncodingQuery.getEncoding((FileObject)FileUtil.toFileObject((File)tempf1));
            }
            this.encoding = encoding;
        }

        public String getName() {
            return this.outputFile.getName();
        }

        public String getTitle() {
            return NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"Merge.titleResult");
        }

        public String getMIMEType() {
            return this.mimeType;
        }

        public Reader createReader() throws IOException {
            throw new IOException("No reader of merge result");
        }

        public Writer createWriter(Difference[] conflicts) throws IOException {
            OutputStreamWriter w = this.fo != null ? new OutputStreamWriter(this.fo.getOutputStream(this.lock), this.encoding) : new OutputStreamWriter(VCSFileProxySupport.getOutputStream((VCSFileProxy)this.outputFile), this.encoding);
            if (conflicts == null || conflicts.length == 0) {
                this.fileToRepairEntriesOf = this.outputFile;
                return w;
            }
            return new MergeConflictFileWriter(w, this.fo, conflicts, this.leftFileRevision, this.rightFileRevision);
        }

        public void close() {
            this.tempf1.delete();
            this.tempf2.delete();
            this.tempf3.delete();
            if (this.lock != null) {
                this.lock.releaseLock();
                this.lock = null;
            }
            this.fo = null;
            if (this.fileToRepairEntriesOf != null) {
                this.repairEntries(this.fileToRepairEntriesOf);
                this.fileToRepairEntriesOf = null;
            }
        }

        private void repairEntries(VCSFileProxy file) {
            ((MarkResolvedAction)SystemAction.get(MarkResolvedAction.class)).performAction(GitUtils.getContextForFile(file));
        }
    }
}

