/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.init;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.ContextHolder;
import org.netbeans.modules.git.remote.ui.init.InitPanel;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class InitAction
implements ActionListener,
HelpCtx.Provider {
    private static final Logger LOG = Logger.getLogger(InitAction.class.getName());
    private final VCSContext ctx;

    public InitAction(ContextHolder ctx) {
        this.ctx = ctx.getContext();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.git.remote.ui.init.InitAction");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        Git.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                Utils.logVCSActionEvent((String)"Git");
                InitAction.this.performInit(InitAction.this.ctx);
            }
        });
    }

    private void performInit(VCSContext context) {
        final VCSFileProxy rootToManage = this.selectRootToManage(context);
        if (rootToManage == null) {
            return;
        }
        RequestProcessor rp = Git.getInstance().getRequestProcessor(rootToManage);
        GitProgressSupport support = new GitProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                try {
                    this.output(NbBundle.getMessage(InitAction.class, (String)"MSG_INIT", (Object)rootToManage));
                    GitClient client = this.getClient();
                    client.init(this.getProgressMonitor());
                    Git.getInstance().getFileStatusCache().refreshAllRoots(rootToManage);
                    Git.getInstance().versionedFilesChanged();
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
                finally {
                    Git.getInstance().clearAncestorCaches();
                    VersioningSupport.versionedRootsChanged();
                }
            }
        };
        support.start(rp, rootToManage, NbBundle.getMessage(InitAction.class, (String)"MSG_Init_Progress"));
    }

    private VCSFileProxy selectRootToManage(VCSContext context) {
        VCSFileProxy rootPath;
        final VCSFileProxy root = rootPath = this.getSuggestedRoot(context);
        final InitPanel panel = new InitPanel(root);
        panel.lblMessage.setVisible(false);
        final DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(InitAction.class, (String)"LBL_Init_Panel_Label"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(InitPanel.class), null);
        dd.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        final RequestProcessor.Task validateTask = Git.getInstance().getRequestProcessor().create(new Runnable(){

            @Override
            public void run() {
                FileObject projectDir;
                FileObject fo;
                Project p;
                String validatedPath = panel.tfRootPath.getText();
                String errorMessage = null;
                boolean valid = !validatedPath.trim().isEmpty();
                VCSFileProxy dir = VCSFileProxySupport.getResource((VCSFileProxy)root, (String)validatedPath);
                if (!dir.isDirectory()) {
                    errorMessage = NbBundle.getMessage(InitAction.class, (String)"LBL_Init_Panel_Error_Directory");
                    if (LOG.isLoggable(Level.FINE) && dir.exists()) {
                        LOG.log(Level.FINE, "InitAction.selectRootToManage.validateTask: selected a file: {0}", dir);
                    }
                    valid = false;
                }
                if (valid) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    if (dir.equals((Object)Git.getInstance().getRepositoryRoot(dir))) {
                        valid = false;
                        errorMessage = NbBundle.getMessage(InitAction.class, (String)"LBL_Init_Panel_Error_Versioned");
                    }
                }
                if (Thread.interrupted()) {
                    return;
                }
                if (valid && (p = FileOwnerQuery.getOwner((FileObject)(fo = dir.normalizeFile().toFileObject()))) != null && FileUtil.isParentOf((FileObject)(projectDir = p.getProjectDirectory()), (FileObject)fo)) {
                    errorMessage = NbBundle.getMessage(InitAction.class, (String)"LBL_Init_Panel_Warning_Under_Project");
                }
                if (Thread.interrupted()) {
                    return;
                }
                dd.setValid(valid);
                if (errorMessage != null) {
                    panel.lblMessage.setText(errorMessage);
                    panel.lblMessage.setForeground(UIManager.getDefaults().getColor(valid ? "nb.warningForeground" : "nb.errorForeground"));
                }
                panel.lblMessage.setVisible(errorMessage != null);
                panel.invalidate();
            }
        });
        panel.tfRootPath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.validate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.validate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.validate();
            }

            private void validate() {
                validateTask.cancel();
                dd.setValid(false);
                validateTask.schedule(300);
            }
        });
        panel.tfRootPath.setText(rootPath == null ? "" : rootPath.getPath());
        do {
            dialog.setVisible(true);
            if (dd.getValue() == DialogDescriptor.OK_OPTION) {
                rootPath = VCSFileProxySupport.getResource((VCSFileProxy)root, (String)panel.tfRootPath.getText());
                validateTask.run();
                continue;
            }
            rootPath = null;
        } while (!dd.isValid() && dd.getValue() == DialogDescriptor.OK_OPTION);
        return rootPath;
    }

    private VCSFileProxy getSuggestedRoot(VCSContext context) {
        VCSFileProxy[] files = context.getRootFiles().toArray(new VCSFileProxy[context.getRootFiles().size()]);
        if (files == null || files.length == 0) {
            return null;
        }
        Project proj = VCSFileProxySupport.getProject((VCSFileProxy[])files);
        VCSFileProxy projFile = VCSFileProxySupport.getProjectFile((Project)proj);
        VCSFileProxy root = null;
        root = this.getCommonAncestor(files);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "InitAction.getSuggestedRoot: common root for {0}: {1}", new Object[]{context.getRootFiles(), root});
        }
        if (projFile != null) {
            root = this.getCommonAncestor(root, projFile);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "InitAction.getSuggestedRoot: root with project at {0}: {1}", new Object[]{projFile, root});
            }
        }
        return root;
    }

    private VCSFileProxy getCommonAncestor(VCSFileProxy firstFile, VCSFileProxy secondFile) {
        if (firstFile.equals((Object)secondFile)) {
            return firstFile;
        }
        for (VCSFileProxy tempFirstFile = firstFile; tempFirstFile != null; tempFirstFile = tempFirstFile.getParentFile()) {
            for (VCSFileProxy tempSecondFile = secondFile; tempSecondFile != null; tempSecondFile = tempSecondFile.getParentFile()) {
                if (!tempFirstFile.equals((Object)tempSecondFile)) continue;
                return tempSecondFile;
            }
        }
        return null;
    }

    private VCSFileProxy getCommonAncestor(VCSFileProxy[] files) {
        VCSFileProxy f1 = files[0];
        for (int i = 1; i < files.length; ++i) {
            VCSFileProxy f = this.getCommonAncestor(f1, files[i]);
            if (f == null) {
                LOG.log(Level.SEVERE, "Unable to get common parent of {0} and {1} ", new Object[]{f1.getPath(), files[i].getPath()});
                continue;
            }
            f1 = f;
        }
        return f1;
    }

    private boolean isEnabled() {
        boolean ret;
        Set rootFiles = this.ctx.getRootFiles();
        if (rootFiles.isEmpty()) {
            return false;
        }
        VCSFileProxy root = (VCSFileProxy)rootFiles.iterator().next();
        if (!VCSFileProxySupport.isConnectedFileSystem((FileSystem)VCSFileProxySupport.getFileSystem((VCSFileProxy)root))) {
            this.notifyImportImpossible(NbBundle.getMessage(InitAction.class, (String)"MSG_FileSystemDisconnected"));
            return false;
        }
        boolean bl = ret = !GitUtils.isFromGitRepository(this.ctx);
        if (!ret) {
            this.notifyImportImpossible(NbBundle.getMessage(InitAction.class, (String)"MSG_AlreadyVersioned"));
        }
        return ret;
    }

    private void notifyImportImpossible(String msg) {
        NotifyDescriptor nd = new NotifyDescriptor((Object)msg, NbBundle.getMessage(InitAction.class, (String)"MSG_ImportNotAllowed"), -1, 2, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(nd);
    }
}

