/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.merge;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitMergeResult;
import org.netbeans.modules.git.remote.cli.GitRepository;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.progress.NotificationListener;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.GitAction;
import org.netbeans.modules.git.remote.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.remote.ui.merge.Bundle;
import org.netbeans.modules.git.remote.ui.merge.MergeRevision;
import org.netbeans.modules.git.remote.ui.output.OutputLogger;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.git.remote.utils.LogUtils;
import org.netbeans.modules.git.remote.utils.ResultProcessor;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class MergeRevisionAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(MergeRevisionAction.class.getName());

    @Override
    protected void performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        this.mergeRevision(repository, info.getActiveBranch().getName().equals("(no branch)") ? "HEAD" : info.getActiveBranch().getName());
    }

    public void mergeRevision(final VCSFileProxy repository, String preselectedRevision) {
        GitRepository.FastForwardOption defaultFFOption = GitRepository.FastForwardOption.FAST_FORWARD;
        try {
            defaultFFOption = Git.getInstance().getRepository(repository).getDefaultFastForwardOption();
        }
        catch (GitException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        final MergeRevision mergeRevision = new MergeRevision(repository, new VCSFileProxy[0], preselectedRevision, defaultFFOption);
        if (mergeRevision.show()) {
            GitProgressSupport supp = new GitProgressSupport(){
                private String revision;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void perform() {
                    try {
                        GitUtils.runWithoutIndexing(new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                GitClient client = this.getClient();
                                client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(new VCSFileProxy[]{repository}));
                                revision = mergeRevision.getRevision();
                                LOG.log(Level.FINE, "Merging revision {0} into HEAD", revision);
                                MergeContext ctx = new MergeContext(revision, mergeRevision.getFFOption());
                                MergeResultProcessor mrp = new MergeResultProcessor(client, repository, ctx, this.getLogger(), this.getProgressMonitor());
                                do {
                                    ctx.setContinue(false);
                                    try {
                                        GitMergeResult result = client.merge(revision, ctx.getFFOption(), this.getProgressMonitor());
                                        mrp.processResult(result);
                                    }
                                    catch (GitException.CheckoutConflictException ex) {
                                        if (LOG.isLoggable(Level.FINE)) {
                                            LOG.log(Level.FINE, "Local modifications in WT during merge: {0} - {1}", new Object[]{repository, Arrays.asList(ex.getConflicts())});
                                        }
                                        ctx.setContinue(mrp.resolveLocalChanges(ex.getConflicts()));
                                    }
                                } while (ctx.isContinue() && !this.isCanceled());
                                return null;
                            }
                        }, repository);
                    }
                    catch (GitException ex) {
                        try {
                            GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                        }
                        catch (Throwable throwable) {
                            this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                            Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                            GitUtils.headChanged(repository);
                            throw throwable;
                        }
                        this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                        GitUtils.headChanged(repository);
                    }
                    this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                    Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                    GitUtils.headChanged(repository);
                }
            };
            supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(MergeRevisionAction.class, (String)"LBL_MergeRevisionAction.progressName"));
        }
    }

    public static class MergeContext {
        private GitRepository.FastForwardOption ffOption;
        private final String revision;
        private boolean cont;

        public MergeContext(String revision, GitRepository.FastForwardOption ffOption) {
            this.revision = revision;
            this.ffOption = ffOption;
        }

        public String getRevision() {
            return this.revision;
        }

        public GitRepository.FastForwardOption getFFOption() {
            return this.ffOption;
        }

        private void setFFOption(GitRepository.FastForwardOption ffOption) {
            this.ffOption = ffOption;
        }

        public void setContinue(boolean cont) {
            this.cont = cont;
        }

        public boolean isContinue() {
            return this.cont;
        }
    }

    public static class MergeResultProcessor
    extends ResultProcessor {
        private final OutputLogger logger;
        private final GitBranch current;
        private final MergeContext context;

        public MergeResultProcessor(GitClient client, VCSFileProxy repository, MergeContext context, OutputLogger logger, ProgressMonitor pm) {
            super(client, repository, context.getRevision(), pm);
            this.context = context;
            this.current = RepositoryInfo.getInstance(repository).getActiveBranch();
            this.logger = logger;
        }

        public void processResult(GitMergeResult result) {
            String revision = this.context.getRevision();
            StringBuilder sb = new StringBuilder(NbBundle.getMessage(MergeRevisionAction.class, (String)"MSG_MergeRevisionAction.result", (Object)result.getMergeStatus().toString()));
            GitRevisionInfo info = null;
            if (result.getNewHead() != null) {
                try {
                    info = this.client.log(result.getNewHead(), GitUtils.NULL_PROGRESS_MONITOR);
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
            }
            boolean logActions = false;
            final Action openAction = this.logger.getOpenOutputAction();
            switch (result.getMergeStatus()) {
                case ALREADY_UP_TO_DATE: {
                    sb.append(NbBundle.getMessage(MergeRevisionAction.class, (String)"MSG_MergeRevisionAction.result.alreadyUpToDate", (Object)revision));
                    break;
                }
                case FAST_FORWARD: {
                    sb.append(NbBundle.getMessage(MergeRevisionAction.class, (String)"MSG_MergeRevisionAction.result.fastForward", (Object)revision));
                    GitUtils.printInfo(sb, info, false);
                    logActions = true;
                    break;
                }
                case MERGED: {
                    sb.append(NbBundle.getMessage(MergeRevisionAction.class, (String)"MSG_MergeRevisionAction.result.merged", (Object)revision));
                    GitUtils.printInfo(sb, info, false);
                    logActions = true;
                    break;
                }
                case CONFLICTING: {
                    sb.append(NbBundle.getMessage(MergeRevisionAction.class, (String)"MSG_MergeRevisionAction.result.conflict", (Object)revision));
                    this.printConflicts(this.logger, sb, result.getConflicts());
                    this.resolveConflicts(result.getConflicts());
                    break;
                }
                case FAILED: {
                    if (openAction != null) {
                        try {
                            EventQueue.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    openAction.actionPerformed(new ActionEvent(MergeResultProcessor.this, 1001, null));
                                }
                            });
                        }
                        catch (InterruptedException ex) {
                        }
                        catch (InvocationTargetException ex) {
                            // empty catch block
                        }
                    }
                    sb.append(NbBundle.getMessage(MergeRevisionAction.class, (String)"MSG_MergeRevisionAction.result.failedFiles", (Object)revision));
                    this.printConflicts(this.logger, sb, result.getFailures());
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(MergeRevisionAction.class, (String)"MSG_MergeRevisionAction.result.failed", (Object)revision), 0));
                    break;
                }
                case ABORTED: {
                    Object o = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)Bundle.MSG_Merge_failed_aborted_text(), Bundle.LBL_Merge_failed_title(), 0, 3, new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION}, NotifyDescriptor.NO_OPTION));
                    if (o == NotifyDescriptor.YES_OPTION) {
                        this.context.setFFOption(GitRepository.FastForwardOption.FAST_FORWARD);
                        this.context.setContinue(true);
                    } else if (openAction != null) {
                        try {
                            EventQueue.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    openAction.actionPerformed(new ActionEvent(MergeResultProcessor.this, 1001, null));
                                }
                            });
                        }
                        catch (InterruptedException | InvocationTargetException ex) {
                            // empty catch block
                        }
                    }
                    sb.append(NbBundle.getMessage(MergeRevisionAction.class, (String)"MSG_MergeRevisionAction.result.aborted", (Object)revision));
                    break;
                }
                case NOT_SUPPORTED: {
                    sb.append(NbBundle.getMessage(MergeRevisionAction.class, (String)"MSG_MergeRevisionAction.result.unsupported"));
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(MergeRevisionAction.class, (String)"MSG_MergeRevisionAction.result.unsupported"), 0));
                }
            }
            if (sb.length() > 0) {
                this.logger.outputLine(sb.toString());
            }
            if (logActions) {
                LogUtils.logBranchUpdateReview(this.repository, this.current.getName(), this.current.getId(), result.getNewHead(), this.logger);
            }
        }
    }
}

