/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.stash;

import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.netbeans.modules.git.remote.FileInformation;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.GitAction;
import org.netbeans.modules.git.remote.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.remote.ui.stash.Bundle;
import org.netbeans.modules.git.remote.ui.stash.SaveStash;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class SaveStashAction
extends SingleRepositoryAction {
    @Override
    protected void performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        this.saveStash(repository, roots);
    }

    public void saveStash(VCSFileProxy repository) {
        this.saveStash(repository, new VCSFileProxy[0]);
    }

    public void saveStash(final VCSFileProxy repository, final VCSFileProxy[] roots) {
        final VCSFileProxy[] modifications = Git.getInstance().getFileStatusCache().listFiles(new VCSFileProxy[]{repository}, FileInformation.STATUS_LOCAL_CHANGES);
        if (modifications.length == 0) {
            NotifyDescriptor nd = new NotifyDescriptor((Object)Bundle.MSG_SaveStashAction_noModifications(), Bundle.LBL_SaveStashAction_noModifications(), -1, 1, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notifyLater(nd);
            return;
        }
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                SaveStash saveStash = new SaveStash(repository, roots, RepositoryInfo.getInstance(repository).getActiveBranch());
                if (saveStash.show()) {
                    SaveStashAction.this.start(repository, modifications, saveStash);
                }
            }
        });
    }

    private void start(final VCSFileProxy repository, final VCSFileProxy[] modifications, final SaveStash saveStash) {
        GitProgressSupport supp = new GitProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void perform() {
                try {
                    final GitClient client = this.getClient();
                    GitUtils.runWithoutIndexing(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            client.stashSave(saveStash.getMessage(), saveStash.isIncludeUncommitted(), this.getProgressMonitor());
                            return null;
                        }
                    }, repository);
                    RepositoryInfo.getInstance(repository).refreshStashes();
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
                finally {
                    if (modifications.length > 0) {
                        this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Arrays.asList(modifications)));
                    }
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.MSG_ApplyStashAction_progressName());
    }
}

